/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.util.math;

import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.mutable.ArrayOps;
import scala.math.Fractional;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public final class package$ {
    public static package$ MODULE$;

    static {
        new package$();
    }

    public float filteredMean(float[] s) {
        float[] defS = (float[])new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(s)).filter((Function1)(JFunction1.mcZF.sp & Serializable & scala.Serializable)x$1 -> !fr.profi.util.primitives.package$.MODULE$.isZeroOrNaN(x$1));
        return new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(defS)).isEmpty() ? Float.NaN : BoxesRunTime.unboxToFloat((Object)new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(defS)).sum((Numeric)Numeric.FloatIsFractional$.MODULE$)) / (float)defS.length;
    }

    public float filteredMedian(float[] s) {
        float[] defS = (float[])new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(s)).filter((Function1)(JFunction1.mcZF.sp & Serializable & scala.Serializable)x$2 -> !fr.profi.util.primitives.package$.MODULE$.isZeroOrNaN(x$2));
        return new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(defS)).isEmpty() ? Float.NaN : BoxesRunTime.unboxToFloat(this.median((Seq)Predef$.MODULE$.wrapFloatArray(defS), (Fractional)Numeric.FloatIsFractional$.MODULE$));
    }

    public double filteredMean(double[] s) {
        double[] defS = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(s)).filter((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)x$3 -> !fr.profi.util.primitives.package$.MODULE$.isZeroOrNaN(x$3));
        return new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(defS)).isEmpty() ? Double.NaN : BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(defS)).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)defS.length;
    }

    public double filteredMedian(double[] s) {
        double[] defS = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(s)).filter((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)x$4 -> !fr.profi.util.primitives.package$.MODULE$.isZeroOrNaN(x$4));
        return new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(defS)).isEmpty() ? Double.NaN : BoxesRunTime.unboxToDouble(this.median((Seq)Predef$.MODULE$.wrapDoubleArray(defS), (Fractional)Numeric.DoubleIsFractional$.MODULE$));
    }

    public <T> T median(Seq<T> s, Fractional<T> n) {
        Tuple2 tuple2 = ((TraversableLike)s.sortBy((Function1 & Serializable & scala.Serializable)x -> x, n)).splitAt(s.size() / 2);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq lower = (Seq)tuple2._1();
        Seq upper = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)lower, (Object)upper);
        Tuple2 tuple23 = tuple22;
        Seq lower2 = (Seq)tuple23._1();
        Seq upper2 = (Seq)tuple23._2();
        return (T)(s.size() % 2 == 0 ? n.mkNumericOps(n.mkNumericOps(lower2.last()).$plus(upper2.head())).$div(n.fromInt(2)) : upper2.head());
    }

    public <T> T getMedianObject(Seq<T> objects, Function2<T, T, Object> sortingFunc) {
        Seq sortedObjects = (Seq)objects.sortWith((Function2 & Serializable & scala.Serializable)(a, b) -> BoxesRunTime.boxToBoolean((boolean)package$.$anonfun$getMedianObject$1(sortingFunc, a, b)));
        int nbObjects = sortedObjects.length();
        int medianIndex = 0;
        medianIndex = nbObjects % 2 == 0 ? nbObjects / 2 : (nbObjects - 1) / 2;
        return (T)sortedObjects.apply(medianIndex);
    }

    public Tuple2<Object, Object> calcLineParams(double x1, double y1, double x2, double y2) {
        double deltaX = x2 - x1;
        Predef$.MODULE$.require(deltaX != 0.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("can't solve line parameters with two identical x values (").append(x1).append(")").toString());
        double slope = (y2 - y1) / deltaX;
        double intercept = y1 - slope * x1;
        return new Tuple2.mcDD.sp(slope, intercept);
    }

    public double linearInterpolation(double xValue, Seq<Tuple2<Object, Object>> xyValues, boolean fixOutOfRange) {
        double d;
        int index = xyValues.indexWhere((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)package$.$anonfun$linearInterpolation$1(xValue, x$9)));
        if (index == -1) {
            if (!fixOutOfRange) {
                throw new IllegalArgumentException("index is out of range");
            }
            int n = index = xValue < ((Tuple2)xyValues.head())._1$mcD$sp() ? 0 : -1;
        }
        if (index == 0) {
            d = ((Tuple2)xyValues.head())._2$mcD$sp();
        } else if (index == -1) {
            d = ((Tuple2)xyValues.last())._2$mcD$sp();
        } else {
            Tuple2 tuple2 = (Tuple2)xyValues.apply(index - 1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            double x1 = tuple2._1$mcD$sp();
            double y1 = tuple2._2$mcD$sp();
            Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(x1, y1);
            Tuple2.mcDD.sp sp3 = sp2;
            double x12 = sp3._1$mcD$sp();
            double y12 = sp3._2$mcD$sp();
            Tuple2 tuple22 = (Tuple2)xyValues.apply(index);
            if (tuple22 == null) {
                throw new MatchError((Object)tuple22);
            }
            double x2 = tuple22._1$mcD$sp();
            double y2 = tuple22._2$mcD$sp();
            Tuple2.mcDD.sp sp4 = new Tuple2.mcDD.sp(x2, y2);
            Tuple2.mcDD.sp sp5 = sp4;
            double x22 = sp5._1$mcD$sp();
            double y22 = sp5._2$mcD$sp();
            if (x12 == x22) {
                d = (y12 + y22) / (double)2;
            } else {
                Tuple2<Object, Object> tuple23 = this.calcLineParams(x12, y12, x22, y22);
                if (tuple23 == null) {
                    throw new MatchError(tuple23);
                }
                double a = tuple23._1$mcD$sp();
                double b = tuple23._2$mcD$sp();
                Tuple2.mcDD.sp sp6 = new Tuple2.mcDD.sp(a, b);
                Tuple2.mcDD.sp sp7 = sp6;
                double a2 = sp7._1$mcD$sp();
                double b2 = sp7._2$mcD$sp();
                d = a2 * xValue + b2;
            }
        }
        return d;
    }

    public double linearInterpolation(double xValue, Seq<Tuple2<Object, Object>> xyValues) {
        return this.linearInterpolation(xValue, xyValues, true);
    }

    public float linearInterpolation(float xValue, Seq<Tuple2<Object, Object>> xyValues, boolean fixOutOfRange) {
        float f;
        int index = xyValues.indexWhere((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)package$.$anonfun$linearInterpolation$2(xValue, x$13)));
        if (index == -1) {
            if (!fixOutOfRange) {
                throw new IllegalArgumentException("index is out of range");
            }
            int n = index = xValue < BoxesRunTime.unboxToFloat((Object)((Tuple2)xyValues.head())._1()) ? 0 : -1;
        }
        if (index == 0) {
            f = BoxesRunTime.unboxToFloat((Object)((Tuple2)xyValues.head())._2());
        } else if (index == -1) {
            f = BoxesRunTime.unboxToFloat((Object)((Tuple2)xyValues.last())._2());
        } else {
            Tuple2 tuple2 = (Tuple2)xyValues.apply(index - 1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            float x1 = BoxesRunTime.unboxToFloat((Object)tuple2._1());
            float y1 = BoxesRunTime.unboxToFloat((Object)tuple2._2());
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToFloat((float)x1), (Object)BoxesRunTime.boxToFloat((float)y1));
            Tuple2 tuple23 = tuple22;
            float x12 = BoxesRunTime.unboxToFloat((Object)tuple23._1());
            float y12 = BoxesRunTime.unboxToFloat((Object)tuple23._2());
            Tuple2 tuple24 = (Tuple2)xyValues.apply(index);
            if (tuple24 == null) {
                throw new MatchError((Object)tuple24);
            }
            float x2 = BoxesRunTime.unboxToFloat((Object)tuple24._1());
            float y2 = BoxesRunTime.unboxToFloat((Object)tuple24._2());
            Tuple2 tuple25 = new Tuple2((Object)BoxesRunTime.boxToFloat((float)x2), (Object)BoxesRunTime.boxToFloat((float)y2));
            Tuple2 tuple26 = tuple25;
            float x22 = BoxesRunTime.unboxToFloat((Object)tuple26._1());
            float y22 = BoxesRunTime.unboxToFloat((Object)tuple26._2());
            if (x12 == x22) {
                f = (y12 + y22) / (float)2;
            } else {
                Tuple2<Object, Object> tuple27 = this.calcLineParams(x12, y12, x22, y22);
                if (tuple27 == null) {
                    throw new MatchError(tuple27);
                }
                double a = tuple27._1$mcD$sp();
                double b = tuple27._2$mcD$sp();
                Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(a, b);
                Tuple2.mcDD.sp sp3 = sp2;
                double a2 = sp3._1$mcD$sp();
                double b2 = sp3._2$mcD$sp();
                f = (float)(a2 * (double)xValue + b2);
            }
        }
        return f;
    }

    public float linearInterpolation(float xValue, Seq<Tuple2<Object, Object>> xyValues) {
        return this.linearInterpolation(xValue, xyValues, true);
    }

    public static final /* synthetic */ boolean $anonfun$getMedianObject$1(Function2 sortingFunc$1, Object a, Object b) {
        return BoxesRunTime.unboxToBoolean((Object)sortingFunc$1.apply(a, b));
    }

    public static final /* synthetic */ boolean $anonfun$linearInterpolation$1(double xValue$1, Tuple2 x$9) {
        return x$9._1$mcD$sp() >= xValue$1;
    }

    public static final /* synthetic */ boolean $anonfun$linearInterpolation$2(float xValue$2, Tuple2 x$13) {
        return BoxesRunTime.unboxToFloat((Object)x$13._1()) >= xValue$2;
    }

    private package$() {
        MODULE$ = this;
    }
}

