/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.rng;

import umontreal.iro.lecuyer.rng.RandomStreamBase;

public class LFSR258
extends RandomStreamBase {
    private static final long serialVersionUID = 70510L;
    private static final double NORM = 5.421010862427523E-20;
    private static final double MAX = 0.9999999999999999;
    private long z0;
    private long z1;
    private long z2;
    private long z3;
    private long z4;
    private long[] stream;
    private long[] substream;
    private static long[] curr_stream = new long[]{1234567890L, 1234567890L, 1234567890L, 1234567890L, 1234567890L};

    public LFSR258() {
        this.name = null;
        this.stream = new long[5];
        this.substream = new long[5];
        for (int i = 0; i < 5; ++i) {
            this.stream[i] = curr_stream[i];
        }
        this.resetStartStream();
        long z = curr_stream[0] & 0xFFFFFFFFFFFFFFFEL;
        long b = z ^ z << 1;
        LFSR258.curr_stream[0] = z = b >>> 61 ^ b >>> 59 ^ b >>> 58 ^ b >>> 57 ^ b >>> 51 ^ b >>> 47 ^ b >>> 46 ^ b >>> 45 ^ b >>> 43 ^ b >>> 39 ^ b >>> 30 ^ b >>> 29 ^ b >>> 23 ^ b >>> 15 ^ z << 2 ^ z << 4 ^ z << 5 ^ z << 6 ^ z << 12 ^ z << 16 ^ z << 17 ^ z << 18 ^ z << 20 ^ z << 24 ^ z << 33 ^ z << 34 ^ z << 40 ^ z << 48;
        z = curr_stream[1] & 0xFFFFFFFFFFFFFE00L;
        b = z ^ z << 24;
        LFSR258.curr_stream[1] = z = b >>> 52 ^ b >>> 50 ^ b >>> 49 ^ b >>> 46 ^ b >>> 43 ^ b >>> 40 ^ b >>> 37 ^ b >>> 34 ^ b >>> 30 ^ b >>> 28 ^ b >>> 26 ^ b >>> 25 ^ b >>> 23 ^ b >>> 21 ^ b >>> 20 ^ b >>> 19 ^ b >>> 17 ^ b >>> 15 ^ b >>> 13 ^ b >>> 12 ^ b >>> 10 ^ b >>> 8 ^ b >>> 7 ^ b >>> 6 ^ b >>> 2 ^ z << 1 ^ z << 4 ^ z << 6 ^ z << 7 ^ z << 11 ^ z << 14 ^ z << 15 ^ z << 16 ^ z << 17 ^ z << 21 ^ z << 22 ^ z << 25 ^ z << 27 ^ z << 29 ^ z << 30 ^ z << 32 ^ z << 34 ^ z << 35 ^ z << 36 ^ z << 38 ^ z << 40 ^ z << 42 ^ z << 43 ^ z << 45 ^ z << 47 ^ z << 48 ^ z << 49 ^ z << 53;
        z = curr_stream[2] & 0xFFFFFFFFFFFFF000L;
        b = z ^ z << 3;
        LFSR258.curr_stream[2] = z = b >>> 49 ^ b >>> 45 ^ b >>> 41 ^ b >>> 40 ^ b >>> 32 ^ b >>> 27 ^ b >>> 23 ^ b >>> 14 ^ b >>> 1 ^ z << 2 ^ z << 3 ^ z << 7 ^ z << 11 ^ z << 12 ^ z << 20 ^ z << 25 ^ z << 29 ^ z << 38 ^ z << 51;
        z = curr_stream[3] & 0xFFFFFFFFFFFE0000L;
        b = z ^ z << 5;
        LFSR258.curr_stream[3] = z = b >>> 45 ^ b >>> 32 ^ b >>> 27 ^ b >>> 22 ^ b >>> 17 ^ b >>> 13 ^ b >>> 12 ^ b >>> 7 ^ b >>> 3 ^ b >>> 2 ^ z << 3 ^ z << 15 ^ z << 20 ^ z << 25 ^ z << 30 ^ z << 34 ^ z << 35 ^ z << 40 ^ z << 44 ^ z << 45;
        z = curr_stream[4] & 0xFFFFFFFFFF800000L;
        b = z ^ z << 3;
        LFSR258.curr_stream[4] = z = b >>> 40 ^ b >>> 39 ^ b >>> 38 ^ b >>> 37 ^ b >>> 35 ^ b >>> 34 ^ b >>> 31 ^ b >>> 30 ^ b >>> 29 ^ b >>> 28 ^ b >>> 27 ^ b >>> 26 ^ b >>> 24 ^ b >>> 23 ^ b >>> 21 ^ b >>> 20 ^ b >>> 18 ^ b >>> 15 ^ b >>> 12 ^ b >>> 10 ^ b >>> 9 ^ b >>> 7 ^ b >>> 6 ^ b >>> 5 ^ b >>> 4 ^ b >>> 3 ^ z << 1 ^ z << 2 ^ z << 3 ^ z << 4 ^ z << 6 ^ z << 7 ^ z << 10 ^ z << 11 ^ z << 12 ^ z << 13 ^ z << 14 ^ z << 15 ^ z << 17 ^ z << 18 ^ z << 20 ^ z << 21 ^ z << 23 ^ z << 26 ^ z << 29 ^ z << 31 ^ z << 32 ^ z << 34 ^ z << 35 ^ z << 36 ^ z << 37 ^ z << 38;
    }

    public LFSR258(String name) {
        this();
        this.name = name;
    }

    public static void setPackageSeed(long[] seed) {
        LFSR258.checkSeed(seed);
        for (int i = 0; i < 5; ++i) {
            LFSR258.curr_stream[i] = seed[i];
        }
    }

    private static void checkSeed(long[] seed) {
        if (seed.length < 5) {
            throw new IllegalArgumentException("Seed must contain 5 values");
        }
        if (seed[0] >= 0L && seed[0] < 2L || seed[1] >= 0L && seed[1] < 512L || seed[2] >= 0L && seed[2] < 4096L || seed[3] >= 0L && seed[3] < 131072L || seed[4] >= 0L && seed[4] < 0x800000L) {
            throw new IllegalArgumentException("The seed elements must be either negative or greater than 1, 511, 4095, 131071 and 8388607 respectively");
        }
    }

    public void setSeed(long[] seed) {
        LFSR258.checkSeed(seed);
        for (int i = 0; i < 5; ++i) {
            this.stream[i] = seed[i];
        }
        this.resetStartStream();
    }

    public long[] getState() {
        return new long[]{this.z0, this.z1, this.z2, this.z3, this.z4};
    }

    public LFSR258 clone() {
        LFSR258 retour = null;
        retour = (LFSR258)super.clone();
        retour.stream = new long[5];
        retour.substream = new long[5];
        for (int i = 0; i < 5; ++i) {
            retour.substream[i] = this.substream[i];
            retour.stream[i] = this.stream[i];
        }
        return retour;
    }

    public void resetStartStream() {
        for (int i = 0; i < 5; ++i) {
            this.substream[i] = this.stream[i];
        }
        this.resetStartSubstream();
    }

    public void resetStartSubstream() {
        this.z0 = this.substream[0];
        this.z1 = this.substream[1];
        this.z2 = this.substream[2];
        this.z3 = this.substream[3];
        this.z4 = this.substream[4];
    }

    public void resetNextSubstream() {
        long z = this.substream[0] & 0xFFFFFFFFFFFFFFFEL;
        long b = z ^ z << 1;
        this.substream[0] = z = b >>> 58 ^ b >>> 55 ^ b >>> 46 ^ b >>> 43 ^ z << 5 ^ z << 8 ^ z << 17 ^ z << 20;
        z = this.substream[1] & 0xFFFFFFFFFFFFFE00L;
        b = z ^ z << 24;
        this.substream[1] = z = b >>> 54 ^ b >>> 53 ^ b >>> 52 ^ b >>> 50 ^ b >>> 49 ^ b >>> 48 ^ b >>> 43 ^ b >>> 41 ^ b >>> 38 ^ b >>> 37 ^ b >>> 30 ^ b >>> 25 ^ b >>> 24 ^ b >>> 23 ^ b >>> 19 ^ b >>> 16 ^ b >>> 15 ^ b >>> 14 ^ b >>> 13 ^ b >>> 11 ^ b >>> 8 ^ b >>> 7 ^ b >>> 5 ^ b >>> 3 ^ z << 0 ^ z << 2 ^ z << 3 ^ z << 6 ^ z << 7 ^ z << 8 ^ z << 9 ^ z << 10 ^ z << 11 ^ z << 12 ^ z << 13 ^ z << 14 ^ z << 16 ^ z << 18 ^ z << 19 ^ z << 21 ^ z << 25 ^ z << 30 ^ z << 31 ^ z << 32 ^ z << 36 ^ z << 39 ^ z << 40 ^ z << 41 ^ z << 42 ^ z << 44 ^ z << 47 ^ z << 48 ^ z << 50 ^ z << 52;
        z = this.substream[2] & 0xFFFFFFFFFFFFF000L;
        b = z ^ z << 3;
        this.substream[2] = z = b >>> 50 ^ b >>> 49 ^ b >>> 46 ^ b >>> 42 ^ b >>> 40 ^ b >>> 39 ^ b >>> 38 ^ b >>> 37 ^ b >>> 36 ^ b >>> 32 ^ b >>> 29 ^ b >>> 28 ^ b >>> 27 ^ b >>> 25 ^ b >>> 23 ^ b >>> 20 ^ b >>> 19 ^ b >>> 15 ^ b >>> 12 ^ b >>> 11 ^ b >>> 2 ^ z << 1 ^ z << 2 ^ z << 3 ^ z << 6 ^ z << 10 ^ z << 12 ^ z << 13 ^ z << 14 ^ z << 15 ^ z << 16 ^ z << 20 ^ z << 23 ^ z << 24 ^ z << 25 ^ z << 27 ^ z << 29 ^ z << 32 ^ z << 33 ^ z << 37 ^ z << 40 ^ z << 41 ^ z << 50;
        z = this.substream[3] & 0xFFFFFFFFFFFE0000L;
        b = z ^ z << 5;
        this.substream[3] = z = b >>> 46 ^ b >>> 44 ^ b >>> 42 ^ b >>> 41 ^ b >>> 40 ^ b >>> 38 ^ b >>> 36 ^ b >>> 32 ^ b >>> 30 ^ b >>> 25 ^ b >>> 18 ^ b >>> 16 ^ b >>> 15 ^ b >>> 14 ^ b >>> 12 ^ b >>> 11 ^ b >>> 10 ^ b >>> 9 ^ b >>> 8 ^ b >>> 6 ^ b >>> 5 ^ b >>> 4 ^ b >>> 3 ^ b >>> 2 ^ z << 2 ^ z << 5 ^ z << 6 ^ z << 7 ^ z << 9 ^ z << 11 ^ z << 15 ^ z << 17 ^ z << 22 ^ z << 29 ^ z << 31 ^ z << 32 ^ z << 33 ^ z << 35 ^ z << 36 ^ z << 37 ^ z << 38 ^ z << 39 ^ z << 41 ^ z << 42 ^ z << 43 ^ z << 44 ^ z << 45;
        z = this.substream[4] & 0xFFFFFFFFFF800000L;
        b = z ^ z << 3;
        this.substream[4] = z = b >>> 40 ^ b >>> 29 ^ b >>> 10 ^ z << 1 ^ z << 12 ^ z << 31;
        this.resetStartSubstream();
    }

    public String toString() {
        if (this.name == null) {
            return "The state of the LFSR258 is: " + this.z0 + "L, " + this.z1 + "L, " + this.z2 + "L, " + this.z3 + "L, " + this.z4 + "L";
        }
        return "The state of " + this.name + " is: " + this.z0 + "L, " + this.z1 + "L, " + this.z2 + "L, " + this.z3 + "L, " + this.z4 + "L";
    }

    private long nextNumber() {
        long b = (this.z0 << 1 ^ this.z0) >>> 53;
        this.z0 = (this.z0 & 0xFFFFFFFFFFFFFFFEL) << 10 ^ b;
        b = (this.z1 << 24 ^ this.z1) >>> 50;
        this.z1 = (this.z1 & 0xFFFFFFFFFFFFFE00L) << 5 ^ b;
        b = (this.z2 << 3 ^ this.z2) >>> 23;
        this.z2 = (this.z2 & 0xFFFFFFFFFFFFF000L) << 29 ^ b;
        b = (this.z3 << 5 ^ this.z3) >>> 24;
        this.z3 = (this.z3 & 0xFFFFFFFFFFFE0000L) << 23 ^ b;
        b = (this.z4 << 3 ^ this.z4) >>> 33;
        this.z4 = (this.z4 & 0xFFFFFFFFFF800000L) << 8 ^ b;
        return this.z0 ^ this.z1 ^ this.z2 ^ this.z3 ^ this.z4;
    }

    protected double nextValue() {
        long res = this.nextNumber();
        if (res <= 0L) {
            return (double)res * 5.421010862427523E-20 + 0.9999999999999999;
        }
        return (double)res * 5.421010862427523E-20;
    }

    public int nextInt(int i, int j) {
        long res;
        if (i > j) {
            throw new IllegalArgumentException(i + " is larger than " + j + ".");
        }
        long d = j - i + 1;
        long q = 0x4000000000000000L / d;
        long r = 0x4000000000000000L % d;
        while ((res = this.nextNumber() >>> 2) >= 0x4000000000000000L - r) {
        }
        return i + (int)(res / q);
    }
}

