/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.map;

import fr.profi.mzdb.model.SpectrumSlice;
import fr.proline.mzscope.map.AbstractLcMsMapSpectrum;
import fr.proline.mzscope.map.LcMsMapChunk;

public class LcMsMapRtSpectrum
extends AbstractLcMsMapSpectrum {
    private double[] intensities = null;
    private double maxIntensity = 0.0;

    public LcMsMapRtSpectrum(LcMsMapChunk chunk, double sliceSizeRt) {
        super(chunk.getViewport().minRt, chunk.getViewport().maxRt, sliceSizeRt);
        double widthRt = chunk.getViewport().maxRt - chunk.getViewport().minRt;
        this.intensities = new double[this.getSliceCount()];
        for (SpectrumSlice slice : chunk.getSlices()) {
            double rt = slice.getHeader().getElutionTime();
            if (rt < chunk.getViewport().minRt || rt > chunk.getViewport().maxRt) continue;
            int rtIndex = this.getRtIndex(rt);
            if (rtIndex < 0 || rtIndex >= this.intensities.length) {
                System.out.println("rt index " + rtIndex + " out of bounds " + this.intensities.length);
                continue;
            }
            for (int dataIndex = 0; dataIndex < slice.getData().getIntensityList().length; ++dataIndex) {
                double mz = slice.getData().getMzList()[dataIndex];
                double intensity = slice.getData().getIntensityList()[dataIndex];
                if (mz < chunk.getViewport().minMz || mz > chunk.getViewport().maxMz) continue;
                int n = rtIndex;
                this.intensities[n] = this.intensities[n] + intensity;
                this.maxIntensity = Math.max(this.maxIntensity, this.intensities[rtIndex]);
            }
        }
    }

    @Override
    public final double[] getIntensities() {
        return this.intensities;
    }

    @Override
    public final double getIntensity(int rtIndex) throws IndexOutOfBoundsException {
        return this.intensities[rtIndex];
    }

    @Override
    public final double getMaxIntensity() {
        return this.maxIntensity;
    }

    private int getRtIndex(double rt) {
        return (int)((rt - this.getMinX()) / this.getSliceSize());
    }

    @Override
    public int getIndex(double xValue) {
        return this.getRtIndex(xValue);
    }

    @Override
    public double getIntensity(double rt) {
        return this.intensities[this.getRtIndex(rt)];
    }
}

