/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.model;

import fr.proline.mzscope.model.IPeakel;

public class PairedPeakel
implements Comparable<PairedPeakel> {
    private IPeakel m_peakel1 = null;
    private IPeakel m_peakel2 = null;
    private PairedPeakelStatus m_status = PairedPeakelStatus.NO_PAIRING;

    public void set(IPeakel peakel1, IPeakel peakel2, PairedPeakelStatus status) {
        this.m_peakel1 = peakel1;
        this.m_peakel2 = peakel2;
        this.m_status = status;
    }

    public IPeakel getPeakel1() {
        return this.m_peakel1;
    }

    public IPeakel getPeakel2() {
        return this.m_peakel2;
    }

    public double getMz() {
        if (this.m_peakel1 != null) {
            this.m_peakel1.getMz();
        }
        return this.m_peakel2.getMz();
    }

    public float getElutionTime() {
        if (this.m_peakel1 != null) {
            this.m_peakel1.getElutionTime();
        }
        return this.m_peakel2.getElutionTime();
    }

    public float getApexIntensity() {
        if (this.m_peakel1 != null) {
            this.m_peakel1.getApexIntensity();
        }
        return this.m_peakel2.getApexIntensity();
    }

    public PairedPeakelStatus getStatus() {
        return this.m_status;
    }

    @Override
    public int compareTo(PairedPeakel pp) {
        if (Math.abs(this.getMz() - pp.getMz()) > 0.0) {
            return this.getMz() < pp.getMz() ? -1 : 1;
        }
        if (Math.abs(this.getElutionTime() - pp.getElutionTime()) > 0.0f) {
            return this.getElutionTime() < pp.getElutionTime() ? -1 : 1;
        }
        return this.getApexIntensity() < pp.getApexIntensity() ? -1 : 1;
    }

    public static enum PairedPeakelStatus {
        NO_PAIRING("No Pairing"),
        PAIRING(""),
        MULTI_PAIRING("Multi Pairing"),
        PAIRING_APEX_PROBLEM("Apex Problem");

        private final String statusString;

        private PairedPeakelStatus(String s) {
            this.statusString = s;
        }

        public String toString() {
            return this.statusString;
        }
    }
}

