/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.processing;

import fr.profi.ms.algo.IsotopePatternEstimator;
import fr.profi.ms.model.TheoreticalIsotopePattern;
import fr.profi.mzdb.algo.DotProductPatternScorer;
import fr.profi.mzdb.algo.LegacyIsotopicPatternScorer;
import fr.profi.mzdb.model.SpectrumData;
import fr.proline.mzscope.processing.ChiSquareScorer;
import fr.proline.mzscope.processing.DotProductScorer;
import fr.proline.mzscope.processing.Scorer;
import fr.proline.mzscope.processing.SpectrumUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class IsotopicPatternUtils {
    private static final Logger logger = LoggerFactory.getLogger(IsotopicPatternUtils.class);
    private static final int MAX_CHARGE_STATE = 8;

    public static Map<Pattern, List<Double>> compareIsotopicPatternPredictions(SpectrumData spectrum, double mz, double ppmTol) {
        Pattern p;
        Tuple2[] putativePatterns;
        double fittedPpmTol = ppmTol;
        int nearestPeakIdx = SpectrumUtils.getNearestPeakIndex(spectrum.getMzList(), mz);
        if (SpectrumUtils.isInRange(spectrum.getMzList()[nearestPeakIdx], mz, ppmTol) && spectrum.getLeftHwhmList()[nearestPeakIdx] > 0.0f) {
            fittedPpmTol = (float)(1000000.0 * (double)spectrum.getLeftHwhmList()[nearestPeakIdx] / spectrum.getMzList()[nearestPeakIdx]);
        }
        HashMap<Pattern, List<Double>> map = new HashMap<Pattern, List<Double>>();
        for (Tuple2 t : putativePatterns = LegacyIsotopicPatternScorer.calcIsotopicPatternHypotheses((SpectrumData)spectrum, (double)mz, (double)fittedPpmTol)) {
            p = new Pattern(((TheoreticalIsotopePattern)t._2).monoMz(), ((TheoreticalIsotopePattern)t._2).charge());
            if (!map.containsKey(p)) {
                map.put(p, new ArrayList());
            }
            ((List)map.get(p)).add((Double)t._1);
        }
        for (Tuple2 t : putativePatterns = IsotopicPatternUtils._calcIsotopicPatternHypotheses(spectrum, mz, fittedPpmTol, new ChiSquareScorer())) {
            p = new Pattern(((TheoreticalIsotopePattern)t._2).monoMz(), ((TheoreticalIsotopePattern)t._2).charge());
            if (!map.containsKey(p)) {
                map.put(p, new ArrayList());
                ((List)map.get(p)).add(0.0);
            }
            ((List)map.get(p)).add((Double)t._1);
        }
        for (Tuple2 t : putativePatterns = IsotopicPatternUtils._calcIsotopicPatternHypotheses(spectrum, mz, fittedPpmTol, new DotProductScorer())) {
            p = new Pattern(((TheoreticalIsotopePattern)t._2).monoMz(), ((TheoreticalIsotopePattern)t._2).charge());
            if (!map.containsKey(p)) {
                map.put(p, new ArrayList());
                ((List)map.get(p)).add(0.0);
            }
            ((List)map.get(p)).add((Double)t._1);
        }
        IsotopicPatternUtils.tracePredictions("Comparison ([Proline, ChiSquare, DotProduct]", mz, ppmTol, map);
        return map;
    }

    public static Tuple2<Object, TheoreticalIsotopePattern> predictIsotopicPattern(SpectrumData spectrum, double mz, double ppmTol) {
        int putativeCharge;
        int k;
        double tol = 2.0 * ppmTol * mz / 1000000.0;
        HashSet<Integer> putativeCharges = new HashSet<Integer>();
        double[] mzList = spectrum.getMzList();
        int nearestPeakIdx = SpectrumUtils.getNearestPeakIndex(mzList, mz);
        for (k = nearestPeakIdx - 1; k >= 0 && mzList[nearestPeakIdx] - mzList[k] < tol + IsotopePatternEstimator.avgIsoMassDiff(); --k) {
            putativeCharge = Math.round((float)(1.0 / (mzList[nearestPeakIdx] - mzList[k])));
            if (!(Math.abs(mzList[nearestPeakIdx] - IsotopePatternEstimator.avgIsoMassDiff() / (double)putativeCharge - mzList[k]) < tol)) continue;
            putativeCharges.add(putativeCharge);
        }
        for (k = nearestPeakIdx + 1; k < spectrum.getPeaksCount() && mzList[k] - mzList[nearestPeakIdx] < tol + IsotopePatternEstimator.avgIsoMassDiff(); ++k) {
            putativeCharge = Math.round((float)(1.0 / (mzList[k] - mzList[nearestPeakIdx])));
            if (!(Math.abs(mzList[nearestPeakIdx] + IsotopePatternEstimator.avgIsoMassDiff() / (double)putativeCharge - mzList[k]) < tol)) continue;
            putativeCharges.add(putativeCharge);
        }
        List charges = putativeCharges.stream().filter(z -> z > 0 && z <= 8).sorted().collect(Collectors.toList());
        double fittedPpmTol = ppmTol;
        Tuple2[] putativePatterns = DotProductPatternScorer.calcIsotopicPatternHypotheses((SpectrumData)spectrum, (double)mz, (double)fittedPpmTol);
        Tuple2 bestPatternHypothese = DotProductPatternScorer.selectBestPatternHypothese((Tuple2[])putativePatterns, (double)0.1);
        double targetMz = mz;
        while (Math.abs(1000000.0 * (targetMz - ((TheoreticalIsotopePattern)bestPatternHypothese._2).monoMz()) / targetMz) > ppmTol) {
            targetMz = ((TheoreticalIsotopePattern)bestPatternHypothese._2).monoMz();
            putativePatterns = DotProductPatternScorer.calcIsotopicPatternHypothesesFromCharge((SpectrumData)spectrum, (double)targetMz, (int)((TheoreticalIsotopePattern)bestPatternHypothese._2).charge(), (double)fittedPpmTol);
            bestPatternHypothese = DotProductPatternScorer.selectBestPatternHypothese((Tuple2[])putativePatterns, (double)0.1);
        }
        return bestPatternHypothese;
    }

    private static void tracePredictions(String title, double mz, double ppmTol, Map<Pattern, List<Double>> putativePatterns) {
        logger.info(" ######### " + title);
        logger.info("Prediction for mz = " + mz + ", ppm = " + ppmTol);
        for (Map.Entry<Pattern, List<Double>> e : putativePatterns.entrySet()) {
            StringJoiner joiner = new StringJoiner(",", "[", "]");
            e.getValue().forEach(x -> joiner.add(String.format("%.3f", x)));
            Pattern pattern = e.getKey();
            logger.info("Mono at mz = " + String.format("%.3f", pattern.mz) + ", " + pattern.charge + "+ = " + joiner.toString());
        }
    }

    private static void tracePredictions(String title, double mz, double ppmTol, Tuple2<Object, TheoreticalIsotopePattern>[] putativePatterns) {
        logger.info(" ######### " + title);
        logger.info("Prediction for mz = " + mz + ", ppm = " + ppmTol);
        for (Tuple2<Object, TheoreticalIsotopePattern> t : putativePatterns) {
            Double score = (Double)t._1;
            TheoreticalIsotopePattern pattern = (TheoreticalIsotopePattern)t._2;
            logger.info("Pattern : " + score + ", " + pattern.charge() + "+, mz = " + pattern.monoMz());
        }
    }

    private static Tuple2<Object, TheoreticalIsotopePattern>[] _calcIsotopicPatternHypotheses(SpectrumData currentSpectrum, double mz, double ppmTol, Scorer scorer) {
        ArrayList<Tuple2<Double, TheoreticalIsotopePattern>> result = new ArrayList<Tuple2<Double, TheoreticalIsotopePattern>>();
        for (int charge = 1; charge <= 8; ++charge) {
            boolean existBackward;
            Tuple2<Double, TheoreticalIsotopePattern> p = scorer.score(currentSpectrum, mz, 0, charge, ppmTol);
            int j = 1;
            double backwardMz = mz - (double)j * IsotopePatternEstimator.avgIsoMassDiff() / (double)charge;
            int nearestPeakIdx = SpectrumUtils.getNearestPeakIndex(currentSpectrum.getMzList(), backwardMz);
            boolean bl = existBackward = 1000000.0 * Math.abs(currentSpectrum.getMzList()[nearestPeakIdx] - backwardMz) / backwardMz < ppmTol;
            while (existBackward && j <= ((TheoreticalIsotopePattern)p._2).theoreticalMaxPeakelIndex() + 1) {
                Tuple2<Double, TheoreticalIsotopePattern> alternativeP = scorer.score(currentSpectrum, mz, j, charge, ppmTol);
                result.add(alternativeP);
                backwardMz = mz - (double)(++j) * IsotopePatternEstimator.avgIsoMassDiff() / (double)charge;
                nearestPeakIdx = SpectrumUtils.getNearestPeakIndex(currentSpectrum.getMzList(), backwardMz);
                existBackward = 1000000.0 * Math.abs(currentSpectrum.getMzList()[nearestPeakIdx] - backwardMz) / backwardMz < ppmTol;
            }
            result.add(p);
        }
        if (!result.isEmpty()) {
            Collections.sort(result, (o1, o2) -> {
                int sign = (int)Math.signum((Double)o1._1 - (Double)o2._1);
                return sign == 0 ? ((TheoreticalIsotopePattern)o2._2).charge() - ((TheoreticalIsotopePattern)o1._2).charge() : sign;
            });
        }
        Tuple2[] patterns = result.toArray(new Tuple2[result.size()]);
        return patterns;
    }

    static class Pattern {
        public double mz;
        public int charge;

        public Pattern(double mz, int charge) {
            this.mz = mz;
            this.charge = charge;
        }

        public int hashCode() {
            int hash = 8;
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Pattern other = (Pattern)obj;
            if (Double.doubleToLongBits(this.mz) != Double.doubleToLongBits(other.mz)) {
                return false;
            }
            return this.charge == other.charge;
        }
    }
}

