/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.ui.model;

import fr.proline.mzscope.model.Mobilogram;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.ExtraDataType;
import fr.proline.studio.graphics.PlotDataSpec;
import fr.proline.studio.graphics.PlotInformation;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.table.AbstractTableModel;

public class MobilogramTableModel
extends AbstractTableModel
implements ExtendedTableModelInterface {
    private static final String[] m_columnNames = new String[]{"mobility", "intensities"};
    public static final int COLTYPE_MOBILOGRAM_DRIFT_TIME = 0;
    public static final int COLTYPE_MOBILOGRAM_INTENSITIES = 1;
    private Mobilogram mobilogram;
    private String m_modelName;
    private Color color;
    private PlotInformation plotInformation;

    public MobilogramTableModel(Mobilogram mobilogram) {
        this.mobilogram = mobilogram;
        this.plotInformation = new PlotInformation();
        this.plotInformation.setPlotColor(this.color);
        this.plotInformation.setPlotTitle(mobilogram.getTitle());
    }

    @Override
    public int getRowCount() {
        return this.mobilogram == null ? 0 : this.mobilogram.getMobilities().length;
    }

    @Override
    public int getColumnCount() {
        return m_columnNames.length;
    }

    @Override
    public String getColumnName(int col) {
        return m_columnNames[col];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.mobilogram.getMobilities()[rowIndex];
            }
            case 1: {
                return Float.valueOf(this.mobilogram.getIntensities()[rowIndex]);
            }
        }
        return null;
    }

    public String getDataColumnIdentifier(int columnIndex) {
        return this.getColumnName(columnIndex);
    }

    public Class getDataColumnClass(int columnIndex) {
        return Double.class;
    }

    public Object getDataValueAt(int rowIndex, int columnIndex) {
        return this.getValueAt(rowIndex, columnIndex);
    }

    public int[] getKeysColumn() {
        int[] keys = new int[]{0};
        return keys;
    }

    public int getInfoColumn() {
        return 1;
    }

    public void setName(String name) {
        this.m_modelName = name;
    }

    public String getName() {
        return this.m_modelName;
    }

    public Map<String, Object> getExternalData() {
        return null;
    }

    public PlotInformation getPlotInformation() {
        return this.plotInformation;
    }

    public void setColor(Color c) {
        this.color = c;
        this.plotInformation.setPlotColor(this.color);
    }

    public long row2UniqueId(int rowIndex) {
        return rowIndex;
    }

    public int uniqueId2Row(long id) {
        return (int)id;
    }

    public ArrayList<ExtraDataType> getExtraDataTypes() {
        return null;
    }

    public Object getValue(Class c) {
        return null;
    }

    public Object getRowValue(Class c, int row) {
        return null;
    }

    public Object getColValue(Class c, int col) {
        return null;
    }

    public void addSingleValue(Object v) {
    }

    public Object getSingleValue(Class c) {
        return null;
    }

    public PlotDataSpec getDataSpecAt(int i) {
        return null;
    }
}

