/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.utils;

import fr.proline.studio.utils.IconManager;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.EventListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.EventListenerList;
import javax.swing.plaf.basic.BasicButtonUI;

public class ButtonTabComponent
extends JPanel {
    private EventListenerList closeListenerList = new EventListenerList();
    private JButton waitingButton = null;
    private JButton closeButton = null;
    private static final MouseListener buttonMouseListener = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent e) {
            Component component = e.getComponent();
            if (component instanceof AbstractButton) {
                AbstractButton button = (AbstractButton)component;
                button.setBorderPainted(true);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            Component component = e.getComponent();
            if (component instanceof AbstractButton) {
                AbstractButton button = (AbstractButton)component;
                button.setBorderPainted(false);
            }
        }
    };

    public ButtonTabComponent(String text) {
        super(new FlowLayout(0, 0, 0));
        this.setOpaque(false);
        final String tabTile = text;
        JLabel label = new JLabel(){

            @Override
            public String getText() {
                return tabTile;
            }
        };
        this.add(label);
        label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        this.closeButton = new TabButton();
        this.add(this.closeButton);
        this.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
    }

    public void setWaitingState(boolean waitingState) {
        if (waitingState) {
            if (this.closeButton != null) {
                this.closeButton.setEnabled(false);
            }
            this.add((Component)this.getWaitingButton(), 0);
        } else if (this.waitingButton != null) {
            this.remove(0);
            this.waitingButton = null;
            if (this.closeButton != null) {
                this.closeButton.setEnabled(true);
            }
        }
        this.repaint();
    }

    private JButton getWaitingButton() {
        if (this.waitingButton == null) {
            this.waitingButton = new JButton(IconManager.getIcon((IconManager.IconType)IconManager.IconType.HOUR_GLASS_MINI9));
            this.waitingButton.setToolTipText("loading data");
            this.waitingButton.setUI(new BasicButtonUI());
            this.waitingButton.setContentAreaFilled(false);
            this.waitingButton.setFocusable(false);
            this.waitingButton.setBorder(BorderFactory.createEtchedBorder());
            this.waitingButton.setBorderPainted(false);
        }
        return this.waitingButton;
    }

    public void addCloseTabListener(CloseTabListener listener) {
        this.closeListenerList.add(CloseTabListener.class, listener);
    }

    public void removeCloseTabListener(CloseTabListener listener) {
        this.closeListenerList.remove(CloseTabListener.class, listener);
    }

    private void fireCloseTab() {
        Object[] listeners = this.closeListenerList.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != CloseTabListener.class) continue;
            ((CloseTabListener)listeners[i + 1]).closeTab(this);
        }
    }

    private class TabButton
    extends JButton
    implements ActionListener {
        private final BasicStroke stroke = new BasicStroke(2.0f, 1, 1);

        public TabButton() {
            this.init();
        }

        private void init() {
            int size = 17;
            this.setPreferredSize(new Dimension(size, size));
            this.setToolTipText("close this tab");
            this.setUI(new BasicButtonUI());
            this.setContentAreaFilled(false);
            this.setFocusable(false);
            this.setBorder(BorderFactory.createEtchedBorder());
            this.setBorderPainted(false);
            this.addMouseListener(buttonMouseListener);
            this.setRolloverEnabled(true);
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ButtonTabComponent.this.fireCloseTab();
        }

        @Override
        public void updateUI() {
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g.create();
            if (this.getModel().isPressed()) {
                g2.translate(1, 1);
            }
            g2.setStroke(this.stroke);
            g2.setColor(Color.DARK_GRAY);
            if (this.getModel().isRollover()) {
                g2.setColor(Color.LIGHT_GRAY);
            }
            int delta = 6;
            g2.drawLine(delta, delta, this.getWidth() - delta - 1, this.getHeight() - delta - 1);
            g2.drawLine(this.getWidth() - delta - 1, delta, delta, this.getHeight() - delta - 1);
            g2.dispose();
        }
    }

    public static interface CloseTabListener
    extends EventListener {
        public void closeTab(ButtonTabComponent var1);
    }
}

