/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.utils;

import com.github.psambit9791.jdsp.misc.UtilMethods;
import com.github.psambit9791.jdsp.signal.Convolution;
import com.github.psambit9791.jdsp.signal.Smooth;
import com.github.psambit9791.jdsp.signal.peaks.FindPeak;
import com.github.psambit9791.jdsp.signal.peaks.Peak;
import java.util.Arrays;
import java.util.List;
import jwave.Transform;
import jwave.compressions.CompressorMagnitude;
import jwave.compressions.CompressorPeaksAverage;
import jwave.transforms.AncientEgyptianDecomposition;
import jwave.transforms.BasicTransform;
import jwave.transforms.DiscreteFourierTransform;
import jwave.transforms.FastWaveletTransform;
import jwave.transforms.wavelets.Wavelet;
import jwave.transforms.wavelets.WaveletBuilder;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.math3.analysis.function.Gaussian;
import org.apache.commons.math3.analysis.polynomials.PolynomialFunction;
import org.apache.commons.math3.stat.StatUtils;
import org.apache.commons.math3.stat.correlation.PearsonsCorrelation;
import org.apache.commons.math3.stat.descriptive.moment.StandardDeviation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class SmoothUtils {
    private static final Logger logger = LoggerFactory.getLogger(SmoothUtils.class);

    public static void peakRestorer(double[] initialSignal, double[] smoothedSignal, double[] x, double ratio) {
        FindPeak fp = new FindPeak(initialSignal);
        Peak out = fp.detectPeaks();
        int[] peaks = out.getPeaks();
        double[] heightOfPeaks = out.getHeights();
        double maxPeak = 0.0;
        for (double heightOfPeak : heightOfPeaks) {
            if (!(maxPeak < heightOfPeak)) continue;
            maxPeak = heightOfPeak;
        }
        double[] xValuesOfPeaks = new double[peaks.length];
        for (int i = 0; i < peaks.length; ++i) {
            xValuesOfPeaks[i] = x[peaks[i]];
        }
        int countPeaksRestored = 0;
        for (int k = 0; k < smoothedSignal.length; ++k) {
            for (int i = 0; i < xValuesOfPeaks.length; ++i) {
                if (xValuesOfPeaks[i] != x[k] || !(heightOfPeaks[i] > ratio * maxPeak)) continue;
                smoothedSignal[k] = heightOfPeaks[i];
                ++countPeaksRestored;
            }
        }
        logger.info("peaks restored " + countPeaksRestored + " times ");
        logger.info("peaks with a height superior to " + ratio * 100.0 + " percent of the highest peak have been restored");
    }

    public static double[] getSlopes(double[] signal) {
        double[] signalSlopes = new double[signal.length - 1];
        for (int k = 0; k < signal.length - 1; ++k) {
            signalSlopes[k] = signal[k + 1] - signal[k];
        }
        return signalSlopes;
    }

    public static double[] getDerivatives(double[] x, double[] y) {
        double[] signalDerivatives = new double[x.length - 1];
        for (int k = 0; k < x.length - 1; ++k) {
            signalDerivatives[k] = (y[k + 1] - y[k]) / (x[k + 1] - x[k]);
        }
        return signalDerivatives;
    }

    public static double[] getSlopeAngles(double[] x, double[] y) {
        double[] signalSlopeAngles = new double[x.length - 1];
        for (int k = 0; k < x.length - 1; ++k) {
            signalSlopeAngles[k] = Math.atan((y[k + 1] - y[k]) / (x[k + 1] - x[k]));
        }
        return signalSlopeAngles;
    }

    public static double getSmoothness(double[] signal) {
        double[] slopes = SmoothUtils.getSlopes(signal);
        double roughness = 0.0;
        for (int k = 0; k < slopes.length - 1; ++k) {
            boolean slopeChanged;
            boolean notCloseToBoundaries = k > 0 && k < slopes.length - 1;
            boolean curveHasAHat = false;
            if (notCloseToBoundaries) {
                curveHasAHat = slopes[k - 1] != 0.0 && slopes[k] == 0.0 && slopes[k + 1] != 0.0;
            }
            boolean bl = slopeChanged = slopes[k] * slopes[k + 1] < 0.0;
            if (!slopeChanged && !curveHasAHat) continue;
            roughness += 1.0;
        }
        return 1.0 - roughness / (double)slopes.length;
    }

    public static double evaluateSignalRoughnessV3(double[] signal) {
        double[] slopes = SmoothUtils.getSlopes(signal);
        double[] peakThreshold = new double[]{0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8};
        double roughness = 0.0;
        double maxValueInSignal = Arrays.stream(signal).max().getAsDouble();
        for (double v : peakThreshold) {
            double maxValueOfSignalThreshold = maxValueInSignal * v;
            int numberOfHighPeaks = 0;
            for (int k = 0; k < slopes.length - 1; ++k) {
                boolean peakHasHighAmplitude;
                boolean slopeChanged;
                boolean bl = slopeChanged = slopes[k] > 0.0 && slopes[k + 1] < 0.0 || slopes[k] < 0.0 && slopes[k + 1] > 0.0;
                if (!slopeChanged) continue;
                boolean bl2 = peakHasHighAmplitude = Math.abs(signal[k + 1] - signal[k]) > maxValueOfSignalThreshold;
                if (!peakHasHighAmplitude) continue;
                ++numberOfHighPeaks;
            }
            double density = (double)numberOfHighPeaks * v * 10.0;
            roughness += density;
        }
        return roughness / (double)signal.length;
    }

    public static double calculateDistanceToOptimalPoint(double correlation, double smoothness) {
        return Math.sqrt((1.0 - correlation) * (1.0 - correlation) * 100.0 + (1.0 - smoothness) * (1.0 - smoothness));
    }

    public static int findBestWavelet(double[] correlations, double[] smoothness) {
        int bestWaveletIndex = 7;
        boolean valueFound = false;
        for (int k = 1; k < 1999; ++k) {
            for (int i = 0; i < 51 && i != 7; ++i) {
                double correlation = correlations[i];
                double smooth = smoothness[i];
                double threshold = (double)k / 1000.0;
                if (!(correlation > -smooth + 2.0 - threshold)) continue;
                bestWaveletIndex = i;
                valueFound = true;
                break;
            }
            if (valueFound) break;
        }
        return bestWaveletIndex;
    }

    public static int findBestWaveletEuclidAndSmoothness(double[] euclideanDistance, double[] smoothness) {
        int bestWaveletIndex = 7;
        boolean valueFound = false;
        double euclidMax = Arrays.stream(euclideanDistance).max().getAsDouble();
        for (int k = 0; k < 50; ++k) {
            for (int i = 1; i < 51 && i != 7; ++i) {
                double euclidDist = euclideanDistance[i];
                double smooth = smoothness[i];
                double threshold = (double)k / 100.0;
                if (!(euclidDist < euclidMax * (smooth - 1.0 + threshold))) continue;
                bestWaveletIndex = i;
                valueFound = true;
                break;
            }
            if (valueFound) break;
        }
        if (!valueFound) {
            logger.info("No wavelet filled conditions, will use Daubechies 8 wavelet");
        }
        return bestWaveletIndex;
    }

    public static void correctNegativeValues(double[] initialArray, double[] smoothedSignal) {
        for (int k = 0; k < initialArray.length; ++k) {
            if (!(smoothedSignal[k] < 0.0)) continue;
            smoothedSignal[k] = initialArray[k];
        }
    }

    public static double[] compressImprovedMethod(double[] arr, double threshold) {
        int arrLength = arr.length;
        double[] arrComp = new double[arrLength];
        double magnitude = 0.0;
        for (double v : arr) {
            magnitude += Math.abs(v);
        }
        magnitude = threshold * magnitude / (double)arrLength;
        for (int i = 0; i < arrLength; ++i) {
            if (arr[i] >= magnitude) {
                arrComp[i] = arr[i] - 2.0 * magnitude / (1.0 + Math.exp(magnitude - arr[i]));
            }
            if (Math.abs(arr[i]) < magnitude) {
                arrComp[i] = 0.0;
            }
            if (!(arr[i] <= -magnitude)) continue;
            arrComp[i] = arr[i] + 2.0 * magnitude / (1.0 + Math.exp(magnitude + arr[i]));
        }
        return arrComp;
    }

    public static double[] compressSoftMethod(double[] arr, double threshold) {
        int arrLength = arr.length;
        double[] arrComp = new double[arrLength];
        double magnitude = 0.0;
        for (int k = 0; k < arr.length; ++k) {
            magnitude += Math.abs(arr[k]);
        }
        magnitude /= (double)arrLength;
        for (int i = 0; i < arrLength; ++i) {
            arrComp[i] = Math.abs(arr[i]) >= threshold * magnitude ? Math.signum(arr[i]) * (Math.abs(arr[i]) - magnitude) : 0.0;
        }
        return arrComp;
    }

    public static double computeSignalPower(double[] signal) {
        double energy = 0.0;
        for (int k = 0; k < signal.length; ++k) {
            energy += signal[k] * signal[k];
        }
        return energy / (double)signal.length;
    }

    public static double computeAbsoluteBias(double[] initialValues, double[] smoothedValues) {
        double bias = 0.0;
        int numberOfValues = initialValues.length;
        for (int k = 0; k < numberOfValues; ++k) {
            bias += Math.abs(initialValues[k] - smoothedValues[k]);
        }
        return bias /= (double)numberOfValues;
    }

    public static double computeRelativeBias(double[] initialValues, double[] smoothedValues) {
        double bias = 0.0;
        int numberOfValues = initialValues.length;
        for (int k = 0; k < numberOfValues; ++k) {
            bias += initialValues[k] - smoothedValues[k];
        }
        return bias /= (double)numberOfValues;
    }

    public static double[] signalMixer(double[] signal1, double[] signal2, double weight1) {
        double[] averageSignal = new double[signal1.length];
        for (int k = 0; k < signal1.length; ++k) {
            averageSignal[k] = (weight1 * signal1[k] + (1.0 - weight1) * signal2[k]) / 2.0;
        }
        return averageSignal;
    }

    public static int indexOf(double[] array, double value) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != value) continue;
            return i;
        }
        return -1;
    }

    public static double computeEnergyDifference(double[] signal1, double[] signal2) {
        return Math.abs(SmoothUtils.computeSignalPower(signal1) - SmoothUtils.computeSignalPower(signal2));
    }

    public static double[] fourierCompressor(double[] signal, double threshold, boolean usePeakRestore, double[] x, double ratio) {
        Transform fourierTransform = new Transform((BasicTransform)new AncientEgyptianDecomposition((BasicTransform)new DiscreteFourierTransform()));
        double[] fourierSignal = fourierTransform.forward(signal);
        CompressorMagnitude fourierCompressor = new CompressorMagnitude(threshold);
        double[] compressedSignal = fourierCompressor.compress(fourierSignal);
        double[] rebuildSignal = fourierTransform.reverse(compressedSignal);
        SmoothUtils.correctNegativeValues(signal, rebuildSignal);
        if (usePeakRestore) {
            SmoothUtils.peakRestorer(signal, rebuildSignal, x, ratio);
        }
        logger.info("initial smoothness:  " + SmoothUtils.getSmoothness(signal) + " final smoothness: " + SmoothUtils.getSmoothness(rebuildSignal));
        return rebuildSignal;
    }

    public static double computeSignalToNoiseRatio(double[] initialSignal, double[] finalSignal) {
        double[] noiseSignal = new double[initialSignal.length];
        for (int k = 0; k < initialSignal.length; ++k) {
            noiseSignal[k] = initialSignal[k] - finalSignal[k];
        }
        double powerInitial = SmoothUtils.computeSignalPower(initialSignal);
        double powerNoise = SmoothUtils.computeSignalPower(noiseSignal);
        return 10.0 * Math.log10(powerInitial / powerNoise);
    }

    public static double[] filter(double[] signal, int windowSize, float percentile) {
        if (windowSize >= signal.length) {
            throw new IllegalArgumentException("Window size cannot be greater than or equal to signal length");
        }
        int paddingSize = (windowSize - 1) / 2;
        double[] cons = new double[paddingSize];
        double[] newSignal = new double[signal.length];
        Arrays.fill(cons, 0.0);
        double[] paddedSignal = new double[]{};
        paddedSignal = UtilMethods.concatenateArray((double[])paddedSignal, (double[])cons);
        paddedSignal = UtilMethods.concatenateArray((double[])paddedSignal, (double[])signal);
        paddedSignal = UtilMethods.concatenateArray((double[])paddedSignal, (double[])cons);
        for (int i = 0; i < signal.length; ++i) {
            newSignal[i] = StatUtils.percentile((double[])paddedSignal, (int)i, (int)windowSize, (double)percentile);
        }
        return newSignal;
    }

    public static double[] buildKernel(int n) {
        if (n <= 1) {
            n = 2;
        }
        double[] kernel = new double[n];
        double value = 1.0 / (double)n;
        for (int k = 0; k < n; ++k) {
            kernel[k] = value;
        }
        return kernel;
    }

    public static double[] buildSymmetricGaussian(double[] params, double minX, double maxX, int nbrPoints) {
        double norm = params[0];
        double mean = params[1];
        double sigma = params[2];
        double[] gaussianSignal = new double[nbrPoints];
        Gaussian gaussian = new Gaussian(norm, mean, sigma);
        for (int k = 0; k < nbrPoints; ++k) {
            double x = (maxX - minX) / (double)nbrPoints * (double)k;
            gaussianSignal[k] = gaussian.value(minX + x);
        }
        return gaussianSignal;
    }

    public static double[] buildAsymmetricGaussian(double norm, double mean, double sigmaLeft, double sigmaRight, double minX, double maxX, int nbrPoints) {
        double[] gaussianSignal = new double[nbrPoints];
        Gaussian gaussianLeft = new Gaussian(norm, mean, sigmaLeft);
        Gaussian gaussianRight = new Gaussian(norm, mean, sigmaRight);
        for (int k = 0; k < nbrPoints; ++k) {
            double x = (maxX - minX) / (double)nbrPoints * (double)k;
            gaussianSignal[k] = minX + x <= mean ? gaussianLeft.value(minX + x) : gaussianRight.value(minX + x);
        }
        return gaussianSignal;
    }

    public static double getBestGaussianMean(double[] params, double xMin, double xMax, int nbrPoints, double[] initialSignal) {
        double delta = 0.45 * (xMax - xMin);
        double norm = params[0];
        double bestMean = params[1];
        double sigma = params[2];
        double[] firstSmoothedSignal = new double[nbrPoints];
        Gaussian initialGaussian = new Gaussian(norm, bestMean, sigma);
        for (int i = 0; i < nbrPoints; ++i) {
            double x = (xMax - xMin) / (double)nbrPoints * (double)i;
            firstSmoothedSignal[i] = initialGaussian.value(xMin + x);
        }
        double bestCorrelation = SmoothUtils.computeEuclideanDistance(firstSmoothedSignal, initialSignal);
        for (int k = 0; k < 11; ++k) {
            double testedMean = params[1] - delta + (double)k * delta / 5.0;
            double[] testedSignal = new double[nbrPoints];
            Gaussian gaussian = new Gaussian(norm, testedMean, sigma);
            for (int i = 0; i < nbrPoints; ++i) {
                double x = (xMax - xMin) / (double)nbrPoints * (double)i;
                testedSignal[i] = gaussian.value(xMin + x);
            }
            double correlation = SmoothUtils.computeEuclideanDistance(testedSignal, initialSignal);
            if (!(correlation < bestCorrelation)) continue;
            bestMean = testedMean;
            bestCorrelation = correlation;
        }
        return bestMean;
    }

    public static double getBestGaussianSigmaSymmetric(double[] params, double xMin, double xMax, int nbrPoints, double[] initialSignal) {
        double norm = params[0];
        double sigma = params[2];
        double mean = params[1];
        double[] firstSmoothedSignal = new double[nbrPoints];
        Gaussian initialGaussian = new Gaussian(norm, mean, sigma);
        for (int i = 0; i < nbrPoints; ++i) {
            double x = (xMax - xMin) / (double)nbrPoints * (double)i;
            firstSmoothedSignal[i] = initialGaussian.value(xMin + x);
        }
        double bestCorrelation = SmoothUtils.computeEuclideanDistance(firstSmoothedSignal, initialSignal);
        double deltaSigma = 0.3 * sigma;
        double bestSigma = sigma;
        for (int k = 0; k < 31; ++k) {
            double testedSigma = sigma - deltaSigma + 2.0 * deltaSigma * (double)k / 30.0;
            double[] testedSignal = new double[nbrPoints];
            Gaussian gaussian = new Gaussian(norm, mean, testedSigma);
            for (int i = 0; i < nbrPoints; ++i) {
                double x = (xMax - xMin) / (double)nbrPoints * (double)i;
                testedSignal[i] = gaussian.value(xMin + x);
            }
            double correlation = SmoothUtils.computeEuclideanDistance(testedSignal, initialSignal);
            if (!(correlation < bestCorrelation)) continue;
            bestSigma = testedSigma;
            bestCorrelation = correlation;
        }
        return bestSigma;
    }

    public static double[] computeOptimalSigmas(double[] initialGaussianParameters, double xMin, double xMax, int nbrPoints, double[] initialSignal) {
        double sigma;
        int steps = 30;
        double norm = initialGaussianParameters[0];
        double mean = initialGaussianParameters[1];
        double bestLeftSigma = sigma = initialGaussianParameters[2];
        double bestRightSigma = sigma;
        double[] firstSmoothedSignal = new double[nbrPoints];
        Gaussian initialGaussian = new Gaussian(norm, mean, sigma);
        for (int i = 0; i < nbrPoints; ++i) {
            double x = (xMax - xMin) / (double)nbrPoints * (double)i;
            firstSmoothedSignal[i] = initialGaussian.value(xMin + x);
        }
        double bestCorrelation = SmoothUtils.computeEuclideanDistance(firstSmoothedSignal, initialSignal);
        double deltaSigma = 90.0 * sigma / 100.0;
        for (int k = 0; k < steps; ++k) {
            double leftSigma = sigma - deltaSigma + deltaSigma * 2.0 * (double)k / (double)steps;
            for (int i = 0; i < steps; ++i) {
                double rightSigma = sigma - deltaSigma + deltaSigma * 2.0 * (double)i / (double)steps;
                double[] theoreticalSignal = SmoothUtils.buildAsymmetricGaussian(norm, mean, leftSigma, rightSigma, xMin, xMax, nbrPoints);
                double correlation = SmoothUtils.computeEuclideanDistance(theoreticalSignal, initialSignal);
                if (!(correlation < bestCorrelation)) continue;
                bestCorrelation = correlation;
                bestRightSigma = rightSigma;
                bestLeftSigma = leftSigma;
            }
        }
        double[] sigmas = new double[]{bestLeftSigma, bestRightSigma};
        return sigmas;
    }

    public static double[] computeOptimalGaussianParameters(double[] initialGaussianParameters, double xMin, double xMax, int nbrPoints, double[] initialSignal) {
        double sigma;
        int steps = 30;
        double norm = initialGaussianParameters[0];
        double mean = initialGaussianParameters[1];
        double bestLeftSigma = sigma = initialGaussianParameters[2];
        double bestRightSigma = sigma;
        double bestNorm = norm;
        double bestMean = mean;
        double[] firstSmoothedSignal = new double[nbrPoints];
        Gaussian initialGaussian = new Gaussian(norm, mean, sigma);
        for (int i = 0; i < nbrPoints; ++i) {
            double x = (xMax - xMin) / (double)nbrPoints * (double)i;
            firstSmoothedSignal[i] = initialGaussian.value(xMin + x);
        }
        double bestCorrelation = SmoothUtils.computeEuclideanDistance(firstSmoothedSignal, initialSignal);
        double deltaSigma = 20.0 * sigma / 100.0;
        double deltaNorm = 20.0 * norm / 100.0;
        double deltaMean = 20.0 * mean / 100.0;
        for (int k = 0; k < steps; ++k) {
            double leftSigma = sigma - deltaSigma + deltaSigma * 2.0 * (double)k / (double)steps;
            for (int i = 0; i < steps; ++i) {
                double rightSigma = sigma - deltaSigma + deltaSigma * 2.0 * (double)i / (double)steps;
                for (int j = 0; j < steps; ++j) {
                    double meanTested = mean - deltaMean + deltaMean * 2.0 * (double)j / (double)steps;
                    for (int l = 0; l < steps; ++l) {
                        double normTested = norm - deltaNorm + deltaNorm * 2.0 * (double)l / (double)steps;
                        double[] theoreticalSignal = SmoothUtils.buildAsymmetricGaussian(normTested, meanTested, leftSigma, rightSigma, xMin, xMax, nbrPoints);
                        double correlation = SmoothUtils.computeEuclideanDistance(theoreticalSignal, initialSignal);
                        if (!(correlation < bestCorrelation)) continue;
                        bestCorrelation = correlation;
                        bestNorm = normTested;
                        bestMean = meanTested;
                        bestLeftSigma = leftSigma;
                        bestRightSigma = rightSigma;
                    }
                }
            }
        }
        double[] optimalParameters = new double[]{bestNorm, bestMean, bestLeftSigma, bestRightSigma};
        return optimalParameters;
    }

    public static double ComputePearsonCorrelation(double[] initialSignal, double[] transformedSignal) {
        return new PearsonsCorrelation().correlation(transformedSignal, initialSignal);
    }

    public static double computeEuclideanDistance(double[] signal1, double[] signal2) {
        if (signal1.length != signal2.length) {
            throw new IllegalArgumentException("Signals must have same length");
        }
        double sumOfSquared = 0.0;
        for (int i = 0; i < signal1.length; ++i) {
            double difference = signal1[i] - signal2[i];
            sumOfSquared += difference * difference;
        }
        return Math.sqrt(sumOfSquared) / (double)signal1.length;
    }

    public static int getBestSmoothWindowSize(double[] initialSignal) {
        int bestWindowSize = 5;
        String mode = "triangular";
        Smooth s1 = new Smooth(initialSignal, bestWindowSize, mode);
        double[] testSignal = s1.smoothSignal("same");
        double bestDistance = SmoothUtils.computeEuclideanDistance(initialSignal, testSignal);
        for (int k = 0; k < 6; ++k) {
            int windowTested = bestWindowSize - 2 + k;
            Smooth s = new Smooth(initialSignal, windowTested, mode);
            double[] smoothSignal = s.smoothSignal("same");
            double distance = SmoothUtils.computeEuclideanDistance(initialSignal, smoothSignal);
            if (!(distance < bestDistance)) continue;
            bestWindowSize = windowTested;
            bestDistance = distance;
        }
        return bestWindowSize;
    }

    public static double gaussian(double norm, double mean, double sigma, double x) {
        double exponent = -0.5 * Math.pow((x - mean) / sigma, 2.0);
        return norm * Math.exp(exponent) / (sigma * Math.sqrt(Math.PI * 2));
    }

    public static double getMaxFromArray(double[] parsedArray) {
        double max = 0.0;
        for (int k = 0; k < parsedArray.length; ++k) {
            if (!(max < parsedArray[k])) continue;
            max = parsedArray[k];
        }
        return max;
    }

    public static Pair<double[], String> waveletSmoother(List<Tuple2> xyPairs, String smoothMethod, double threshold, int waveletIndex, boolean userSelectedAWavelet) {
        Tuple2[] result = xyPairs.toArray(new Tuple2[xyPairs.size()]);
        double[] x = new double[result.length];
        double[] y = new double[result.length];
        for (int k = 0; k < result.length; ++k) {
            x[k] = (Double)result[k]._1;
            y[k] = (Double)result[k]._2;
        }
        Wavelet[] arrOfWaveletObjects = WaveletBuilder.create2arr();
        CompressorMagnitude compressor = new CompressorMagnitude(threshold);
        CompressorPeaksAverage compressor2 = new CompressorPeaksAverage(threshold);
        if (userSelectedAWavelet) {
            Wavelet wavelet = arrOfWaveletObjects[waveletIndex];
            Transform fwt = new Transform((BasicTransform)new AncientEgyptianDecomposition((BasicTransform)new FastWaveletTransform(wavelet)));
            double[] transformedSignal = fwt.forward(y);
            double[] compressedSignal = compressor.compress(transformedSignal);
            double[] rebuiltSignal = fwt.reverse(compressedSignal);
            SmoothUtils.correctNegativeValues(y, rebuiltSignal);
            String waveletName = wavelet.getName();
            return Pair.of((Object)rebuiltSignal, (Object)waveletName);
        }
        double[] valuesOfBias = new double[arrOfWaveletObjects.length];
        double[] energyDifference = new double[arrOfWaveletObjects.length];
        double[] valuesOfROC = new double[arrOfWaveletObjects.length];
        double[] valuesOfSNR = new double[arrOfWaveletObjects.length];
        double[] valuesOfSmoothness = new double[arrOfWaveletObjects.length];
        double[] correlations = new double[arrOfWaveletObjects.length];
        double[] distanceToOptimalPoint = new double[arrOfWaveletObjects.length];
        double[] distanceToInitialSignal = new double[arrOfWaveletObjects.length];
        for (int i = 0; i < arrOfWaveletObjects.length; ++i) {
            Wavelet wavelet = arrOfWaveletObjects[i];
            Transform fwt = new Transform((BasicTransform)new AncientEgyptianDecomposition((BasicTransform)new FastWaveletTransform(wavelet)));
            double[] transformedSignal = fwt.forward(y);
            double[] compressedSignal = compressor.compress(transformedSignal);
            double[] rebuiltSignal = fwt.reverse(compressedSignal);
            SmoothUtils.correctNegativeValues(y, rebuiltSignal);
            valuesOfBias[i] = SmoothUtils.computeAbsoluteBias(y, rebuiltSignal);
            valuesOfSNR[i] = SmoothUtils.computeSignalToNoiseRatio(y, rebuiltSignal);
            energyDifference[i] = SmoothUtils.computeEnergyDifference(rebuiltSignal, y);
            valuesOfSmoothness[i] = SmoothUtils.getSmoothness(rebuiltSignal);
            correlations[i] = Math.abs(SmoothUtils.ComputePearsonCorrelation(y, rebuiltSignal));
            distanceToOptimalPoint[i] = SmoothUtils.calculateDistanceToOptimalPoint(correlations[i], valuesOfSmoothness[i]);
            distanceToInitialSignal[i] = SmoothUtils.computeEuclideanDistance(y, rebuiltSignal);
        }
        int indexOfOptimalWavelet = SmoothUtils.findBestWavelet(correlations, valuesOfSmoothness);
        int indexOfEuclideanSmoothness = SmoothUtils.findBestWaveletEuclidAndSmoothness(distanceToInitialSignal, valuesOfSmoothness);
        double minDistance = distanceToInitialSignal[0];
        int indexOfMinDist = 0;
        for (int k = 0; k < arrOfWaveletObjects.length; ++k) {
            if (!(minDistance > distanceToInitialSignal[k])) continue;
            minDistance = distanceToInitialSignal[k];
            indexOfMinDist = k;
        }
        double minBias = valuesOfBias[0];
        int indexOfMin = 0;
        for (int k = 1; k < arrOfWaveletObjects.length; ++k) {
            if (!(minBias > valuesOfBias[k])) continue;
            minBias = valuesOfBias[k];
            indexOfMin = k;
        }
        double maxBias = valuesOfBias[0];
        int indexOfMax = 0;
        for (int k = 0; k < arrOfWaveletObjects.length; ++k) {
            if (!(maxBias < valuesOfBias[k])) continue;
            maxBias = valuesOfBias[k];
            indexOfMax = k;
        }
        double minEnergyDifference = energyDifference[0];
        int indexOfMinEnergy = 0;
        for (int k = 0; k < arrOfWaveletObjects.length; ++k) {
            if (!(minEnergyDifference > energyDifference[k])) continue;
            minEnergyDifference = energyDifference[k];
            indexOfMinEnergy = k;
        }
        double maxSmoothness = valuesOfSmoothness[0];
        int indexOfmaxSmoothness = 0;
        for (int k = 0; k < arrOfWaveletObjects.length; ++k) {
            if (!(maxSmoothness < valuesOfSmoothness[k])) continue;
            maxSmoothness = valuesOfSmoothness[k];
            indexOfmaxSmoothness = k;
        }
        double minDistanceToOptimalPoint = valuesOfROC[0];
        int indexOfMinDistanceToOptimalPoint = 0;
        for (int k = 0; k < arrOfWaveletObjects.length; ++k) {
            if (!(minDistanceToOptimalPoint > valuesOfROC[k])) continue;
            minDistanceToOptimalPoint = valuesOfROC[k];
            indexOfMinDistanceToOptimalPoint = k;
        }
        double maxSNR = valuesOfSNR[0];
        int indexOfWaveletWithMaxSNR = 0;
        for (int k = 0; k < arrOfWaveletObjects.length; ++k) {
            if (!(maxSNR < valuesOfSNR[k])) continue;
            maxSNR = valuesOfSNR[k];
            indexOfWaveletWithMaxSNR = k;
        }
        double minSNR = valuesOfSNR[0];
        int indexOfWaveletWithMinSNR = 0;
        for (int k = 0; k < arrOfWaveletObjects.length; ++k) {
            if (!(minSNR > valuesOfSNR[k])) continue;
            minSNR = valuesOfSNR[k];
            indexOfWaveletWithMinSNR = k;
        }
        double maxCorrelation = correlations[0];
        int indexOfWaveletWithMaxCorrelation = 0;
        for (int k = 0; k < arrOfWaveletObjects.length; ++k) {
            if (!(maxCorrelation < correlations[k])) continue;
            maxCorrelation = correlations[k];
            indexOfWaveletWithMaxCorrelation = k;
        }
        double minCorrelation = correlations[0];
        int indexOfWaveletWithMinCorrelation = 0;
        for (int k = 0; k < arrOfWaveletObjects.length; ++k) {
            if (!(minCorrelation > correlations[k])) continue;
            minCorrelation = correlations[k];
            indexOfWaveletWithMinCorrelation = k;
        }
        double optimalValue = distanceToOptimalPoint[0];
        int indexOfOptimalValue = 0;
        for (int k = 0; k < arrOfWaveletObjects.length; ++k) {
            if (!(optimalValue > distanceToOptimalPoint[k])) continue;
            optimalValue = distanceToOptimalPoint[k];
            indexOfOptimalValue = k;
        }
        Wavelet selectedWavelet = switch (smoothMethod) {
            case "Correlation max" -> arrOfWaveletObjects[indexOfWaveletWithMaxCorrelation];
            case "Correlation min" -> arrOfWaveletObjects[indexOfWaveletWithMinCorrelation];
            case "smoothness + correlation" -> arrOfWaveletObjects[indexOfOptimalWavelet];
            case "Best SNR" -> arrOfWaveletObjects[indexOfWaveletWithMaxSNR];
            case "Min energy difference" -> arrOfWaveletObjects[indexOfMinEnergy];
            case "Min euclidean distance" -> arrOfWaveletObjects[indexOfEuclideanSmoothness];
            default -> arrOfWaveletObjects[0];
        };
        Transform fwtFast = new Transform((BasicTransform)new AncientEgyptianDecomposition((BasicTransform)new FastWaveletTransform(selectedWavelet)));
        double[] transformedSignal = fwtFast.forward(y);
        double[] denoisedSignal = compressor.compress(transformedSignal);
        double[] finalSignal = fwtFast.reverse(denoisedSignal);
        SmoothUtils.correctNegativeValues(y, finalSignal);
        return Pair.of((Object)finalSignal, (Object)selectedWavelet.getName());
    }

    public static int getIndexOfWaveletByName(String waveletName) {
        int index = 0;
        Wavelet[] listOfWavelets = WaveletBuilder.create2arr();
        for (int k = 0; k < listOfWavelets.length; ++k) {
            if (!listOfWavelets[k].getName().equals(waveletName)) continue;
            index = k;
        }
        return index;
    }

    public static Wavelet getWaveletByIndex(int waveletIndex) {
        Wavelet[] listOfWavelets = WaveletBuilder.create2arr();
        return listOfWavelets[waveletIndex];
    }

    public static double getBestGaussianNorm(double[] bestFit, double xMin, double xMax, int length, double[] y) {
        int steps = 30;
        double initialNorm = bestFit[0];
        double[] initialGaussianSignal = SmoothUtils.buildSymmetricGaussian(bestFit, xMin, xMax, length);
        double bestCorrelation = SmoothUtils.computeEuclideanDistance(y, initialGaussianSignal);
        double optimalNorm = initialNorm;
        double deltaNorm = 0.2 * initialNorm;
        for (int k = 0; k < steps; ++k) {
            double testedNorm;
            bestFit[0] = testedNorm = initialNorm - deltaNorm + deltaNorm * (double)k * 2.0 / (double)steps;
            double[] gaussianCandidate = SmoothUtils.buildSymmetricGaussian(bestFit, xMin, xMax, length);
            double correlation = SmoothUtils.computeEuclideanDistance(gaussianCandidate, y);
            if (!(correlation < bestCorrelation)) continue;
            bestCorrelation = correlation;
            optimalNorm = testedNorm;
        }
        return optimalNorm;
    }

    public static String displayTime(long displayedTime) {
        Object timeAsAString = "";
        long seconds = (long)((double)displayedTime / 1.0E9);
        long remaining = (long)((double)displayedTime - 1.0E9 * (double)seconds);
        long milliSeconds = (long)((double)remaining / 1000000.0);
        long remaining2 = (long)((double)remaining - 1000000.0 * (double)milliSeconds);
        long microSeconds = (long)((double)remaining2 / 1000.0);
        long nanoseconds = remaining2 - microSeconds * 1000L;
        if (seconds != 0L) {
            timeAsAString = seconds + " s ";
        }
        if (milliSeconds != 0L) {
            timeAsAString = (String)timeAsAString + milliSeconds + " ms ";
        }
        if (microSeconds != 0L) {
            timeAsAString = (String)timeAsAString + microSeconds + " \u00b5s ";
        }
        if (nanoseconds != 0L) {
            timeAsAString = (String)timeAsAString + nanoseconds + " ns";
        }
        return timeAsAString;
    }

    public static double[] buildPolynomialFromCoefficients(double[] coefficients, double minX, double maxX, int nbrPoints) {
        double[] polynomialSignal = new double[nbrPoints];
        PolynomialFunction polynom = new PolynomialFunction(coefficients);
        for (int k = 0; k < nbrPoints; ++k) {
            double x = (maxX - minX) / (double)nbrPoints * (double)k;
            polynomialSignal[k] = polynom.value(minX + x);
        }
        return polynomialSignal;
    }

    public static double estimateGlobalDeviation(double[] signal, int windowSize) {
        int nbrOfSamples = signal.length / windowSize;
        int remainingSample = signal.length % windowSize;
        StandardDeviation standardDeviation = new StandardDeviation();
        double globalStandardDeviation = 0.0;
        if (nbrOfSamples != 0) {
            for (int i = 0; i < nbrOfSamples; ++i) {
                int start = i * windowSize;
                int end = start + windowSize;
                double[] truncatedSignal = SmoothUtils.getTruncatedSignal(signal, start, end);
                double localDeviation = standardDeviation.evaluate(truncatedSignal);
                globalStandardDeviation += localDeviation;
            }
            if (remainingSample != 0) {
                int startRemaining = nbrOfSamples * windowSize;
                int endRemaining = startRemaining + remainingSample;
                double[] lastRemainingSignal = SmoothUtils.getTruncatedSignal(signal, startRemaining, endRemaining);
                double meanSlope = lastRemainingSignal[remainingSample - 1] - lastRemainingSignal[0];
                globalStandardDeviation += standardDeviation.evaluate(lastRemainingSignal);
            }
            logger.info("locally computed standard deviation: " + globalStandardDeviation / (double)nbrOfSamples + " with a window size of: " + windowSize);
            logger.info("length of signal: " + signal.length);
            return globalStandardDeviation / (double)nbrOfSamples / (double)signal.length;
        }
        logger.info("computed standard deviation on 1 sample: " + standardDeviation.evaluate(signal));
        return standardDeviation.evaluate(signal) / (double)signal.length;
    }

    public static double[] multiScaleStandardDeviationAnalysis(double[] signal, int nbrOfTests) {
        double[] results = new double[nbrOfTests];
        for (int k = 0; k < nbrOfTests; ++k) {
            results[k] = SmoothUtils.estimateGlobalDeviation(signal, 5 + k);
        }
        return results;
    }

    public static double[] getTruncatedSignal(double[] signal, int start, int end) {
        double[] truncatedSignal = new double[end - start];
        if (end - start >= 0) {
            System.arraycopy(signal, start, truncatedSignal, 0, end - start);
        }
        return truncatedSignal;
    }

    public static double computeLengthOfSignal(double[] x, double[] y) {
        double length = 0.0;
        for (int k = 0; k < x.length - 1; ++k) {
            length += Math.sqrt((x[k + 1] - x[k]) * (x[k + 1] - x[k]) + (y[k + 1] - y[k]) * (y[k + 1] - y[k]));
        }
        return length;
    }

    public static Pair<Double, Double> computeStandardDeviationOfSlopes(double[] x, double[] y) {
        StandardDeviation standardDeviation = new StandardDeviation();
        double[] slopeAngles = SmoothUtils.getSlopeAngles(x, y);
        double stdSlopes = standardDeviation.evaluate(slopeAngles);
        double[] kernel = SmoothUtils.buildKernel(5);
        Convolution con = new Convolution(y, kernel);
        double[] convolvedSignal = con.convolve("same");
        double[] smoothedSlopeAngles = SmoothUtils.getSlopeAngles(x, convolvedSignal);
        double stdSmoothedSlopes = standardDeviation.evaluate(smoothedSlopeAngles);
        return Pair.of((Object)stdSmoothedSlopes, (Object)stdSlopes);
    }

    public static double calculateArea(double[] x, double[] y) {
        double integral1 = 0.0;
        double integral2 = 0.0;
        for (int k = 0; k < x.length - 1; ++k) {
            integral1 += (x[k + 1] - x[k]) * y[k];
            integral2 += (x[k + 1] - x[k]) * y[k + 1];
        }
        return (integral2 + integral1) / 2.0;
    }
}

