/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzknife;

import com.almworks.sqlite4java.SQLiteException;
import com.beust.jcommander.ParameterException;
import com.typesafe.config.ConfigFactory;
import fr.profi.mzdb.MzDbReader;
import fr.profi.mzdb.db.model.Software;
import fr.profi.mzdb.io.writer.mgf.DefaultPrecursorComputer;
import fr.profi.mzdb.io.writer.mgf.DefaultSpectrumProcessor;
import fr.profi.mzdb.io.writer.mgf.IPrecursorComputation;
import fr.profi.mzdb.io.writer.mgf.ISpectrumProcessor;
import fr.profi.mzdb.io.writer.mgf.IsolationWindowPrecursorExtractor;
import fr.profi.mzdb.io.writer.mgf.MgfBoostPrecursorExtractor;
import fr.profi.mzdb.io.writer.mgf.MgfWriter;
import fr.profi.mzdb.io.writer.mgf.PrecursorMzComputationEnum;
import fr.profi.mzdb.io.writer.mgf.ScanSelectorModes;
import fr.profi.mzknife.CommandArguments;
import fr.profi.mzknife.mgf.MGFECleaner;
import fr.profi.mzknife.mgf.PCleanProcessor;
import fr.profi.mzknife.mzdb.MzDBMetrics;
import fr.profi.mzknife.mzdb.MzDBRecalibrator;
import fr.profi.mzknife.mzdb.MzDBSplitter;
import fr.profi.mzknife.util.AbstractProcessing;
import fr.profi.mzknife.util.PrecursorComputerWrapper;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.StandardToStringStyle;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Enumeration;

public class MzDbProcessing
extends AbstractProcessing {
    private static final Logger LOG = LoggerFactory.getLogger(MzDbProcessing.class);
    private static final StandardToStringStyle style = new StandardToStringStyle();

    public static void main(String[] args) {
        CommandArguments.MzDBRecalibrateCommand mzDBRecalibrateCommand = new CommandArguments.MzDBRecalibrateCommand();
        CommandArguments.MzDBSplitterCommand mzDBSplitterCommand = new CommandArguments.MzDBSplitterCommand();
        CommandArguments.MzDBCreateMgfCommand mzDBCreateMgfCommand = new CommandArguments.MzDBCreateMgfCommand();
        CommandArguments.MzDBMetricsCommand mzDBMetricsCommand = new CommandArguments.MzDBMetricsCommand();
        MzDbProcessing.addCommand(mzDBRecalibrateCommand);
        MzDbProcessing.addCommand(mzDBSplitterCommand);
        MzDbProcessing.addCommand(mzDBCreateMgfCommand);
        MzDbProcessing.addCommand(mzDBMetricsCommand);
        try {
            String parsedCmd;
            switch (parsedCmd = MzDbProcessing.parseCommand(args)) {
                case "recalibrate": {
                    if (mzDBRecalibrateCommand.help) {
                        MzDbProcessing.usage();
                    }
                    MzDbProcessing.recalibrateMzdb(mzDBRecalibrateCommand);
                    break;
                }
                case "create_mgf": {
                    if (mzDBCreateMgfCommand.help) {
                        MzDbProcessing.usage();
                    }
                    MzDbProcessing.mzdbcreateMgf(mzDBCreateMgfCommand);
                    break;
                }
                case "split": {
                    if (mzDBSplitterCommand.help) {
                        MzDbProcessing.usage();
                    }
                    MzDbProcessing.splitMzdb(mzDBSplitterCommand);
                    break;
                }
                case "metrics": {
                    if (mzDBMetricsCommand.help) {
                        MzDbProcessing.usage();
                    }
                    MzDbProcessing.computeMzdbMetrics(mzDBMetricsCommand);
                    break;
                }
                default: {
                    LOG.warn("Invalid command specified ");
                    MzDbProcessing.usage();
                    break;
                }
            }
        }
        catch (FileNotFoundException fnfe) {
            LOG.error("File not found", (Throwable)fnfe);
        }
        catch (SQLiteException sqle) {
            LOG.error("mzDB SQLite exception", (Throwable)sqle);
        }
        catch (Exception e) {
            LOG.error("ERROR ", (Throwable)e);
        }
    }

    public static void recalibrateMzdb(CommandArguments.MzDBRecalibrateCommand mzDBRecalibrateCommand) throws FileNotFoundException, SQLiteException {
        File mzdbSrcFile = new File(mzDBRecalibrateCommand.inputFileName);
        File mzdbDstFile = MzDbProcessing.getDestFile(mzDBRecalibrateCommand.outputFileName, ".recal.mzdb", mzdbSrcFile);
        LOG.info(" MzDbProcessing " + mzdbSrcFile.getName() + " to " + mzdbDstFile.getAbsolutePath());
        MzDbReader srcReader = new MzDbReader(mzdbSrcFile, true);
        MzDBRecalibrator mzdbRecalibrator = new MzDBRecalibrator(srcReader, mzdbDstFile);
        mzdbRecalibrator.recalibrate(mzDBRecalibrateCommand.firstScan, mzDBRecalibrateCommand.lastScan, mzDBRecalibrateCommand.deltaMass);
    }

    public static void computeMzdbMetrics(CommandArguments.MzDBMetricsCommand mzDBMetricsCommand) throws FileNotFoundException, SQLiteException {
        File mzdbSrcFile = new File(mzDBMetricsCommand.inputFileName);
        File outputFile = MzDbProcessing.getDestFile(mzDBMetricsCommand.outputFileName, ".metrics.tsv", mzdbSrcFile);
        LOG.info(" MzDbProcessing " + mzdbSrcFile.getName() + " to " + outputFile.getAbsolutePath());
        MzDBMetrics metricsComputer = new MzDBMetrics(mzdbSrcFile, outputFile);
        metricsComputer.computeMetrics();
    }

    public static void splitMzdb(CommandArguments.MzDBSplitterCommand mzDBSplitterCommand) {
        String mzdbInputFileName = mzDBSplitterCommand.inputFileName;
        File mzdbInputFile = new File(mzdbInputFileName);
        MzDBSplitter splitter = new MzDBSplitter(mzdbInputFile);
        boolean splitSuccess = splitter.splitMzDbFile();
        if (!splitSuccess) {
            LOG.warn(" An error occurred during Split. Output files may be corrupted !! ");
        } else {
            List<File> outFiles = splitter.getOutputMzdbFiles();
            LOG.info(" END Splitting {} into {} files : ", (Object)mzdbInputFileName, (Object)outFiles.size());
            for (File f : outFiles) {
                LOG.info(" Output File: {}", (Object)f.getName());
            }
        }
    }

    public static void mzdbcreateMgf(CommandArguments.MzDBCreateMgfCommand mzDBCreateMgfCommand) throws SQLiteException, IOException {
        ConfigFactory.load();
        LOG.info("Creating MGF File for mzDB file " + mzDBCreateMgfCommand.mzdbFile);
        LOG.info("Precursor m/z values will be defined using the method: " + mzDBCreateMgfCommand.precMzComputation);
        MgfWriter writer = new MgfWriter(mzDBCreateMgfCommand.mzdbFile, mzDBCreateMgfCommand.msLevel.intValue());
        MzDbReader mzDbReader = writer.getMzDbReader();
        ISpectrumProcessor specProcessor = MzDbProcessing.createSpectrumProcessor(mzDBCreateMgfCommand);
        IPrecursorComputation precursorComputation = MzDbProcessing.createPrecursorComputation(mzDBCreateMgfCommand);
        String s = ToStringBuilder.reflectionToString((Object)mzDBCreateMgfCommand, (ToStringStyle)style);
        List comments = Arrays.stream(s.split("\n")).collect(Collectors.toList());
        CommandArguments.CleanConfig cleanConfig = mzDBCreateMgfCommand.cleanConfig;
        if (cleanConfig != null) {
            if (mzDBCreateMgfCommand.cleanMethod.equalsIgnoreCase("pClean")) {
                comments.addAll(cleanConfig.stringifyPCleanParametersList());
            } else if (mzDBCreateMgfCommand.cleanMethod.equalsIgnoreCase("eClean")) {
                comments.addAll(cleanConfig.stringifyECleanParametersList());
            }
        }
        comments.add("precMzComputation.description=" + precursorComputation.getMethodName() + " - version " + precursorComputation.getMethodVersion());
        comments.add("spectrumProcessor.description=" + specProcessor.getMethodName() + " - version " + specProcessor.getMethodVersion());
        comments.add("input.mzdb.format.version=" + mzDbReader.getModelVersion());
        Software soft = mzDbReader.getMzdbConverter();
        if (soft != null) {
            comments.add("input.mzdb.converter.software=" + soft.getName());
            comments.add("input.mzdb.converter.version=" + soft.getVersion());
        }
        comments.add("generated on " + DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss").format(LocalDateTime.now()) + " by " + System.getProperty("user.name"));
        writer.setHeaderComments(comments);
        writer.write(mzDBCreateMgfCommand.outputFile, precursorComputation, specProcessor, mzDBCreateMgfCommand.intensityCutoff.floatValue(), mzDBCreateMgfCommand.exportProlineTitle.booleanValue());
    }

    private static IPrecursorComputation createPrecursorComputation(CommandArguments.MzDBCreateMgfCommand mzDBCreateMgfCommand) {
        Object precursorComputation;
        Optional<PrecursorMzComputationEnum> precCompEnum = Arrays.stream(PrecursorMzComputationEnum.values()).filter(v -> v.name().equalsIgnoreCase(mzDBCreateMgfCommand.precMzComputation.trim())).findFirst();
        if (precCompEnum.isPresent()) {
            precursorComputation = new DefaultPrecursorComputer(precCompEnum.get(), mzDBCreateMgfCommand.mzTolPPM.floatValue());
        } else if (mzDBCreateMgfCommand.precMzComputation.equals("isolation_window_extracted")) {
            precursorComputation = new IsolationWindowPrecursorExtractor(mzDBCreateMgfCommand.mzTolPPM.floatValue());
        } else if (mzDBCreateMgfCommand.precMzComputation.equals("mgf_boost")) {
            Enumeration.Value scanSelector = ScanSelectorModes.withName((String)mzDBCreateMgfCommand.scanSelectorMode.toString());
            precursorComputation = new MgfBoostPrecursorExtractor(mzDBCreateMgfCommand.mzTolPPM.floatValue(), mzDBCreateMgfCommand.useHeader.booleanValue(), mzDBCreateMgfCommand.useSelectionWindow.booleanValue(), mzDBCreateMgfCommand.swMaxPrecursorsCount.intValue(), mzDBCreateMgfCommand.swIntensityThreshold.floatValue(), scanSelector, mzDBCreateMgfCommand.pifThreshold.doubleValue(), mzDBCreateMgfCommand.rankThreshold.intValue());
        } else {
            throw new IllegalArgumentException("Can't create the MGF file, invalid precursor m/z computation method");
        }
        if (mzDBCreateMgfCommand.dAnnot.booleanValue()) {
            try {
                BufferedWriter annotationWriter = new BufferedWriter(new FileWriter(mzDBCreateMgfCommand.outputFile + ".annot"));
                PrecursorComputerWrapper wrapper = new PrecursorComputerWrapper((IPrecursorComputation)precursorComputation, annotationWriter);
                annotationWriter.write(Arrays.stream(wrapper.getAnnotations()).collect(Collectors.joining(wrapper.getDelimiter())));
                annotationWriter.newLine();
                precursorComputation = wrapper;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return precursorComputation;
    }

    private static ISpectrumProcessor createSpectrumProcessor(CommandArguments.MzDBCreateMgfCommand createMgfCommand) {
        CommandArguments.CleanConfig cleanConfig = createMgfCommand.cleanConfig;
        boolean useClean = !createMgfCommand.cleanMethod.equalsIgnoreCase("None");
        String cleanLabelMethodName = createMgfCommand.cleanLabelMethodName;
        Object specProcessor = null;
        if (useClean) {
            if (cleanConfig == null) {
                LOG.error("if pClean usage is specified, the -pConfig parameter should be specified ! ");
                MzDbProcessing.usage();
            } else {
                switch (cleanConfig) {
                    case XLINK: 
                    case LABEL_FREE: {
                        if (cleanLabelMethodName == null || cleanLabelMethodName.isEmpty()) break;
                        LOG.warn("Specified clean label method " + cleanLabelMethodName + " will be ignored. It isn't consistent with " + cleanConfig.getConfigCommandValue());
                        cleanLabelMethodName = "";
                        break;
                    }
                    case TMT_LABELED: {
                        if (cleanLabelMethodName != null && !cleanLabelMethodName.isEmpty()) break;
                        throw new ParameterException("When using " + cleanConfig.getConfigCommandValue() + " configuration, you must specify clean label method using -cLabelMethod");
                    }
                }
                if (createMgfCommand.cleanMethod.equalsIgnoreCase("pClean")) {
                    specProcessor = new PCleanProcessor(cleanLabelMethodName);
                    ((PCleanProcessor)specProcessor).setPCleanParameters(cleanConfig.getPCleanConfigTemplate());
                } else if (createMgfCommand.cleanMethod.equalsIgnoreCase("eClean")) {
                    specProcessor = new MGFECleaner(20.0, cleanLabelMethodName);
                    ((MGFECleaner)specProcessor).setECleanParameters(cleanConfig.getECleanConfigTemplate());
                }
            }
        } else {
            specProcessor = new DefaultSpectrumProcessor();
        }
        return specProcessor;
    }

    static {
        style.setContentStart("");
        style.setContentEnd("");
        style.setFieldSeparator("\n");
        style.setUseClassName(false);
        style.setUseIdentityHashCode(false);
    }
}

