/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzknife.mgf;

import fr.profi.chemistry.model.BiomoleculeAtomTable$;
import fr.profi.chemistry.model.MolecularConstants;
import fr.profi.ms.model.TheoreticalIsotopePattern;
import fr.profi.mzdb.algo.DotProductPatternScorer;
import fr.profi.mzdb.io.writer.mgf.ISpectrumProcessor;
import fr.profi.mzdb.io.writer.mgf.MgfPrecursor;
import fr.profi.mzdb.model.SpectrumData;
import fr.profi.mzknife.mgf.ECleanConfigTemplate;
import fr.profi.mzknife.mgf.IsotopicPatternMatch;
import fr.profi.mzknife.mgf.MGFRewriter;
import fr.profi.mzscope.InvalidMGFFormatException;
import fr.profi.mzscope.MSMSSpectrum;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class MGFECleaner
extends MGFRewriter
implements ISpectrumProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(MGFECleaner.class);
    private static final BiomoleculeAtomTable$ atomTable = BiomoleculeAtomTable$.MODULE$;
    private IsobaricTag isobaricTags = null;
    private double mzTolPpm = 20.0;

    protected MGFECleaner(double mzTolPpm) {
        this.mzTolPpm = mzTolPpm;
    }

    public MGFECleaner(double mzTolPpm, String labelingMethodName) {
        this.mzTolPpm = mzTolPpm;
        if (labelingMethodName != null && !labelingMethodName.isEmpty()) {
            this.isobaricTags = IsobaricTag.valueOf(labelingMethodName.toUpperCase());
        }
    }

    public MGFECleaner(File srcFile, File m_dstFile, double mzTolPpm) throws InvalidMGFFormatException {
        super(srcFile, m_dstFile);
        this.mzTolPpm = mzTolPpm;
    }

    public MGFECleaner(File srcFile, File m_dstFile, double mzTolPpm, IsobaricTag tags) throws InvalidMGFFormatException {
        super(srcFile, m_dstFile);
        this.mzTolPpm = mzTolPpm;
        this.isobaricTags = tags;
    }

    public void setECleanParameters(ECleanConfigTemplate eCleanConfigTemplate) {
    }

    public String getMethodName() {
        return "edypClean";
    }

    public String getMethodVersion() {
        return "1.1";
    }

    public SpectrumData processSpectrum(MgfPrecursor mgfPrecursor, SpectrumData spectrumData) {
        int parentCharge = mgfPrecursor.getCharge();
        double parentMass = mgfPrecursor.getPrecMz() * (double)parentCharge - (double)parentCharge * MolecularConstants.PROTON_MASS();
        double[] masses = spectrumData.getMzList();
        float[] intensities = spectrumData.getIntensityList();
        ArrayList<Peak> peaks = new ArrayList<Peak>(masses.length);
        HashMap<Integer, Peak> peaksByIndex = new HashMap<Integer, Peak>();
        for (int k = 0; k < masses.length; ++k) {
            Peak p = new Peak(masses[k], intensities[k], k);
            peaks.add(p);
            peaksByIndex.put(p.index, p);
        }
        List<Peak> result = this.processPeaks(parentMass, parentCharge, peaks, spectrumData, peaksByIndex);
        masses = new double[result.size()];
        intensities = new float[result.size()];
        int k = 0;
        for (Peak p : result) {
            masses[k] = p.mass;
            intensities[k++] = (float)p.intensity;
        }
        SpectrumData newSpectrumData = new SpectrumData(masses, intensities);
        return newSpectrumData;
    }

    @Override
    protected MSMSSpectrum getSpectrum2Export(MSMSSpectrum inSpectrum) {
        int parentCharge = inSpectrum.getPrecursorCharge();
        double parentMass = inSpectrum.getPrecursorMz() * (double)parentCharge - (double)parentCharge * MolecularConstants.PROTON_MASS();
        double[] masses = inSpectrum.getMassValues();
        double[] intensities = inSpectrum.getIntensityValues();
        float[] fIntensities = new float[intensities.length];
        ArrayList<Peak> peaks = new ArrayList<Peak>(masses.length);
        HashMap<Integer, Peak> peaksByIndex = new HashMap<Integer, Peak>();
        for (int k = 0; k < masses.length; ++k) {
            Peak p = new Peak(masses[k], intensities[k], k);
            peaks.add(p);
            peaksByIndex.put(p.index, p);
            fIntensities[k] = (float)intensities[k];
        }
        SpectrumData spectrumData = new SpectrumData(masses, fIntensities);
        List<Peak> result = this.processPeaks(parentMass, parentCharge, peaks, spectrumData, peaksByIndex);
        masses = new double[result.size()];
        intensities = new double[result.size()];
        int k = 0;
        for (Peak p : result) {
            masses[k] = p.mass;
            intensities[k++] = p.intensity;
        }
        MSMSSpectrum outSpectrum = new MSMSSpectrum(inSpectrum.getPrecursorMz(), inSpectrum.getPrecursorIntensity(), inSpectrum.getPrecursorCharge(), inSpectrum.getRetentionTime());
        inSpectrum.getAnnotations().forEachRemaining(a -> outSpectrum.setAnnotation(a, inSpectrum.getAnnotation(a)));
        for (int i = 0; i < masses.length; ++i) {
            outSpectrum.addPeak(masses[i], intensities[i]);
        }
        return outSpectrum;
    }

    private List<Peak> processPeaks(double parentMass, int parentCharge, List<Peak> peaks, SpectrumData spectrumData, Map<Integer, Peak> peaksByIndex) {
        ArrayList<Peak> result = new ArrayList(peaks.size());
        List<Double> immoniumIonMasses = Arrays.stream(ImmoniumIon.values()).map(i -> i.mass).sorted().toList();
        ArrayList<Double> reporterAssociatedIonMasses = new ArrayList<Double>(this.isobaricTags == null ? 0 : this.isobaricTags.reporterIons.length * 3 + 3);
        if (this.isobaricTags != null) {
            for (double reporterMass : this.isobaricTags.reporterIons) {
                reporterAssociatedIonMasses.add(reporterMass);
                double reporterCOHMass = reporterMass + atomTable.getAtom("C").monoMass() + atomTable.getAtom("O").monoMass() + MolecularConstants.PROTON_MASS();
                reporterAssociatedIonMasses.add(reporterCOHMass);
                reporterAssociatedIonMasses.add(parentMass - reporterCOHMass);
            }
            reporterAssociatedIonMasses.add(this.isobaricTags.tagMass + MolecularConstants.PROTON_MASS());
            reporterAssociatedIonMasses.add(this.isobaricTags.tagMass + 2.0 * MolecularConstants.PROTON_MASS());
            reporterAssociatedIonMasses.add(parentMass - this.isobaricTags.tagMass);
        }
        reporterAssociatedIonMasses.sort(Double::compareTo);
        peaks.sort((o1, o2) -> Double.compare(o2.intensity, o1.intensity));
        for (int k = 0; k < peaks.size(); ++k) {
            Peak p2 = peaks.get(k);
            if (p2.mass < 160.0) {
                for (double ionMass : immoniumIonMasses) {
                    if (1000000.0 * Math.abs(ionMass - p2.mass) / p2.mass < this.mzTolPpm) {
                        p2.used = true;
                        break;
                    }
                    if (!(ionMass > p2.mass)) continue;
                    break;
                }
            }
            if (this.isobaricTags != null) {
                Iterator iterator = reporterAssociatedIonMasses.iterator();
                while (iterator.hasNext()) {
                    double ionMass = (Double)iterator.next();
                    if (1000000.0 * Math.abs(ionMass - p2.mass) / p2.mass < this.mzTolPpm) {
                        p2.used = true;
                        break;
                    }
                    if (!(ionMass > p2.mass)) continue;
                    break;
                }
            }
            if (p2.used) continue;
            IsotopicPatternMatch patternMatch = MGFECleaner.predictIsotopicPattern(spectrumData, p2.mass, this.mzTolPpm, parentCharge, peaksByIndex);
            if (patternMatch != null) {
                Integer peakIdx;
                int charge = patternMatch.theoreticalPattern.charge();
                for (Optional<Integer> peakIndex : patternMatch.matchingPeaks) {
                    if (peakIndex.isEmpty()) continue;
                    Peak peak = peaksByIndex.get(peakIndex.get());
                    peak.used = true;
                }
                if (charge == 1) {
                    peakIdx = patternMatch.matchingPeaks.get(0).get();
                    result.add(new Peak(peaksByIndex.get(peakIdx)));
                    continue;
                }
                peakIdx = patternMatch.matchingPeaks.get(0).get();
                Peak monoPeak = peaksByIndex.get(peakIdx);
                Peak newPeak = new Peak(monoPeak.mass * (double)charge - (double)(charge - 1) * MolecularConstants.PROTON_MASS(), monoPeak.intensity, p2.index);
                result.add(newPeak);
                continue;
            }
            p2.used = true;
            result.add(new Peak(p2));
        }
        result = result.stream().filter(p -> p.mass <= parentMass).sorted(Comparator.comparingDouble(o -> o.mass)).collect(Collectors.toList());
        return result;
    }

    public static int getPeakIndex(double[] peaksMz, double value, double ppmTol) {
        int idx = Arrays.binarySearch(peaksMz, value);
        idx = idx < 0 ? ~idx : idx;
        double min = Double.MAX_VALUE;
        int resultIdx = -1;
        for (int k = Math.max(0, idx - 1); k <= Math.min(peaksMz.length - 1, idx + 1); ++k) {
            if (!(1000000.0 * Math.abs(peaksMz[k] - value) / value < ppmTol) || !(Math.abs(peaksMz[k] - value) < min)) continue;
            min = Math.abs(peaksMz[k] - value);
            resultIdx = k;
        }
        return resultIdx;
    }

    public static IsotopicPatternMatch predictIsotopicPattern(SpectrumData spectrum, double mz, double ppmTol, int maxCharge, Map<Integer, Peak> peaksByIndex) {
        ArrayList<Tuple2> putativePatterns = new ArrayList<Tuple2>();
        for (int charge = 1; charge <= maxCharge; ++charge) {
            Tuple2[] patterns = DotProductPatternScorer.calcIsotopicPatternHypothesesFromCharge((SpectrumData)spectrum, (double)mz, (int)charge, (double)ppmTol);
            putativePatterns.addAll(Arrays.asList(patterns));
        }
        putativePatterns.sort((p1, p2) -> {
            double s2;
            double s1 = (Double)p1._1;
            return s1 == (s2 = ((Double)p2._1).doubleValue()) ? ((TheoreticalIsotopePattern)p1._2).charge() - ((TheoreticalIsotopePattern)p2._2).charge() : Double.compare(s1, s2);
        });
        List<Object> matches = new ArrayList(putativePatterns.size());
        for (Tuple2 prediction : putativePatterns) {
            IsotopicPatternMatch patternMatch = new IsotopicPatternMatch((Double)prediction._1, (TheoreticalIsotopePattern)prediction._2, spectrum.getMzList(), ppmTol);
            matches.add(patternMatch);
        }
        if ((matches = matches.stream().filter(m -> m.score < 0.4 && m.matchingPeaks.get(0).isPresent() && m.matchingPeaks.get(1).isPresent() && !((Peak)peaksByIndex.get((Object)m.matchingPeaks.get((int)0).get())).used && !((Peak)peaksByIndex.get((Object)m.matchingPeaks.get((int)1).get())).used).collect(Collectors.toList())).size() > 1) {
            double maxScore = ((IsotopicPatternMatch)matches.get((int)0)).score;
            if ((matches = matches.stream().filter(m -> maxScore - m.score < 0.1).collect(Collectors.toList())).size() > 1) {
                int maxMatching = matches.stream().map(m -> m.matchingCount).max(Integer::compareTo).get();
                matches = matches.stream().filter(m -> m.matchingCount == maxMatching).collect(Collectors.toList());
            }
        }
        return matches.isEmpty() ? null : (IsotopicPatternMatch)matches.get(0);
    }

    public static enum IsobaricTag {
        ITRAQ4PLEX(144.102063, new double[]{114.110679, 115.107714, 116.111069, 117.114424}),
        ITRAQ8PLEX(304.20536, new double[]{113.107324, 114.110679, 115.107714, 116.111069, 117.114424, 118.111459, 119.114814, 121.121523}),
        TMT6PLEX(229.162932, new double[]{126.1277261, 127.1310809, 128.1344357, 129.1377905, 130.1411453, 131.1381802}),
        TMT10PLEX(229.162932, new double[]{126.1277261, 127.124761, 127.1310809, 128.1281158, 128.1344357, 129.1314706, 129.1377905, 130.1348254, 130.1411453, 131.1381802}),
        TMT11PLEX(229.162932, new double[]{126.1277261, 127.124761, 127.1310809, 128.1281158, 128.1344357, 129.1314706, 129.1377905, 130.1348254, 130.1411453, 131.1381802, 131.144999}),
        TMT16PLEX(304.207146, new double[]{126.127726, 127.124761, 127.131081, 128.128116, 128.134436, 129.131471, 129.13779, 130.134825, 130.141145, 131.13818, 131.1445, 132.141535, 132.147855, 133.14489, 133.15121, 134.148245}),
        TMT18PLEX(304.207146, new double[]{126.127726, 127.124761, 127.131081, 128.128116, 128.134436, 129.131471, 129.13779, 130.134825, 130.141145, 131.13818, 131.1445, 132.141535, 132.147855, 133.14489, 133.15121, 134.148245, 134.154565, 135.1516}),
        TMT16PLEX_DEUTERATED(304.2135, new double[]{127.134003, 128.131038, 128.137358, 129.134393, 129.140713, 130.137748, 130.144068, 131.141103, 131.147423, 132.144458, 132.150778, 133.147813, 133.154133, 134.151171, 134.157491, 135.154526}),
        TMT35PLEX(304.2135, new double[]{126.127726, 127.124761, 127.131081, 127.134003, 128.128116, 128.131038, 128.134436, 128.137358, 129.131471, 129.134393, 129.13779, 129.140713, 130.134825, 130.137748, 130.141145, 130.144068, 131.13818, 131.141103, 131.1445, 131.147423, 132.141535, 132.144458, 132.147855, 132.150778, 133.14489, 133.147813, 133.15121, 133.154133, 134.148245, 134.151171, 134.154565, 134.157491, 135.1516, 135.154526, 135.160846});

        public final double[] reporterIons;
        public final double tagMass;

        private IsobaricTag(double mass, double[] reporters) {
            this.reporterIons = reporters;
            this.tagMass = mass;
        }
    }

    public static class Peak {
        final double mass;
        final double intensity;
        final int index;
        boolean used = false;

        public Peak(Peak peak) {
            this(peak.mass, peak.intensity, peak.index);
        }

        public Peak(double mass, double intensity, int index) {
            this.mass = mass;
            this.intensity = intensity;
            this.index = index;
        }
    }

    public static enum ImmoniumIon {
        GLYCINE(30.03438),
        ALANINE(44.05003),
        SERINE(60.04494),
        PROLINE(70.06568),
        VALINE(72.08133),
        THREONINE(74.06059),
        CYSTEINE(76.0221),
        CARBAMIDOMETHYLATED(133.0436),
        CARBOXYMETHYLATED(134.0276),
        ACRYLAMIDE_ADDUCT(147.0772),
        LEUCINE_ISOLEUCINE(86.09698),
        ASPARAGINE(87.05584),
        ASPARAGINE_A1(70.03),
        ASPARTIC_ACID(88.03986),
        GLUTAMINE(101.0715),
        GLUTAMINE_A1(129.1),
        GLUTAMINE_A2(84.04),
        GLUTAMINE_A3(56.05),
        LYSINE(101.1079),
        LYSINE_2(84.08136),
        GLUTAMIC_ACID(102.0555),
        METHIONINE(104.0534),
        OXIDIZED_METHIONINE(120.0483),
        HISTIDINE(110.0718),
        PHENYLALANINE(120.0813),
        ARGININE(129.114),
        ARGININE_A1(115.09),
        ARGININE_A2(112.09),
        ARGININE_A3(87.09),
        ARGININE_A4(60.06),
        TYROSINE(136.0762),
        TRYPTOPHAN(159.0922),
        TRYPTOPHAN_A1(132.08),
        TRYPTOPHAN_A2(130.07);

        private final double mass;

        private ImmoniumIon(double mass) {
            this.mass = mass;
        }
    }
}

