/*
 * Decompiled with CFR 0.152.
 */
package javolution.context;

import java.io.File;
import java.io.Serializable;
import javolution.context.AbstractContext;
import javolution.lang.Configurable;
import javolution.osgi.internal.OSGiServices;

public abstract class StorageContext
extends AbstractContext {
    public static final Configurable<File> FILE_STORAGE_LOCATION = new Configurable<File>(){

        @Override
        protected File getDefault() {
            return new File("storage");
        }

        @Override
        protected File parse(String pathname) {
            return new File(pathname);
        }
    };

    protected StorageContext() {
    }

    public static StorageContext enter() {
        return (StorageContext)StorageContext.currentStorageContext().enterInner();
    }

    public abstract <V extends Serializable> V read(Resource<V> var1) throws SecurityException;

    public abstract <V extends Serializable> void write(Resource<V> var1, V var2) throws SecurityException;

    private static StorageContext currentStorageContext() {
        StorageContext ctx = StorageContext.current(StorageContext.class);
        if (ctx != null) {
            return ctx;
        }
        return OSGiServices.getStorageContext();
    }

    public static interface Resource<T> {
        public String uniqueID();
    }
}

