/*
 * Decompiled with CFR 0.152.
 */
package javolution.context.internal;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.realtime.RealtimeThread;
import javolution.context.AbstractContext;
import javolution.context.internal.ConcurrentContextImpl;

public class ConcurrentThreadImpl
extends RealtimeThread {
    private static int count;
    private ConcurrentContextImpl context;
    private AtomicBoolean isBusy = new AtomicBoolean();
    private Runnable logic;
    private int priority;

    public ConcurrentThreadImpl() {
        this.setName("ConcurrentThread-" + ++count);
        this.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(Runnable logic, ConcurrentContextImpl inContext) {
        if (!this.isBusy.compareAndSet(false, true)) {
            return false;
        }
        ConcurrentThreadImpl concurrentThreadImpl = this;
        synchronized (concurrentThreadImpl) {
            this.priority = Thread.currentThread().getPriority();
            this.context = inContext;
            this.logic = logic;
            this.notify();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            try {
                ConcurrentThreadImpl concurrentThreadImpl = this;
                synchronized (concurrentThreadImpl) {
                    while (this.logic == null) {
                        this.wait();
                    }
                }
                this.setPriority(this.priority);
                AbstractContext.inherit(this.context);
                this.logic.run();
                this.context.completed(null);
            }
            catch (Throwable error) {
                this.context.completed(error);
            }
            this.logic = null;
            this.context = null;
            AbstractContext.inherit(null);
            this.isBusy.set(false);
        }
    }
}

