/*
 * Decompiled with CFR 0.152.
 */
package javolution.io;

import java.io.IOException;
import java.io.Writer;

public final class AppendableWriter
extends Writer {
    private Appendable _output;
    private char[] _tmpBuffer;
    private final CharSequence _tmpBufferAsCharSequence = new CharSequence(){

        @Override
        public int length() {
            return AppendableWriter.this._tmpBuffer.length;
        }

        @Override
        public char charAt(int index) {
            return AppendableWriter.this._tmpBuffer[index];
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            throw new UnsupportedOperationException();
        }
    };

    public AppendableWriter() {
    }

    public AppendableWriter(Appendable output) {
        this._output = output;
    }

    public void setOutput(Appendable output) {
        if (this._output != null) {
            throw new IllegalStateException("Writer not closed or reset");
        }
        this._output = output;
    }

    public Appendable getOutput() {
        return this._output;
    }

    public void write(char c) throws IOException {
        if (this._output == null) {
            throw new IOException("Writer closed");
        }
        this._output.append(c);
    }

    @Override
    public void write(int c) throws IOException {
        if (this._output == null) {
            throw new IOException("Writer closed");
        }
        this._output.append((char)c);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        if (this._output == null) {
            throw new IOException("Writer closed");
        }
        this._tmpBuffer = cbuf;
        this._output.append(this._tmpBufferAsCharSequence, off, off + len);
        this._tmpBuffer = null;
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        if (this._output == null) {
            throw new IOException("Writer closed");
        }
        this._output.append(str, off, off + len);
    }

    public void write(CharSequence csq) throws IOException {
        if (this._output == null) {
            throw new IOException("Writer closed");
        }
        this._output.append(csq);
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
        if (this._output != null) {
            this.reset();
        }
    }

    public void reset() {
        this._output = null;
        this._tmpBuffer = null;
    }
}

