/*
 * Decompiled with CFR 0.152.
 */
package javolution.util;

import java.util.Collection;
import javolution.lang.Constant;
import javolution.util.FastTable;
import javolution.util.internal.table.ConstantTableImpl;
import javolution.util.internal.table.ReversedTableImpl;
import javolution.util.internal.table.SubTableImpl;
import javolution.util.service.TableService;
import javolution.xml.DefaultXMLFormat;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;

@DefaultXMLFormat(value=XML.class)
@Constant(comment="Immutable")
public class ConstantTable<E>
extends FastTable<E> {
    private static final long serialVersionUID = 1536L;

    public static <E> ConstantTable<E> of(E ... elements) {
        return new ConstantTable<E>(new ConstantTableImpl<E>(elements));
    }

    public static <E> ConstantTable<E> of(Collection<? extends E> that) {
        return ConstantTable.of(that.toArray(new Object[that.size()]));
    }

    protected ConstantTable(@Constant TableService<E> service) {
        super(service);
    }

    @Override
    @Constant
    public ConstantTable<E> atomic() {
        return this;
    }

    @Override
    @Constant
    public ConstantTable<E> reversed() {
        return new ConstantTable(new ReversedTableImpl(this.service()));
    }

    @Override
    @Constant
    public ConstantTable<E> shared() {
        return this;
    }

    @Override
    @Constant
    public ConstantTable<E> subTable(int fromIndex, int toIndex) {
        return new ConstantTable(new SubTableImpl(this.service(), fromIndex, toIndex));
    }

    @Override
    @Constant
    public ConstantTable<E> unmodifiable() {
        return this;
    }

    @Override
    @Constant
    protected TableService<E> service() {
        return super.service();
    }

    public static class XML
    extends XMLFormat<ConstantTable<?>> {
        @Override
        public ConstantTable<?> newInstance(Class<? extends ConstantTable<?>> cls, XMLFormat.InputElement xml) throws XMLStreamException {
            int size = xml.getAttribute("size", 0);
            Object[] elements = new Object[size];
            for (int i = 0; i < size; ++i) {
                elements[i] = xml.getNext();
            }
            return ConstantTable.of(elements);
        }

        @Override
        public void read(XMLFormat.InputElement xml, ConstantTable<?> that) throws XMLStreamException {
        }

        @Override
        public void write(ConstantTable<?> that, XMLFormat.OutputElement xml) throws XMLStreamException {
            int n = that.size();
            xml.setAttribute("size", n);
            for (int i = 0; i < n; ++i) {
                xml.add(that.get(i));
            }
        }
    }
}

