/*
 * Decompiled with CFR 0.152.
 */
package javolution.util.internal.comparator;

import java.util.Comparator;
import javolution.util.function.Equality;

public final class WrapperComparatorImpl<E>
implements Equality<E> {
    private static final long serialVersionUID = 1536L;
    private final Comparator<? super E> comparator;

    public WrapperComparatorImpl(Comparator<? super E> comparator) {
        this.comparator = comparator;
    }

    @Override
    public boolean equal(E e1, E e2) {
        return e1 == e2 || e1 != null && this.comparator.compare(e1, e2) == 0;
    }

    @Override
    public int compare(E left, E right) {
        if (left == right) {
            return 0;
        }
        if (left == null) {
            return -1;
        }
        if (right == null) {
            return 1;
        }
        return this.comparator.compare(left, right);
    }

    @Override
    public int hashOf(E obj) {
        throw new UnsupportedOperationException("Standard comparator (java.util.Comparator) cannot be used for hashcode calculations; please use a coherent equality comparator instead (e.g. javolution.util.function.Equality).");
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof WrapperComparatorImpl)) {
            return false;
        }
        WrapperComparatorImpl that = (WrapperComparatorImpl)obj;
        return this.comparator.equals(that.comparator);
    }

    public int hashCode() {
        return this.comparator.hashCode();
    }
}

