/*
 * Decompiled with CFR 0.152.
 */
package javolution.util.internal.map;

import java.util.Iterator;
import java.util.Map;
import javolution.util.function.Consumer;
import javolution.util.function.Equality;
import javolution.util.internal.map.MapView;
import javolution.util.service.MapService;

public class AtomicMapImpl<K, V>
extends MapView<K, V> {
    private static final long serialVersionUID = 1536L;
    protected volatile MapService<K, V> immutable = this.cloneTarget();
    protected transient Thread updatingThread;

    public AtomicMapImpl(MapService<K, V> target) {
        super(target);
    }

    @Override
    public synchronized void clear() {
        this.target().clear();
        if (!this.updateInProgress()) {
            this.immutable = this.cloneTarget();
        }
    }

    @Override
    public synchronized AtomicMapImpl<K, V> clone() {
        AtomicMapImpl copy = (AtomicMapImpl)super.clone();
        copy.updatingThread = null;
        return copy;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.targetView().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.targetView().containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.targetView().get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.targetView().isEmpty();
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return new IteratorImpl();
    }

    @Override
    public Equality<? super K> keyComparator() {
        return this.targetView().keyComparator();
    }

    @Override
    public synchronized V put(K key, V value) {
        V v = this.target().put(key, value);
        if (!this.updateInProgress()) {
            this.immutable = this.cloneTarget();
        }
        return v;
    }

    @Override
    public synchronized void putAll(Map<? extends K, ? extends V> m) {
        this.target().putAll(m);
        if (!this.updateInProgress()) {
            this.immutable = this.cloneTarget();
        }
    }

    @Override
    public synchronized V putIfAbsent(K key, V value) {
        V v = this.target().putIfAbsent(key, value);
        if (!this.updateInProgress()) {
            this.immutable = this.cloneTarget();
        }
        return v;
    }

    @Override
    public synchronized V remove(Object key) {
        Object v = this.target().remove(key);
        if (!this.updateInProgress()) {
            this.immutable = this.cloneTarget();
        }
        return v;
    }

    @Override
    public synchronized boolean remove(Object key, Object value) {
        boolean changed = this.target().remove(key, value);
        if (changed && !this.updateInProgress()) {
            this.immutable = this.cloneTarget();
        }
        return changed;
    }

    @Override
    public synchronized V replace(K key, V value) {
        V v = this.target().replace(key, value);
        if (!this.updateInProgress()) {
            this.immutable = this.cloneTarget();
        }
        return v;
    }

    @Override
    public synchronized boolean replace(K key, V oldValue, V newValue) {
        boolean changed = this.target().replace(key, oldValue, newValue);
        if (changed && !this.updateInProgress()) {
            this.immutable = this.cloneTarget();
        }
        return changed;
    }

    @Override
    public int size() {
        return this.targetView().size();
    }

    @Override
    public synchronized void update(Consumer<MapService<K, V>> action, MapService<K, V> view) {
        this.updatingThread = Thread.currentThread();
        try {
            this.target().update(action, view);
        }
        finally {
            this.updatingThread = null;
            this.immutable = this.cloneTarget();
        }
    }

    @Override
    public Equality<? super V> valueComparator() {
        return this.targetView().valueComparator();
    }

    protected MapService<K, V> cloneTarget() {
        try {
            return this.target().clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Cannot happen since target is Cloneable.");
        }
    }

    protected MapService<K, V> targetView() {
        return this.updatingThread == null || this.updatingThread != Thread.currentThread() ? this.immutable : this.target();
    }

    protected final boolean updateInProgress() {
        return this.updatingThread == Thread.currentThread();
    }

    private class IteratorImpl
    implements Iterator<Map.Entry<K, V>> {
        private Map.Entry<K, V> current;
        private final Iterator<Map.Entry<K, V>> targetIterator;

        private IteratorImpl() {
            this.targetIterator = AtomicMapImpl.this.targetView().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.targetIterator.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            this.current = this.targetIterator.next();
            return this.current;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            AtomicMapImpl.this.remove(this.current.getKey());
            this.current = null;
        }
    }
}

