/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.util;

import fr.profi.util.StringUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PropertiesUtils {
    private static final Logger LOG = LoggerFactory.getLogger(PropertiesUtils.class);
    private static final int BUFFER_LENGTH = 2048;

    private PropertiesUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(String name) {
        if (StringUtils.isEmpty(name)) {
            throw new IllegalArgumentException("Invalid properties name");
        }
        Properties result = null;
        InputStream is = null;
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            is = classLoader.getResourceAsStream(name);
            if (is == null) {
                is = new FileInputStream(name);
                LOG.debug("Loading [{}] as file", (Object)name);
            } else {
                LOG.debug("Loading [{}] as resource from ClassLoader", (Object)name);
            }
            Properties props = new Properties();
            props.load(is);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Properties [" + name + "] :" + StringUtils.LINE_SEPARATOR + PropertiesUtils.formatProperties(props));
            }
            result = props;
        }
        catch (Exception ex) {
            LOG.error("Error loading [" + name + "]", (Throwable)ex);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException exClose) {
                    LOG.error("Error closing [" + name + "]", (Throwable)exClose);
                }
            }
        }
        return result;
    }

    public static String getProperty(Map<Object, Object> properties, String key) {
        if (properties == null) {
            throw new IllegalArgumentException("Properties Map is null");
        }
        if (key == null) {
            throw new IllegalArgumentException("Key is null");
        }
        String result = null;
        Object value = properties.get(key);
        if (value instanceof String) {
            result = (String)value;
        } else if (value != null) {
            LOG.warn(String.format("Properties Map contains non String value for %s : %s [%s]", key, value.getClass().getName(), value));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatProperties(Map<Object, Object> props) {
        if (props == null) {
            throw new IllegalArgumentException("Props Map is null");
        }
        StringBuilder buff = new StringBuilder(2048);
        Map<Object, Object> map = props;
        synchronized (map) {
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                Object key = entry.getKey();
                if (key == null) {
                    buff.append("NULL");
                } else {
                    buff.append(key);
                }
                buff.append(" : ");
                Object value = entry.getValue();
                if (value == null) {
                    buff.append("NULL");
                } else {
                    buff.append(value.getClass().getName());
                    buff.append(" [").append(value).append(']');
                }
                buff.append(StringUtils.LINE_SEPARATOR);
            }
        }
        return buff.toString();
    }
}

