/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.util;

import fr.profi.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadLogger
implements Thread.UncaughtExceptionHandler {
    private final Logger m_logger;

    public ThreadLogger(Logger logger) {
        if (logger == null) {
            throw new IllegalArgumentException("Logger is null");
        }
        this.m_logger = logger;
    }

    public ThreadLogger(String loggerName) {
        if (StringUtils.isEmpty(loggerName)) {
            throw new IllegalArgumentException("Invalid loggerName");
        }
        this.m_logger = LoggerFactory.getLogger((String)loggerName);
    }

    public ThreadLogger() {
        this(LoggerFactory.getLogger(ThreadLogger.class));
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        assert (this.m_logger != null) : "ThreadLogger.uncaughtException() m_logger is null";
        if (t != null && e != null) {
            this.m_logger.error("Uncaught Exception in thread \"" + t.getName() + "\"", e);
        }
    }
}

