/*
 * Decompiled with CFR 0.152.
 */
package jwave.datatypes.blocks;

import java.util.HashMap;
import jwave.datatypes.blocks.Block;
import jwave.datatypes.lines.Line;
import jwave.datatypes.lines.LineHash;
import jwave.exceptions.JWaveException;
import jwave.exceptions.JWaveFailure;

public class BlockHash
extends Block {
    HashMap<Integer, Line> _hashMapLines = null;

    public BlockHash() {
    }

    public BlockHash(Block block) {
        super(block);
        try {
            this.alloc();
            for (int i = 0; i < this._noOfRows; ++i) {
                for (int j = 0; j < this._noOfCols; ++j) {
                    this.set(i, j, block.get(i, j));
                }
            }
        }
        catch (JWaveException e) {
            e.printStackTrace();
        }
    }

    public BlockHash(int noOfRows, int noOfCols) {
        super(noOfRows, noOfCols);
    }

    public BlockHash(int offSetRow, int offSetCol, int noOfRows, int noOfCols) {
        super(offSetRow, offSetCol, noOfRows, noOfCols);
    }

    @Override
    public Block copy() {
        return new BlockHash(this);
    }

    @Override
    public boolean isAllocated() {
        boolean isAllocated = true;
        if (this._hashMapLines == null) {
            isAllocated = false;
        }
        return isAllocated;
    }

    @Override
    public void alloc() throws JWaveException {
        if (!this.isAllocated()) {
            this._hashMapLines = new HashMap();
        }
    }

    @Override
    public void erase() throws JWaveException {
        if (this._hashMapLines != null) {
            this._hashMapLines.clear();
        }
        this._hashMapLines = null;
    }

    @Override
    public double get(int i, int j) throws JWaveException {
        this.checkMemory();
        this.check(i, j);
        Line line = null;
        double value = 0.0;
        if (!this._hashMapLines.containsKey(j)) {
            throw new JWaveFailure("Line - no value stored for requested i: " + i);
        }
        line = this._hashMapLines.get(j);
        value = line.get(i);
        return value;
    }

    @Override
    public void set(int i, int j, double value) throws JWaveException {
        this.checkMemory();
        this.check(i, j);
        Line line = null;
        if (this._hashMapLines.containsKey(j)) {
            line = this._hashMapLines.get(j);
            line.set(i, value);
        } else {
            line = new LineHash(this._offSetRow, this._noOfRows);
            line.alloc();
            line.set(i, value);
            this._hashMapLines.put(j, line);
        }
    }
}

