/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzscope.ui;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import fr.profi.mzscope.CalibrationIon;
import fr.profi.mzscope.ionlibraries.Aligner;
import fr.profi.mzscope.ionlibraries.IonEntry;
import fr.profi.mzscope.ionlibraries.IonLibrary;
import fr.proline.studio.Exceptions;
import fr.proline.studio.export.ExportButton;
import fr.proline.studio.extendedtablemodel.CompoundTableModel;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.filter.FilterButton;
import fr.proline.studio.filter.FilterTableModelInterface;
import fr.proline.studio.graphics.MonoGraphicsPanel;
import fr.proline.studio.markerbar.MarkerComponentInterface;
import fr.proline.studio.markerbar.MarkerContainerPanel;
import fr.proline.studio.progress.ProgressInterface;
import fr.proline.studio.table.BeanTableModel;
import fr.proline.studio.table.DecoratedMarkerTable;
import fr.proline.studio.table.TablePopupMenu;
import fr.proline.studio.utils.StudioResourceBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.prefs.Preferences;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.apache.commons.math3.analysis.interpolation.AkimaSplineInterpolator;
import org.apache.commons.math3.analysis.interpolation.LinearInterpolator;
import org.apache.commons.math3.analysis.interpolation.SplineInterpolator;
import org.apache.commons.math3.analysis.interpolation.UnivariateInterpolator;
import org.jdesktop.swingx.JXTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IonLibraryAlignementPanel
extends JPanel {
    private static final String LAST_DIR = "Last ion lib directory";
    private static final Logger logger = LoggerFactory.getLogger(IonLibraryAlignementPanel.class);
    private final CompoundTableModel tableModel = new CompoundTableModel((GlobalTableModelInterface)new BeanTableModel(IonEntry.class, Arrays.asList("class", "schema")), true);
    private Aligner aligner;
    private MonoGraphicsPanel graphicsPanel;
    private MarkerContainerPanel markerContainerPanel;
    private final IonLibrary library;
    private JButton alignBtn;
    private JComboBox interpolationCbx;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JSplitPane jSplitPane1;
    private JLabel libraryEntriesJL;
    private JButton loadReferenceBtn;
    private JPanel plotPanel;
    private JLabel referenceEntriesJL;
    private JTextField referencePathTF;
    private JButton saveLibraryBtn;
    private JPanel tablePane;
    private JToolBar tableToolbar;

    public IonLibraryAlignementPanel(IonLibrary library) {
        this.library = library;
        this.initComponents();
        this.aligner = new Aligner(library);
        this.libraryEntriesJL.setText("(" + library.getEntries().size() + " entries found, " + library.getNonRedondantEntries().size() + " non redondant)");
        this.markerContainerPanel.setMaxLineNumber(library.getNonRedondantEntries().size());
        ((BeanTableModel)this.tableModel.getBaseModel()).setData(library.getNonRedondantEntries());
        this.graphicsPanel.setData((ExtendedTableModelInterface)this.tableModel, null);
    }

    private void initComponents() {
        this.tableToolbar = new JToolBar();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.referencePathTF = new JTextField();
        this.loadReferenceBtn = new JButton();
        this.libraryEntriesJL = new JLabel();
        this.referenceEntriesJL = new JLabel();
        this.jSplitPane1 = new JSplitPane();
        this.jPanel2 = new JPanel();
        this.jPanel3 = new JPanel();
        this.saveLibraryBtn = new JButton();
        this.alignBtn = new JButton();
        this.interpolationCbx = new JComboBox();
        this.tablePane = new JPanel();
        this.plotPanel = new JPanel();
        this.tableToolbar.setFloatable(false);
        this.tableToolbar.setOrientation(1);
        this.tableToolbar.setRollover(true);
        this.jLabel1.setText(StudioResourceBundle.getMessage(IonLibraryAlignementPanel.class, (String)"IonLibraryAlignementPanel.jLabel1.text"));
        this.jLabel2.setText(StudioResourceBundle.getMessage(IonLibraryAlignementPanel.class, (String)"IonLibraryAlignementPanel.jLabel2.text"));
        this.referencePathTF.setText(StudioResourceBundle.getMessage(IonLibraryAlignementPanel.class, (String)"IonLibraryAlignementPanel.referencePathTF.text"));
        this.loadReferenceBtn.setText(StudioResourceBundle.getMessage(IonLibraryAlignementPanel.class, (String)"IonLibraryAlignementPanel.loadReferenceBtn.text"));
        this.loadReferenceBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IonLibraryAlignementPanel.this.loadReferenceBtnActionPerformed(evt);
            }
        });
        this.libraryEntriesJL.setText(StudioResourceBundle.getMessage(IonLibraryAlignementPanel.class, (String)"IonLibraryAlignementPanel.libraryEntriesJL.text"));
        this.referenceEntriesJL.setText(StudioResourceBundle.getMessage(IonLibraryAlignementPanel.class, (String)"IonLibraryAlignementPanel.referenceEntriesJL.text"));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel2, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.referencePathTF, -2, 242, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.loadReferenceBtn, -2, 33, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.referenceEntriesJL, -1, -1, Short.MAX_VALUE)).addComponent(this.libraryEntriesJL, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel1).addComponent(this.libraryEntriesJL, -1, 23, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.referencePathTF, -2, -1, -2).addComponent(this.loadReferenceBtn)).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.referenceEntriesJL, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        this.jSplitPane1.setDividerLocation(150);
        this.jSplitPane1.setOrientation(0);
        this.saveLibraryBtn.setText(StudioResourceBundle.getMessage(IonLibraryAlignementPanel.class, (String)"IonLibraryAlignementPanel.saveLibraryBtn.text"));
        this.saveLibraryBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IonLibraryAlignementPanel.this.saveLibraryBtnActionPerformed(evt);
            }
        });
        this.alignBtn.setText(StudioResourceBundle.getMessage(IonLibraryAlignementPanel.class, (String)"IonLibraryAlignementPanel.alignBtn.text"));
        this.alignBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IonLibraryAlignementPanel.this.alignBtnActionPerformed(evt);
            }
        });
        this.interpolationCbx.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addGap(0, 246, Short.MAX_VALUE).addComponent(this.interpolationCbx, -2, 115, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.alignBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.saveLibraryBtn)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.saveLibraryBtn).addComponent(this.alignBtn).addComponent(this.interpolationCbx, -2, -1, -2)));
        this.tablePane.setLayout(new BorderLayout());
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addComponent(this.tablePane, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addComponent(this.tablePane, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, -1, -2)));
        this.jSplitPane1.setTopComponent(this.jPanel2);
        GroupLayout plotPanelLayout = new GroupLayout(this.plotPanel);
        this.plotPanel.setLayout(plotPanelLayout);
        plotPanelLayout.setHorizontalGroup(plotPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 557, Short.MAX_VALUE));
        plotPanelLayout.setVerticalGroup(plotPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        this.jSplitPane1.setRightComponent(this.plotPanel);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jSplitPane1).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSplitPane1, -1, 295, Short.MAX_VALUE).addContainerGap()));
        this.initCustomComponents();
    }

    private void alignBtnActionPerformed(ActionEvent evt) {
        UnivariateInterpolator interpolator = (UnivariateInterpolator)this.interpolationCbx.getSelectedItem();
        this.aligner.align(interpolator);
        this.aligner.predictRT();
        this.tableModel.fireTableDataChanged();
        this.graphicsPanel.setData((ExtendedTableModelInterface)this.tableModel, null);
    }

    private void loadReferenceBtnActionPerformed(ActionEvent evt) {
        Preferences prefs = Preferences.userNodeForPackage(this.getClass());
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle("Open Reference file");
        String directory = prefs.get(LAST_DIR, fileChooser.getCurrentDirectory().getAbsolutePath());
        fileChooser.setCurrentDirectory(new File(directory));
        fileChooser.setMultiSelectionEnabled(false);
        int returnVal = fileChooser.showOpenDialog(this);
        if (returnVal == 0) {
            try {
                File file = fileChooser.getSelectedFile();
                logger.info("Start loading ion library from " + file.getAbsolutePath());
                ArrayList<CalibrationIon> entries = new ArrayList<CalibrationIon>();
                FileInputStream fis = new FileInputStream(file);
                BufferedReader fReader = new BufferedReader(new InputStreamReader(fis));
                CsvMapper mapper = new CsvMapper();
                mapper.configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true);
                CsvSchema schema = CsvSchema.emptySchema().withHeader().withColumnSeparator('\t');
                MappingIterator it = mapper.readerFor(CalibrationIon.class).with((FormatSchema)schema).readValues((Reader)fReader);
                while (it.hasNext()) {
                    CalibrationIon row = (CalibrationIon)it.next();
                    entries.add(row);
                }
                int matchesCount = 0;
                for (CalibrationIon c : entries) {
                    if (!this.aligner.addCalibrationIon(c)) continue;
                    ++matchesCount;
                }
                this.referencePathTF.setText(file.getAbsolutePath());
                this.referenceEntriesJL.setText("(" + entries.size() + " entries found, " + matchesCount + " matched in the library)");
                this.tableModel.fireTableDataChanged();
                this.graphicsPanel.setData((ExtendedTableModelInterface)this.tableModel, null);
                prefs.put(LAST_DIR, file.getParent());
                logger.info("Ion Library loaded");
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        } else {
            System.out.println("File access cancelled by user.");
        }
    }

    private void saveLibraryBtnActionPerformed(ActionEvent evt) {
        Preferences prefs = Preferences.userNodeForPackage(this.getClass());
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle("Save Library file");
        String directory = prefs.get(LAST_DIR, fileChooser.getCurrentDirectory().getAbsolutePath());
        fileChooser.setCurrentDirectory(new File(directory));
        int returnVal = fileChooser.showSaveDialog(this);
        if (returnVal == 0) {
            try {
                File file = fileChooser.getSelectedFile();
                this.aligner.applyPredictedRT();
                this.aligner.getLibrary().saveToFile(file);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void initCustomComponents() {
        JScrollPane tableScrollPane = new JScrollPane();
        DecoratedMarkerTable table = new DecoratedMarkerTable(){

            public TablePopupMenu initPopupMenu() {
                return new TablePopupMenu();
            }

            public void prepostPopupMenu() {
            }

            public void addTableModelListener(TableModelListener l) {
                this.getModel().addTableModelListener(l);
            }
        };
        table.setModel((TableModel)this.tableModel);
        tableScrollPane.setViewportView((Component)table);
        table.setFillsViewportHeight(true);
        table.setViewport(tableScrollPane.getViewport());
        ExportButton exportButton = new ExportButton((ProgressInterface)this.tableModel, "Export", (JXTable)table);
        this.tableToolbar.add((Component)exportButton);
        FilterButton filterButton = new FilterButton((FilterTableModelInterface)this.tableModel){

            protected void filteringDone() {
            }
        };
        this.tableToolbar.add((Component)filterButton);
        this.markerContainerPanel = new MarkerContainerPanel(tableScrollPane, (MarkerComponentInterface)table);
        this.tablePane.add((Component)this.tableToolbar, "West");
        this.tablePane.add((Component)this.markerContainerPanel, "Center");
        this.graphicsPanel = new MonoGraphicsPanel(false);
        this.graphicsPanel.setData((ExtendedTableModelInterface)this.tableModel, null);
        this.plotPanel.setLayout(new BorderLayout());
        this.plotPanel.add((Component)this.graphicsPanel, "Center");
        UnivariateInterpolator[] interpolationMethods = new UnivariateInterpolator[]{new LinearInterpolator(){

            public String toString() {
                return "Multi-Linear";
            }
        }, new SplineInterpolator(){

            public String toString() {
                return "Spline";
            }
        }, new AkimaSplineInterpolator(){

            public String toString() {
                return "Akima";
            }
        }};
        this.interpolationCbx.setModel(new DefaultComboBoxModel<UnivariateInterpolator>(interpolationMethods));
    }
}

