/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzscope.ui;

import fr.profi.mzscope.ionlibraries.IonEntry;
import fr.profi.mzscope.ionlibraries.IonLibrary;
import fr.profi.mzscope.ui.IonLibraryAlignementPanel;
import fr.proline.mzscope.model.ExtractionRequest;
import fr.proline.mzscope.ui.IMzScopeController;
import fr.proline.mzscope.ui.IRawFileViewer;
import fr.proline.mzscope.ui.model.MzScopePreferences;
import fr.proline.mzscope.utils.Display;
import fr.proline.studio.export.ExportButton;
import fr.proline.studio.extendedtablemodel.CompoundTableModel;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.filter.FilterButton;
import fr.proline.studio.filter.FilterTableModelInterface;
import fr.proline.studio.graphics.marker.IntervalMarker;
import fr.proline.studio.markerbar.MarkerComponentInterface;
import fr.proline.studio.markerbar.MarkerContainerPanel;
import fr.proline.studio.progress.ProgressInterface;
import fr.proline.studio.table.BeanTableModel;
import fr.proline.studio.table.DecoratedMarkerTable;
import fr.proline.studio.table.TablePopupMenu;
import fr.proline.studio.utils.StudioResourceBundle;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IonLibraryPanel
extends JPanel {
    private static final Logger logger = LoggerFactory.getLogger(IonLibraryPanel.class);
    private final CompoundTableModel ionEntriesTableModel = new CompoundTableModel((GlobalTableModelInterface)new BeanTableModel(IonEntry.class, Arrays.asList("class", "schema")), true);
    private final CompoundTableModel peptidesTableModel = new CompoundTableModel((GlobalTableModelInterface)new BeanTableModel(IonLibrary.Peptide.class), true);
    private MarkerContainerPanel ionEntriesMarkerContainerPanel;
    private MarkerContainerPanel peptidesMarkerContainerPanel;
    private final IonLibrary library;
    private final IMzScopeController appController;
    private DecoratedMarkerTable ionEntriesTable;
    private DecoratedMarkerTable peptidesTable;
    private JButton alignLibraryBtn;
    private JButton extractBtn;
    private JPanel fragmentsPane;
    private JSplitPane jSplitPane1;
    private JToolBar jToolBar1;
    private JPanel precursorsPane;

    public IonLibraryPanel(IonLibrary library, IMzScopeController appController) {
        this.library = library;
        this.appController = appController;
        this.initComponents();
        this.ionEntriesMarkerContainerPanel.setMaxLineNumber(library.getNonRedondantEntries().size());
        ((BeanTableModel)this.ionEntriesTableModel.getBaseModel()).setData(library.getEntries());
        ArrayList<IonLibrary.Peptide> peptides = new ArrayList<IonLibrary.Peptide>();
        for (IonEntry e : library.getNonRedondantEntries()) {
            List<IonEntry> entries = library.getIonEntryBySequence(e.getModification_sequence());
            Map<Integer, List<IonEntry>> map = entries.stream().collect(Collectors.groupingBy(IonEntry::getPrec_z));
            for (Integer charge : map.keySet()) {
                IonEntry prototype = map.get(charge).get(0);
                peptides.add(new IonLibrary.Peptide(prototype));
            }
        }
        ((BeanTableModel)this.peptidesTableModel.getBaseModel()).setData(peptides);
        this.peptidesMarkerContainerPanel.setMaxLineNumber(peptides.size());
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.fragmentsPane = new JPanel();
        this.precursorsPane = new JPanel();
        this.jToolBar1 = new JToolBar();
        this.alignLibraryBtn = new JButton();
        this.extractBtn = new JButton();
        this.jSplitPane1.setDividerLocation(130);
        this.fragmentsPane.setLayout(new BorderLayout());
        this.jSplitPane1.setRightComponent(this.fragmentsPane);
        this.precursorsPane.setLayout(new BorderLayout());
        this.jSplitPane1.setLeftComponent(this.precursorsPane);
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.alignLibraryBtn.setText(StudioResourceBundle.getMessage(IonLibraryPanel.class, (String)"IonLibraryPanel.alignLibraryBtn.text"));
        this.alignLibraryBtn.setFocusable(false);
        this.alignLibraryBtn.setHorizontalTextPosition(0);
        this.alignLibraryBtn.setVerticalTextPosition(3);
        this.alignLibraryBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IonLibraryPanel.this.alignLibraryBtnActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.alignLibraryBtn);
        this.extractBtn.setText(StudioResourceBundle.getMessage(IonLibraryPanel.class, (String)"IonLibraryPanel.extractBtn.text"));
        this.extractBtn.setFocusable(false);
        this.extractBtn.setHorizontalTextPosition(0);
        this.extractBtn.setVerticalTextPosition(3);
        this.extractBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IonLibraryPanel.this.extractBtnActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.extractBtn);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1).addComponent(this.jToolBar1, -1, 481, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jToolBar1, -2, 26, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSplitPane1, -1, 218, Short.MAX_VALUE).addContainerGap()));
        this.initCustomComponents();
    }

    private void alignLibraryBtnActionPerformed(ActionEvent evt) {
        JDialog dialog = new JDialog((Frame)((JFrame)this.getTopLevelAncestor()), "Ion Library Alignment");
        dialog.setContentPane(new IonLibraryAlignementPanel(this.library));
        dialog.pack();
        dialog.setModal(true);
        dialog.setVisible(true);
    }

    private void extractBtnActionPerformed(ActionEvent evt) {
        block5: {
            IRawFileViewer viewer = this.appController.getCurrentRawFileViewer();
            if (viewer.getCurrentRawfile() == null || !viewer.getCurrentRawfile().isDIAFile()) break block5;
            String identifier = new Timestamp(System.currentTimeMillis()).toString();
            int selectedPeptideRow = this.peptidesTable.convertRowIndexToNonFilteredModel(this.peptidesTable.getSelectedRow());
            if (selectedPeptideRow >= 0) {
                IonLibrary.Peptide peptide = (IonLibrary.Peptide)((BeanTableModel)this.peptidesTableModel.getBaseModel()).getData().get(selectedPeptideRow);
                ExtractionRequest.Builder builder = ExtractionRequest.builder((Object)this);
                builder.setMzTolPPM(MzScopePreferences.getInstance().getMzPPMTolerance()).setMz(peptide.getQ1().doubleValue());
                viewer.extractAndDisplay(builder.build(), new Display(Display.Mode.SERIES, identifier), null);
            }
            int[] selectedIonsRows = this.ionEntriesTable.getSelectedRows();
            List entries = ((BeanTableModel)this.ionEntriesTableModel.getBaseModel()).getData();
            IonEntry firstIon = selectedIonsRows.length > 0 ? (IonEntry)entries.get(this.ionEntriesTable.convertRowIndexToNonFilteredModel(selectedIonsRows[0])) : (IonEntry)entries.get(0);
            Display display = new Display(Display.Mode.SERIES, Arrays.asList(new IntervalMarker(null, Color.ORANGE, Color.RED, firstIon.getRT_detected() - 5.0, firstIon.getRT_detected() + 5.0)), identifier);
            if (selectedIonsRows.length > 0) {
                for (int k = 0; k < selectedIonsRows.length; ++k) {
                    IonEntry ion = (IonEntry)entries.get(this.ionEntriesTable.convertRowIndexToNonFilteredModel(selectedIonsRows[k]));
                    ExtractionRequest.Builder builder = ExtractionRequest.builder((Object)this);
                    builder.setMz(ion.getQ1().doubleValue()).setFragmentMz(ion.getQ3().doubleValue()).setFragmentMzTolPPM(MzScopePreferences.getInstance().getFragmentMzPPMTolerance());
                    viewer.extractAndDisplay(builder.build(), display, null);
                    display = new Display(Display.Mode.SERIES, identifier);
                }
            } else {
                for (IonEntry ion : entries) {
                    ExtractionRequest.Builder builder = ExtractionRequest.builder((Object)this);
                    builder.setMz(ion.getQ1().doubleValue()).setFragmentMz(ion.getQ3().doubleValue()).setFragmentMzTolPPM(MzScopePreferences.getInstance().getFragmentMzPPMTolerance());
                    viewer.extractAndDisplay(builder.build(), display, null);
                    display = new Display(Display.Mode.SERIES, identifier);
                }
            }
        }
    }

    private void initCustomComponents() {
        JScrollPane ionEntriesScrollPane = new JScrollPane();
        this.ionEntriesTable = new DecoratedMarkerTable(){

            public TablePopupMenu initPopupMenu() {
                return new TablePopupMenu();
            }

            public void prepostPopupMenu() {
            }

            public void addTableModelListener(TableModelListener l) {
                this.getModel().addTableModelListener(l);
            }
        };
        this.ionEntriesTable.setModel((TableModel)this.ionEntriesTableModel);
        ionEntriesScrollPane.setViewportView((Component)this.ionEntriesTable);
        this.ionEntriesTable.setFillsViewportHeight(true);
        this.ionEntriesTable.setViewport(ionEntriesScrollPane.getViewport());
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.setOrientation(1);
        toolbar.setRollover(true);
        ExportButton exportButton = new ExportButton((ProgressInterface)this.ionEntriesTableModel, "Export", (JXTable)this.ionEntriesTable);
        toolbar.add((Component)exportButton);
        FilterButton filterButton = new FilterButton((FilterTableModelInterface)this.ionEntriesTableModel){

            protected void filteringDone() {
            }
        };
        toolbar.add((Component)filterButton);
        this.ionEntriesMarkerContainerPanel = new MarkerContainerPanel(ionEntriesScrollPane, (MarkerComponentInterface)this.ionEntriesTable);
        this.fragmentsPane.add((Component)toolbar, "West");
        this.fragmentsPane.add((Component)this.ionEntriesMarkerContainerPanel, "Center");
        JScrollPane peptidesScrollPane = new JScrollPane();
        this.peptidesTable = new DecoratedMarkerTable(){

            public TablePopupMenu initPopupMenu() {
                return new TablePopupMenu();
            }

            public void prepostPopupMenu() {
            }

            public void addTableModelListener(TableModelListener l) {
                this.getModel().addTableModelListener(l);
            }

            public void valueChanged(ListSelectionEvent e) {
                super.valueChanged(e);
                int selectedRow = this.convertRowIndexToNonFilteredModel(this.getSelectedRow());
                if (selectedRow >= 0) {
                    List peptides = ((BeanTableModel)IonLibraryPanel.this.peptidesTableModel.getBaseModel()).getData();
                    IonLibrary.Peptide selectedPeptide = (IonLibrary.Peptide)peptides.get(selectedRow);
                    List<IonEntry> entries = IonLibraryPanel.this.library.getIonEntryBySequence(selectedPeptide.getSequence());
                    Map<Integer, List<IonEntry>> map = entries.stream().collect(Collectors.groupingBy(IonEntry::getPrec_z));
                    ((BeanTableModel)IonLibraryPanel.this.ionEntriesTableModel.getBaseModel()).setData(map.get(selectedPeptide.getCharge()));
                }
            }
        };
        this.peptidesTable.setModel((TableModel)this.peptidesTableModel);
        peptidesScrollPane.setViewportView((Component)this.peptidesTable);
        this.peptidesTable.setFillsViewportHeight(true);
        this.peptidesTable.setViewport(peptidesScrollPane.getViewport());
        this.peptidesMarkerContainerPanel = new MarkerContainerPanel(peptidesScrollPane, (MarkerComponentInterface)this.peptidesTable);
        filterButton = new FilterButton((FilterTableModelInterface)this.peptidesTableModel){

            protected void filteringDone() {
            }
        };
        toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.setOrientation(1);
        toolbar.setRollover(true);
        toolbar.add((Component)filterButton);
        this.precursorsPane.add((Component)toolbar, "West");
        this.precursorsPane.add((Component)this.peptidesMarkerContainerPanel, "Center");
    }
}

