/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzscope.ui;

import fr.profi.mzscope.ConverterManager;
import fr.profi.mzscope.InvalidMGFFormatException;
import fr.profi.mzscope.MGFReader;
import fr.profi.mzscope.MSMSSpectrum;
import fr.profi.mzscope.ionlibraries.IonEntry;
import fr.profi.mzscope.ionlibraries.IonLibrary;
import fr.profi.mzscope.ionlibraries.PeakViewEntry;
import fr.profi.mzscope.ionlibraries.SpectronautEntry;
import fr.profi.mzscope.ui.IonLibraryPanel;
import fr.profi.mzscope.ui.IsotopicToolPanel;
import fr.profi.mzscope.ui.MGFPanel;
import fr.profi.mzscope.ui.RawMinerPanel;
import fr.profi.util.version.IVersion;
import fr.proline.mzscope.ui.BatchExtractionPanel;
import fr.proline.mzscope.ui.IMzScopeController;
import fr.proline.mzscope.ui.IRawFileViewer;
import fr.proline.mzscope.ui.dialog.ConvertRawFilesDialog;
import fr.proline.mzscope.ui.dialog.MzdbFilter;
import fr.proline.studio.Exceptions;
import fr.proline.studio.WindowManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.prefs.Preferences;
import javax.swing.GroupLayout;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.filechooser.FileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawMinerFrame
extends JFrame {
    private static final Logger logger = LoggerFactory.getLogger(RawMinerFrame.class);
    private static final String LAST_DIR = "Last ion lib directory";
    private final RawMinerPanel rawMinerPanel;
    private JMenuItem detectPeakelsMI;
    private JMenuItem extractFeaturesMI;
    private JMenuItem experimentalMI;
    private JPanel mainPanel;

    public RawMinerFrame() {
        this.initComponents();
        ServiceLoader<IVersion> versionLoader = ServiceLoader.load(IVersion.class);
        Iterator<IVersion> iter = versionLoader.iterator();
        String version = "snapshot";
        while (iter.hasNext()) {
            IVersion v = iter.next();
            if (!v.getModuleName().equalsIgnoreCase("mzScope")) continue;
            version = v.getVersion();
        }
        this.setTitle("mzScope " + version);
        this.rawMinerPanel = new RawMinerPanel(this);
        this.mainPanel.add((Component)this.rawMinerPanel, "Center");
        this.setSize(700, 500);
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle("Open mzDB file");
        fileChooser.addChoosableFileFilter((FileFilter)new MzdbFilter());
        this.setDefaultCloseOperation(3);
        this.setTitle("mzScope");
        this.mainPanel.setLayout(new BorderLayout());
        JMenu fileMenu = new JMenu("File");
        JMenuItem openRawMI = new JMenuItem("Open mzDB file ...");
        openRawMI.setAccelerator(KeyStroke.getKeyStroke(79, 128));
        openRawMI.addActionListener(this::openRawMIActionPerformed);
        fileMenu.add(openRawMI);
        JMenuItem convertRawMI = new JMenuItem("Convert and open raw files ...");
        convertRawMI.setAccelerator(KeyStroke.getKeyStroke(67, 128));
        convertRawMI.addActionListener(this::convertRawMIActionPerformed);
        fileMenu.add(convertRawMI);
        fileMenu.add(new JPopupMenu.Separator());
        JMenuItem closeAllMI = new JMenuItem("Close All");
        closeAllMI.addActionListener(this::closeAllMIActionPerformed);
        fileMenu.add(closeAllMI);
        fileMenu.add(new JPopupMenu.Separator());
        JMenuItem exitMI = new JMenuItem("Exit");
        exitMI.setActionCommand("exit");
        exitMI.addActionListener(this::exitMIActionPerformed);
        fileMenu.add(exitMI);
        exitMI.getAccessibleContext().setAccessibleName("exitMenuItem");
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(fileMenu);
        JMenu processMenu = new JMenu();
        this.extractFeaturesMI = new JMenuItem();
        this.detectPeakelsMI = new JMenuItem();
        JMenuItem detectFeatureMI = new JMenuItem();
        JMenuItem exportChromatogramMI = new JMenuItem();
        JMenuItem comparePeakelListMI = new JMenuItem();
        processMenu.setText("Process");
        this.extractFeaturesMI.setText("Extract features from MS2");
        this.extractFeaturesMI.setActionCommand("extractMenuItem");
        this.extractFeaturesMI.addActionListener(this::extractFeaturesMIActionPerformed);
        processMenu.add(this.extractFeaturesMI);
        this.detectPeakelsMI.setText("Detect Peakels");
        this.detectPeakelsMI.addActionListener(this::detectPeakelsMIActionPerformed);
        processMenu.add(this.detectPeakelsMI);
        detectFeatureMI.setText("Detect Features");
        detectFeatureMI.addActionListener(this::detectFeatureMIActionPerformed);
        processMenu.add(detectFeatureMI);
        exportChromatogramMI.setText("Export chromatogram");
        exportChromatogramMI.addActionListener(this::exportChromatogramActionPerformed);
        processMenu.add(exportChromatogramMI);
        exportChromatogramMI.getAccessibleContext().setAccessibleName("exportChromatogramItem");
        comparePeakelListMI.setText("Compare Peakel List");
        comparePeakelListMI.addActionListener(this::comparePeakelListActionPerformed);
        processMenu.add(comparePeakelListMI);
        menuBar.add(processMenu);
        JMenu toolsMenu = new JMenu("Tools");
        JMenu loadIonLibrarySubmenu = new JMenu("Load Ion Library");
        JMenuItem loadPeakViewLibraryMI = new JMenuItem("Peakview...");
        loadPeakViewLibraryMI.addActionListener(this::loadPeakViewLibraryMIActionPerformed);
        loadIonLibrarySubmenu.add(loadPeakViewLibraryMI);
        JMenuItem loadSpectronautLibraryMI = new JMenuItem("Proline/Spectronaut...");
        loadSpectronautLibraryMI.addActionListener(this::loadSpectronautLibraryMIActionPerformed);
        loadIonLibrarySubmenu.add(loadSpectronautLibraryMI);
        toolsMenu.add(loadIonLibrarySubmenu);
        JMenuItem loadMGFMI = new JMenuItem("Load MGF File ...");
        loadMGFMI.addActionListener(this::loadMGFMIActionPerformed);
        toolsMenu.add(loadMGFMI);
        JMenuItem isotopicToolMI = new JMenuItem("Isotopic Distribution ...");
        isotopicToolMI.addActionListener(this::isotopicToolActionPerformed);
        toolsMenu.add(isotopicToolMI);
        JMenuItem batchExtractionToolMI = new JMenuItem("Batch Extraction ...");
        batchExtractionToolMI.addActionListener(this::batchExtractionToolActionPerformed);
        toolsMenu.add(batchExtractionToolMI);
        menuBar.add(toolsMenu);
        this.setJMenuBar(menuBar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mainPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mainPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void exitMIActionPerformed(ActionEvent evt) {
        this.rawMinerPanel.closeAllFiles();
        System.exit(0);
    }

    private void openRawMIActionPerformed(ActionEvent evt) {
        this.rawMinerPanel.openRawFile();
    }

    private void convertRawMIActionPerformed(ActionEvent evt) {
        ConvertRawFilesDialog dialog = new ConvertRawFilesDialog((Window)WindowManager.getDefault().getMainWindow());
        dialog.setVisible(true);
        if (dialog.getButtonClicked() == 0) {
            ConverterManager.getInstance().setRawMinerPanel(this.rawMinerPanel);
            ConverterManager.getInstance().addFiles(dialog.getFilePaths());
            ConverterManager.setConverterExeFile(dialog.getConverterExeFile());
            ConverterManager.setConverterOption(dialog.getConverterOption());
            ConverterManager.getInstance().runConvert();
        }
    }

    private void extractFeaturesMIActionPerformed(ActionEvent evt) {
        IRawFileViewer viewer = this.rawMinerPanel.getMzScopePanel().getCurrentRawFileViewer();
        if (viewer != null && viewer.getCurrentRawfile() != null) {
            this.rawMinerPanel.getMzScopePanel().extractFeaturesFromMS2(Collections.singletonList(viewer.getCurrentRawfile()));
        }
    }

    private void exportChromatogramActionPerformed(ActionEvent evt) {
        this.rawMinerPanel.exportChromatogram();
    }

    private void detectPeakelsMIActionPerformed(ActionEvent evt) {
        IRawFileViewer viewer = this.rawMinerPanel.getMzScopePanel().getCurrentRawFileViewer();
        if (viewer != null && viewer.getCurrentRawfile() != null) {
            this.rawMinerPanel.getMzScopePanel().detectPeakels(Collections.singletonList(viewer.getCurrentRawfile()));
        }
    }

    private void comparePeakelListActionPerformed(ActionEvent evt) {
        List rawFileList;
        boolean compare = false;
        IRawFileViewer viewer = this.rawMinerPanel.getMzScopePanel().getCurrentRawFileViewer();
        if (viewer != null && (rawFileList = viewer.getAllRawfiles()) != null && rawFileList.size() == 2) {
            this.rawMinerPanel.getMzScopePanel().comparePeakels(rawFileList);
            compare = true;
        }
        if (!compare) {
            JOptionPane.showMessageDialog(this, "You can only compare Peakel lists in a view with 2 mzdb openend", "Warning", 1);
        }
    }

    private void closeAllMIActionPerformed(ActionEvent evt) {
        this.rawMinerPanel.closeAllFiles();
    }

    private void detectFeatureMIActionPerformed(ActionEvent evt) {
        IRawFileViewer viewer = this.rawMinerPanel.getMzScopePanel().getCurrentRawFileViewer();
        if (viewer != null && viewer.getCurrentRawfile() != null) {
            this.rawMinerPanel.getMzScopePanel().detectFeatures(Collections.singletonList(viewer.getCurrentRawfile()));
        }
    }

    private void loadIonLibraryMI(String dialogTitle, IonEntry prototype) {
        Preferences prefs = Preferences.userNodeForPackage(this.getClass());
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle(dialogTitle);
        String directory = prefs.get(LAST_DIR, fileChooser.getCurrentDirectory().getAbsolutePath());
        fileChooser.setCurrentDirectory(new File(directory));
        fileChooser.setMultiSelectionEnabled(true);
        int returnVal = fileChooser.showOpenDialog(this);
        if (returnVal == 0) {
            File file = fileChooser.getSelectedFile();
            IonLibrary library = IonLibrary.fromFile(file, prototype);
            prefs.put(LAST_DIR, file.getParent());
            this.rawMinerPanel.getMzScopePanel().addFeatureTab("Ion Lib: " + file.getName(), (Component)new IonLibraryPanel(library, (IMzScopeController)this.rawMinerPanel.getMzScopePanel()), "");
        }
    }

    private void loadPeakViewLibraryMIActionPerformed(ActionEvent evt) {
        this.loadIonLibraryMI("Open PeakView Library file", new PeakViewEntry());
    }

    private void isotopicToolActionPerformed(ActionEvent evt) {
        this.rawMinerPanel.getMzScopePanel().addFeatureTab("Isotopic distribution", (Component)new IsotopicToolPanel(this.rawMinerPanel.getMzScopePanel()), "Isotopic pattern tool");
    }

    private void batchExtractionToolActionPerformed(ActionEvent evt) {
        this.rawMinerPanel.getMzScopePanel().addFeatureTab("Batch Extraction", (Component)new BatchExtractionPanel((IMzScopeController)this.rawMinerPanel.getMzScopePanel(), 0), "Batch Extraction tool");
    }

    private void loadMGFMIActionPerformed(ActionEvent evt) {
        Preferences prefs = Preferences.userNodeForPackage(this.getClass());
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle("Open MGF file");
        String directory = prefs.get(LAST_DIR, fileChooser.getCurrentDirectory().getAbsolutePath());
        fileChooser.setCurrentDirectory(new File(directory));
        fileChooser.setMultiSelectionEnabled(true);
        int returnVal = fileChooser.showOpenDialog(this);
        if (returnVal == 0) {
            try {
                File file = fileChooser.getSelectedFile();
                MGFReader reader = new MGFReader();
                List<MSMSSpectrum> peakList = reader.read(file);
                String title = "MGF file " + file.getName();
                this.rawMinerPanel.getMzScopePanel().addFeatureTab(title, (Component)new MGFPanel(peakList, (IMzScopeController)this.rawMinerPanel.getMzScopePanel()), "Spectra loaded from " + title);
                prefs.put(LAST_DIR, file.getParent());
            }
            catch (InvalidMGFFormatException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void loadSpectronautLibraryMIActionPerformed(ActionEvent evt) {
        this.loadIonLibraryMI("Open Spectronaut Library file", new SpectronautEntry());
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Windows".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(RawMinerFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new RawMinerFrame().setVisible(true);
            }
        });
    }

    public void setExtractFeaturesMIEnabled(boolean extractFeatures) {
        this.extractFeaturesMI.setEnabled(extractFeatures);
    }

    public void setDetectPeakelsMIEnabled(boolean detectPeakels) {
        this.detectPeakelsMI.setEnabled(detectPeakels);
    }
}

