/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.graphics;

public class AxisTicks {
    private static int m_maxTicks;
    private double m_min;
    private double m_max;
    private double m_calculatedRange;
    private double m_calculatedMin;
    private double m_calculatedMax;
    private double m_tickSpacing;
    private int m_nbFractionalDigits;
    private int m_nbIntegerDigits;
    private boolean m_log;
    private boolean m_isInteger;
    private boolean m_isEnum;

    public AxisTicks(double min, double max, int maxTicks, boolean log, double logMinValue, boolean isInteger, boolean isEnum) {
        m_maxTicks = maxTicks <= 1 ? 2 : maxTicks;
        this.m_log = log;
        this.m_isInteger = isInteger;
        this.m_isEnum = isEnum;
        if (log) {
            this.m_min = Math.log10(min <= logMinValue ? logMinValue : min);
            this.m_max = Math.log10(max <= logMinValue ? logMinValue * 10.0 : max);
        } else {
            this.m_min = min;
            this.m_max = max;
        }
        this.calculate();
    }

    public double getTickMin() {
        return this.m_calculatedMin;
    }

    public double getTickMax() {
        return this.m_calculatedMax;
    }

    public double getTickSpacing() {
        return this.m_tickSpacing;
    }

    public int getFractionalDigits() {
        return this.m_nbFractionalDigits;
    }

    public int getIntegerDigits() {
        return this.m_nbIntegerDigits;
    }

    private void calculate() {
        if (this.m_log) {
            this.m_calculatedMin = Math.floor(this.m_min);
            this.m_calculatedMax = Math.ceil(this.m_max);
            this.m_calculatedRange = this.m_calculatedMax - this.m_calculatedMin;
            this.m_tickSpacing = 1.0;
            this.m_nbFractionalDigits = 0;
            this.m_nbIntegerDigits = 1;
        } else if (this.m_isInteger) {
            this.m_calculatedMin = Math.floor(this.m_min);
            this.m_calculatedMax = Math.ceil(this.m_max);
            this.m_calculatedRange = this.m_calculatedMax - this.m_calculatedMin;
            this.m_tickSpacing = 1.0;
            this.m_nbFractionalDigits = 0;
            this.m_nbIntegerDigits = Math.max((int)Math.round(Math.floor(Math.log10(Math.abs(this.m_calculatedMax)))), (int)Math.round(Math.floor(Math.log10(Math.abs(this.m_calculatedMin)))));
        } else {
            this.m_calculatedRange = this.niceNum(this.m_max - this.m_min, false);
            this.m_tickSpacing = this.niceNum(this.m_calculatedRange / (double)(m_maxTicks - 1), true);
            this.m_nbFractionalDigits = -((int)Math.round(Math.floor(Math.log10(this.m_calculatedRange / (double)(m_maxTicks - 1)))));
            this.m_calculatedMin = Math.floor(this.m_min / this.m_tickSpacing) * this.m_tickSpacing;
            this.m_calculatedMax = Math.ceil(this.m_max / this.m_tickSpacing) * this.m_tickSpacing;
            this.m_nbIntegerDigits = Math.max((int)Math.round(Math.floor(Math.log10(Math.abs(Math.ceil(this.m_calculatedMax))))), (int)Math.round(Math.floor(Math.log10(Math.abs(Math.ceil(this.m_calculatedMin))))));
        }
    }

    private double niceNum(double range, boolean round) {
        double exponent = Math.floor(Math.log10(range));
        double fraction = range / Math.pow(10.0, exponent);
        double niceFraction = round ? (fraction < 1.5 ? 1.0 : (fraction < 3.0 ? 2.0 : (fraction < 7.0 ? 5.0 : 10.0))) : (fraction <= 1.0 ? 1.0 : (fraction <= 2.0 ? 2.0 : (fraction <= 5.0 ? 5.0 : 10.0)));
        return niceFraction * Math.pow(10.0, exponent);
    }
}

