/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.gui.expressionbuilder;

import fr.proline.studio.gui.expressionbuilder.ExpressionBuilderPanel;
import fr.proline.studio.gui.expressionbuilder.ExpressionEntity;
import fr.proline.studio.utils.IconManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class ExpressionEntityTree
extends JTree {
    private ExpressionBuilderPanel m_builderPanel;

    protected ExpressionEntityTree(ExpressionBuilderPanel builderPanel, TreeType type) {
        super(new RootFunctionNode(type));
        this.m_builderPanel = builderPanel;
        this.setToggleClickCount(0);
        this.setCellRenderer(new EntityTreeRenderer());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getClickCount() == 1) {
                    TreePath path = ExpressionEntityTree.this.getSelectionPath();
                    if (path == null) {
                        return;
                    }
                    DataNode node = (DataNode)path.getLastPathComponent();
                    ExpressionEntityTree.this.action(node);
                    ExpressionEntityTree.this.clearSelection();
                }
            }
        });
    }

    public void action(DataNode node) {
        if (node.getType() == DataNode.DataNodeType.VALUE) {
            ExpressionEntity expressionEntity = ((EntityNode)node).getExpressionEntity();
            this.m_builderPanel.addEntityToExpression(expressionEntity);
        }
    }

    public void addEntity(ExpressionEntity entity) {
        EntityNode function = new EntityNode(entity);
        RootFunctionNode root = (RootFunctionNode)this.getModel().getRoot();
        root.add(function);
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        model.nodeStructureChanged(root);
    }

    public static class RootFunctionNode
    extends DataNode {
        private ImageIcon m_icon;
        private String m_name;

        public RootFunctionNode(TreeType type) {
            super(DataNode.DataNodeType.ROOT);
            switch (type) {
                case FUNCTIONS: {
                    this.m_icon = IconManager.getIcon(IconManager.IconType.FUNCTION);
                    this.m_name = "Functions";
                    break;
                }
                case VARIABLES: {
                    this.m_icon = IconManager.getIcon(IconManager.IconType.COLUMN);
                    this.m_name = "Variables";
                }
            }
        }

        @Override
        public ImageIcon getIcon() {
            return this.m_icon;
        }

        @Override
        public String toString() {
            return this.m_name;
        }
    }

    public static enum TreeType {
        FUNCTIONS,
        VARIABLES;

    }

    private class EntityTreeRenderer
    extends DefaultTreeCellRenderer {
        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            DataNode node = (DataNode)value;
            boolean visible = node.isVisible();
            if (!visible) {
                this.setForeground(Color.gray);
            } else {
                this.setForeground(Color.black);
            }
            ImageIcon icon = node.getIcon();
            if (icon != null) {
                this.setIcon(icon);
            }
            return this;
        }
    }

    public static abstract class DataNode
    extends DefaultMutableTreeNode {
        private DataNodeType m_type;

        public DataNode(DataNodeType type) {
            this.m_type = type;
        }

        public DataNodeType getType() {
            return this.m_type;
        }

        public boolean isVisible() {
            return true;
        }

        public abstract ImageIcon getIcon();

        public static enum DataNodeType {
            ROOT,
            VALUE;

        }
    }

    public static class EntityNode
    extends DataNode {
        private ExpressionEntity m_expressionEntity = null;

        public EntityNode(ExpressionEntity entity) {
            super(DataNode.DataNodeType.VALUE);
            this.m_expressionEntity = entity;
        }

        public ExpressionEntity getExpressionEntity() {
            return this.m_expressionEntity;
        }

        @Override
        public ImageIcon getIcon() {
            return IconManager.getIcon(IconManager.IconType.CONTROL_SMALL);
        }

        @Override
        public String toString() {
            return this.m_expressionEntity.getName();
        }
    }
}

