/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.search;

import fr.proline.studio.WindowManager;
import fr.proline.studio.filter.Filter;
import fr.proline.studio.filter.FilterMapInterface;
import fr.proline.studio.filter.FilterTableModelInterface;
import fr.proline.studio.progress.ProgressBarDialog;
import fr.proline.studio.progress.ProgressInterface;
import fr.proline.studio.search.AdvancedSearchFloatingPanel;
import fr.proline.studio.search.ApplySearchInterface;
import fr.proline.studio.search.SearchInterface;
import fr.proline.studio.utils.IconManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.JToggleButton;
import org.jdesktop.swingx.JXTable;

public class SearchToggleButton
extends JToggleButton {
    private ProgressInterface m_progressInterface = null;
    private JXTable m_table = null;
    private FilterTableModelInterface m_tableModelFilterInterface = null;
    SearchInterface m_searchInterface = null;
    FilterMapInterface m_filterMapInterface = null;
    private AdvancedSearchFloatingPanel m_searchPanel = null;

    public SearchToggleButton(ProgressInterface progressInterface, JXTable table, FilterTableModelInterface tableModelFilterInterface) {
        this.init(progressInterface, table, tableModelFilterInterface);
        this.initGraphic(new Search());
    }

    public SearchToggleButton(ApplySearchInterface applySearchInterface, ProgressInterface progressInterface, SearchInterface searchInterface, FilterMapInterface filterMapInterface) {
        this.m_progressInterface = progressInterface;
        this.m_searchInterface = searchInterface;
        this.m_filterMapInterface = filterMapInterface;
        this.initGraphic(applySearchInterface);
    }

    public final void init(ProgressInterface progressInterface, JXTable table, FilterTableModelInterface tableModelFilterInterface) {
        this.m_progressInterface = progressInterface;
        this.m_table = table;
        this.m_tableModelFilterInterface = tableModelFilterInterface;
    }

    private void initGraphic(ApplySearchInterface search) {
        this.m_searchPanel = new AdvancedSearchFloatingPanel(search);
        this.m_searchPanel.setToggleButton(this);
        this.setIcon(IconManager.getIcon(IconManager.IconType.SEARCH));
        this.setToolTipText("Search");
        this.setFocusPainted(false);
        this.addActionListener(new ActionListener(){
            boolean firstTime = true;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SearchToggleButton.this.m_progressInterface != null && !SearchToggleButton.this.m_progressInterface.isLoaded()) {
                    ProgressBarDialog dialog = ProgressBarDialog.getDialog(WindowManager.getDefault().getMainWindow(), SearchToggleButton.this.m_progressInterface, "Data loading", "Search is not available while data is loading. Please Wait.");
                    dialog.setLocation(SearchToggleButton.this.getLocationOnScreen().x + SearchToggleButton.this.getWidth() + 5, SearchToggleButton.this.getLocationOnScreen().y + SearchToggleButton.this.getHeight() + 5);
                    dialog.setVisible(true);
                    if (!dialog.isWaitingFinished()) {
                        SearchToggleButton.this.setSelected(false);
                        return;
                    }
                }
                if (SearchToggleButton.this.isSelected() && !SearchToggleButton.this.m_searchPanel.hasFilters()) {
                    LinkedHashMap<Integer, Filter> filtersMap = SearchToggleButton.this.m_filterMapInterface != null ? SearchToggleButton.this.m_filterMapInterface.getFilters() : SearchToggleButton.this.m_tableModelFilterInterface.getFilters();
                    Filter[] filters = new Filter[filtersMap.size()];
                    int index = 0;
                    for (Map.Entry<Integer, Filter> entry : filtersMap.entrySet()) {
                        filters[index++] = entry.getValue().cloneFilter4Search();
                    }
                    SearchToggleButton.this.m_searchPanel.setFilers(filters);
                }
                SearchToggleButton.this.m_searchPanel.setVisible(SearchToggleButton.this.isSelected());
                if (this.firstTime) {
                    this.firstTime = false;
                    SearchToggleButton.this.m_searchPanel.setLocation(SearchToggleButton.this.getX() + SearchToggleButton.this.getWidth() + 5, SearchToggleButton.this.getY() + 5);
                }
            }
        });
    }

    public AdvancedSearchFloatingPanel getSearchPanel() {
        return this.m_searchPanel;
    }

    private class Search
    implements ApplySearchInterface {
        private Search() {
        }

        @Override
        public void doSearch(Filter f, boolean firstSearch) {
            int modelRowIndex = SearchToggleButton.this.m_tableModelFilterInterface.search(SearchToggleButton.this.m_table, f, firstSearch);
            if (modelRowIndex == -1) {
                JOptionPane.showMessageDialog(WindowManager.getDefault().getMainWindow(), "No result found", "Search", 1);
                return;
            }
            int rowView = SearchToggleButton.this.m_table.convertRowIndexToView(modelRowIndex);
            SearchToggleButton.this.m_table.setRowSelectionInterval(rowView, rowView);
            SearchToggleButton.this.m_table.scrollRowToVisible(rowView);
        }
    }
}

