/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.utils;

import java.awt.Color;

public class CyclicColorPalette {
    public static final Color[] DEFAULT_BASE_PALETTE = new Color[]{new Color(231, 197, 31), new Color(231, 113, 58), new Color(169, 35, 59), new Color(106, 44, 95), new Color(104, 71, 160), new Color(98, 126, 206), new Color(82, 120, 123), new Color(63, 121, 58), new Color(109, 153, 5)};
    public static final Color[] GROUP4_PALETTE = new Color[]{new Color(229, 115, 115), new Color(129, 212, 250), new Color(255, 213, 79), new Color(76, 175, 80), new Color(183, 28, 28), new Color(3, 155, 229), new Color(255, 179, 0), new Color(27, 94, 32), new Color(255, 23, 68), new Color(1, 87, 155), new Color(255, 234, 0), new Color(0, 200, 83)};
    public static final Color GRAY_BACKGROUND = new Color(239, 236, 234);
    public static final Color GRAY_BACKGROUND_DARKER = new Color(229, 226, 224);
    public static final Color GRAY_TEXT_LIGHT = new Color(142, 136, 131);
    public static final Color GRAY_TEXT_DARK = new Color(99, 95, 93);
    public static final Color GRAY_GRID = new Color(229, 226, 224);
    public static final Color GRAY_GRID_LOG = new Color(244, 240, 238);
    public static final Color BLUE_SELECTION_ZONE = new Color(0.2f, 0.2f, 1.0f, 0.5f);
    public static final Color GRAY_DARK = new Color(47, 43, 42);

    public static Color getColor(int colorIndex) {
        return CyclicColorPalette.getColor(colorIndex, DEFAULT_BASE_PALETTE);
    }

    public static Color getColorBlue(int colorIndex) {
        int q = colorIndex % GROUP4_PALETTE.length;
        return GROUP4_PALETTE[q];
    }

    public static Color getColor(int colorIndex, Color[] palette) {
        int paletteSize = palette.length * 3;
        if ((colorIndex %= paletteSize) < palette.length) {
            return palette[colorIndex];
        }
        int q = colorIndex / palette.length;
        int sign = q % 2 == 0 ? 1 : -1;
        float[] hsb = Color.RGBtoHSB(palette[colorIndex - q * palette.length].getRed(), palette[colorIndex - q * palette.length].getGreen(), palette[colorIndex - q * palette.length].getBlue(), null);
        float brightness = hsb[2] + (float)sign * 0.17f;
        brightness = Math.max(0.0f, brightness);
        brightness = Math.min(brightness, 1.0f);
        return new Color(Color.HSBtoRGB(hsb[0], hsb[1], brightness));
    }

    public static Color[] getPalette() {
        int paletteSize = DEFAULT_BASE_PALETTE.length * 3;
        Color[] palette = new Color[paletteSize];
        for (int i = 0; i < paletteSize; ++i) {
            palette[i] = CyclicColorPalette.getColor(i);
        }
        return palette;
    }

    public static Color getDarkerColor(Color color, double fraction) {
        int red = (int)Math.round((double)color.getRed() * (1.0 - fraction));
        int green = (int)Math.round((double)color.getGreen() * (1.0 - fraction));
        int blue = (int)Math.round((double)color.getBlue() * (1.0 - fraction));
        if (red < 0) {
            red = 0;
        } else if (red > 255) {
            red = 255;
        }
        if (green < 0) {
            green = 0;
        } else if (green > 255) {
            green = 255;
        }
        if (blue < 0) {
            blue = 0;
        } else if (blue > 255) {
            blue = 255;
        }
        int alpha = color.getAlpha();
        return new Color(red, green, blue, alpha);
    }

    public static Color getColor(int colorIndex, int alpha) {
        Color c = CyclicColorPalette.getColor(colorIndex);
        return new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha);
    }

    public static Color getColor(Color color, int alpha) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
    }

    public static String getHTMLColor(int colorIndex) {
        Color c = CyclicColorPalette.getColor(colorIndex);
        return CyclicColorPalette.getHTMLColor(c);
    }

    public static String getHTMLColor(Color color) {
        return String.format("%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
    }

    public static String getHTMLColoredBlock(Color color) {
        return "<font color='" + CyclicColorPalette.getHTMLColor(color) + "'>&#x25A0;&nbsp;</font>";
    }
}

