/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.db;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;

public class DerbyUtil {
    private static boolean connectionActive = false;
    private static final HashMap<String, ArrayList<String>> activeConnections = new HashMap();

    public static void disableDerbyLog() {
        System.setProperty("derby.stream.error.method", "com.compomics.util.db.DerbyUtil.disabledDerbyLog");
    }

    public static OutputStream disabledDerbyLog() {
        return new OutputStream(){

            @Override
            public void write(int b) throws IOException {
            }
        };
    }

    public static void closeConnection() {
        try {
            DriverManager.getConnection("jdbc:derby:;shutdown=true;deregister=false");
        }
        catch (SQLException se) {
            if (!se.getSQLState().equals("XJ015")) {
                se.printStackTrace();
            }
        }
        finally {
            System.gc();
            connectionActive = false;
        }
    }

    public static boolean isConnectionActive() {
        return connectionActive;
    }

    public static void setConnectionActive(boolean connectionActive) {
        DerbyUtil.connectionActive = connectionActive;
    }

    public static void addActiveConnection(String id, String path) {
        ArrayList<String> paths = activeConnections.get(id);
        if (paths == null) {
            paths = new ArrayList();
            activeConnections.put(id, paths);
        }
        paths.add(path);
    }

    public static ArrayList<String> getActiveConnectionsPaths(String id) {
        return activeConnections.get(id);
    }

    public static boolean isActiveConnection(String id, String path) {
        ArrayList<String> paths = activeConnections.get(id);
        if (paths != null) {
            return paths.contains(path);
        }
        return false;
    }

    public static boolean isActiveConnection(String path) {
        for (ArrayList<String> paths : activeConnections.values()) {
            if (!paths.contains(path)) continue;
            return true;
        }
        return false;
    }

    public static void removeActiveConnection(String id, String path) {
        ArrayList<String> paths = activeConnections.get(id);
        if (paths != null) {
            paths.remove(path);
        }
    }
}

