/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology;

import com.compomics.util.experiment.biology.AminoAcidPattern;
import com.compomics.util.experiment.biology.AminoAcidSequence;
import com.compomics.util.experiment.biology.Atom;
import com.compomics.util.experiment.biology.AtomChain;
import com.compomics.util.experiment.biology.AtomImpl;
import com.compomics.util.experiment.biology.NeutralLoss;
import com.compomics.util.experiment.biology.PTM;
import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.biology.ions.ReporterIon;
import com.compomics.util.experiment.identification.amino_acid_tags.Tag;
import com.compomics.util.experiment.identification.amino_acid_tags.TagComponent;
import com.compomics.util.experiment.identification.identification_parameters.PtmSettings;
import com.compomics.util.experiment.identification.identification_parameters.SearchParameters;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.io.json.JsonMarshaller;
import com.compomics.util.preferences.SequenceMatchingPreferences;
import com.compomics.util.pride.CvTerm;
import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;

public class PTMFactory
implements Serializable {
    private static PTMFactory instance = null;
    private static String SERIALIZATION_FILE_FOLDER = System.getProperty("user.home") + "/.compomics";
    private static String SERIALIZATION_FILE_NAME = "ptmFactory-4.12.1.json";
    private HashMap<String, PTM> ptmMap = new HashMap();
    private ArrayList<String> defaultMods = new ArrayList();
    private ArrayList<String> userMods = new ArrayList();
    private HashMap<String, Color> userColors = new HashMap();
    public static final PTM unknownPTM = new PTM(0, "unknown", "*", null, null, new AminoAcidPattern());
    public static final String SINGLE_AA_SUFFIX = "|single_aa";
    public boolean defaultModsSorted = false;
    public boolean usersModsSorted = false;

    private PTMFactory() {
        this.setDefaultModifications();
    }

    public static PTMFactory getInstance() {
        if (instance == null) {
            try {
                File savedFile = new File(SERIALIZATION_FILE_FOLDER, SERIALIZATION_FILE_NAME);
                instance = PTMFactory.loadFromFile(savedFile);
                instance.checkUserModifications();
            }
            catch (Exception e) {
                instance = new PTMFactory();
            }
        }
        return instance;
    }

    public static PTMFactory loadFromFile(File file) throws IOException {
        JsonMarshaller jsonMarshaller = new JsonMarshaller();
        PTMFactory result = (PTMFactory)jsonMarshaller.fromJson(PTMFactory.class, file);
        return result;
    }

    public static void saveToFile(PTMFactory ptmFactory, File file) throws IOException {
        JsonMarshaller jsonMarshaller = new JsonMarshaller();
        jsonMarshaller.saveObjectToJson(ptmFactory, file);
    }

    private void checkUserModifications() {
        for (String tempUserMod : this.getUserModifications()) {
            PTM ptm = this.getPTM(tempUserMod);
            if (!ptm.getNeutralLosses().isEmpty()) {
                for (NeutralLoss neutralLoss : ptm.getNeutralLosses()) {
                    if (NeutralLoss.getNeutralLoss(neutralLoss.name) != null) continue;
                    NeutralLoss.addNeutralLoss(neutralLoss);
                }
            }
            if (ptm.getReporterIons().isEmpty()) continue;
            for (ReporterIon reporterIon : ptm.getReporterIons()) {
                if (ReporterIon.getReporterIon(reporterIon.getName()) != null) continue;
                ReporterIon.addReporterIon(reporterIon);
            }
        }
    }

    public void clearFactory() {
        instance = new PTMFactory();
    }

    public void reloadFactory() {
        instance = null;
    }

    public void saveFactory() throws IOException {
        File factoryFile = new File(SERIALIZATION_FILE_FOLDER, SERIALIZATION_FILE_NAME);
        if (!factoryFile.getParentFile().exists()) {
            factoryFile.getParentFile().mkdir();
        }
        PTMFactory.saveToFile(instance, factoryFile);
    }

    public static PTM getSingleAAPTM(PTM modification) {
        if (!modification.isStandardSearch()) {
            return new PTM(modification.getType(), modification.getShortName(), modification.getName() + SINGLE_AA_SUFFIX, modification.getAtomChainAdded(), modification.getAtomChainRemoved(), modification.getPattern().getStandardSearchPattern());
        }
        return modification;
    }

    public PTM getSingleAAPTM(String modificationName) {
        PTM modification = this.getPTM(modificationName);
        return PTMFactory.getSingleAAPTM(modification);
    }

    public void addUserPTM(PTM ptm) {
        String modName = ptm.getName();
        this.ptmMap.put(modName, ptm);
        if (!this.userMods.contains(modName)) {
            this.userMods.add(modName);
        } else {
            this.userMods.set(this.userMods.indexOf(modName), modName);
        }
        this.usersModsSorted = false;
        if (!ptm.getNeutralLosses().isEmpty()) {
            for (NeutralLoss neutralLoss : ptm.getNeutralLosses()) {
                if (NeutralLoss.getNeutralLoss(neutralLoss.name) != null) continue;
                NeutralLoss.addNeutralLoss(neutralLoss);
            }
        }
        if (!ptm.getReporterIons().isEmpty()) {
            for (ReporterIon reporterIon : ptm.getReporterIons()) {
                if (ReporterIon.getReporterIon(reporterIon.getName()) != null) continue;
                ReporterIon.addReporterIon(reporterIon);
            }
        }
    }

    public void removeUserPtm(String ptmName) {
        if (this.defaultMods.contains(ptmName)) {
            throw new IllegalArgumentException("Impossible to remove default modification " + ptmName);
        }
        this.ptmMap.remove(ptmName);
        this.userMods.remove(ptmName);
    }

    public PTM getPTM(String name) {
        PTM ptm = this.ptmMap.get(name);
        if (ptm != null) {
            return ptm;
        }
        return unknownPTM;
    }

    public boolean containsPTM(String name) {
        return this.ptmMap.containsKey(name) || name.equals(unknownPTM.getName());
    }

    public ArrayList<String> getDefaultModifications() {
        return this.defaultMods;
    }

    public ArrayList<String> getDefaultModificationsOrdered() {
        if (!this.defaultModsSorted) {
            Collections.sort(this.defaultMods);
            this.defaultModsSorted = true;
        }
        return this.defaultMods;
    }

    public ArrayList<String> getUserModifications() {
        return this.userMods;
    }

    public ArrayList<String> getUserModificationsOrdered() {
        if (!this.usersModsSorted) {
            Collections.sort(this.userMods);
            this.usersModsSorted = true;
        }
        return this.userMods;
    }

    public ArrayList<String> getPTMs() {
        return new ArrayList<String>(this.ptmMap.keySet());
    }

    public boolean isUserDefined(String ptmName) {
        return !this.defaultMods.contains(ptmName);
    }

    public ArrayList<String> loadBackedUpModifications(SearchParameters searchParameters, boolean overwrite) {
        PtmSettings modificationProfile = searchParameters.getPtmSettings();
        ArrayList<String> toCheck = new ArrayList<String>();
        for (String modification : modificationProfile.getBackedUpPtms()) {
            if (this.containsPTM(modification)) {
                PTM newPTM;
                PTM oldPTM = this.getPTM(modification);
                if (oldPTM.isSameAs(newPTM = modificationProfile.getPtm(modification))) continue;
                toCheck.add(modification);
                if (!overwrite) continue;
                PTM ptm = modificationProfile.getPtm(modification);
                this.ptmMap.put(modification, ptm);
                for (NeutralLoss neutralLoss : ptm.getNeutralLosses()) {
                    NeutralLoss.addNeutralLoss(neutralLoss);
                }
                continue;
            }
            PTM ptm = modificationProfile.getPtm(modification);
            this.addUserPTM(ptm);
            for (NeutralLoss neutralLoss : ptm.getNeutralLosses()) {
                NeutralLoss.addNeutralLoss(neutralLoss);
            }
        }
        return toCheck;
    }

    public HashMap<Integer, ArrayList<String>> getExpectedPTMs(PtmSettings modificationProfile, Peptide peptide, double modificationMass, double ptmMassTolerance, SequenceMatchingPreferences sequenceMatchingPreferences, SequenceMatchingPreferences ptmSequenceMatchingPreferences) throws IOException, IllegalArgumentException, InterruptedException, FileNotFoundException, ClassNotFoundException, FileNotFoundException, SQLException {
        HashMap<Integer, ArrayList<String>> mapping = new HashMap<Integer, ArrayList<String>>();
        for (String ptmName : modificationProfile.getAllNotFixedModifications()) {
            PTM ptm = this.getPTM(ptmName);
            if (!(Math.abs(ptm.getMass() - modificationMass) <= ptmMassTolerance)) continue;
            for (int site : peptide.getPotentialModificationSites(ptm, sequenceMatchingPreferences, ptmSequenceMatchingPreferences)) {
                ArrayList<String> modifications = mapping.get(site);
                if (modifications == null) {
                    modifications = new ArrayList();
                    mapping.put(site, modifications);
                }
                modifications.add(ptmName);
            }
        }
        return mapping;
    }

    public HashMap<Integer, ArrayList<String>> getExpectedPTMs(PtmSettings modificationProfile, Peptide peptide, String ptmName, Double ptmMassTolerance, SequenceMatchingPreferences sequenceMatchingPreferences, SequenceMatchingPreferences ptmSequenceMatchingPreferences) throws IOException, IllegalArgumentException, InterruptedException, FileNotFoundException, ClassNotFoundException, SQLException {
        PTM ptm = this.getPTM(ptmName);
        return this.getExpectedPTMs(modificationProfile, peptide, ptm.getMass(), (double)ptmMassTolerance, sequenceMatchingPreferences, ptmSequenceMatchingPreferences);
    }

    public void checkFixedModifications(PtmSettings modificationProfile, Peptide peptide, SequenceMatchingPreferences sequenceMatchingPreferences, SequenceMatchingPreferences ptmSequenceMatchingPreferences) throws IOException, IllegalArgumentException, InterruptedException, FileNotFoundException, ClassNotFoundException, SQLException {
        if (peptide.isModified()) {
            ArrayList<ModificationMatch> toRemove = new ArrayList<ModificationMatch>(peptide.getNModifications());
            for (ModificationMatch modMatch : peptide.getModificationMatches()) {
                if (modMatch.isVariable()) continue;
                toRemove.add(modMatch);
            }
            for (ModificationMatch modMatch : toRemove) {
                peptide.getModificationMatches().remove(modMatch);
            }
        }
        HashMap<Integer, Double> taken = new HashMap<Integer, Double>(peptide.getNModifications());
        block13: for (String fixedModification : modificationProfile.getFixedModifications()) {
            PTM ptm = this.getPTM(fixedModification);
            switch (ptm.getType()) {
                case 0: {
                    for (int pos : peptide.getPotentialModificationSites(ptm, sequenceMatchingPreferences, ptmSequenceMatchingPreferences)) {
                        if (!taken.containsKey(pos)) {
                            taken.put(pos, ptm.getMass());
                            peptide.addModificationMatch(new ModificationMatch(fixedModification, false, pos));
                            continue;
                        }
                        if (((Double)taken.get(pos)).doubleValue() == ptm.getMass()) continue;
                        throw new IllegalArgumentException("Attempting to put two fixed modifications of different masses (" + taken.get(pos) + ", " + ptm.getMass() + ") at position " + pos + " in peptide " + peptide.getSequence() + ".");
                    }
                    continue block13;
                }
                case 3: {
                    if (peptide.isCterm(sequenceMatchingPreferences).isEmpty()) break;
                    peptide.addModificationMatch(new ModificationMatch(fixedModification, false, peptide.getSequence().length()));
                    break;
                }
                case 1: {
                    if (peptide.isNterm(sequenceMatchingPreferences).isEmpty()) break;
                    peptide.addModificationMatch(new ModificationMatch(fixedModification, false, 1));
                    break;
                }
                case 4: {
                    String sequence = peptide.getSequence();
                    if (!peptide.getPotentialModificationSites(ptm, sequenceMatchingPreferences, ptmSequenceMatchingPreferences).contains(sequence.length())) break;
                    peptide.addModificationMatch(new ModificationMatch(fixedModification, false, peptide.getSequence().length()));
                    break;
                }
                case 2: {
                    if (!peptide.getPotentialModificationSites(ptm, sequenceMatchingPreferences, ptmSequenceMatchingPreferences).contains(1)) break;
                    peptide.addModificationMatch(new ModificationMatch(fixedModification, false, 1));
                    break;
                }
                case 7: {
                    peptide.addModificationMatch(new ModificationMatch(fixedModification, false, peptide.getSequence().length()));
                    break;
                }
                case 5: {
                    peptide.addModificationMatch(new ModificationMatch(fixedModification, false, 1));
                    break;
                }
                case 8: {
                    String sequence = peptide.getSequence();
                    if (!peptide.getPotentialModificationSites(ptm, sequenceMatchingPreferences, ptmSequenceMatchingPreferences).contains(sequence.length())) break;
                    peptide.addModificationMatch(new ModificationMatch(fixedModification, false, sequence.length()));
                    break;
                }
                case 6: {
                    if (!peptide.getPotentialModificationSites(ptm, sequenceMatchingPreferences, ptmSequenceMatchingPreferences).contains(1)) break;
                    peptide.addModificationMatch(new ModificationMatch(fixedModification, false, 1));
                    break;
                }
            }
        }
    }

    public void checkFixedModifications(PtmSettings modificationProfile, Tag tag, SequenceMatchingPreferences sequenceMatchingPreferences) throws IOException, IllegalArgumentException, InterruptedException, FileNotFoundException, ClassNotFoundException, SQLException {
        int indexInTag = 0;
        int componentNumber = 0;
        for (TagComponent tagComponent : tag.getContent()) {
            PTM ptm;
            int aa;
            Object modificationMatches;
            ArrayList<ModificationMatch> toRemove;
            ++componentNumber;
            if (tagComponent instanceof AminoAcidPattern) {
                AminoAcidPattern aminoAcidPattern = (AminoAcidPattern)tagComponent;
                toRemove = new ArrayList<ModificationMatch>();
                for (int aa2 : aminoAcidPattern.getModificationIndexes()) {
                    modificationMatches = aminoAcidPattern.getModificationsAt(aa2);
                    Iterator<ModificationMatch> iterator = ((ArrayList)modificationMatches).iterator();
                    while (iterator.hasNext()) {
                        ModificationMatch modMatch2 = iterator.next();
                        if (modMatch2.isVariable()) continue;
                        toRemove.add(modMatch2);
                    }
                    for (ModificationMatch modMatch : toRemove) {
                        aminoAcidPattern.removeModificationMatch(aa2, modMatch);
                    }
                }
                for (aa = 1; aa <= aminoAcidPattern.length(); ++aa) {
                    ++indexInTag;
                    Double modificationMass = null;
                    for (String string : modificationProfile.getFixedModifications()) {
                        ptm = this.getPTM(string);
                        if (ptm.getType() == 0) {
                            if (!tag.getPotentialModificationSites(ptm, sequenceMatchingPreferences).contains(indexInTag)) continue;
                            if (modificationMass == null) {
                                modificationMass = ptm.getMass();
                                aminoAcidPattern.addModificationMatch(aa, new ModificationMatch(string, false, aa));
                                continue;
                            }
                            if (modificationMass.doubleValue() == ptm.getMass()) continue;
                            throw new IllegalArgumentException("Attempting to put two fixed modifications of different masses (" + modificationMass + ", " + ptm.getMass() + ") at position " + aa + " in pattern " + aminoAcidPattern.asSequence() + " of tag " + tag.asSequence() + ".");
                        }
                        if (ptm.getType() == 7 && componentNumber == tag.getContent().size() && aa == aminoAcidPattern.length()) {
                            aminoAcidPattern.addModificationMatch(aa, new ModificationMatch(string, false, aa));
                            continue;
                        }
                        if (ptm.getType() == 5 && componentNumber == 1 && aa == 1) {
                            aminoAcidPattern.addModificationMatch(1, new ModificationMatch(string, false, 1));
                            continue;
                        }
                        if (ptm.getType() == 8 && componentNumber == tag.getContent().size() && aa == aminoAcidPattern.length()) {
                            if (!tag.getPotentialModificationSites(ptm, sequenceMatchingPreferences).contains(indexInTag)) continue;
                            aminoAcidPattern.addModificationMatch(aa, new ModificationMatch(string, false, aa));
                            continue;
                        }
                        if (ptm.getType() != 6 || componentNumber != 1 || aa != 1 || !tag.getPotentialModificationSites(ptm, sequenceMatchingPreferences).contains(1)) continue;
                        aminoAcidPattern.addModificationMatch(1, new ModificationMatch(string, false, 1));
                    }
                }
                continue;
            }
            if (tagComponent instanceof AminoAcidSequence) {
                AminoAcidSequence aminoAcidSequence = (AminoAcidSequence)tagComponent;
                toRemove = new ArrayList();
                for (int aa3 : aminoAcidSequence.getModificationIndexes()) {
                    modificationMatches = aminoAcidSequence.getModificationsAt(aa3);
                    Iterator iterator = ((ArrayList)modificationMatches).iterator();
                    while (iterator.hasNext()) {
                        ModificationMatch modMatch;
                        modMatch = (ModificationMatch)iterator.next();
                        if (modMatch.isVariable()) continue;
                        toRemove.add(modMatch);
                    }
                    for (ModificationMatch modMatch : toRemove) {
                        aminoAcidSequence.removeModificationMatch(aa3, modMatch);
                    }
                }
                for (aa = 1; aa <= aminoAcidSequence.length(); ++aa) {
                    ++indexInTag;
                    Double modificationMass = null;
                    for (String string : modificationProfile.getFixedModifications()) {
                        ptm = this.getPTM(string);
                        if (ptm.getType() == 0) {
                            if (!tag.getPotentialModificationSites(ptm, sequenceMatchingPreferences).contains(indexInTag)) continue;
                            if (modificationMass == null) {
                                modificationMass = ptm.getMass();
                                aminoAcidSequence.addModificationMatch(aa, new ModificationMatch(string, false, aa));
                                continue;
                            }
                            if (modificationMass.doubleValue() == ptm.getMass()) continue;
                            throw new IllegalArgumentException("Attempting to put two fixed modifications of different masses (" + modificationMass + ", " + ptm.getMass() + ") at position " + aa + " in pattern " + aminoAcidSequence.asSequence() + " of tag " + tag.asSequence() + ".");
                        }
                        if (ptm.getType() == 7 && componentNumber == tag.getContent().size() && aa == aminoAcidSequence.length()) {
                            aminoAcidSequence.addModificationMatch(aa, new ModificationMatch(string, false, aa));
                            continue;
                        }
                        if (ptm.getType() == 5 && componentNumber == 1 && aa == 1) {
                            aminoAcidSequence.addModificationMatch(1, new ModificationMatch(string, false, 1));
                            continue;
                        }
                        if (ptm.getType() == 8 && componentNumber == tag.getContent().size() && aa == aminoAcidSequence.length()) {
                            if (!tag.getPotentialModificationSites(ptm, sequenceMatchingPreferences).contains(indexInTag)) continue;
                            aminoAcidSequence.addModificationMatch(aa, new ModificationMatch(string, false, aa));
                            continue;
                        }
                        if (ptm.getType() != 6 || componentNumber != 1 || aa != 1 || !tag.getPotentialModificationSites(ptm, sequenceMatchingPreferences).contains(1)) continue;
                        aminoAcidSequence.addModificationMatch(1, new ModificationMatch(string, false, 1));
                    }
                }
                continue;
            }
            ++indexInTag;
        }
    }

    public Color getColor(String modification) {
        if (!this.userColors.containsKey(modification)) {
            this.setColor(modification, PTMFactory.getDefaultColor(modification));
        }
        return this.userColors.get(modification);
    }

    public void setColor(String expectedModification, Color color) {
        this.userColors.put(expectedModification, color);
    }

    public static Color getDefaultColor(String modification) {
        if (modification.contains("no modification")) {
            return Color.LIGHT_GRAY;
        }
        if (modification.toLowerCase().contains("phospho")) {
            return Color.RED;
        }
        if (modification.toLowerCase().contains("pyro")) {
            return new Color(255, 102, 51);
        }
        if (modification.toLowerCase().contains("ox")) {
            return Color.BLUE;
        }
        if (modification.toLowerCase().contains("itraq")) {
            return Color.ORANGE;
        }
        if (modification.toLowerCase().contains("tmt")) {
            return Color.ORANGE;
        }
        if (modification.toLowerCase().contains("carbamido")) {
            return Color.LIGHT_GRAY;
        }
        if (modification.toLowerCase().contains("ace")) {
            return new Color(153, 153, 0);
        }
        if (modification.toLowerCase().contains("glyco")) {
            return Color.MAGENTA;
        }
        float r = (float)Math.random();
        float g = (float)Math.random();
        float b = (float)Math.random();
        return new Color(r, g, b);
    }

    public String convertPridePtm(String pridePtmName, PtmSettings modProfile, ArrayList<String> unknownPtms, boolean isFixed) {
        String prideParametersReport = "";
        if (pridePtmName.equalsIgnoreCase("iTRAQ4plex") || pridePtmName.equalsIgnoreCase("iTRAQ4plex reporter+balance reagent N-acylated residue") || pridePtmName.equalsIgnoreCase("iTRAQ4plex reporter+balance reagent acylated residue") || pridePtmName.equalsIgnoreCase("iTRAQ4plex-114 reporter+balance reagent N6-acylated lysine") || pridePtmName.equalsIgnoreCase("iTRAQ4plex-114 reporter+balance reagent O4&apos;-acylated tyrosine") || pridePtmName.equalsIgnoreCase("iTRAQ4plex-114 reporter+balance reagent acylated N-terminal") || pridePtmName.equalsIgnoreCase("iTRAQ4plex-114 reporter+balance reagent acylated residue") || pridePtmName.equalsIgnoreCase("iTRAQ4plex-116 reporter+balance reagent acylated residue") || pridePtmName.equalsIgnoreCase("iTRAQ4plex-117 reporter+balance reagent N6-acylated lysine")) {
            if (!modProfile.contains("iTRAQ 4-plex of K")) {
                modProfile.addFixedModification(this.getPTM("iTRAQ 4-plex of K"));
                prideParametersReport = prideParametersReport + "<br>iTRAQ 4-plex of K (assumed fixed)";
            }
            if (!modProfile.contains("iTRAQ 4-plex of N-term")) {
                modProfile.addFixedModification(this.getPTM("iTRAQ 4-plex of N-term"));
                prideParametersReport = prideParametersReport + "<br>iTRAQ 4-plex of N-term (assumed fixed)";
            }
            if (!modProfile.contains("iTRAQ 4-plex of Y")) {
                modProfile.addVariableModification(this.getPTM("iTRAQ 4-plex of Y"));
                prideParametersReport = prideParametersReport + "<br>iTRAQ 4-plex of Y (assumed variable)";
            }
        } else if (pridePtmName.equalsIgnoreCase("iTRAQ8plex") || pridePtmName.equalsIgnoreCase("iTRAQ8plex reporter+balance reagent acylated residue") || pridePtmName.equalsIgnoreCase("iTRAQ8plex-113 reporter+balance reagent acylated residue") || pridePtmName.equalsIgnoreCase("iTRAQ8plex-114 reporter+balance reagent N6-acylated lysine") || pridePtmName.equalsIgnoreCase("iTRAQ8plex-114 reporter+balance reagent O4&apos;-acylated tyrosine") || pridePtmName.equalsIgnoreCase("iTRAQ8plex-114 reporter+balance reagent acylated N-terminal") || pridePtmName.equalsIgnoreCase("iTRAQ8plex-115 reporter+balance reagent acylated residue") || pridePtmName.equalsIgnoreCase("iTRAQ8plex-116 reporter+balance reagent acylated residue") || pridePtmName.equalsIgnoreCase("iTRAQ8plex:13C(6)15N(2)")) {
            if (!modProfile.contains("iTRAQ 8-plex of K")) {
                modProfile.addFixedModification(this.getPTM("iTRAQ 8-plex of K"));
                prideParametersReport = prideParametersReport + "<br>iTRAQ 8-plex of K (assumed fixed)";
            }
            if (!modProfile.contains("iTRAQ 8-plex of N-term")) {
                modProfile.addFixedModification(this.getPTM("iTRAQ 8-plex of N-term"));
                prideParametersReport = prideParametersReport + "<br>iTRAQ 8-plex of N-term (assumed fixed)";
            }
            if (!modProfile.contains("iTRAQ 8-plex of Y")) {
                modProfile.addVariableModification(this.getPTM("iTRAQ 8-plex of Y"));
                prideParametersReport = prideParametersReport + "<br>iTRAQ 8-plex of Y (assumed variable)";
            }
        } else if (pridePtmName.equalsIgnoreCase("TMT2plex") || pridePtmName.equalsIgnoreCase("TMTduplex")) {
            if (!modProfile.contains("TMT 2-plex of K")) {
                modProfile.addFixedModification(this.getPTM("TMT 2-plex of K"));
                prideParametersReport = prideParametersReport + "<br>TMT 2-plex of K (assumed fixed)";
            }
            if (!modProfile.contains("TMT 2-plex of N-term")) {
                modProfile.addFixedModification(this.getPTM("TMT 2-plex of N-term"));
                prideParametersReport = prideParametersReport + "<br>TMT 2-plex of N-term (assumed fixed)";
            }
        } else if (pridePtmName.equalsIgnoreCase("TMT6plex") || pridePtmName.equalsIgnoreCase("TMT6plex-126 reporter+balance reagent acylated residue") || pridePtmName.equalsIgnoreCase("TMT6plex-131 reporter+balance reagent N6-acylated lysine")) {
            if (!modProfile.contains("TMT 6-plex of K")) {
                modProfile.addFixedModification(this.getPTM("TMT 6-plex of K"));
                prideParametersReport = prideParametersReport + "<br>TMT 6-plex of K (assumed fixed)";
            }
            if (!modProfile.contains("TMT 6-plex of N-term")) {
                modProfile.addFixedModification(this.getPTM("TMT 6-plex of N-term"));
                prideParametersReport = prideParametersReport + "<br>TMT 6-plex of N-term (assumed fixed)";
            }
        } else if (pridePtmName.equalsIgnoreCase("TMT10plex") || pridePtmName.equalsIgnoreCase("TMT10plex-126 reporter+balance reagent acylated residue") || pridePtmName.equalsIgnoreCase("TMT10plex-131 reporter+balance reagent N6-acylated lysine")) {
            if (!modProfile.contains("TMT 10-plex of K")) {
                modProfile.addFixedModification(this.getPTM("TMT 10-plex of K"));
                prideParametersReport = prideParametersReport + "<br>TMT 10-plex of K (assumed fixed)";
            }
            if (!modProfile.contains("TMT 10-plex of N-term")) {
                modProfile.addFixedModification(this.getPTM("TMT 10-plex of N-term"));
                prideParametersReport = prideParametersReport + "<br>TMT 10-plex of N-term (assumed fixed)";
            }
        } else if (pridePtmName.equalsIgnoreCase("Phosphorylation") || pridePtmName.equalsIgnoreCase("L-aspartic 4-phosphoric anhydride") || pridePtmName.equalsIgnoreCase("O-phosphorylated residue") || pridePtmName.equalsIgnoreCase("Phospho") || pridePtmName.equalsIgnoreCase("phosphorylated residue")) {
            if (!modProfile.contains("Phosphorylation of S")) {
                modProfile.addVariableModification(this.getPTM("Phosphorylation of S"));
                prideParametersReport = prideParametersReport + "<br>Phosphorylation of S (assumed variable)";
            }
            if (!modProfile.contains("Phosphorylation of T")) {
                modProfile.addVariableModification(this.getPTM("Phosphorylation of T"));
                prideParametersReport = prideParametersReport + "<br>Phosphorylation of T (assumed variable)";
            }
            if (!modProfile.contains("Phosphorylation of Y")) {
                modProfile.addVariableModification(this.getPTM("Phosphorylation of Y"));
                prideParametersReport = prideParametersReport + "<br>Phosphorylation of Y (assumed variable)";
            }
        } else if (pridePtmName.equalsIgnoreCase("Palmitoylation")) {
            if (!modProfile.contains("Palmitoylation of C")) {
                modProfile.addVariableModification(this.getPTM("Palmitoylation of C"));
                prideParametersReport = prideParametersReport + "<br>Palmitoylation of C (assumed variable)";
            }
            if (!modProfile.contains("Palmitoylation of K")) {
                modProfile.addVariableModification(this.getPTM("Palmitoylation of K"));
                prideParametersReport = prideParametersReport + "<br>Palmitoylation of K (assumed variable)";
            }
            if (!modProfile.contains("Palmitoylation of S")) {
                modProfile.addVariableModification(this.getPTM("Palmitoylation of S"));
                prideParametersReport = prideParametersReport + "<br>Palmitoylation of S (assumed variable)";
            }
            if (!modProfile.contains("Palmitoylation of T")) {
                modProfile.addVariableModification(this.getPTM("Palmitoylation of T"));
                prideParametersReport = prideParametersReport + "<br>Palmitoylation of T (assumed variable)";
            }
            if (!modProfile.contains("Palmitoylation of protein N-term")) {
                modProfile.addVariableModification(this.getPTM("Palmitoylation of protein N-term"));
                prideParametersReport = prideParametersReport + "<br>Palmitoylation of protein N-term (assumed variable)";
            }
        } else if (pridePtmName.equalsIgnoreCase("Formylation")) {
            if (!modProfile.contains("Formylation of K")) {
                modProfile.addVariableModification(this.getPTM("Formylation of K"));
                prideParametersReport = prideParametersReport + "<br>Formylation of K (assumed variable)";
            }
            if (!modProfile.contains("Formylation of S")) {
                modProfile.addVariableModification(this.getPTM("Formylation of S"));
                prideParametersReport = prideParametersReport + "<br>Formylation of S (assumed variable)";
            }
            if (!modProfile.contains("Formylation of T")) {
                modProfile.addVariableModification(this.getPTM("Formylation of T"));
                prideParametersReport = prideParametersReport + "<br>Formylation of T (assumed variable)";
            }
            if (!modProfile.contains("Formylation of peptide N-term")) {
                modProfile.addVariableModification(this.getPTM("Formylation of peptide N-term"));
                prideParametersReport = prideParametersReport + "<br>Formylation of peptide N-term (assumed variable)";
            }
        } else if (pridePtmName.equalsIgnoreCase("Carbamylation") || pridePtmName.equalsIgnoreCase("carbamoylated residue")) {
            if (!modProfile.contains("Carbamylation of K")) {
                modProfile.addVariableModification(this.getPTM("Carbamylation of K"));
                prideParametersReport = prideParametersReport + "<br>Carbamylation of K (assumed variable)";
            }
            if (!modProfile.contains("Carbamilation of protein N-term")) {
                modProfile.addVariableModification(this.getPTM("Carbamilation of protein N-term"));
                prideParametersReport = prideParametersReport + "<br>Carbamilation of protein N-term (assumed variable)";
            }
        } else if (pridePtmName.equalsIgnoreCase("3x(12)C labeled N6-propanoyl-L-lysine")) {
            if (!modProfile.contains("Propionyl of K light")) {
                modProfile.addVariableModification(this.getPTM("Propionyl of K light"));
                prideParametersReport = prideParametersReport + "<br>Propionyl of K light (assumed variable)";
            }
            if (!modProfile.contains("Propionyl of peptide N-term light")) {
                modProfile.addVariableModification(this.getPTM("Propionyl of peptide N-term light"));
                prideParametersReport = prideParametersReport + "<br>Propionyl of peptide N-term light (assumed variable)";
            }
        } else if (pridePtmName.equalsIgnoreCase("3x(13)C labeled N6-propanoyl-L-lysine")) {
            if (!modProfile.contains("Propionyl of K heavy")) {
                modProfile.addVariableModification(this.getPTM("Propionyl of K heavy"));
                prideParametersReport = prideParametersReport + "<br>Propionyl of K heavy (assumed variable)";
            }
            if (!modProfile.contains("Propionyl of peptide N-term heavy")) {
                modProfile.addVariableModification(this.getPTM("Propionyl of peptide N-term heavy"));
                prideParametersReport = prideParametersReport + "<br>Propionyl of peptide N-term heavy (assumed variable)";
            }
        } else if (pridePtmName.equalsIgnoreCase("3x(2)H residue methyl ester")) {
            if (!modProfile.contains("Trideuterated Methyl Ester of D")) {
                modProfile.addVariableModification(this.getPTM("Trideuterated Methyl Ester of D"));
                prideParametersReport = prideParametersReport + "<br>Trideuterated Methyl Ester of D (assumed variable)";
            }
            if (!modProfile.contains("Trideuterated Methyl Ester of E")) {
                modProfile.addVariableModification(this.getPTM("Trideuterated Methyl Ester of E"));
                prideParametersReport = prideParametersReport + "<br>Trideuterated Methyl Ester of E (assumed variable)";
            }
            if (!modProfile.contains("Trideuterated Methyl Ester of K")) {
                modProfile.addVariableModification(this.getPTM("Trideuterated Methyl Ester of K"));
                prideParametersReport = prideParametersReport + "<br>Trideuterated Methyl Ester of K (assumed variable)";
            }
            if (!modProfile.contains("Trideuterated Methyl Ester of R")) {
                modProfile.addVariableModification(this.getPTM("Trideuterated Methyl Ester of R"));
                prideParametersReport = prideParametersReport + "<br>Trideuterated Methyl Ester of R (assumed variable)";
            }
            if (!modProfile.contains("Trideuterated Methyl Ester of peptide C-term")) {
                modProfile.addVariableModification(this.getPTM("Trideuterated Methyl Ester of peptide C-term"));
                prideParametersReport = prideParametersReport + "<br>Trideuterated Methyl Ester of peptide C-term (assumed variable)";
            }
        } else if (pridePtmName.equalsIgnoreCase("6x(13)C labeled residue")) {
            if (!modProfile.contains("Arginine 13C6")) {
                modProfile.addVariableModification(this.getPTM("Arginine 13C6"));
                prideParametersReport = prideParametersReport + "<br>Arginine 13C6 (assumed variable)";
            }
            if (!modProfile.contains("Lysine 13C6")) {
                modProfile.addVariableModification(this.getPTM("Lysine 13C6"));
                prideParametersReport = prideParametersReport + "<br>Lysine 13C6 (assumed variable)";
            }
        } else if (pridePtmName.equalsIgnoreCase("Acetyl") || pridePtmName.equalsIgnoreCase("N-acetylated residue") || pridePtmName.equalsIgnoreCase("N-acylated residue") || pridePtmName.equalsIgnoreCase("acetylated residue")) {
            if (!modProfile.contains("Acetylation of K")) {
                modProfile.addVariableModification(this.getPTM("Acetylation of K"));
                prideParametersReport = prideParametersReport + "<br>Acetylation of K (assumed variable)";
            }
            if (!modProfile.contains("Acetylation of peptide N-term")) {
                modProfile.addVariableModification(this.getPTM("Acetylation of peptide N-term"));
                prideParametersReport = prideParametersReport + "<br>Acetylation of peptide N-term (assumed variable)";
            }
        } else if (pridePtmName.equalsIgnoreCase("dimethylated residue")) {
            if (!modProfile.contains("Dimethylation of K")) {
                modProfile.addVariableModification(this.getPTM("Dimethylation of K"));
                prideParametersReport = prideParametersReport + "<br>Dimethylation of K (assumed variable)";
            }
            if (!modProfile.contains("Dimethylation of R")) {
                modProfile.addVariableModification(this.getPTM("Dimethylation of R"));
                prideParametersReport = prideParametersReport + "<br>Dimethylation of R (assumed variable)";
            }
            if (!modProfile.contains("Dimethylation of peptide N-term")) {
                modProfile.addVariableModification(this.getPTM("Dimethylation of peptide N-term"));
                prideParametersReport = prideParametersReport + "<br>Dimethylation of peptide N-term (assumed variable)";
            }
        } else if (pridePtmName.equalsIgnoreCase("trimethylated residue")) {
            if (!modProfile.contains("Trimethylation of K")) {
                modProfile.addVariableModification(this.getPTM("Trimethylation of K"));
                prideParametersReport = prideParametersReport + "<br>Trimethylation of K (assumed variable)";
            }
            if (!modProfile.contains("Trimethylation of R")) {
                modProfile.addVariableModification(this.getPTM("Trimethylation of R"));
                prideParametersReport = prideParametersReport + "<br>Trimethylation of R (assumed variable)";
            }
            if (!modProfile.contains("Trimethylation of protein N-term A")) {
                modProfile.addVariableModification(this.getPTM("Trimethylation of protein N-term A"));
                prideParametersReport = prideParametersReport + "<br>Trimethylation of protein N-term A (assumed variable)";
            }
        } else if (pridePtmName.equalsIgnoreCase("Acetylation")) {
            if (!modProfile.contains("Acetylation of K")) {
                modProfile.addVariableModification(this.getPTM("Acetylation of K"));
                prideParametersReport = prideParametersReport + "<br>Acetylation of K (assumed variable)";
            }
            if (!modProfile.contains("Acetylation of peptide N-term")) {
                modProfile.addVariableModification(this.getPTM("Acetylation of peptide N-term"));
                prideParametersReport = prideParametersReport + "<br>Acetylation of peptide N-term (assumed variable)";
            }
        } else if (pridePtmName.equalsIgnoreCase("Guanidination")) {
            if (!modProfile.contains("Guanidination of K")) {
                modProfile.addVariableModification(this.getPTM("Guanidination of K"));
                prideParametersReport = prideParametersReport + "<br>Guanidination of K (assumed variable)";
            }
            if (!modProfile.contains("Guanidination of peptide N-term")) {
                modProfile.addVariableModification(this.getPTM("Guanidination of peptide N-term"));
                prideParametersReport = prideParametersReport + "<br>Guanidination of peptide N-term (assumed variable)";
            }
        } else if (pridePtmName.equalsIgnoreCase("Methylthio")) {
            if (!modProfile.contains("Methylthio of N")) {
                modProfile.addVariableModification(this.getPTM("Methylthio of N"));
                prideParametersReport = prideParametersReport + "<br>Methylthio of N (assumed variable)";
            }
            if (!modProfile.contains("Methylthio of D")) {
                modProfile.addVariableModification(this.getPTM("Methylthio of D"));
                prideParametersReport = prideParametersReport + "<br>Methylthio of D (assumed variable)";
            }
        } else if (pridePtmName.equalsIgnoreCase("Sulfo") || pridePtmName.equalsIgnoreCase("sulfated residue")) {
            if (!modProfile.contains("Sulfonation of Y")) {
                modProfile.addVariableModification(this.getPTM("Sulfonation of Y"));
                prideParametersReport = prideParametersReport + "<br>Sulfonation of Y (assumed variable)";
            }
            if (!modProfile.contains("Sulfonation of S")) {
                modProfile.addVariableModification(this.getPTM("Sulfonation of S"));
                prideParametersReport = prideParametersReport + "<br>Sulfonation of S (assumed variable)";
            }
            if (!modProfile.contains("Sulfonation of T")) {
                modProfile.addVariableModification(this.getPTM("Sulfonation of T"));
                prideParametersReport = prideParametersReport + "<br>Sulfonation of T (assumed variable)";
            }
        } else if (pridePtmName.equalsIgnoreCase("Deamination") || pridePtmName.equalsIgnoreCase("Deamidated") || pridePtmName.equalsIgnoreCase("deamidated L-glutamine") || pridePtmName.equalsIgnoreCase("deamidated residue") || pridePtmName.equalsIgnoreCase("deaminated residue")) {
            if (!modProfile.contains("Deamidation of N")) {
                modProfile.addVariableModification(this.getPTM("Deamidation of N"));
                prideParametersReport = prideParametersReport + "<br>Deamidation of N (assumed variable)";
            }
            if (!modProfile.contains("Deamidation of Q")) {
                modProfile.addVariableModification(this.getPTM("Deamidation of Q"));
                prideParametersReport = prideParametersReport + "<br>Deamidation of Q (assumed variable)";
            }
        } else if (pridePtmName.equalsIgnoreCase("Dioxidation")) {
            if (!modProfile.contains("Dioxidation of M")) {
                modProfile.addVariableModification(this.getPTM("Dioxidation of M"));
                prideParametersReport = prideParametersReport + "<br>Dioxidation of M (assumed variable)";
            }
            if (!modProfile.contains("Dioxidation of W")) {
                modProfile.addVariableModification(this.getPTM("Dioxidation of W"));
                prideParametersReport = prideParametersReport + "<br>Dioxidation of W (assumed variable)";
            }
        } else if (pridePtmName.equalsIgnoreCase("dehydrated residue") || pridePtmName.equalsIgnoreCase("Dehydratation")) {
            if (!modProfile.contains("Dehydration of S")) {
                modProfile.addVariableModification(this.getPTM("Dehydration of S"));
                prideParametersReport = prideParametersReport + "<br>Dehydration of S (assumed variable)";
            }
            if (!modProfile.contains("Dehydration of T")) {
                modProfile.addVariableModification(this.getPTM("Dehydration of T"));
                prideParametersReport = prideParametersReport + "<br>Dehydration of T (assumed variable)";
            }
        } else if (!pridePtmName.equalsIgnoreCase("No PTMs are included in the dataset")) {
            String utilitiesPtmName = this.convertPridePtmToUtilitiesPtm(pridePtmName);
            if (utilitiesPtmName != null) {
                if (!modProfile.contains(utilitiesPtmName)) {
                    if (isFixed) {
                        modProfile.addFixedModification(this.getPTM(utilitiesPtmName));
                        prideParametersReport = prideParametersReport + "<br>" + utilitiesPtmName + " (assumed fixed)";
                    } else {
                        modProfile.addVariableModification(this.getPTM(utilitiesPtmName));
                        prideParametersReport = prideParametersReport + "<br>" + utilitiesPtmName + " (assumed variable)";
                    }
                }
            } else if (!unknownPtms.contains(pridePtmName)) {
                unknownPtms.add(pridePtmName);
            }
        }
        return prideParametersReport;
    }

    private String convertPridePtmToUtilitiesPtm(String pridePtmName) {
        if (pridePtmName.equalsIgnoreCase("Carbamidomethyl") || pridePtmName.equalsIgnoreCase("S-carboxamidomethyl-L-cysteine") || pridePtmName.equalsIgnoreCase("iodoacetamide - site C") || pridePtmName.equalsIgnoreCase("iodoacetamide -site C") || pridePtmName.equalsIgnoreCase("iodoacetamide derivatized residue") || pridePtmName.equalsIgnoreCase("Iodoacetamide derivative")) {
            return "Carbamidomethylation of C";
        }
        if (pridePtmName.equalsIgnoreCase("Oxidation") || pridePtmName.equalsIgnoreCase("monohydroxylated residue") || pridePtmName.equalsIgnoreCase("oxidized residue")) {
            return "Oxidation of M";
        }
        if (pridePtmName.equalsIgnoreCase("Amidation")) {
            return "Amidation of the peptide C-term";
        }
        if (pridePtmName.equalsIgnoreCase("Carboxymethyl") || pridePtmName.equalsIgnoreCase("S-carboxymethyl-L-cysteine") || pridePtmName.equalsIgnoreCase("iodoacetic acid derivatized residue")) {
            return "Carboxymethylation of C";
        }
        if (pridePtmName.equalsIgnoreCase("Farnesylation")) {
            return "Farnesylation of C";
        }
        if (pridePtmName.equalsIgnoreCase("Geranyl-geranyl")) {
            return "Geranyl-geranyl of C";
        }
        if (pridePtmName.equalsIgnoreCase("Homoserine")) {
            return "Homoserine of peptide C-term M";
        }
        if (pridePtmName.equalsIgnoreCase("Homoserine lactone")) {
            return "Homoserine lactone of peptide C-term M";
        }
        if (pridePtmName.equalsIgnoreCase("ICAT-C") || pridePtmName.equalsIgnoreCase("Applied Biosystems cleavable ICAT(TM) light")) {
            return "ICAT-O";
        }
        if (pridePtmName.equalsIgnoreCase("ICAT-C:13C(9)") || pridePtmName.equalsIgnoreCase("Applied Biosystems cleavable ICAT(TM) heavy")) {
            return "ICAT-9";
        }
        if (pridePtmName.equalsIgnoreCase("Lipoyl")) {
            return "Lipoyl of K";
        }
        if (pridePtmName.equalsIgnoreCase("NIPCAM(C)")) {
            return "NIPCAM of C";
        }
        if (pridePtmName.equalsIgnoreCase("Phosphopantetheine")) {
            return "phosphopantetheine s";
        }
        if (pridePtmName.equalsIgnoreCase("Propionamide(C)") || pridePtmName.equalsIgnoreCase("Acrylamide adduct")) {
            return "Propionamide of C";
        }
        if (pridePtmName.equalsIgnoreCase("Pyridylethyl")) {
            return "Pyridylethyl of C";
        }
        if (pridePtmName.equalsIgnoreCase("(18)O label at both C-terminal oxygens")) {
            return "18O(2) of peptide C-term";
        }
        if (pridePtmName.equalsIgnoreCase("(18)O monosubstituted residue")) {
            return "18O(1) of peptide C-term";
        }
        if (pridePtmName.equalsIgnoreCase("(4,4,5,5-(2)H4)-L-lysine")) {
            return "Lysine 2H4";
        }
        if (pridePtmName.equalsIgnoreCase("2-pyrrolidone-5-carboxylic acid (Gln)") || pridePtmName.equalsIgnoreCase("Ammonia-loss")) {
            return "Pyrolidone from Q";
        }
        if (pridePtmName.equalsIgnoreCase("2-pyrrolidone-5-carboxylic acid (Glu)") || pridePtmName.equalsIgnoreCase("Glu->pyro-Glu")) {
            return "Pyrolidone from E";
        }
        if (pridePtmName.equalsIgnoreCase("3-hydroxy-L-proline")) {
            return "Oxidation of P";
        }
        if (pridePtmName.equalsIgnoreCase("3x(2)H labeled L-aspartic acid 4-methyl ester")) {
            return "Trideuterated Methyl Ester of D";
        }
        if (pridePtmName.equalsIgnoreCase("4x(2)H labeled alpha-dimethylamino N-terminal residue")) {
            return "Dimethylation of peptide N-term 2H(4)";
        }
        if (pridePtmName.equalsIgnoreCase("4x(2)H labeled dimethylated L-lysine")) {
            return "Dimethylation of K 2H(4)";
        }
        if (pridePtmName.equalsIgnoreCase("5-methyl-L-arginine")) {
            return "Methylation of R";
        }
        if (pridePtmName.equalsIgnoreCase("6x(13)C labeled L-arginine")) {
            return "Arginine 13C6";
        }
        if (pridePtmName.equalsIgnoreCase("6x(13)C,4x(15)N labeled L-arginine")) {
            return "Arginine 13C6 15N4";
        }
        if (pridePtmName.equalsIgnoreCase("6x(13)C labeled L-lysine")) {
            return "Lysine 13C6";
        }
        if (pridePtmName.equalsIgnoreCase("6x(13)C,2x(15)N labeled L-lysine")) {
            return "Lysine 13C6 15N2";
        }
        if (pridePtmName.equalsIgnoreCase("L-aspartic acid 4-methyl ester")) {
            return "Methylation of D";
        }
        if (pridePtmName.equalsIgnoreCase("L-cysteic acid (L-cysteine sulfonic acid)")) {
            return "Oxidation of C";
        }
        if (pridePtmName.equalsIgnoreCase("L-cysteine glutathione disulfide")) {
            return "Glutathione of C";
        }
        if (pridePtmName.equalsIgnoreCase("L-cysteine methyl disulfide") || pridePtmName.equalsIgnoreCase("methyl methanethiosulfonate")) {
            return "Methylthio of C";
        }
        if (pridePtmName.equalsIgnoreCase("L-cystine (cross-link)")) {
            return "Didehydro of T";
        }
        if (pridePtmName.equalsIgnoreCase("L-glutamic acid 5-methyl ester (Glu)") || pridePtmName.equalsIgnoreCase("methylated glutamic acid")) {
            return "Methylation of E";
        }
        if (pridePtmName.equalsIgnoreCase("L-homoarginine")) {
            return "Guanidination of K";
        }
        if (pridePtmName.equalsIgnoreCase("L-methionine (R)-sulfoxide") || pridePtmName.equalsIgnoreCase("L-methionine (S)-sulfoxide") || pridePtmName.equalsIgnoreCase("L-methionine sulfoxide")) {
            return "Oxidation of M";
        }
        if (pridePtmName.equalsIgnoreCase("L-methionine sulfone")) {
            return "Dioxidation of M";
        }
        if (pridePtmName.equalsIgnoreCase("N-acetyl-L-asparagine") || pridePtmName.equalsIgnoreCase("N-acetyl-L-cysteine") || pridePtmName.equalsIgnoreCase("N-acetyl-L-glutamic acid") || pridePtmName.equalsIgnoreCase("N-acetyl-L-isoleucine") || pridePtmName.equalsIgnoreCase("N-acetyl-L-serine") || pridePtmName.equalsIgnoreCase("N-acetyl-L-tyrosine") || pridePtmName.equalsIgnoreCase("N2-acetyl-L-tryptophan") || pridePtmName.equalsIgnoreCase("alpha-amino acetylated residue")) {
            return "Acetylation of protein N-term";
        }
        if (pridePtmName.equalsIgnoreCase("N-acetylated L-lysine") || pridePtmName.equalsIgnoreCase("N6-acetyl-L-lysine")) {
            return "Acetylation of K";
        }
        if (pridePtmName.equalsIgnoreCase("N-ethylmaleimide derivatized cysteine")) {
            return "Nethylmaleimide of C";
        }
        if (pridePtmName.equalsIgnoreCase("N-formyl-L-methionine")) {
            return "FormylMet of protein N-term";
        }
        if (pridePtmName.equalsIgnoreCase("N-formylated residue")) {
            return "Formylation of peptide N-term";
        }
        if (pridePtmName.equalsIgnoreCase("N-methyl-L-serine")) {
            return "Methylation of S";
        }
        if (pridePtmName.equalsIgnoreCase("N6,N6-dimethyl-L-lysine")) {
            return "Dimethylation of K";
        }
        if (pridePtmName.equalsIgnoreCase("N6-formyl-L-lysine")) {
            return "Formylation of K";
        }
        if (pridePtmName.equalsIgnoreCase("N6-methyl-L-lysine") || pridePtmName.equalsIgnoreCase("methylated lysine") || pridePtmName.equalsIgnoreCase("monomethylated L-lysine")) {
            return "Methylation of K";
        }
        if (pridePtmName.equalsIgnoreCase("N6-propanoyl-L-lysine")) {
            return "Propionyl of K light";
        }
        if (pridePtmName.equalsIgnoreCase("O-(N-acetylamino)glucosyl-L-serine")) {
            return "HexNAc of S";
        }
        if (pridePtmName.equalsIgnoreCase("O-(N-acetylamino)glucosyl-L-threonine")) {
            return "HexNAc of T";
        }
        if (pridePtmName.equalsIgnoreCase("O-phospho-L-serine")) {
            return "Phosphorylation of S";
        }
        if (pridePtmName.equalsIgnoreCase("O-phospho-L-threonine")) {
            return "Phosphorylation of T";
        }
        if (pridePtmName.equalsIgnoreCase("O4&apos;-phospho-L-tyrosine")) {
            return "Phosphorylation of Y";
        }
        if (pridePtmName.equalsIgnoreCase("S-carboxamidoethyl-L-cysteine")) {
            return "Propionamide of C";
        }
        if (pridePtmName.equalsIgnoreCase("S-methyl-L-cysteine")) {
            return "Methylation of C";
        }
        if (pridePtmName.equalsIgnoreCase("alpha-amino dimethylated residue")) {
            return "Dimethylation of N-term";
        }
        if (pridePtmName.equalsIgnoreCase("amidated residue")) {
            return "Amidation of the peptide C-term";
        }
        if (pridePtmName.equalsIgnoreCase("deamidated L-asparagine") || pridePtmName.equalsIgnoreCase("deglycosylated asparagine")) {
            return "Deamidation of N";
        }
        if (pridePtmName.equalsIgnoreCase("dihydroxylated residue - site W")) {
            return "Dioxidation of W";
        }
        if (pridePtmName.equalsIgnoreCase("diiodinated residue")) {
            return "Diiodination of Y";
        }
        if (pridePtmName.equalsIgnoreCase("hydroxylated lysine") || pridePtmName.equalsIgnoreCase("monohydroxylated lysine")) {
            return "Oxidation of K";
        }
        if (pridePtmName.equalsIgnoreCase("iodoacetamide -site E") || pridePtmName.equalsIgnoreCase("iodoacetamide - site E")) {
            return "Carbamidomethylat\"iodoacetamide -site E\"ion of E";
        }
        if (pridePtmName.equalsIgnoreCase("iodoacetamide N6-derivatized lysine")) {
            return "Carbamidomethylation of K";
        }
        if (pridePtmName.equalsIgnoreCase("monomethylated L-aspartic acid")) {
            return "Methylation of D";
        }
        if (pridePtmName.equalsIgnoreCase("thioacylation of primary amines - site N-term")) {
            return "Thioacyl of peptide N-term";
        }
        if (pridePtmName.equalsIgnoreCase("ubiquitination signature dipeptidyl lysine")) {
            return "Ubiquitination of K";
        }
        if (pridePtmName.equalsIgnoreCase("Label:13C(6)15N(2)")) {
            return "Lysine 13C(6) 15N(2)";
        }
        return null;
    }

    public static String getSerializationFolder() {
        return SERIALIZATION_FILE_FOLDER;
    }

    public static void setSerializationFolder(String serializationFolder) {
        SERIALIZATION_FILE_FOLDER = serializationFolder;
    }

    private void setDefaultModifications() {
        AtomChain atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 2);
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 2);
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0));
        AtomChain atomChainRemoved = null;
        AminoAcidPattern aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("K");
        String ptmName = "Acetylation of K";
        PTM ptm = new PTM(0, ptmName, "ace", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:1", "Acetyl", null));
        ptm.addReporterIon(ReporterIon.ACE_K_126);
        ptm.addReporterIon(ReporterIon.ACE_K_143);
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 2);
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 2);
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0));
        atomChainRemoved = null;
        aminoAcidPattern = null;
        ptmName = "Acetylation of peptide N-term";
        ptm = new PTM(5, ptmName, "ace", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:1", "Acetyl", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 2);
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 2);
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0));
        atomChainRemoved = null;
        aminoAcidPattern = null;
        ptmName = "Acetylation of protein N-term";
        ptm = new PTM(1, ptmName, "ace", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:1", "Acetyl", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 2);
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 3);
        atomChainAdded.append(new AtomImpl(Atom.N, (Integer)0));
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0));
        atomChainRemoved = null;
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("C");
        ptmName = "Carbamidomethylation of C";
        ptm = new PTM(0, ptmName, "cmm", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:4", "Carbamidomethyl", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 2);
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 3);
        atomChainAdded.append(new AtomImpl(Atom.N, (Integer)0));
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0));
        atomChainRemoved = null;
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("E");
        ptmName = "Carbamidomethylation of E";
        ptm = new PTM(0, ptmName, "cmm", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:4", "Carbamidomethyl", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 2);
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 3);
        atomChainAdded.append(new AtomImpl(Atom.N, (Integer)0));
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0));
        atomChainRemoved = null;
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("K");
        ptmName = "Carbamidomethylation of K";
        ptm = new PTM(0, ptmName, "cmm", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:4", "Carbamidomethyl", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0));
        atomChainRemoved = null;
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("M");
        ptmName = "Oxidation of M";
        ptm = new PTM(0, ptmName, "ox", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:35", "Oxidation", null));
        ptm.addNeutralLoss(NeutralLoss.CH4OS);
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0));
        atomChainRemoved = null;
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("P");
        ptmName = "Oxidation of P";
        ptm = new PTM(0, ptmName, "ox", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:35", "Oxidation", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0));
        atomChainRemoved = null;
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("K");
        ptmName = "Oxidation of K";
        ptm = new PTM(0, ptmName, "ox", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:35", "Oxidation", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0));
        atomChainRemoved = null;
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("C");
        ptmName = "Oxidation of C";
        ptm = new PTM(0, ptmName, "ox", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:35", "Oxidation", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0), 2);
        atomChainRemoved = null;
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("M");
        ptmName = "Dioxidation of M";
        ptm = new PTM(0, ptmName, "diox", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:425", "Dioxidation", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0), 2);
        atomChainRemoved = null;
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("W");
        ptmName = "Dioxidation of W";
        ptm = new PTM(0, ptmName, "diox", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:425", "Dioxidation", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0), 3);
        atomChainRemoved = null;
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("C");
        ptmName = "Trioxidation of C";
        ptm = new PTM(0, ptmName, "triox", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:345", "Trioxidation", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0));
        atomChainAdded.append(new AtomImpl(Atom.P, (Integer)0));
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0), 3);
        atomChainRemoved = null;
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("S");
        ptmName = "Phosphorylation of S";
        ptm = new PTM(0, ptmName, "p", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:21", "Phospho", null));
        ptm.addNeutralLoss(NeutralLoss.H3PO4);
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0));
        atomChainAdded.append(new AtomImpl(Atom.P, (Integer)0));
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0), 3);
        atomChainRemoved = null;
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("T");
        ptmName = "Phosphorylation of T";
        ptm = new PTM(0, ptmName, "p", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:21", "Phospho", null));
        ptm.addNeutralLoss(NeutralLoss.H3PO4);
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0));
        atomChainAdded.append(new AtomImpl(Atom.P, (Integer)0));
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0), 3);
        atomChainRemoved = null;
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("Y");
        ptmName = "Phosphorylation of Y";
        ptm = new PTM(0, ptmName, "p", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:21", "Phospho", null));
        ptm.addNeutralLoss(NeutralLoss.HPO3);
        ptm.addReporterIon(ReporterIon.PHOSPHO_Y);
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)1), 6);
        atomChainRemoved = new AtomChain();
        atomChainRemoved.append(new AtomImpl(Atom.C, (Integer)0), 6);
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("R");
        ptmName = "Arginine 13C(6)";
        ptm = new PTM(0, ptmName, "*", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:188", "Label:13C(6)", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)1), 6);
        atomChainAdded.append(new AtomImpl(Atom.N, (Integer)1), 4);
        atomChainRemoved = new AtomChain();
        atomChainRemoved.append(new AtomImpl(Atom.C, (Integer)0), 6);
        atomChainRemoved.append(new AtomImpl(Atom.N, (Integer)0), 4);
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("R");
        ptmName = "Arginine 13C(6) 15N(4)";
        ptm = new PTM(0, ptmName, "*", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:267", "Label:13C(6)15N(4)", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)1), 4);
        atomChainRemoved = new AtomChain();
        atomChainRemoved.append(new AtomImpl(Atom.H, (Integer)0), 4);
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("K");
        ptmName = "Lysine 2H(4)";
        ptm = new PTM(0, ptmName, "*", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:481", "Label:2H(4)", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)1), 6);
        atomChainRemoved = new AtomChain();
        atomChainRemoved.append(new AtomImpl(Atom.C, (Integer)0), 6);
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("K");
        ptmName = "Lysine 13C(6)";
        ptm = new PTM(0, ptmName, "*", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:188", "Label:13C(6)", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)1), 6);
        atomChainAdded.append(new AtomImpl(Atom.N, (Integer)1), 2);
        atomChainRemoved = new AtomChain();
        atomChainRemoved.append(new AtomImpl(Atom.C, (Integer)0), 6);
        atomChainRemoved.append(new AtomImpl(Atom.N, (Integer)0), 2);
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("K");
        ptmName = "Lysine 13C(6) 15N(2)";
        ptm = new PTM(0, ptmName, "*", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:259", "Label:13C(6)15N(2)", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)1), 5);
        atomChainRemoved = new AtomChain();
        atomChainRemoved.append(new AtomImpl(Atom.C, (Integer)0), 5);
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("P");
        ptmName = "Proline 13C(5)";
        ptm = new PTM(0, ptmName, "*", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:772", "Label:13C(5)", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 5);
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 9);
        atomChainAdded.append(new AtomImpl(Atom.N, (Integer)0), 1);
        atomChainRemoved = null;
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("P");
        ptmName = "4-Hydroxyproline";
        ptm = new PTM(0, ptmName, "hydroxy", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)1), 6);
        atomChainAdded.append(new AtomImpl(Atom.N, (Integer)1), 1);
        atomChainRemoved = new AtomChain();
        atomChainRemoved.append(new AtomImpl(Atom.C, (Integer)0), 6);
        atomChainRemoved.append(new AtomImpl(Atom.N, (Integer)0), 1);
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("L");
        ptmName = "Leucine 13C(6) 15N(1)";
        ptm = new PTM(0, ptmName, "*", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:695", "Label:13C(6)15N(1)", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)1), 6);
        atomChainAdded.append(new AtomImpl(Atom.N, (Integer)1), 1);
        atomChainRemoved = new AtomChain();
        atomChainRemoved.append(new AtomImpl(Atom.C, (Integer)0), 6);
        atomChainRemoved.append(new AtomImpl(Atom.N, (Integer)0), 1);
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("I");
        ptmName = "Isoleucine 13C(6) 15N(1)";
        ptm = new PTM(0, ptmName, "*", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:695", "Label:13C(6)15N(1)", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)1), 4);
        atomChainRemoved = new AtomChain();
        atomChainRemoved.append(new AtomImpl(Atom.H, (Integer)0), 4);
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("K");
        ptmName = "Label of K 2H(4)";
        ptm = new PTM(0, ptmName, "2H(4)", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:481", "Label:2H(4)", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 2);
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)1), 4);
        atomChainRemoved = null;
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("K");
        ptmName = "Dimethylation of K 2H(4)";
        ptm = new PTM(0, ptmName, "dimeth4", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:199 ", "Dimethyl:2H(4)", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)1), 6);
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 2);
        atomChainRemoved = new AtomChain();
        atomChainRemoved.append(new AtomImpl(Atom.H, (Integer)0), 2);
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("K");
        ptmName = "Dimethylation of K 2H(6)";
        ptm = new PTM(0, ptmName, "dimeth6", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:1291", "Dimethyl:2H(6)", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)1), 2);
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)1), 6);
        atomChainRemoved = new AtomChain();
        atomChainRemoved.append(new AtomImpl(Atom.H, (Integer)0), 2);
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("K");
        ptmName = "Dimethylation of K 2H(6) 13C(2)";
        ptm = new PTM(0, ptmName, "dimeth8", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:330", " Dimethyl:2H(6)13C(2)", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 2);
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)1), 4);
        atomChainRemoved = null;
        aminoAcidPattern = null;
        ptmName = "Dimethylation of peptide N-term 2H(4)";
        ptm = new PTM(5, ptmName, "dimeth4", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:199 ", "Dimethyl:2H(4)", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 2);
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)1), 6);
        atomChainRemoved = new AtomChain();
        atomChainRemoved.append(new AtomImpl(Atom.H, (Integer)0), 2);
        aminoAcidPattern = null;
        ptmName = "Dimethylation of peptide N-term 2H(6)";
        ptm = new PTM(5, ptmName, "dimeth6", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD: 1291", "Dimethyl:2H(6)", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)1), 2);
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)1), 6);
        atomChainRemoved = new AtomChain();
        atomChainRemoved.append(new AtomImpl(Atom.H, (Integer)0), 2);
        aminoAcidPattern = null;
        ptmName = "Dimethylation of peptide N-term 2H(6) 13C(2)";
        ptm = new PTM(5, ptmName, "dimeth8", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:330", " Dimethyl:2H(6)13C(2)", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)2), 2);
        atomChainRemoved = new AtomChain();
        atomChainRemoved.append(new AtomImpl(Atom.O, (Integer)0), 2);
        aminoAcidPattern = null;
        ptmName = "18O(2) of peptide C-term";
        ptm = new PTM(7, ptmName, "18O", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD: 193", "Label:18O(2)", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)2), 1);
        atomChainRemoved = new AtomChain();
        atomChainRemoved.append(new AtomImpl(Atom.O, (Integer)0), 1);
        aminoAcidPattern = null;
        ptmName = "18O(1) of peptide C-term";
        ptm = new PTM(7, ptmName, "18O", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:258", "Label:18O(1)", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 10);
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 17);
        atomChainAdded.append(new AtomImpl(Atom.N, (Integer)0), 3);
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0), 3);
        atomChainRemoved = null;
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("C");
        ptmName = "ICAT-O";
        ptm = new PTM(0, ptmName, "*", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:105", "ICAT-C", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)1), 9);
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 1);
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 17);
        atomChainAdded.append(new AtomImpl(Atom.N, (Integer)0), 3);
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0), 3);
        atomChainRemoved = null;
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("C");
        ptmName = "ICAT-9";
        ptm = new PTM(0, ptmName, "*", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:106", "ICAT-C:13C(9)", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 6);
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 3);
        atomChainAdded.append(new AtomImpl(Atom.N, (Integer)0), 1);
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0), 1);
        atomChainRemoved = null;
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("K");
        ptmName = "ICPL0 of K";
        ptm = new PTM(0, ptmName, "icpl0", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:365", "ICPL", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 6);
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 3);
        atomChainAdded.append(new AtomImpl(Atom.N, (Integer)0), 1);
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0), 1);
        atomChainRemoved = null;
        aminoAcidPattern = null;
        ptmName = "ICPL0 of peptide N-term";
        ptm = new PTM(5, ptmName, "icpl0", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:365", "ICPL", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 6);
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)1), 4);
        atomChainAdded.append(new AtomImpl(Atom.N, (Integer)0), 1);
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0), 1);
        atomChainRemoved = new AtomChain();
        atomChainRemoved.append(new AtomImpl(Atom.H, (Integer)0), 1);
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("K");
        ptmName = "ICPL4 of K";
        ptm = new PTM(0, ptmName, "icpl4", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:687", "ICPL:2H(4)", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 6);
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)1), 4);
        atomChainAdded.append(new AtomImpl(Atom.N, (Integer)0), 1);
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0), 1);
        atomChainRemoved = new AtomChain();
        atomChainRemoved.append(new AtomImpl(Atom.H, (Integer)0), 1);
        aminoAcidPattern = null;
        ptmName = "ICPL4 of peptide N-term";
        ptm = new PTM(5, ptmName, "icpl4", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:687", "ICPL:2H(4)", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)1), 6);
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 3);
        atomChainAdded.append(new AtomImpl(Atom.N, (Integer)0), 1);
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0), 1);
        atomChainRemoved = null;
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("K");
        ptmName = "ICPL6 of K";
        ptm = new PTM(0, ptmName, "icpl6", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:364", "ICPL:13C(6)", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)1), 6);
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 3);
        atomChainAdded.append(new AtomImpl(Atom.N, (Integer)0), 1);
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0), 1);
        atomChainRemoved = null;
        aminoAcidPattern = null;
        ptmName = "ICPL6 of peptide N-term";
        ptm = new PTM(5, ptmName, "icpl6", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:364", "ICPL:13C(6)", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)1), 6);
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)1), 4);
        atomChainAdded.append(new AtomImpl(Atom.N, (Integer)0), 1);
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0), 1);
        atomChainRemoved = new AtomChain();
        atomChainRemoved.append(new AtomImpl(Atom.H, (Integer)0), 1);
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("K");
        ptmName = "ICPL10 of K";
        ptm = new PTM(0, ptmName, "icpl10", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:866", "ICPL:13C(6)2H(4)", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)1), 6);
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)1), 4);
        atomChainAdded.append(new AtomImpl(Atom.N, (Integer)0), 1);
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0), 1);
        atomChainRemoved = new AtomChain();
        atomChainRemoved.append(new AtomImpl(Atom.H, (Integer)0), 1);
        aminoAcidPattern = null;
        ptmName = "ICPL10 of peptide N-term";
        ptm = new PTM(5, ptmName, "icpl10", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:866", "ICPL:13C(6)2H(4)", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 7);
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 12);
        atomChainAdded.append(new AtomImpl(Atom.N, (Integer)0), 2);
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0), 1);
        atomChainRemoved = null;
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("K");
        ptmName = "mTRAQ of K light";
        ptm = new PTM(0, ptmName, "mTRAQ0", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD: 888 ", "mTRAQ", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 7);
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 12);
        atomChainAdded.append(new AtomImpl(Atom.N, (Integer)0), 2);
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0), 1);
        atomChainRemoved = null;
        aminoAcidPattern = null;
        ptmName = "mTRAQ of peptide N-term light";
        ptm = new PTM(5, ptmName, "mTRAQ0", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:888", "mTRAQ", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 4);
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)1), 3);
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 12);
        atomChainAdded.append(new AtomImpl(Atom.N, (Integer)0), 1);
        atomChainAdded.append(new AtomImpl(Atom.N, (Integer)1), 1);
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0), 1);
        atomChainRemoved = null;
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("K");
        ptmName = "mTRAQ of K 13C(3) 15N";
        ptm = new PTM(0, ptmName, "mTRAQ4", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:889", "mTRAQ:13C(3)15N(1) ", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 4);
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)1), 3);
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 12);
        atomChainAdded.append(new AtomImpl(Atom.N, (Integer)0), 1);
        atomChainAdded.append(new AtomImpl(Atom.N, (Integer)1), 1);
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0), 1);
        atomChainRemoved = null;
        aminoAcidPattern = null;
        ptmName = "mTRAQ of peptide N-term 13C(3) 15N";
        ptm = new PTM(5, ptmName, "mTRAQ4", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:889", "mTRAQ:13C(3)15N(1) ", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 1);
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)1), 6);
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 12);
        atomChainAdded.append(new AtomImpl(Atom.N, (Integer)1), 2);
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0), 1);
        atomChainRemoved = null;
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("K");
        ptmName = "mTRAQ of 13C(6) 15N(2)";
        ptm = new PTM(0, ptmName, "mTRAQ8", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:1302", "mTRAQ:13C(6)15N(2) ", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 1);
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)1), 6);
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 12);
        atomChainAdded.append(new AtomImpl(Atom.N, (Integer)1), 2);
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0), 1);
        atomChainRemoved = null;
        aminoAcidPattern = null;
        ptmName = "mTRAQ of peptide N-term 13C(6) 15N(2)";
        ptm = new PTM(5, ptmName, "mTRAQ8", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:1302", "mTRAQ:13C(6)15N(2) ", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 4);
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)1), 3);
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 12);
        atomChainAdded.append(new AtomImpl(Atom.N, (Integer)0), 1);
        atomChainAdded.append(new AtomImpl(Atom.N, (Integer)1), 1);
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0), 1);
        atomChainRemoved = null;
        aminoAcidPattern = null;
        ptmName = "iTRAQ 4-plex of peptide N-term";
        ptm = new PTM(5, ptmName, "iTRAQ", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:214", "iTRAQ4plex", null));
        ptm.addReporterIon(ReporterIon.iTRAQ4Plex_114);
        ptm.addReporterIon(ReporterIon.iTRAQ4Plex_115);
        ptm.addReporterIon(ReporterIon.iTRAQ4Plex_116);
        ptm.addReporterIon(ReporterIon.iTRAQ4Plex_117);
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 4);
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)1), 3);
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 12);
        atomChainAdded.append(new AtomImpl(Atom.N, (Integer)0), 1);
        atomChainAdded.append(new AtomImpl(Atom.N, (Integer)1), 1);
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0), 1);
        atomChainRemoved = null;
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("K");
        ptmName = "iTRAQ 4-plex of K";
        ptm = new PTM(0, ptmName, "iTRAQ", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:214", "iTRAQ4plex", null));
        ptm.addReporterIon(ReporterIon.iTRAQ4Plex_114);
        ptm.addReporterIon(ReporterIon.iTRAQ4Plex_115);
        ptm.addReporterIon(ReporterIon.iTRAQ4Plex_116);
        ptm.addReporterIon(ReporterIon.iTRAQ4Plex_117);
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 4);
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)1), 3);
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 12);
        atomChainAdded.append(new AtomImpl(Atom.N, (Integer)0), 1);
        atomChainAdded.append(new AtomImpl(Atom.N, (Integer)1), 1);
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0), 1);
        atomChainRemoved = null;
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("Y");
        ptmName = "iTRAQ 4-plex of Y";
        ptm = new PTM(0, ptmName, "iTRAQ", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:214", "iTRAQ4plex", null));
        ptm.addReporterIon(ReporterIon.iTRAQ4Plex_114);
        ptm.addReporterIon(ReporterIon.iTRAQ4Plex_115);
        ptm.addReporterIon(ReporterIon.iTRAQ4Plex_116);
        ptm.addReporterIon(ReporterIon.iTRAQ4Plex_117);
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 8);
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)1), 6);
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 24);
        atomChainAdded.append(new AtomImpl(Atom.N, (Integer)0), 2);
        atomChainAdded.append(new AtomImpl(Atom.N, (Integer)1), 2);
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0), 3);
        atomChainRemoved = null;
        aminoAcidPattern = null;
        ptmName = "iTRAQ 8-plex of peptide N-term";
        ptm = new PTM(5, ptmName, "iTRAQ", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:730", "iTRAQ8plex", null));
        ptm.addReporterIon(ReporterIon.iTRAQ8Plex_113);
        ptm.addReporterIon(ReporterIon.iTRAQ8Plex_114);
        ptm.addReporterIon(ReporterIon.iTRAQ8Plex_115);
        ptm.addReporterIon(ReporterIon.iTRAQ8Plex_116);
        ptm.addReporterIon(ReporterIon.iTRAQ8Plex_117);
        ptm.addReporterIon(ReporterIon.iTRAQ8Plex_118);
        ptm.addReporterIon(ReporterIon.iTRAQ8Plex_119);
        ptm.addReporterIon(ReporterIon.iTRAQ8Plex_121);
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 8);
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)1), 6);
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 24);
        atomChainAdded.append(new AtomImpl(Atom.N, (Integer)0), 2);
        atomChainAdded.append(new AtomImpl(Atom.N, (Integer)1), 2);
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0), 3);
        atomChainRemoved = null;
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("K");
        ptmName = "iTRAQ 8-plex of K";
        ptm = new PTM(0, ptmName, "iTRAQ", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:730", "iTRAQ8plex", null));
        ptm.addReporterIon(ReporterIon.iTRAQ8Plex_113);
        ptm.addReporterIon(ReporterIon.iTRAQ8Plex_114);
        ptm.addReporterIon(ReporterIon.iTRAQ8Plex_115);
        ptm.addReporterIon(ReporterIon.iTRAQ8Plex_116);
        ptm.addReporterIon(ReporterIon.iTRAQ8Plex_117);
        ptm.addReporterIon(ReporterIon.iTRAQ8Plex_118);
        ptm.addReporterIon(ReporterIon.iTRAQ8Plex_119);
        ptm.addReporterIon(ReporterIon.iTRAQ8Plex_121);
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 8);
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)1), 6);
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 24);
        atomChainAdded.append(new AtomImpl(Atom.N, (Integer)0), 2);
        atomChainAdded.append(new AtomImpl(Atom.N, (Integer)1), 2);
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0), 3);
        atomChainRemoved = null;
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("Y");
        ptmName = "iTRAQ 8-plex of Y";
        ptm = new PTM(0, ptmName, "iTRAQ", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:730", "iTRAQ8plex", null));
        ptm.addReporterIon(ReporterIon.iTRAQ8Plex_113);
        ptm.addReporterIon(ReporterIon.iTRAQ8Plex_114);
        ptm.addReporterIon(ReporterIon.iTRAQ8Plex_115);
        ptm.addReporterIon(ReporterIon.iTRAQ8Plex_116);
        ptm.addReporterIon(ReporterIon.iTRAQ8Plex_117);
        ptm.addReporterIon(ReporterIon.iTRAQ8Plex_118);
        ptm.addReporterIon(ReporterIon.iTRAQ8Plex_119);
        ptm.addReporterIon(ReporterIon.iTRAQ8Plex_121);
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 11);
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)1), 1);
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 20);
        atomChainAdded.append(new AtomImpl(Atom.N, (Integer)0), 2);
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0), 2);
        atomChainRemoved = null;
        aminoAcidPattern = null;
        ptmName = "TMT 2-plex of peptide N-term";
        ptm = new PTM(5, ptmName, "TMT", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:738", "TMT2plex", null));
        ptm.addReporterIon(ReporterIon.TMT_126);
        ptm.addReporterIon(ReporterIon.TMT_127C);
        ptm.addReporterIon(ReporterIon.TMT_126_ETD);
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 11);
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)1), 1);
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 20);
        atomChainAdded.append(new AtomImpl(Atom.N, (Integer)0), 2);
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0), 2);
        atomChainRemoved = null;
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("K");
        ptmName = "TMT 2-plex of K";
        ptm = new PTM(0, ptmName, "TMT", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:738", "TMT2plex", null));
        ptm.addReporterIon(ReporterIon.TMT_126);
        ptm.addReporterIon(ReporterIon.TMT_127C);
        ptm.addReporterIon(ReporterIon.TMT_126_ETD);
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 8);
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)1), 4);
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 20);
        atomChainAdded.append(new AtomImpl(Atom.N, (Integer)0), 1);
        atomChainAdded.append(new AtomImpl(Atom.N, (Integer)1), 1);
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0), 2);
        atomChainRemoved = null;
        aminoAcidPattern = null;
        ptmName = "TMT 6-plex of peptide N-term";
        ptm = new PTM(5, ptmName, "TMT", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:737", "TMT6plex", null));
        ptm.addReporterIon(ReporterIon.TMT_126);
        ptm.addReporterIon(ReporterIon.TMT_127N);
        ptm.addReporterIon(ReporterIon.TMT_128C);
        ptm.addReporterIon(ReporterIon.TMT_129N);
        ptm.addReporterIon(ReporterIon.TMT_130C);
        ptm.addReporterIon(ReporterIon.TMT_131);
        ptm.addReporterIon(ReporterIon.TMT_126);
        ptm.addReporterIon(ReporterIon.TMT_127N);
        ptm.addReporterIon(ReporterIon.TMT_128C);
        ptm.addReporterIon(ReporterIon.TMT_129N);
        ptm.addReporterIon(ReporterIon.TMT_130C);
        ptm.addReporterIon(ReporterIon.TMT_131);
        ptm.addReporterIon(ReporterIon.TMT_126_ETD);
        ptm.addReporterIon(ReporterIon.TMT_127N_ETD);
        ptm.addReporterIon(ReporterIon.TMT_128C_ETD);
        ptm.addReporterIon(ReporterIon.TMT_129N_ETD);
        ptm.addReporterIon(ReporterIon.TMT_130C_ETD);
        ptm.addReporterIon(ReporterIon.TMT_131_ETD);
        ptm.addReporterIon(ReporterIon.TMT_126_ETD);
        ptm.addReporterIon(ReporterIon.TMT_127N_ETD);
        ptm.addReporterIon(ReporterIon.TMT_128C_ETD);
        ptm.addReporterIon(ReporterIon.TMT_129N_ETD);
        ptm.addReporterIon(ReporterIon.TMT_130C_ETD);
        ptm.addReporterIon(ReporterIon.TMT_131_ETD);
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 8);
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)1), 4);
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 20);
        atomChainAdded.append(new AtomImpl(Atom.N, (Integer)0), 1);
        atomChainAdded.append(new AtomImpl(Atom.N, (Integer)1), 1);
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0), 2);
        atomChainRemoved = null;
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("K");
        ptmName = "TMT 6-plex of K";
        ptm = new PTM(0, ptmName, "TMT", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:737", "TMT6plex", null));
        ptm.addReporterIon(ReporterIon.TMT_126);
        ptm.addReporterIon(ReporterIon.TMT_127N);
        ptm.addReporterIon(ReporterIon.TMT_128C);
        ptm.addReporterIon(ReporterIon.TMT_129N);
        ptm.addReporterIon(ReporterIon.TMT_130C);
        ptm.addReporterIon(ReporterIon.TMT_131);
        ptm.addReporterIon(ReporterIon.TMT_126);
        ptm.addReporterIon(ReporterIon.TMT_127N);
        ptm.addReporterIon(ReporterIon.TMT_128C);
        ptm.addReporterIon(ReporterIon.TMT_129N);
        ptm.addReporterIon(ReporterIon.TMT_130C);
        ptm.addReporterIon(ReporterIon.TMT_131);
        ptm.addReporterIon(ReporterIon.TMT_126_ETD);
        ptm.addReporterIon(ReporterIon.TMT_127N_ETD);
        ptm.addReporterIon(ReporterIon.TMT_128C_ETD);
        ptm.addReporterIon(ReporterIon.TMT_129N_ETD);
        ptm.addReporterIon(ReporterIon.TMT_130C_ETD);
        ptm.addReporterIon(ReporterIon.TMT_131_ETD);
        ptm.addReporterIon(ReporterIon.TMT_126_ETD);
        ptm.addReporterIon(ReporterIon.TMT_127N_ETD);
        ptm.addReporterIon(ReporterIon.TMT_128C_ETD);
        ptm.addReporterIon(ReporterIon.TMT_129N_ETD);
        ptm.addReporterIon(ReporterIon.TMT_130C_ETD);
        ptm.addReporterIon(ReporterIon.TMT_131_ETD);
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 8);
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)1), 4);
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 20);
        atomChainAdded.append(new AtomImpl(Atom.N, (Integer)0), 1);
        atomChainAdded.append(new AtomImpl(Atom.N, (Integer)1), 1);
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0), 2);
        atomChainRemoved = null;
        aminoAcidPattern = null;
        ptmName = "TMT 10-plex of peptide N-term";
        ptm = new PTM(5, ptmName, "TMT", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:737", "TMT6plex", null));
        ptm.addReporterIon(ReporterIon.TMT_126);
        ptm.addReporterIon(ReporterIon.TMT_127C);
        ptm.addReporterIon(ReporterIon.TMT_127N);
        ptm.addReporterIon(ReporterIon.TMT_128C);
        ptm.addReporterIon(ReporterIon.TMT_128N);
        ptm.addReporterIon(ReporterIon.TMT_129C);
        ptm.addReporterIon(ReporterIon.TMT_129N);
        ptm.addReporterIon(ReporterIon.TMT_130C);
        ptm.addReporterIon(ReporterIon.TMT_130N);
        ptm.addReporterIon(ReporterIon.TMT_131);
        ptm.addReporterIon(ReporterIon.TMT_126_ETD);
        ptm.addReporterIon(ReporterIon.TMT_127C_ETD);
        ptm.addReporterIon(ReporterIon.TMT_127N_ETD);
        ptm.addReporterIon(ReporterIon.TMT_128C_ETD);
        ptm.addReporterIon(ReporterIon.TMT_128N_ETD);
        ptm.addReporterIon(ReporterIon.TMT_129C_ETD);
        ptm.addReporterIon(ReporterIon.TMT_129N_ETD);
        ptm.addReporterIon(ReporterIon.TMT_130C_ETD);
        ptm.addReporterIon(ReporterIon.TMT_130N_ETD);
        ptm.addReporterIon(ReporterIon.TMT_131_ETD);
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 8);
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)1), 4);
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 20);
        atomChainAdded.append(new AtomImpl(Atom.N, (Integer)0), 1);
        atomChainAdded.append(new AtomImpl(Atom.N, (Integer)1), 1);
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0), 2);
        atomChainRemoved = null;
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("K");
        ptmName = "TMT 10-plex of K";
        ptm = new PTM(0, ptmName, "TMT", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:737", "TMT6plex", null));
        ptm.addReporterIon(ReporterIon.TMT_126);
        ptm.addReporterIon(ReporterIon.TMT_127C);
        ptm.addReporterIon(ReporterIon.TMT_127N);
        ptm.addReporterIon(ReporterIon.TMT_128C);
        ptm.addReporterIon(ReporterIon.TMT_128N);
        ptm.addReporterIon(ReporterIon.TMT_129C);
        ptm.addReporterIon(ReporterIon.TMT_129N);
        ptm.addReporterIon(ReporterIon.TMT_130C);
        ptm.addReporterIon(ReporterIon.TMT_130N);
        ptm.addReporterIon(ReporterIon.TMT_131);
        ptm.addReporterIon(ReporterIon.TMT_126_ETD);
        ptm.addReporterIon(ReporterIon.TMT_127C_ETD);
        ptm.addReporterIon(ReporterIon.TMT_127N_ETD);
        ptm.addReporterIon(ReporterIon.TMT_128C_ETD);
        ptm.addReporterIon(ReporterIon.TMT_128N_ETD);
        ptm.addReporterIon(ReporterIon.TMT_129C_ETD);
        ptm.addReporterIon(ReporterIon.TMT_129N_ETD);
        ptm.addReporterIon(ReporterIon.TMT_130C_ETD);
        ptm.addReporterIon(ReporterIon.TMT_130N_ETD);
        ptm.addReporterIon(ReporterIon.TMT_131_ETD);
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 4);
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 6);
        atomChainAdded.append(new AtomImpl(Atom.N, (Integer)0), 2);
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0), 2);
        atomChainRemoved = null;
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("K");
        ptmName = "Ubiquitination of K";
        ptm = new PTM(0, ptmName, "ub", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:121", "GG", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0));
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 2);
        atomChainRemoved = null;
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("K");
        ptmName = "Methylation of K";
        ptm = new PTM(0, ptmName, "meth", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:34", "Methyl", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0));
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 2);
        atomChainRemoved = null;
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("R");
        ptmName = "Methylation of R";
        ptm = new PTM(0, ptmName, "meth", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:34", "Methyl", null));
        ptm.addReporterIon(ReporterIon.METHYL_R_70);
        ptm.addReporterIon(ReporterIon.METHYL_R_87);
        ptm.addReporterIon(ReporterIon.METHYL_R_112);
        ptm.addReporterIon(ReporterIon.METHYL_R_115);
        ptm.addReporterIon(ReporterIon.METHYL_R_143);
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 1);
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 2);
        atomChainRemoved = null;
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("E");
        ptmName = "Methylation of E";
        ptm = new PTM(0, ptmName, "meth", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:34", "Methyl", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 1);
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 2);
        atomChainRemoved = null;
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("C");
        ptmName = "Methylation of C";
        ptm = new PTM(0, ptmName, "meth", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:34", "Methyl", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 1);
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 2);
        atomChainRemoved = null;
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("D");
        ptmName = "Methylation of D";
        ptm = new PTM(0, ptmName, "meth", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:34", "Methyl", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 1);
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 2);
        atomChainRemoved = null;
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("S");
        ptmName = "Methylation of S";
        ptm = new PTM(0, ptmName, "meth", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:34", "Methyl", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 2);
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 4);
        atomChainRemoved = null;
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("K");
        ptmName = "Dimethylation of K";
        ptm = new PTM(0, ptmName, "dimeth", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:36", "Dimethyl", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 2);
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 4);
        atomChainRemoved = null;
        aminoAcidPattern = null;
        ptmName = "Dimethylation of peptide N-term";
        ptm = new PTM(5, ptmName, "dimeth", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:36", "Dimethyl", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 2);
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 4);
        atomChainRemoved = null;
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("R");
        ptmName = "Dimethylation of R";
        ptm = new PTM(0, ptmName, "dimeth", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:36", "Dimethyl", null));
        ptm.addReporterIon(ReporterIon.DI_METHYL_R_112);
        ptm.addReporterIon(ReporterIon.DI_METHYL_R_115);
        ptm.addReporterIon(ReporterIon.DI_METHYL_R_157);
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 3);
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 6);
        atomChainRemoved = null;
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("K");
        ptmName = "Trimethylation of K";
        ptm = new PTM(0, ptmName, "trimeth", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:37", "Trimethyl", null));
        ptm.addNeutralLoss(NeutralLoss.C3H9N);
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 3);
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 6);
        atomChainRemoved = null;
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("R");
        ptmName = "Trimethylation of R";
        ptm = new PTM(0, ptmName, "trimeth", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:37", "Trimethyl", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 3);
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 6);
        atomChainRemoved = null;
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("A");
        ptmName = "Trimethylation of protein N-term A";
        ptm = new PTM(1, ptmName, "trimeth", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:37", "Trimethyl", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = null;
        atomChainRemoved = new AtomChain();
        atomChainRemoved.append(new AtomImpl(Atom.O, (Integer)0), 1);
        atomChainRemoved.append(new AtomImpl(Atom.H, (Integer)0), 2);
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("E");
        ptmName = "Pyrolidone from E";
        ptm = new PTM(6, ptmName, "pyro", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:27", "Glu->pyro-Glu", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = null;
        atomChainRemoved = new AtomChain();
        atomChainRemoved.append(new AtomImpl(Atom.N, (Integer)0), 1);
        atomChainRemoved.append(new AtomImpl(Atom.H, (Integer)0), 3);
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("Q");
        ptmName = "Pyrolidone from Q";
        ptm = new PTM(6, ptmName, "pyro", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:28", "Gln->pyro-Glu", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = null;
        atomChainRemoved = new AtomChain();
        atomChainRemoved.append(new AtomImpl(Atom.N, (Integer)0), 1);
        atomChainRemoved.append(new AtomImpl(Atom.H, (Integer)0), 3);
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("C");
        ptmName = "Pyrolidone from carbamidomethylated C";
        ptm = new PTM(6, ptmName, "pyro", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:385", "Ammonia-loss", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 8);
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 13);
        atomChainAdded.append(new AtomImpl(Atom.N, (Integer)0));
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0), 5);
        atomChainRemoved = null;
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("S");
        ptmName = "HexNAc of S";
        ptm = new PTM(0, ptmName, "glyco", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:43", "HexNAc", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 8);
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 13);
        atomChainAdded.append(new AtomImpl(Atom.N, (Integer)0));
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0), 5);
        atomChainRemoved = null;
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("T");
        ptmName = "HexNAc of T";
        ptm = new PTM(0, ptmName, "glyco", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:43", "HexNAc", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 14);
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 23);
        atomChainAdded.append(new AtomImpl(Atom.N, (Integer)0));
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0), 10);
        atomChainRemoved = null;
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("S");
        ptmName = "Hex(1)NAc(1) of S";
        ptm = new PTM(0, ptmName, "glyco", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:793", "Hex(1)HexNAc(1) ", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 14);
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 23);
        atomChainAdded.append(new AtomImpl(Atom.N, (Integer)0));
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0), 10);
        atomChainRemoved = null;
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("T");
        ptmName = "Hex(1)NAc(1) of T";
        ptm = new PTM(0, ptmName, "glyco", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:793", "Hex(1)HexNAc(1) ", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 6);
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 10);
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0), 5);
        atomChainRemoved = null;
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("K");
        ptmName = "Hexose of K";
        ptm = new PTM(0, ptmName, "hex", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:41", "Hex", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 84);
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 136);
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0), 61);
        atomChainAdded.append(new AtomImpl(Atom.N, (Integer)0), 6);
        atomChainRemoved = null;
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("N");
        ptmName = "Hex(5) HexNAc(4) NeuAc(2) of N";
        ptm = new PTM(0, ptmName, "glyco", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 84);
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 135);
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0), 61);
        atomChainAdded.append(new AtomImpl(Atom.N, (Integer)0), 6);
        atomChainAdded.append(new AtomImpl(Atom.Na, (Integer)0), 1);
        atomChainRemoved = null;
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("N");
        ptmName = "Hex(5) HexNAc(4) NeuAc(2) Na of N";
        ptm = new PTM(0, ptmName, "glyco", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:1408", "Hex(5)HexNAc(4)NeuAc(2) ", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 18);
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 29);
        atomChainAdded.append(new AtomImpl(Atom.N, (Integer)0), 7);
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0), 8);
        atomChainRemoved = null;
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("K");
        ptmName = "SUMO-2/3 Q87R";
        ptm = new PTM(0, ptmName, "sumo", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.addReporterIon(ReporterIon.QQ);
        ptm.addReporterIon(ReporterIon.QQ_H2O);
        ptm.addReporterIon(ReporterIon.QQT);
        ptm.addReporterIon(ReporterIon.QQT_H2O);
        ptm.addReporterIon(ReporterIon.QQTG);
        ptm.addReporterIon(ReporterIon.QQTG_H2O);
        ptm.addReporterIon(ReporterIon.QQTGG);
        ptm.addReporterIon(ReporterIon.QQTGG_H2O);
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0), 1);
        atomChainRemoved = new AtomChain();
        atomChainRemoved.append(new AtomImpl(Atom.N, (Integer)0), 1);
        atomChainRemoved.append(new AtomImpl(Atom.H, (Integer)0), 1);
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("N");
        ptmName = "Deamidation of N";
        ptm = new PTM(0, ptmName, "deam", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:7", "Deamidated", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0), 1);
        atomChainRemoved = new AtomChain();
        atomChainRemoved.append(new AtomImpl(Atom.N, (Integer)0), 1);
        atomChainRemoved.append(new AtomImpl(Atom.H, (Integer)0), 1);
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("Q");
        ptmName = "Deamidation of Q";
        ptm = new PTM(0, ptmName, "deam", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:7", "Deamidated", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)2), 1);
        atomChainRemoved = new AtomChain();
        atomChainRemoved.append(new AtomImpl(Atom.N, (Integer)0), 1);
        atomChainRemoved.append(new AtomImpl(Atom.H, (Integer)0), 1);
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("N");
        ptmName = "Deamidation of N 18O";
        ptm = new PTM(0, ptmName, "deam", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD: 366", "Deamidation in presence of O18", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0));
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0));
        atomChainAdded.append(new AtomImpl(Atom.N, (Integer)0));
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0));
        atomChainRemoved = null;
        aminoAcidPattern = null;
        ptmName = "Carbamilation of protein N-term";
        ptm = new PTM(1, ptmName, "cm", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:5", "Carbamyl", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0));
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0));
        atomChainAdded.append(new AtomImpl(Atom.N, (Integer)0));
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0));
        atomChainRemoved = null;
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("K");
        ptmName = "Carbamilation of K";
        ptm = new PTM(0, ptmName, "cm", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:5", "Carbamyl", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 2);
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 2);
        atomChainRemoved = null;
        aminoAcidPattern = null;
        ptmName = "Acetaldehyde +26";
        ptm = new PTM(5, ptmName, "ace", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:254", "Delta:H(2)C(2)", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.Na, (Integer)0), 1);
        atomChainRemoved = new AtomChain();
        atomChainRemoved.append(new AtomImpl(Atom.H, (Integer)0), 1);
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("D");
        ptmName = "Sodium adduct to D";
        ptm = new PTM(0, ptmName, "Na", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:30", "Cation:Na", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.Na, (Integer)0), 1);
        atomChainRemoved = new AtomChain();
        atomChainRemoved.append(new AtomImpl(Atom.H, (Integer)0), 1);
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("E");
        ptmName = "Sodium adduct to E";
        ptm = new PTM(0, ptmName, "Na", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:30", "Cation:Na", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 1);
        atomChainAdded.append(new AtomImpl(Atom.N, (Integer)0), 1);
        atomChainRemoved = new AtomChain();
        atomChainRemoved.append(new AtomImpl(Atom.O, (Integer)0), 1);
        aminoAcidPattern = null;
        ptmName = "Amidation of the peptide C-term";
        ptm = new PTM(7, ptmName, "am", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:2", "Amidated", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 1);
        atomChainAdded.append(new AtomImpl(Atom.N, (Integer)0), 1);
        atomChainRemoved = new AtomChain();
        atomChainRemoved.append(new AtomImpl(Atom.O, (Integer)0), 1);
        aminoAcidPattern = null;
        ptmName = "Amidation of the protein C-term";
        ptm = new PTM(3, ptmName, "am", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:2", "Amidated", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0), 3);
        atomChainAdded.append(new AtomImpl(Atom.S, (Integer)0), 1);
        atomChainRemoved = null;
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("S");
        ptmName = "Sulfation of S";
        ptm = new PTM(0, ptmName, "s", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:40", "Sulfo", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0), 3);
        atomChainAdded.append(new AtomImpl(Atom.S, (Integer)0), 1);
        atomChainRemoved = null;
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("T");
        ptmName = "Sulfation of T";
        ptm = new PTM(0, ptmName, "s", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:40", "Sulfo", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0), 3);
        atomChainAdded.append(new AtomImpl(Atom.S, (Integer)0), 1);
        atomChainRemoved = null;
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("Y");
        ptmName = "Sulfation of Y";
        ptm = new PTM(0, ptmName, "s", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:40", "Sulfo", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 30);
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 16);
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0), 1);
        atomChainRemoved = null;
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("C");
        ptmName = "Palmitoylation of C";
        ptm = new PTM(0, ptmName, "palm", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:47", "Palmitoylation", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 30);
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 16);
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0), 1);
        atomChainRemoved = null;
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("K");
        ptmName = "Palmitoylation of K";
        ptm = new PTM(0, ptmName, "palm", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:47", "Palmitoylation", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 30);
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 16);
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0), 1);
        atomChainRemoved = null;
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("S");
        ptmName = "Palmitoylation of S";
        ptm = new PTM(0, ptmName, "palm", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:47", "Palmitoylation", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 30);
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 16);
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0), 1);
        atomChainRemoved = null;
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("T");
        ptmName = "Palmitoylation of T";
        ptm = new PTM(0, ptmName, "palm", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:47", "Palmitoylation", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 30);
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 16);
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0), 1);
        atomChainRemoved = null;
        aminoAcidPattern = null;
        ptmName = "Palmitoylation of protein N-term";
        ptm = new PTM(1, ptmName, "palm", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:47", "Palmitoylation", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 1);
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0), 1);
        atomChainRemoved = null;
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("K");
        ptmName = "Formylation of K";
        ptm = new PTM(0, ptmName, "form", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:122", "Formylation", null));
        ptm.addReporterIon(ReporterIon.FORMYL_K);
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 1);
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0), 1);
        atomChainRemoved = null;
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("S");
        ptmName = "Formylation of S";
        ptm = new PTM(0, ptmName, "form", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:122", "Formylation", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 1);
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0), 1);
        atomChainRemoved = null;
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("T");
        ptmName = "Formylation of T";
        ptm = new PTM(0, ptmName, "form", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:122", "Formylation", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 1);
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0), 1);
        atomChainRemoved = null;
        aminoAcidPattern = null;
        ptmName = "Formylation of peptide N-term";
        ptm = new PTM(5, ptmName, "form", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:122", "Formylation", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 1);
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0), 1);
        atomChainRemoved = null;
        aminoAcidPattern = null;
        ptmName = "Formylation of protein N-term";
        ptm = new PTM(1, ptmName, "form", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:122", "Formylation", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 4);
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 3);
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0), 1);
        atomChainRemoved = null;
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("K");
        ptmName = "Propionyl of K light";
        ptm = new PTM(0, ptmName, "prop", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:58", "Propionyl", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 4);
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 3);
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0), 1);
        atomChainRemoved = null;
        aminoAcidPattern = null;
        ptmName = "Propionyl of peptide N-term light";
        ptm = new PTM(5, ptmName, "prop", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:58", "Propionyl", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 4);
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)1), 3);
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0), 1);
        atomChainRemoved = null;
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("K");
        ptmName = "Propionyl of K heavy";
        ptm = new PTM(0, ptmName, "prop", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:59", "Propionyl:13C(3)", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 4);
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)1), 3);
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0), 1);
        atomChainRemoved = null;
        aminoAcidPattern = null;
        ptmName = "Propionyl of peptide N-term heavy";
        ptm = new PTM(5, ptmName, "prop", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:59", "Propionyl:13C(3)", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)1), 3);
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 1);
        atomChainRemoved = new AtomChain();
        atomChainRemoved.append(new AtomImpl(Atom.H, (Integer)0), 1);
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("D");
        ptmName = "Trideuterated Methyl Ester of D";
        ptm = new PTM(0, ptmName, "methyl(d3)", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:298", "Methyl:2H(3)", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)1), 3);
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 1);
        atomChainRemoved = new AtomChain();
        atomChainRemoved.append(new AtomImpl(Atom.H, (Integer)0), 1);
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("E");
        ptmName = "Trideuterated Methyl Ester of E";
        ptm = new PTM(0, ptmName, "methyl(d3)", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:298", "Methyl:2H(3)", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)1), 3);
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 1);
        atomChainRemoved = new AtomChain();
        atomChainRemoved.append(new AtomImpl(Atom.H, (Integer)0), 1);
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("K");
        ptmName = "Trideuterated Methyl Ester of K";
        ptm = new PTM(0, ptmName, "methyl(d3)", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:298", "Methyl:2H(3)", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)1), 3);
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 1);
        atomChainRemoved = new AtomChain();
        atomChainRemoved.append(new AtomImpl(Atom.H, (Integer)0), 1);
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("R");
        ptmName = "Trideuterated Methyl Ester of R";
        ptm = new PTM(0, ptmName, "methyl(d3)", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:298", "Methyl:2H(3)", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)1), 3);
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 1);
        atomChainRemoved = new AtomChain();
        atomChainRemoved.append(new AtomImpl(Atom.H, (Integer)0), 1);
        aminoAcidPattern = null;
        ptmName = "Trideuterated Methyl Ester of peptide C-term";
        ptm = new PTM(5, ptmName, "methyl(d3)", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:298", "Methyl:2H(3)", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 2);
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 2);
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0), 2);
        atomChainRemoved = null;
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("C");
        ptmName = "Carboxymethylation of C";
        ptm = new PTM(0, ptmName, "carbox", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:6", "Carboxymethyl", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 24);
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 15);
        atomChainRemoved = null;
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("C");
        ptmName = "Farnesylation of C";
        ptm = new PTM(0, ptmName, "far", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:44", "Farnesyl", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 32);
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 20);
        atomChainRemoved = null;
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("C");
        ptmName = "Geranyl-geranyl of C";
        ptm = new PTM(0, ptmName, "geranyl", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:48", "GeranylGeranyl", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 2);
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 1);
        atomChainAdded.append(new AtomImpl(Atom.N, (Integer)0), 2);
        atomChainRemoved = null;
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("K");
        ptmName = "Guanidination of K";
        ptm = new PTM(0, ptmName, "guan", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:52", "Guanidinyl", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 2);
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 1);
        atomChainAdded.append(new AtomImpl(Atom.N, (Integer)0), 2);
        atomChainRemoved = null;
        aminoAcidPattern = null;
        ptmName = "Guanidination of peptide N-term";
        ptm = new PTM(5, ptmName, "guan", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:52", "Guanidinyl", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0), 1);
        atomChainRemoved = new AtomChain();
        atomChainRemoved.append(new AtomImpl(Atom.H, (Integer)0), 2);
        atomChainRemoved.append(new AtomImpl(Atom.C, (Integer)0), 1);
        atomChainRemoved.append(new AtomImpl(Atom.S, (Integer)0), 1);
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("M");
        ptmName = "Homoserine of peptide C-term M";
        ptm = new PTM(8, ptmName, "hse", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:10", "Met->Hse", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = null;
        atomChainRemoved = new AtomChain();
        atomChainRemoved.append(new AtomImpl(Atom.H, (Integer)0), 4);
        atomChainRemoved.append(new AtomImpl(Atom.C, (Integer)0), 1);
        atomChainRemoved.append(new AtomImpl(Atom.S, (Integer)0), 1);
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("M");
        ptmName = "Homoserine lactone of peptide C-term M";
        ptm = new PTM(8, ptmName, "hsel", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:11", "Met->Hsl", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 12);
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 8);
        atomChainAdded.append(new AtomImpl(Atom.S, (Integer)0), 2);
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0), 1);
        atomChainRemoved = null;
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("K");
        ptmName = "Lipoyl of K";
        ptm = new PTM(0, ptmName, "lip", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:42", "Lipoyl", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 2);
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 1);
        atomChainAdded.append(new AtomImpl(Atom.S, (Integer)0), 1);
        atomChainRemoved = null;
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("D");
        ptmName = "Methylthio of D";
        ptm = new PTM(0, ptmName, "mmts", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:39", "Methylthio", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 2);
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 1);
        atomChainAdded.append(new AtomImpl(Atom.S, (Integer)0), 1);
        atomChainRemoved = null;
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("N");
        ptmName = "Methylthio of N";
        ptm = new PTM(0, ptmName, "mmts", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:39", "Methylthio", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 2);
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 1);
        atomChainAdded.append(new AtomImpl(Atom.S, (Integer)0), 1);
        atomChainRemoved = null;
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("C");
        ptmName = "Methylthio of C";
        ptm = new PTM(0, ptmName, "mmts", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:39", "Methylthio", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 9);
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 5);
        atomChainAdded.append(new AtomImpl(Atom.N, (Integer)0), 1);
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0), 1);
        atomChainRemoved = null;
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("C");
        ptmName = "NIPCAM of C";
        ptm = new PTM(0, ptmName, "nipcam", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:17", "NIPCAM", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 5);
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 3);
        atomChainAdded.append(new AtomImpl(Atom.N, (Integer)0), 1);
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0), 1);
        atomChainRemoved = null;
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("C");
        ptmName = "Propionamide of C";
        ptm = new PTM(0, ptmName, "propam", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:24", "Propionamide", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 5);
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 3);
        atomChainAdded.append(new AtomImpl(Atom.N, (Integer)0), 1);
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0), 1);
        atomChainRemoved = null;
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("K");
        ptmName = "Propionamide of K";
        ptm = new PTM(0, ptmName, "propam", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:24", "Propionamide", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 5);
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 3);
        atomChainAdded.append(new AtomImpl(Atom.N, (Integer)0), 1);
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0), 1);
        atomChainRemoved = null;
        aminoAcidPattern = null;
        ptmName = "Propionamide of peptide N-term";
        ptm = new PTM(5, ptmName, "propam", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:24", "Propionamide", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 7);
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 7);
        atomChainAdded.append(new AtomImpl(Atom.N, (Integer)0), 1);
        atomChainRemoved = null;
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("C");
        ptmName = "Pyridylethyl of C";
        ptm = new PTM(0, ptmName, "pyri", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:31", "Pyridylethyl", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = null;
        atomChainRemoved = new AtomChain();
        atomChainRemoved.append(new AtomImpl(Atom.H, (Integer)0), 2);
        atomChainRemoved.append(new AtomImpl(Atom.O, (Integer)0), 1);
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("S");
        ptmName = "Dehydration of S";
        ptm = new PTM(0, ptmName, "dehyd", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:23", "Dehydrated", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = null;
        atomChainRemoved = new AtomChain();
        atomChainRemoved.append(new AtomImpl(Atom.H, (Integer)0), 2);
        atomChainRemoved.append(new AtomImpl(Atom.O, (Integer)0), 1);
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("T");
        ptmName = "Dehydration of T";
        ptm = new PTM(0, ptmName, "dehyd", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:23", "Dehydrated", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 7);
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0), 2);
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 6);
        atomChainAdded.append(new AtomImpl(Atom.N, (Integer)0), 1);
        atomChainRemoved = null;
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("C");
        ptmName = "Nethylmaleimide of C";
        ptm = new PTM(0, ptmName, "nem", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:108", "Nethylmaleimide", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 15);
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0), 6);
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 10);
        atomChainAdded.append(new AtomImpl(Atom.N, (Integer)0), 3);
        atomChainAdded.append(new AtomImpl(Atom.S, (Integer)0), 1);
        atomChainRemoved = null;
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("C");
        ptmName = "Glutathione of C";
        ptm = new PTM(0, ptmName, "glut", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:55", "Glutathione", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 9);
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0), 2);
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 6);
        atomChainAdded.append(new AtomImpl(Atom.N, (Integer)0), 1);
        atomChainAdded.append(new AtomImpl(Atom.S, (Integer)0), 1);
        atomChainRemoved = null;
        aminoAcidPattern = null;
        ptmName = "FormylMet of protein N-term";
        ptm = new PTM(1, ptmName, "nmet", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:107", "FormylMet", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = null;
        atomChainRemoved = new AtomChain();
        atomChainRemoved.append(new AtomImpl(Atom.H, (Integer)0), 2);
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("T");
        ptmName = "Didehydro of T";
        ptm = new PTM(0, ptmName, "didehyro", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:401", "Didehydro", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.H, (Integer)0), 4);
        atomChainAdded.append(new AtomImpl(Atom.C, (Integer)0), 3);
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0), 1);
        atomChainAdded.append(new AtomImpl(Atom.S, (Integer)0), 1);
        atomChainRemoved = null;
        aminoAcidPattern = null;
        ptmName = "Thioacyl of peptide N-term";
        ptm = new PTM(5, ptmName, "thioacyl", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:126", "Thioacyl", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.I, (Integer)0), 2);
        atomChainRemoved = new AtomChain();
        atomChainRemoved.append(new AtomImpl(Atom.H, (Integer)0), 2);
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("Y");
        ptmName = "Diiodination of Y";
        ptm = new PTM(0, ptmName, "diiodo", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:130", "Diiodo", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0), 1);
        atomChainRemoved = new AtomChain();
        atomChainRemoved.append(new AtomImpl(Atom.N, (Integer)0), 1);
        atomChainRemoved.append(new AtomImpl(Atom.H, (Integer)0), 1);
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("R");
        ptmName = "Citrullination of R";
        ptm = new PTM(0, ptmName, "cit", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:7", "Deamidated", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
        atomChainAdded = new AtomChain();
        atomChainAdded.append(new AtomImpl(Atom.N, (Integer)0), 1);
        atomChainAdded.append(new AtomImpl(Atom.O, (Integer)0), 1);
        atomChainRemoved = new AtomChain();
        atomChainRemoved.append(new AtomImpl(Atom.H, (Integer)0), 1);
        aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString("C");
        ptmName = "S-nitrosylation";
        ptm = new PTM(0, ptmName, "nitrosyl", atomChainAdded, atomChainRemoved, aminoAcidPattern);
        ptm.setCvTerm(new CvTerm("UNIMOD", "UNIMOD:275", "Nitrosyl", null));
        this.defaultMods.add(ptmName);
        this.ptmMap.put(ptmName, ptm);
    }
}

