/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.identification_parameters.tool_specific;

import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.identification.identification_parameters.IdentificationAlgorithmParameter;

public class XtandemParameters
implements IdentificationAlgorithmParameter {
    static final long serialVersionUID = -5898951075262732261L;
    private Double maxEValue = 0.01;
    private String outputResults = "all";
    private Double dynamicRange = 100.0;
    private Integer nPeaks = 50;
    private Double minPrecursorMass = 500.0;
    private Double minFragmentMz = 200.0;
    private Integer minPeaksPerSpectrum = 5;
    private Boolean proteinQuickAcetyl = true;
    private Boolean quickPyrolidone = true;
    private Boolean refine = true;
    private Boolean refineSemi = false;
    private Boolean refinePointMutations = false;
    private Boolean refineSpectrumSynthesis = true;
    private Boolean refineUnanticipatedCleavages = true;
    private Boolean refineSnaps = true;
    private Double maximumExpectationValueRefinement = 0.01;
    private Boolean potentialModificationsForFullRefinment = false;
    private String skylinePath = "";
    private Boolean outputProteins = true;
    private boolean outputSequences = false;
    private Boolean outputSpectra = true;
    private Boolean outputHistograms = false;
    private Boolean stpBias = false;
    private Boolean useNoiseSuppression = false;
    private Double proteinPtmComplexity = 6.0;

    public Double getDynamicRange() {
        return this.dynamicRange;
    }

    public void setDynamicRange(Double dynamicRange) {
        this.dynamicRange = dynamicRange;
    }

    public Integer getnPeaks() {
        return this.nPeaks;
    }

    public void setnPeaks(Integer nPeaks) {
        this.nPeaks = nPeaks;
    }

    public Double getMinPrecursorMass() {
        return this.minPrecursorMass;
    }

    public void setMinPrecursorMass(Double minPrecursorMass) {
        this.minPrecursorMass = minPrecursorMass;
    }

    public Double getMinFragmentMz() {
        return this.minFragmentMz;
    }

    public void setMinFragmentMz(Double minFragmentMz) {
        this.minFragmentMz = minFragmentMz;
    }

    public Integer getMinPeaksPerSpectrum() {
        return this.minPeaksPerSpectrum;
    }

    public void setMinPeaksPerSpectrum(Integer minPeaksPerSpectrum) {
        this.minPeaksPerSpectrum = minPeaksPerSpectrum;
    }

    public Boolean isProteinQuickAcetyl() {
        return this.proteinQuickAcetyl;
    }

    public void setProteinQuickAcetyl(Boolean proteinQuickAcetyl) {
        this.proteinQuickAcetyl = proteinQuickAcetyl;
    }

    public Boolean isQuickPyrolidone() {
        return this.quickPyrolidone;
    }

    public void setQuickPyrolidone(Boolean quickPyrolidone) {
        this.quickPyrolidone = quickPyrolidone;
    }

    public Boolean isRefine() {
        return this.refine;
    }

    public void setRefine(Boolean refine) {
        this.refine = refine;
    }

    public Boolean isStpBias() {
        return this.stpBias;
    }

    public void setStpBias(Boolean stpBias) {
        this.stpBias = stpBias;
    }

    public Double getMaxEValue() {
        return this.maxEValue;
    }

    public void setMaxEValue(Double maxEValue) {
        this.maxEValue = maxEValue;
    }

    public Boolean isRefineSemi() {
        return this.refineSemi;
    }

    public void setRefineSemi(Boolean refineSemi) {
        this.refineSemi = refineSemi;
    }

    public Boolean isRefinePointMutations() {
        return this.refinePointMutations;
    }

    public void setRefinePointMutations(Boolean refinePointMutations) {
        this.refinePointMutations = refinePointMutations;
    }

    public Boolean isRefineSpectrumSynthesis() {
        return this.refineSpectrumSynthesis;
    }

    public void setRefineSpectrumSynthesis(Boolean refineSpectrumSynthesis) {
        this.refineSpectrumSynthesis = refineSpectrumSynthesis;
    }

    public Boolean isRefineUnanticipatedCleavages() {
        return this.refineUnanticipatedCleavages;
    }

    public void setRefineUnanticipatedCleavages(Boolean refineUnanticipatedCleavages) {
        this.refineUnanticipatedCleavages = refineUnanticipatedCleavages;
    }

    public Double getMaximumExpectationValueRefinement() {
        return this.maximumExpectationValueRefinement;
    }

    public void setMaximumExpectationValueRefinement(Double maximumExpectationValue) {
        this.maximumExpectationValueRefinement = maximumExpectationValue;
    }

    public Boolean isPotentialModificationsForFullRefinment() {
        return this.potentialModificationsForFullRefinment;
    }

    public void setPotentialModificationsForFullRefinment(Boolean potentialModificationsForFullRefinment) {
        this.potentialModificationsForFullRefinment = potentialModificationsForFullRefinment;
    }

    public String getSkylinePath() {
        return this.skylinePath;
    }

    public void setSkylinePath(String skylinePath) {
        this.skylinePath = skylinePath;
    }

    public Boolean isOutputProteins() {
        return this.outputProteins;
    }

    public void setOutputProteins(Boolean outputProteins) {
        this.outputProteins = outputProteins;
    }

    public Boolean isOutputSequences() {
        return this.outputSequences;
    }

    public void setOutputSequences(boolean outputSequences) {
        this.outputSequences = outputSequences;
    }

    public Boolean isOutputSpectra() {
        return this.outputSpectra;
    }

    public void setOutputSpectra(Boolean outputSpectra) {
        this.outputSpectra = outputSpectra;
    }

    public Boolean isOutputHistograms() {
        return this.outputHistograms;
    }

    public void setOutputHistograms(Boolean outputHistograms) {
        this.outputHistograms = outputHistograms;
    }

    public Boolean isUseNoiseSuppression() {
        return this.useNoiseSuppression;
    }

    public void setUseNoiseSuppression(Boolean useNoiseSuppression) {
        this.useNoiseSuppression = useNoiseSuppression;
    }

    public Boolean isRefineSnaps() {
        return this.refineSnaps;
    }

    public void setRefineSnaps(Boolean refineSnaps) {
        this.refineSnaps = refineSnaps;
    }

    public String getOutputResults() {
        if (this.outputResults == null) {
            this.outputResults = "all";
        }
        return this.outputResults;
    }

    public void setOutputResults(String outputResults) {
        this.outputResults = outputResults;
    }

    public Double getProteinPtmComplexity() {
        if (this.proteinPtmComplexity == null) {
            this.proteinPtmComplexity = 6.0;
        }
        return this.proteinPtmComplexity;
    }

    public void setProteinPtmComplexity(Double proteinPtmComplexity) {
        this.proteinPtmComplexity = proteinPtmComplexity;
    }

    @Override
    public Advocate getAlgorithm() {
        return Advocate.xtandem;
    }

    @Override
    public boolean equals(IdentificationAlgorithmParameter identificationAlgorithmParameter) {
        if (identificationAlgorithmParameter instanceof XtandemParameters) {
            XtandemParameters xtandemParameters = (XtandemParameters)identificationAlgorithmParameter;
            double diff = Math.abs(this.maxEValue - xtandemParameters.getMaxEValue());
            if (diff > 1.0E-13) {
                return false;
            }
            diff = Math.abs(this.dynamicRange - xtandemParameters.getDynamicRange());
            if (diff > 1.0E-13) {
                return false;
            }
            if (this.getnPeaks().intValue() != xtandemParameters.getnPeaks().intValue()) {
                return false;
            }
            diff = Math.abs(this.minPrecursorMass - xtandemParameters.getMinPrecursorMass());
            if (diff > 1.0E-13) {
                return false;
            }
            diff = Math.abs(this.minFragmentMz - xtandemParameters.getMinFragmentMz());
            if (diff > 1.0E-13) {
                return false;
            }
            if (this.getMinPeaksPerSpectrum().intValue() != xtandemParameters.getMinPeaksPerSpectrum().intValue()) {
                return false;
            }
            if (this.isProteinQuickAcetyl().booleanValue() != xtandemParameters.isProteinQuickAcetyl().booleanValue()) {
                return false;
            }
            if (this.isQuickPyrolidone().booleanValue() != xtandemParameters.isQuickPyrolidone().booleanValue()) {
                return false;
            }
            if (this.isRefine().booleanValue() != xtandemParameters.isRefine().booleanValue()) {
                return false;
            }
            if (this.isRefineSemi().booleanValue() != xtandemParameters.isRefineSemi().booleanValue()) {
                return false;
            }
            if (this.isRefinePointMutations().booleanValue() != xtandemParameters.isRefinePointMutations().booleanValue()) {
                return false;
            }
            if (this.isRefineSpectrumSynthesis().booleanValue() != xtandemParameters.isRefineSpectrumSynthesis().booleanValue()) {
                return false;
            }
            if (this.isRefineUnanticipatedCleavages().booleanValue() != xtandemParameters.isRefineUnanticipatedCleavages().booleanValue()) {
                return false;
            }
            if (this.isRefineSnaps().booleanValue() != xtandemParameters.isRefineSnaps().booleanValue()) {
                return false;
            }
            diff = Math.abs(this.maximumExpectationValueRefinement - xtandemParameters.getMaximumExpectationValueRefinement());
            if (diff > 1.0E-13) {
                return false;
            }
            if (this.isPotentialModificationsForFullRefinment().booleanValue() != xtandemParameters.isPotentialModificationsForFullRefinment().booleanValue()) {
                return false;
            }
            if (!this.getSkylinePath().equals(xtandemParameters.getSkylinePath())) {
                return false;
            }
            if (this.isOutputProteins().booleanValue() != xtandemParameters.isOutputProteins().booleanValue()) {
                return false;
            }
            if (this.isOutputSpectra().booleanValue() != xtandemParameters.isOutputSpectra().booleanValue()) {
                return false;
            }
            if (this.isOutputSequences().booleanValue() != xtandemParameters.isOutputSequences().booleanValue()) {
                return false;
            }
            if (this.isOutputHistograms().booleanValue() != xtandemParameters.isOutputHistograms().booleanValue()) {
                return false;
            }
            if (this.isStpBias().booleanValue() != xtandemParameters.isStpBias().booleanValue()) {
                return false;
            }
            if (this.isUseNoiseSuppression().booleanValue() != xtandemParameters.isUseNoiseSuppression().booleanValue()) {
                return false;
            }
            if (!this.getOutputResults().equalsIgnoreCase(xtandemParameters.getOutputResults())) {
                return false;
            }
            return this.getProteinPtmComplexity().doubleValue() == xtandemParameters.getProteinPtmComplexity().doubleValue();
        }
        return false;
    }

    @Override
    public String toString(boolean html) {
        String newLine = System.getProperty("line.separator");
        if (html) {
            newLine = "<br>";
        }
        StringBuilder output = new StringBuilder();
        Advocate advocate = this.getAlgorithm();
        output.append("# ------------------------------------------------------------------");
        output.append(newLine);
        output.append("# ").append(advocate.getName()).append(" Specific Parameters");
        output.append(newLine);
        output.append("# ------------------------------------------------------------------");
        output.append(newLine);
        output.append(newLine);
        output.append("DYNAMIC_RANGE=");
        output.append(this.dynamicRange);
        output.append(newLine);
        output.append("NUMBER_OF_PEAKS=");
        output.append(this.nPeaks);
        output.append(newLine);
        output.append("MIN_FRAG_MASS=");
        output.append(this.minFragmentMz);
        output.append(newLine);
        output.append("MIN_NUMBER_OF_PEAKS=");
        output.append(this.minPeaksPerSpectrum);
        output.append(newLine);
        output.append("NOISE_SUPPRESSION=");
        if (this.useNoiseSuppression.booleanValue()) {
            output.append("YES");
        } else {
            output.append("NO");
        }
        output.append(newLine);
        output.append("MIN_PREC_MASS=");
        output.append(this.minPrecursorMass);
        output.append(newLine);
        output.append("PROTEIN_QUICK_ACETYL=");
        if (this.proteinQuickAcetyl.booleanValue()) {
            output.append("YES");
        } else {
            output.append("NO");
        }
        output.append(newLine);
        output.append("QUICK_PYROLIDONE=");
        if (this.quickPyrolidone.booleanValue()) {
            output.append("YES");
        } else {
            output.append("NO");
        }
        output.append(newLine);
        output.append("PROTEIN_PTM_COMPLEXITY=");
        output.append(this.getProteinPtmComplexity());
        output.append(newLine);
        output.append("STP_BIAS=");
        if (this.stpBias.booleanValue()) {
            output.append("YES");
        } else {
            output.append("NO");
        }
        output.append(newLine);
        output.append("REFINE=");
        if (this.refine.booleanValue()) {
            output.append("YES");
        } else {
            output.append("NO");
        }
        output.append(newLine);
        output.append("REFINE_SEMI=");
        if (this.refineSemi.booleanValue()) {
            output.append("YES");
        } else {
            output.append("NO");
        }
        output.append(newLine);
        output.append("REFINE_POINT_MUTATIONS=");
        if (this.refinePointMutations.booleanValue()) {
            output.append("YES");
        } else {
            output.append("NO");
        }
        output.append(newLine);
        output.append("REFINE_SPECTRUM_SYNTHESIS=");
        if (this.refineSpectrumSynthesis.booleanValue()) {
            output.append("YES");
        } else {
            output.append("NO");
        }
        output.append(newLine);
        output.append("REFINE_UNANTICIPATED_CLEABAGES=");
        if (this.refineUnanticipatedCleavages.booleanValue()) {
            output.append("YES");
        } else {
            output.append("NO");
        }
        output.append(newLine);
        output.append("REFINE_SNAPS=");
        if (this.refineSnaps.booleanValue()) {
            output.append("YES");
        } else {
            output.append("NO");
        }
        output.append(newLine);
        output.append("REFINE_MAX_EVALUE=");
        output.append(this.maximumExpectationValueRefinement);
        output.append(newLine);
        output.append("POTENTIAL_MODIFICATIONS_FOR_FULL_REFINEMENT=");
        if (this.potentialModificationsForFullRefinment.booleanValue()) {
            output.append("YES");
        } else {
            output.append("NO");
        }
        output.append(newLine);
        output.append("EVALUE_CUTOFF=");
        output.append(this.maxEValue);
        output.append(newLine);
        output.append("SKYLINE_PATH=");
        output.append(this.skylinePath);
        output.append(newLine);
        output.append("OUTPUT_RESULTS=");
        output.append(this.getOutputResults());
        output.append(newLine);
        output.append("OUTPUT_PROTEINS=");
        if (this.outputProteins.booleanValue()) {
            output.append("YES");
        } else {
            output.append("NO");
        }
        output.append(newLine);
        output.append("OUTPUT_SEQUENCES=");
        if (this.outputSequences) {
            output.append("YES");
        } else {
            output.append("NO");
        }
        output.append(newLine);
        output.append("OUTPUT_SPECTRA=");
        if (this.outputSpectra.booleanValue()) {
            output.append("YES");
        } else {
            output.append("NO");
        }
        output.append(newLine);
        output.append("OUTPUT_HISTOGRAMS=");
        if (this.outputHistograms.booleanValue()) {
            output.append("YES");
        } else {
            output.append("NO");
        }
        output.append(newLine);
        return output.toString();
    }
}

