/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.matches;

import com.compomics.util.experiment.biology.Enzyme;
import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.biology.Protein;
import com.compomics.util.experiment.identification.IdentificationMatch;
import com.compomics.util.experiment.identification.protein_sequences.SequenceFactory;
import com.compomics.util.preferences.SequenceMatchingPreferences;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class ProteinMatch
extends IdentificationMatch {
    static final long serialVersionUID = -6061842447053092696L;
    private ArrayList<String> theoreticProtein = new ArrayList();
    private String mainMatch;
    private ArrayList<String> peptideMatchesKeys = new ArrayList();
    public static final String PROTEIN_KEY_SPLITTER = "_cus_";
    private static HashMap<String, String[]> proteinGroupCache = new HashMap(1000);
    private static int cacheSize = 1000;
    private static int sizeOfProteinsInCache = 10;

    public ProteinMatch() {
    }

    public ProteinMatch(String proteinAccession) throws IllegalArgumentException {
        if (proteinAccession.contains(PROTEIN_KEY_SPLITTER)) {
            throw new IllegalArgumentException("Protein accession containing '_cus_' are not supported. Conflicting accession: " + this.mainMatch);
        }
        this.theoreticProtein.add(proteinAccession);
        this.mainMatch = proteinAccession;
    }

    public ProteinMatch(Peptide peptide, String peptideMatchKey) throws IOException, SQLException, ClassNotFoundException, InterruptedException {
        ArrayList<String> parentProteins = peptide.getParentProteinsNoRemapping();
        if (parentProteins == null || parentProteins.isEmpty()) {
            throw new IllegalArgumentException("Peptide " + peptide.getSequence() + " presents no parent protein.");
        }
        Collections.sort(parentProteins);
        for (String protein : parentProteins) {
            if (this.theoreticProtein.contains(protein)) continue;
            this.theoreticProtein.add(protein);
        }
        this.mainMatch = parentProteins.get(0);
        this.peptideMatchesKeys.add(peptideMatchKey);
    }

    public ArrayList<String> getTheoreticProteinsAccessions() {
        return this.theoreticProtein;
    }

    public void addTheoreticProtein(String proteinAccession) {
        this.theoreticProtein.add(proteinAccession);
    }

    public String getMainMatch() {
        return this.mainMatch;
    }

    public void setMainMatch(String mainMatch) {
        this.mainMatch = mainMatch;
    }

    public ArrayList<String> getPeptideMatchesKeys() {
        return this.peptideMatchesKeys;
    }

    public void addPeptideMatchKey(String peptideMatchKey) {
        if (!this.peptideMatchesKeys.contains(peptideMatchKey)) {
            this.peptideMatchesKeys.add(peptideMatchKey);
        }
    }

    public void setPeptideKeys(ArrayList<String> peptideMatchKeys) {
        this.peptideMatchesKeys = peptideMatchKeys;
    }

    public int getPeptideCount() {
        return this.peptideMatchesKeys.size();
    }

    public boolean isDecoy() {
        for (String accession : this.theoreticProtein) {
            if (!SequenceFactory.getInstance().isDecoyAccession(accession)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDecoy(String key) {
        SequenceFactory sequenceFactory = SequenceFactory.getInstance();
        for (String accession : ProteinMatch.getAccessions(key)) {
            if (!sequenceFactory.isDecoyAccession(accession)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getKey() {
        Collections.sort(this.theoreticProtein);
        StringBuilder result = new StringBuilder();
        for (String accession : this.theoreticProtein) {
            if (result.length() != 0) {
                result.append(PROTEIN_KEY_SPLITTER);
            }
            result.append(accession);
        }
        return result.toString();
    }

    public static String getProteinMatchKey(Peptide peptide) throws IOException, SQLException, ClassNotFoundException, InterruptedException {
        ArrayList<String> accessions = peptide.getParentProteinsNoRemapping();
        if (accessions == null) {
            throw new IllegalArgumentException("Proteins not set for peptide " + peptide.getKey() + ".");
        }
        HashSet<String> uniqueAccessions = new HashSet<String>(accessions);
        accessions = new ArrayList<String>(uniqueAccessions);
        Collections.sort(accessions);
        StringBuilder key = new StringBuilder(accessions.size() * 6);
        for (String accession : accessions) {
            if (key.length() > 0) {
                key.append(PROTEIN_KEY_SPLITTER);
            }
            key.append(accession);
        }
        return key.toString();
    }

    public static int getNProteins(String matchKey) {
        return ProteinMatch.getAccessions(matchKey).length;
    }

    public int getNProteins() {
        return this.theoreticProtein.size();
    }

    public static boolean contains(String sharedKey, String uniqueKey) {
        List<String> sharedAccessions = Arrays.asList(ProteinMatch.getAccessions(sharedKey));
        for (String uniqueAccession : ProteinMatch.getAccessions(uniqueKey)) {
            if (sharedAccessions.contains(uniqueAccession)) continue;
            return false;
        }
        return true;
    }

    public static boolean contains(HashSet<String> sharedAccessions, ArrayList<String> uniqueKeys) {
        for (String uniqueAccession : uniqueKeys) {
            if (sharedAccessions.contains(uniqueAccession)) continue;
            return false;
        }
        return true;
    }

    public static ArrayList<String> getOtherProteins(String group1, String group2) {
        String[] group1Proteins = ProteinMatch.getAccessions(group1);
        List<String> group2Proteins = Arrays.asList(ProteinMatch.getAccessions(group2));
        ArrayList<String> result = new ArrayList<String>();
        for (String sharedAccession : group1Proteins) {
            if (group2Proteins.contains(sharedAccession)) continue;
            result.add(sharedAccession);
        }
        return result;
    }

    public static ArrayList<String> getCommonProteins(String group1, String group2) {
        String[] group1Proteins = ProteinMatch.getAccessions(group1);
        List<String> group2Proteins = Arrays.asList(ProteinMatch.getAccessions(group2));
        ArrayList<String> result = new ArrayList<String>();
        for (String sharedAccession : group1Proteins) {
            if (!group2Proteins.contains(sharedAccession)) continue;
            result.add(sharedAccession);
        }
        return result;
    }

    public boolean contains(ProteinMatch proteinMatch) {
        if (this.getKey().equals(proteinMatch.getKey())) {
            return false;
        }
        for (String accession : proteinMatch.getTheoreticProteinsAccessions()) {
            if (this.theoreticProtein.contains(accession)) continue;
            return false;
        }
        return true;
    }

    public boolean contains(String aProtein) {
        return this.theoreticProtein.contains(aProtein);
    }

    public static String[] getAccessions(String groupKey) {
        String[] result = proteinGroupCache.get(groupKey);
        if (result == null && (result = groupKey.split(PROTEIN_KEY_SPLITTER)).length > sizeOfProteinsInCache) {
            proteinGroupCache.put(groupKey, result);
            if (proteinGroupCache.size() > cacheSize) {
                int smallestSize = sizeOfProteinsInCache;
                String smallestGroup = null;
                for (String key : proteinGroupCache.keySet()) {
                    String[] group = proteinGroupCache.get(key);
                    if (smallestGroup != null && group.length >= smallestSize) continue;
                    smallestGroup = key;
                    smallestSize = group.length;
                }
                proteinGroupCache.remove(smallestGroup);
                sizeOfProteinsInCache = smallestSize;
            }
        }
        return result;
    }

    public static void clearCache() {
        proteinGroupCache.clear();
        sizeOfProteinsInCache = 10;
    }

    public boolean hasEnzymaticPeptide(String accession, ArrayList<Enzyme> enzymes, SequenceMatchingPreferences sequenceMatchingPreferences) throws IOException, InterruptedException, ClassNotFoundException {
        SequenceFactory sequenceFactory = SequenceFactory.getInstance();
        for (String peptideKey : this.peptideMatchesKeys) {
            String peptideSequence = Peptide.getSequence(peptideKey);
            Protein protein = sequenceFactory.getProtein(accession);
            if (!protein.isEnzymaticPeptide(peptideSequence, enzymes, sequenceMatchingPreferences)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IdentificationMatch.MatchType getType() {
        return IdentificationMatch.MatchType.Protein;
    }
}

