/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.protein_inference;

import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.matches.VariantMatch;
import com.compomics.util.preferences.SequenceMatchingPreferences;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;

public class PeptideProteinMapping {
    private String proteinAccession;
    private String peptideSequence;
    private int index;
    private ArrayList<ModificationMatch> modificationMatches = null;
    private ArrayList<VariantMatch> variantMatches = null;

    public PeptideProteinMapping(String proteinAccession, String peptideSequence, int index) {
        this.proteinAccession = proteinAccession;
        this.peptideSequence = peptideSequence;
        this.index = index;
    }

    public PeptideProteinMapping(String proteinAccession, String peptideSequence, int index, ArrayList<ModificationMatch> modificationMatches) {
        this.proteinAccession = proteinAccession;
        this.peptideSequence = peptideSequence;
        this.index = index;
        this.modificationMatches = modificationMatches;
    }

    public PeptideProteinMapping(String proteinAccession, String peptideSequence, int index, ArrayList<ModificationMatch> modificationMatches, ArrayList<VariantMatch> variantMatches) {
        this.proteinAccession = proteinAccession;
        this.peptideSequence = peptideSequence;
        this.index = index;
        this.modificationMatches = modificationMatches;
        this.variantMatches = variantMatches;
    }

    public String getProteinAccession() {
        return this.proteinAccession;
    }

    public String getPeptideSequence() {
        return this.peptideSequence;
    }

    public int getIndex() {
        return this.index;
    }

    public ArrayList<ModificationMatch> getModificationMatches() {
        return this.modificationMatches;
    }

    public ArrayList<VariantMatch> getVariantMatches() {
        return this.variantMatches;
    }

    public static HashMap<String, HashMap<String, ArrayList<Integer>>> getPeptideProteinIndexesMap(ArrayList<PeptideProteinMapping> peptideProteinMappings) {
        HashMap<String, HashMap<String, ArrayList<Integer>>> result = new HashMap<String, HashMap<String, ArrayList<Integer>>>(2);
        for (PeptideProteinMapping peptideProteinMapping : peptideProteinMappings) {
            String accession;
            ArrayList<Integer> indexes;
            String peptideSequence = peptideProteinMapping.getPeptideSequence();
            HashMap<String, ArrayList<Integer>> proteins = result.get(peptideSequence);
            if (proteins == null) {
                proteins = new HashMap(2);
                result.put(peptideSequence, proteins);
            }
            if ((indexes = proteins.get(accession = peptideProteinMapping.getProteinAccession())) == null) {
                indexes = new ArrayList(2);
                proteins.put(accession, indexes);
            }
            indexes.add(peptideProteinMapping.getIndex());
        }
        return result;
    }

    public static HashMap<String, HashSet<String>> getPeptideProteinMap(ArrayList<PeptideProteinMapping> peptideProteinMappings) {
        HashMap<String, HashSet<String>> result = new HashMap<String, HashSet<String>>(peptideProteinMappings.size());
        for (PeptideProteinMapping peptideProteinMapping : peptideProteinMappings) {
            String peptideSequence = peptideProteinMapping.getPeptideSequence();
            HashSet<String> proteins = result.get(peptideSequence);
            if (proteins == null) {
                proteins = new HashSet(1);
                result.put(peptideSequence, proteins);
            }
            String accession = peptideProteinMapping.getProteinAccession();
            proteins.add(accession);
        }
        return result;
    }

    public static Collection<Peptide> getPeptides(ArrayList<PeptideProteinMapping> peptideProteinMappings, SequenceMatchingPreferences sequenceMatchingPreferences) {
        Peptide peptide;
        HashMap<String, Peptide> peptidesMap = new HashMap<String, Peptide>(peptideProteinMappings.size());
        HashMap<String, HashSet<String>> proteinsMap = new HashMap<String, HashSet<String>>(peptideProteinMappings.size());
        for (PeptideProteinMapping peptideProteinMapping : peptideProteinMappings) {
            HashSet<String> proteins;
            Peptide tempPeptide = new Peptide(peptideProteinMapping.getPeptideSequence(), peptideProteinMapping.getModificationMatches());
            String peptideKey = tempPeptide.getMatchingKey(sequenceMatchingPreferences);
            peptide = (Peptide)peptidesMap.get(peptideKey);
            if (peptide == null) {
                tempPeptide.addVariantMatches(peptideProteinMapping.getVariantMatches());
                peptidesMap.put(peptideKey, tempPeptide);
                proteins = new HashSet<String>(1);
                proteins.add(peptideProteinMapping.getProteinAccession());
                proteinsMap.put(peptideKey, proteins);
                continue;
            }
            peptide.addVariantMatches(peptideProteinMapping.getVariantMatches());
            proteins = (HashSet<String>)proteinsMap.get(peptideKey);
            proteins.add(peptideProteinMapping.getProteinAccession());
        }
        for (String peptideKey : peptidesMap.keySet()) {
            HashSet proteins = (HashSet)proteinsMap.get(peptideKey);
            ArrayList<String> sortedProteinList = new ArrayList<String>(proteins);
            Collections.sort(sortedProteinList);
            peptide = (Peptide)peptidesMap.get(peptideKey);
            peptide.setParentProteins(sortedProteinList);
        }
        return peptidesMap.values();
    }
}

