/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.protein_sequences.digestion;

import com.compomics.util.experiment.biology.AminoAcidSequence;
import com.compomics.util.experiment.biology.Enzyme;
import com.compomics.util.experiment.identification.protein_sequences.digestion.ProteinIteratorUtils;
import com.compomics.util.experiment.identification.protein_sequences.digestion.SequenceIterator;
import com.compomics.util.experiment.identification.protein_sequences.digestion.iterators.NoDigestionCombinationIterator;
import com.compomics.util.experiment.identification.protein_sequences.digestion.iterators.NoDigestionIterator;
import com.compomics.util.experiment.identification.protein_sequences.digestion.iterators.SpecificSingleEnzymeCombinationIterator;
import com.compomics.util.experiment.identification.protein_sequences.digestion.iterators.SpecificSingleEnzymeIterator;
import com.compomics.util.experiment.identification.protein_sequences.digestion.iterators.UnspecificCombinationIterator;
import com.compomics.util.experiment.identification.protein_sequences.digestion.iterators.UnspecificIterator;
import com.compomics.util.preferences.DigestionPreferences;
import java.util.ArrayList;

public class IteratorFactory {
    private ProteinIteratorUtils proteinIteratorUtils;

    public IteratorFactory(ArrayList<String> fixedModifications, Integer maxX) {
        this.proteinIteratorUtils = new ProteinIteratorUtils(fixedModifications, maxX);
    }

    public IteratorFactory(ArrayList<String> fixedModifications) {
        this(fixedModifications, null);
    }

    public SequenceIterator getSequenceIterator(String sequence, DigestionPreferences digestionPreferences, double massMin, double massMax) throws InterruptedException {
        switch (digestionPreferences.getCleavagePreference()) {
            case unSpecific: {
                if (AminoAcidSequence.hasCombination(sequence)) {
                    return new UnspecificCombinationIterator(this.proteinIteratorUtils, sequence, massMin, massMax);
                }
                return new UnspecificIterator(this.proteinIteratorUtils, sequence, massMin, massMax);
            }
            case wholeProtein: {
                if (AminoAcidSequence.hasCombination(sequence)) {
                    return new NoDigestionCombinationIterator(this.proteinIteratorUtils, sequence, massMin, massMax);
                }
                return new NoDigestionIterator(this.proteinIteratorUtils, sequence, massMin, massMax);
            }
            case enzyme: {
                ArrayList<Enzyme> enzymes = digestionPreferences.getEnzymes();
                if (enzymes.size() != 1) break;
                Enzyme enzyme = enzymes.get(0);
                int nMissedCleavages = digestionPreferences.getnMissedCleavages(enzyme.getName());
                if (AminoAcidSequence.hasCombination(sequence)) {
                    return new SpecificSingleEnzymeCombinationIterator(this.proteinIteratorUtils, sequence, enzyme, nMissedCleavages, massMin, massMax);
                }
                return new SpecificSingleEnzymeIterator(this.proteinIteratorUtils, sequence, enzyme, nMissedCleavages, massMin, massMax);
            }
        }
        throw new UnsupportedOperationException("Cleavage preference of type " + (Object)((Object)digestionPreferences.getCleavagePreference()) + " not supported.");
    }
}

