/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.protein_sequences.digestion.iterators;

import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.identification.protein_sequences.digestion.PeptideWithPosition;
import com.compomics.util.experiment.identification.protein_sequences.digestion.ProteinIteratorUtils;
import com.compomics.util.experiment.identification.protein_sequences.digestion.SequenceIterator;

public class NoDigestionIterator
implements SequenceIterator {
    private ProteinIteratorUtils proteinIteratorUtils;
    private PeptideWithPosition peptideWithPosition = null;

    public NoDigestionIterator(ProteinIteratorUtils proteinIteratorUtils, String sequence, double massMin, double massMax) throws InterruptedException {
        this.proteinIteratorUtils = proteinIteratorUtils;
        this.setPeptide(sequence, massMin, massMax);
    }

    @Override
    public PeptideWithPosition getNextPeptide() {
        PeptideWithPosition result = this.peptideWithPosition;
        this.peptideWithPosition = null;
        return result;
    }

    private void setPeptide(String sequence, double massMin, double massMax) throws InterruptedException {
        Peptide peptide = this.proteinIteratorUtils.getPeptideFromProtein(sequence.toCharArray(), sequence, 0, massMin, massMax);
        if (peptide != null && peptide.getMass() >= massMin && peptide.getMass() <= massMax) {
            this.peptideWithPosition = new PeptideWithPosition(peptide, 0);
        }
    }
}

