/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.spectrum_annotation;

import com.compomics.util.experiment.biology.NeutralLoss;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;

public class NeutralLossesMap
implements Serializable {
    static final long serialVersionUID = -4690159937753713106L;
    private HashMap<NeutralLoss, Integer> bBoundaries;
    private HashMap<NeutralLoss, Integer> yBoundaries;
    private HashMap<String, Integer> forwardBoundaries = new HashMap(2);
    private HashMap<String, Integer> rewindBoundaries = new HashMap(2);
    private ArrayList<String> accountedNeutralLosses = null;

    public void backwardCompatibilityFix() {
        String name;
        Integer boundary;
        if (this.forwardBoundaries == null) {
            this.forwardBoundaries = new HashMap();
            if (this.bBoundaries != null) {
                for (NeutralLoss neutralLoss : this.bBoundaries.keySet()) {
                    boundary = this.bBoundaries.get(neutralLoss);
                    name = neutralLoss.name;
                    this.forwardBoundaries.put(name, boundary);
                    NeutralLoss.addNeutralLoss(neutralLoss);
                }
            }
        }
        if (this.rewindBoundaries == null) {
            this.rewindBoundaries = new HashMap();
            if (this.yBoundaries != null) {
                for (NeutralLoss neutralLoss : this.yBoundaries.keySet()) {
                    boundary = this.yBoundaries.get(neutralLoss);
                    name = neutralLoss.name;
                    this.rewindBoundaries.put(name, boundary);
                    NeutralLoss.addNeutralLoss(neutralLoss);
                }
            }
        }
    }

    public void addNeutralLoss(NeutralLoss neutralLoss, Integer bStart, Integer yStart) {
        this.addNeutralLoss(neutralLoss.name, bStart, yStart);
        this.accountedNeutralLosses = null;
    }

    public void addNeutralLoss(String neutralLossName, Integer bStart, Integer yStart) {
        this.backwardCompatibilityFix();
        Integer position = this.forwardBoundaries.get(neutralLossName);
        if (position == null || bStart < position) {
            this.forwardBoundaries.put(neutralLossName, bStart);
        }
        if ((position = this.rewindBoundaries.get(neutralLossName)) == null || yStart < position) {
            this.rewindBoundaries.put(neutralLossName, yStart);
        }
        this.accountedNeutralLosses = null;
    }

    public void clearNeutralLosses() {
        this.backwardCompatibilityFix();
        this.forwardBoundaries.clear();
        this.rewindBoundaries.clear();
        this.accountedNeutralLosses = null;
    }

    public void makeSequenceIndependant() {
        this.backwardCompatibilityFix();
        for (String neutralLossName : this.forwardBoundaries.keySet()) {
            this.forwardBoundaries.put(neutralLossName, 1);
            this.rewindBoundaries.put(neutralLossName, 1);
        }
    }

    public boolean isEmpty() {
        this.backwardCompatibilityFix();
        return this.forwardBoundaries.isEmpty();
    }

    public ArrayList<String> getAccountedNeutralLosses() {
        this.backwardCompatibilityFix();
        if (this.accountedNeutralLosses == null) {
            this.accountedNeutralLosses = new ArrayList<String>(this.forwardBoundaries.keySet());
        }
        return this.accountedNeutralLosses;
    }

    public Integer getForwardStart(String neutralLossName) {
        this.backwardCompatibilityFix();
        return this.forwardBoundaries.get(neutralLossName);
    }

    public int getRewindStart(String neutralLossName) {
        this.backwardCompatibilityFix();
        Integer start = this.rewindBoundaries.get(neutralLossName);
        if (start == null) {
            return 0;
        }
        return start;
    }

    public boolean containsLoss(String neutralLossName) {
        this.backwardCompatibilityFix();
        return this.forwardBoundaries.containsKey(neutralLossName);
    }

    public NeutralLossesMap clone() {
        NeutralLossesMap result = new NeutralLossesMap();
        for (String neutralLossName : this.getAccountedNeutralLosses()) {
            result.addNeutralLoss(neutralLossName, this.getForwardStart(neutralLossName), (Integer)this.getRewindStart(neutralLossName));
        }
        return result;
    }
}

