/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.spectrum_annotation.simple_annotators;

import com.compomics.util.experiment.biology.AminoAcid;
import com.compomics.util.experiment.biology.PTM;
import com.compomics.util.experiment.biology.PTMFactory;
import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.biology.ions.ElementaryIon;
import com.compomics.util.experiment.biology.ions.PeptideFragmentIon;
import com.compomics.util.experiment.identification.matches.IonMatch;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.spectrum_annotation.spectrum_annotators.SimplePeptideAnnotator;
import com.compomics.util.experiment.massspectrometry.Peak;
import com.compomics.util.experiment.massspectrometry.indexes.SpectrumIndex;
import com.compomics.util.experiment.massspectrometry.utils.StandardMasses;
import java.util.ArrayList;

public class FragmentAnnotator {
    private final PTMFactory ptmFactory = PTMFactory.getInstance();
    private final double[] forwardIonMz1;
    private final double[] complementaryIonMz1;
    private final int peptideLength;
    private final int forwardIonType;
    private final int complementaryIonType;

    public FragmentAnnotator(Peptide peptide, SimplePeptideAnnotator.IonSeries ionSeries) throws InterruptedException {
        this(peptide, ionSeries, true, true);
    }

    public FragmentAnnotator(Peptide peptide, SimplePeptideAnnotator.IonSeries ionSeries, boolean forward, boolean complementary) throws InterruptedException {
        double complementaryMass;
        double forwardMass;
        char[] aas = peptide.getSequence().toCharArray();
        this.peptideLength = aas.length;
        this.forwardIonMz1 = new double[this.peptideLength];
        this.complementaryIonMz1 = new double[this.peptideLength];
        double[] modificationsMasses = new double[this.peptideLength];
        ArrayList<ModificationMatch> modificationMatches = peptide.getModificationMatches();
        if (modificationMatches != null) {
            for (ModificationMatch modificationMatch : modificationMatches) {
                String modificationName = modificationMatch.getTheoreticPtm();
                PTM modification = this.ptmFactory.getPTM(modificationName);
                double modificationMass = modification.getMass();
                int site = modificationMatch.getModificationSite();
                int n = site - 1;
                modificationsMasses[n] = modificationsMasses[n] + modificationMass;
            }
        }
        if (ionSeries == SimplePeptideAnnotator.IonSeries.by) {
            forwardMass = ElementaryIon.proton.getTheoreticMass();
            complementaryMass = peptide.getMass() + ElementaryIon.protonMassMultiples[2];
            this.forwardIonType = 1;
            this.complementaryIonType = 4;
        } else if (ionSeries == SimplePeptideAnnotator.IonSeries.cz) {
            forwardMass = ElementaryIon.proton.getTheoreticMass() + StandardMasses.nh3.mass;
            complementaryMass = peptide.getMass() + ElementaryIon.protonMassMultiples[2] - StandardMasses.nh3.mass;
            this.forwardIonType = 2;
            this.complementaryIonType = 5;
        } else if (ionSeries == SimplePeptideAnnotator.IonSeries.ax) {
            forwardMass = ElementaryIon.proton.getTheoreticMass() - StandardMasses.co.mass;
            complementaryMass = peptide.getMass() + ElementaryIon.protonMassMultiples[2] + StandardMasses.co.mass;
            this.forwardIonType = 0;
            this.complementaryIonType = 3;
        } else {
            throw new UnsupportedOperationException("Ion series " + (Object)((Object)ionSeries) + " not supported.");
        }
        for (int i = 0; i < this.peptideLength; ++i) {
            char aa = aas[i];
            AminoAcid aminoAcid = AminoAcid.getAminoAcid(aa);
            forwardMass += aminoAcid.getMonoisotopicMass();
            forwardMass += modificationsMasses[i];
            if (forward) {
                this.forwardIonMz1[i] = forwardMass;
            }
            if (!complementary) continue;
            this.complementaryIonMz1[i] = complementaryMass - forwardMass;
        }
    }

    public ArrayList<IonMatch> getIonMatches(SpectrumIndex spectrumIndex, int peptideCharge) {
        ArrayList<IonMatch> results = new ArrayList<IonMatch>(0);
        for (int i = 0; i < this.peptideLength; ++i) {
            PeptideFragmentIon ion;
            double ionMz = this.forwardIonMz1[i];
            ArrayList<Peak> peaks = spectrumIndex.getMatchingPeaks(ionMz);
            if (!peaks.isEmpty()) {
                int ionNumber = i + 1;
                double ionMass = ionMz - ElementaryIon.proton.getTheoreticMass();
                for (Peak peak : peaks) {
                    ion = new PeptideFragmentIon(this.forwardIonType, ionNumber, ionMass, null);
                    results.add(new IonMatch(peak, ion, 1));
                }
            }
            if ((peaks = spectrumIndex.getMatchingPeaks(ionMz = this.complementaryIonMz1[i])).isEmpty()) continue;
            double ionMass = ionMz - ElementaryIon.proton.getTheoreticMass();
            int ionNumber = this.peptideLength - i - 1;
            for (Peak peak : peaks) {
                ion = new PeptideFragmentIon(this.complementaryIonType, ionNumber, ionMass, null);
                results.add(new IonMatch(peak, ion, 1));
            }
        }
        for (int ionCharge = 2; ionCharge < peptideCharge; ++ionCharge) {
            int extraProtons = ionCharge - 1;
            double protonContribution = ElementaryIon.getProtonMassMultiple(extraProtons);
            for (int i = 0; i < this.peptideLength; ++i) {
                PeptideFragmentIon ion;
                double ionMz1 = this.forwardIonMz1[i];
                double ionMz = (ionMz1 + protonContribution) / (double)ionCharge;
                ArrayList<Peak> peaks = spectrumIndex.getMatchingPeaks(ionMz);
                if (!peaks.isEmpty()) {
                    int ionNumber = i + 1;
                    double ionMass = ionMz1 - ElementaryIon.proton.getTheoreticMass();
                    for (Peak peak : peaks) {
                        ion = new PeptideFragmentIon(this.forwardIonType, ionNumber, ionMass, null);
                        results.add(new IonMatch(peak, ion, ionCharge));
                    }
                }
                if ((peaks = spectrumIndex.getMatchingPeaks(ionMz = ((ionMz1 = this.complementaryIonMz1[i]) + protonContribution) / (double)ionCharge)).isEmpty()) continue;
                double ionMass = ionMz1 - ElementaryIon.proton.getTheoreticMass();
                int ionNumber = this.peptideLength - i - 1;
                for (Peak peak : peaks) {
                    ion = new PeptideFragmentIon(this.complementaryIonType, ionNumber, ionMass, null);
                    results.add(new IonMatch(peak, ion, ionCharge));
                }
            }
        }
        return results;
    }
}

