/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.io.identifications;

import com.compomics.util.experiment.biology.Enzyme;
import com.compomics.util.experiment.biology.EnzymeFactory;
import com.compomics.util.experiment.identification.identification_parameters.SearchParameters;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.preferences.DigestionPreferences;
import com.compomics.util.waiting.WaitingHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import uk.ac.ebi.jmzidml.model.mzidml.AbstractParam;
import uk.ac.ebi.jmzidml.model.mzidml.CvParam;
import uk.ac.ebi.jmzidml.model.mzidml.ParamList;
import uk.ac.ebi.jmzidml.model.mzidml.SpectrumIdentificationProtocol;
import uk.ac.ebi.jmzidml.model.mzidml.Tolerance;
import uk.ac.ebi.jmzidml.xml.io.MzIdentMLUnmarshaller;

public class MzIdentMLIdfileSearchParametersConverter
extends ExperimentObject {
    public static String getSearchParameters(File mzIdentMLFile, SearchParameters searchParameters, String species, WaitingHandler waitingHandler) throws FileNotFoundException, IOException, ClassNotFoundException {
        String parametersReport = "<br><b><u>Extracted Search Parameters</u></b><br>";
        MzIdentMLUnmarshaller unmarshaller = new MzIdentMLUnmarshaller(mzIdentMLFile);
        if (waitingHandler != null && waitingHandler.isRunCanceled()) {
            mzIdentMLFile = null;
            unmarshaller = null;
            return null;
        }
        SpectrumIdentificationProtocol spectrumIdentificationProtocol = (SpectrumIdentificationProtocol)unmarshaller.unmarshal(SpectrumIdentificationProtocol.class);
        Double fragmentMinTolerance = null;
        Double fragmentMaxTolerance = null;
        Boolean fragmentToleranceTypeIsPpm = false;
        Tolerance tempFragmentTolerance = spectrumIdentificationProtocol.getFragmentTolerance();
        if (tempFragmentTolerance != null) {
            for (CvParam cvParam : tempFragmentTolerance.getCvParam()) {
                if (cvParam.getAccession().equalsIgnoreCase("MS:1001412")) {
                    fragmentMaxTolerance = Double.valueOf(cvParam.getValue());
                    fragmentToleranceTypeIsPpm = cvParam.getUnitAccession().equalsIgnoreCase("UO:0000169");
                    continue;
                }
                if (!cvParam.getAccession().equalsIgnoreCase("MS:1001413")) continue;
                fragmentMinTolerance = Double.valueOf(cvParam.getValue());
                fragmentToleranceTypeIsPpm = cvParam.getUnitAccession().equalsIgnoreCase("UO:0000169");
            }
        }
        parametersReport = parametersReport + "<br><b>Fragment Ion Mass Tolerance:</b> ";
        if (fragmentMinTolerance != null && fragmentMaxTolerance != null) {
            Double fragmentTolerance = Math.abs(fragmentMinTolerance) - Math.abs(fragmentMaxTolerance) < 1.0E-7 ? Double.valueOf(Math.abs(fragmentMinTolerance)) : Double.valueOf(Math.max(Math.abs(fragmentMinTolerance), Math.abs(fragmentMaxTolerance)));
            searchParameters.setPrecursorAccuracy(fragmentTolerance);
            if (fragmentToleranceTypeIsPpm.booleanValue()) {
                searchParameters.setFragmentAccuracyType(SearchParameters.MassAccuracyType.PPM);
                parametersReport = parametersReport + fragmentTolerance + " ppm";
            } else {
                searchParameters.setFragmentAccuracyType(SearchParameters.MassAccuracyType.DA);
                parametersReport = parametersReport + fragmentTolerance + " Da";
            }
        } else {
            parametersReport = parametersReport + searchParameters.getFragmentIonAccuracy() + " Da (default)";
        }
        Double precursorMinTolerance = null;
        Double precursorMaxTolerance = null;
        Boolean precursorToleranceTypeIsPpm = true;
        Tolerance tempPrecursorTolerance = spectrumIdentificationProtocol.getParentTolerance();
        for (CvParam cvParam : tempPrecursorTolerance.getCvParam()) {
            if (cvParam.getAccession().equalsIgnoreCase("MS:1001412")) {
                precursorMaxTolerance = Double.valueOf(cvParam.getValue());
                precursorToleranceTypeIsPpm = cvParam.getUnitAccession().equalsIgnoreCase("UO:0000169");
                continue;
            }
            if (!cvParam.getAccession().equalsIgnoreCase("MS:1001413")) continue;
            precursorMinTolerance = Double.valueOf(cvParam.getValue());
            precursorToleranceTypeIsPpm = cvParam.getUnitAccession().equalsIgnoreCase("UO:0000169");
        }
        parametersReport = parametersReport + "<br><b>Precursor Ion Mass Tolerance:</b> ";
        if (precursorMinTolerance != null && precursorMaxTolerance != null) {
            Double precursorTolerance = Math.abs(precursorMinTolerance) - Math.abs(precursorMaxTolerance) < 1.0E-7 ? Double.valueOf(Math.abs(precursorMinTolerance)) : Double.valueOf(Math.max(Math.abs(precursorMinTolerance), Math.abs(precursorMaxTolerance)));
            searchParameters.setPrecursorAccuracy(precursorTolerance);
            if (precursorToleranceTypeIsPpm.booleanValue()) {
                searchParameters.setPrecursorAccuracyType(SearchParameters.MassAccuracyType.PPM);
                parametersReport = parametersReport + precursorTolerance + " ppm";
            } else {
                searchParameters.setPrecursorAccuracyType(SearchParameters.MassAccuracyType.DA);
                parametersReport = parametersReport + precursorTolerance + " Da";
            }
        } else {
            parametersReport = parametersReport + searchParameters.getPrecursorAccuracy() + " ppm (default)";
        }
        parametersReport = parametersReport + "<br><br><b>Digestion:</b> ";
        List mzIdEnzymes = spectrumIdentificationProtocol.getEnzymes().getEnzyme();
        DigestionPreferences digestionPreferences = new DigestionPreferences();
        if (!mzIdEnzymes.isEmpty()) {
            digestionPreferences.clear();
            for (uk.ac.ebi.jmzidml.model.mzidml.Enzyme mzIdEnzyme : mzIdEnzymes) {
                String enzymeName;
                ParamList paramList = mzIdEnzyme.getEnzymeName();
                Integer nMissedCleavages = mzIdEnzyme.getMissedCleavages();
                Boolean semiSpecific = mzIdEnzyme.isSemiSpecific();
                if (paramList.getParamGroup().isEmpty()) continue;
                String enzymeId = ((AbstractParam)paramList.getParamGroup().get(0)).getName();
                Enzyme utilitiesEnzyme = EnzymeFactory.getInstance().getEnzyme(enzymeId);
                if (utilitiesEnzyme != null) {
                    enzymeName = utilitiesEnzyme.getName();
                    parametersReport = parametersReport + utilitiesEnzyme.getName();
                } else {
                    enzymeName = "Trypsin";
                    utilitiesEnzyme = EnzymeFactory.getInstance().getEnzyme(enzymeName);
                    parametersReport = parametersReport + utilitiesEnzyme.getName() + " (assumed)";
                }
                parametersReport = parametersReport + ", ";
                if (nMissedCleavages != null) {
                    parametersReport = parametersReport + nMissedCleavages;
                } else {
                    nMissedCleavages = 2;
                    parametersReport = parametersReport + nMissedCleavages + " (assumed)";
                }
                parametersReport = parametersReport + ", ";
                DigestionPreferences.Specificity specificity = DigestionPreferences.Specificity.specific;
                if (semiSpecific != null) {
                    if (semiSpecific.booleanValue()) {
                        specificity = DigestionPreferences.Specificity.semiSpecific;
                    }
                    parametersReport = parametersReport + (Object)((Object)specificity);
                } else {
                    parametersReport = parametersReport + (Object)((Object)specificity) + " (assumed)";
                }
                digestionPreferences.addEnzyme(utilitiesEnzyme);
                digestionPreferences.setSpecificity(enzymeName, specificity);
                digestionPreferences.setnMissedCleavages(enzymeName, nMissedCleavages);
                digestionPreferences.setCleavagePreference(DigestionPreferences.CleavagePreference.enzyme);
            }
        } else {
            parametersReport = parametersReport + "Trypsin (assumed), 2 allowed missed cleavages (assumed), specific (assumed)";
        }
        searchParameters.setDigestionPreferences(digestionPreferences);
        parametersReport = parametersReport + "<br><br><b>Min Precusor Charge:</b> ";
        parametersReport = parametersReport + searchParameters.getMinChargeSearched().value + " (default)";
        parametersReport = parametersReport + "<br><b>Max Precusor Charge:</b> ";
        parametersReport = parametersReport + searchParameters.getMaxChargeSearched().value + " (default)";
        parametersReport = parametersReport + "<br><br><b>Species:</b> ";
        parametersReport = species == null || species.length() == 0 ? parametersReport + "unknown" : parametersReport + species;
        mzIdentMLFile = null;
        unmarshaller = null;
        if (waitingHandler != null && waitingHandler.isRunCanceled()) {
            return null;
        }
        return parametersReport;
    }
}

