/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.io.identifications.idfilereaders;

import com.compomics.util.Util;
import com.compomics.util.experiment.biology.AminoAcid;
import com.compomics.util.experiment.biology.AminoAcidSequence;
import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.identification.amino_acid_tags.Tag;
import com.compomics.util.experiment.identification.identification_parameters.SearchParameters;
import com.compomics.util.experiment.identification.identification_parameters.tool_specific.DirecTagParameters;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.identification.protein_inference.PeptideMapperType;
import com.compomics.util.experiment.identification.protein_inference.proteintree.ProteinTree;
import com.compomics.util.experiment.identification.protein_sequences.SequenceFactory;
import com.compomics.util.experiment.identification.spectrum_assumptions.TagAssumption;
import com.compomics.util.experiment.io.identifications.IdfileReader;
import com.compomics.util.experiment.massspectrometry.Charge;
import com.compomics.util.experiment.massspectrometry.Spectrum;
import com.compomics.util.experiment.massspectrometry.SpectrumFactory;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.preferences.SequenceMatchingPreferences;
import com.compomics.util.waiting.WaitingHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import javax.xml.bind.JAXBException;
import uk.ac.ebi.pride.tools.braf.BufferedRandomAccessFile;

public class DirecTagIdfileReader
extends ExperimentObject
implements IdfileReader {
    private String tagsGenerator;
    private String tagsGeneratorVersion;
    private String copyRight;
    private String license;
    private String timeStart;
    private String timeEnd;
    private Double taggingTimeSeconds;
    private Integer nProcessingNode;
    private String inputFile;
    private HashMap<String, String> tagsParameters = new HashMap();
    private HashMap<String, Integer> spectrumLineContent = new HashMap();
    private HashMap<String, Integer> tagLineContent = new HashMap();
    private HashMap<Integer, Long> spectrumIndexes = new HashMap();
    private HashMap<Integer, ArrayList<Long>> tagIndexes = new HashMap();
    private BufferedRandomAccessFile bufferedRandomAccessFile;
    private File tagFile;
    private SpectrumFactory spectrumFactory = SpectrumFactory.getInstance();
    public final double cTermCorrection = 0.0;
    public final double nTermCorrection = 0.0;
    private DirecTagParameters direcTagParameters;
    private HashMap<Character, Character> dynamicModsResidues;

    public DirecTagIdfileReader() {
    }

    public DirecTagIdfileReader(File tagFile) throws FileNotFoundException, IOException {
        this(tagFile, false);
    }

    public DirecTagIdfileReader(File tagFile, boolean indexResults) throws FileNotFoundException, IOException {
        this.tagFile = tagFile;
        this.bufferedRandomAccessFile = new BufferedRandomAccessFile(tagFile, "r", 102400);
        this.parseFile(indexResults);
    }

    public Set<String> getTagsParametersNames() {
        return this.tagsParameters.keySet();
    }

    public String getTagParameter(String tagParameterName) {
        return this.tagsParameters.get(tagParameterName);
    }

    private void parseFile(boolean indexResults) throws FileNotFoundException, IOException {
        try {
            boolean endOfFile = this.parseParameters();
            if (!endOfFile) {
                endOfFile = this.parseTagParameters();
            }
            if (!endOfFile) {
                endOfFile = this.parseHeaders();
            }
            if (!endOfFile && indexResults) {
                this.parseResults();
            }
        }
        finally {
            this.bufferedRandomAccessFile.close();
        }
    }

    private boolean parseParameters() throws IOException {
        String line;
        while ((line = this.bufferedRandomAccessFile.readLine()) != null && line != null && !line.startsWith("H\tTagsParameters")) {
            if (line == null) {
                throw new IOException("Unexpected end of file while parsing the parameters.");
            }
            if (line.startsWith("H(S)") || line.startsWith("H(T)") || line.startsWith("S") || line.startsWith("T")) {
                throw new IOException("Unexpected end of parameters section.");
            }
            if ((line = line.substring(1).trim()).startsWith("TagsGeneratorVersion")) {
                this.tagsGeneratorVersion = line.substring(line.indexOf("\t")).trim();
                continue;
            }
            if (line.startsWith("TagsGenerator")) {
                this.tagsGenerator = line.substring(line.indexOf("\t")).trim();
                continue;
            }
            if (line.contains("(c)")) {
                this.copyRight = line;
                continue;
            }
            if (line.contains("License")) {
                this.license = line;
                continue;
            }
            if (line.startsWith("Tagging started at")) {
                this.tagsGeneratorVersion = line.substring(line.indexOf("Tagging started at")).trim();
                continue;
            }
            if (line.startsWith("Tagging started at")) {
                this.timeStart = line.substring(line.indexOf("Tagging started at")).trim();
                continue;
            }
            if (line.startsWith("Tagging finished at")) {
                this.timeEnd = line.substring(line.indexOf("Tagging finished at")).trim();
                continue;
            }
            if (line.startsWith("Total tagging time:")) {
                line = line.substring(line.indexOf(":") + 1).trim();
                line = line.substring(0, line.indexOf(" ")).trim();
                try {
                    this.taggingTimeSeconds = new Double(line);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (line.contains("node")) {
                line = line.substring(line.indexOf(" ")).trim();
                line = line.substring(0, line.indexOf(" ")).trim();
                try {
                    this.nProcessingNode = new Integer(line);
                }
                catch (Exception exception) {}
                continue;
            }
            if (!line.startsWith("InputFile")) continue;
            this.inputFile = line.substring(line.indexOf("\t")).trim();
        }
        return line == null;
    }

    private boolean parseTagParameters() throws IOException {
        String line;
        while ((line = this.bufferedRandomAccessFile.readLine()) != null && !line.trim().isEmpty()) {
            String[] components;
            if (line == null) {
                throw new IOException("Unexpected end of file while parsing the tag parameters.");
            }
            if (line.startsWith("H(S)") || line.startsWith("H(T)") || line.startsWith("S") || line.startsWith("T")) {
                throw new IOException("Unexpected end of tag parameters section.");
            }
            line = line.substring(1).trim();
            for (String component : components = line.split(", ")) {
                int index = component.indexOf(": ");
                if (index == -1) continue;
                String key = component.substring(0, index).trim();
                String value = component.substring(index + 1).trim();
                this.tagsParameters.put(key, value);
            }
        }
        return line == null;
    }

    private boolean parseHeaders() throws IOException {
        String line = this.bufferedRandomAccessFile.readLine();
        if (line != null) {
            this.parseHeaderLine(line);
        }
        if ((line = this.bufferedRandomAccessFile.readLine()) != null) {
            this.parseHeaderLine(line);
        }
        return line == null;
    }

    private void parseHeaderLine(String line) throws IOException {
        block4: {
            block3: {
                if (line.startsWith("S") || line.startsWith("T")) {
                    throw new IOException("No Header found.");
                }
                if (!line.startsWith("H(S)")) break block3;
                line = line.substring(4).trim();
                String[] components = line.split("\t");
                for (int i = 0; i < components.length; ++i) {
                    this.spectrumLineContent.put(components[i], i);
                }
                break block4;
            }
            if (!line.startsWith("H(T)")) break block4;
            line = line.substring(4).trim();
            String[] components = line.split("\t");
            for (int i = 0; i < components.length; ++i) {
                this.tagLineContent.put(components[i], i);
            }
        }
    }

    private void parseResults() throws IOException {
        String line;
        Integer sIdIndex = this.spectrumLineContent.get("Index");
        int scpt = 0;
        while ((line = this.bufferedRandomAccessFile.readLine()) != null) {
            long lineIndex = this.bufferedRandomAccessFile.getFilePointer();
            Integer id = ++scpt;
            if (line.startsWith("S")) {
                line = line.substring(1).trim();
                if (sIdIndex != null) {
                    String[] components = line.split("\t");
                    id = new Integer(components[sIdIndex]);
                }
                this.spectrumIndexes.put(id, lineIndex);
                continue;
            }
            if (!line.startsWith("T")) continue;
            ArrayList<Long> indexes = this.tagIndexes.get(id);
            if (indexes == null) {
                indexes = new ArrayList();
                this.tagIndexes.put(id, indexes);
            }
            indexes.add(lineIndex);
        }
    }

    public String getSpectrumComponent(int spectrumId, String componentName) throws IOException {
        long index = this.spectrumIndexes.get(spectrumId);
        this.bufferedRandomAccessFile.seek(index);
        String line = this.bufferedRandomAccessFile.readLine();
        line = line.substring(1).trim();
        String[] components = line.split("\t");
        Integer columnIndex = this.spectrumLineContent.get(componentName);
        if (columnIndex != null && columnIndex < components.length) {
            return components[columnIndex];
        }
        return null;
    }

    public Set<Integer> getSpectrumIds() {
        return this.spectrumIndexes.keySet();
    }

    public Set<String> getSpectrumComponentNames() {
        return this.spectrumLineContent.keySet();
    }

    private ArrayList<HashMap<String, String>> getTags(int spectrumId) throws IOException {
        ArrayList<HashMap<String, String>> result = new ArrayList<HashMap<String, String>>();
        ArrayList<Long> indexes = this.tagIndexes.get(spectrumId);
        if (indexes != null) {
            for (Long index : indexes) {
                this.bufferedRandomAccessFile.seek(index.longValue());
                String line = this.bufferedRandomAccessFile.readLine();
                line = line.substring(1).trim();
                String[] components = line.split("\t");
                HashMap<String, String> lineMap = new HashMap<String, String>();
                for (String componentName : this.tagLineContent.keySet()) {
                    int columnIndex = this.tagLineContent.get(componentName);
                    String value = components[columnIndex];
                    lineMap.put(componentName, value);
                }
                result.add(lineMap);
            }
        }
        return result;
    }

    @Override
    public LinkedList<SpectrumMatch> getAllSpectrumMatches(WaitingHandler waitingHandler, SearchParameters searchParameters) throws IOException, IllegalArgumentException, SQLException, ClassNotFoundException, InterruptedException, JAXBException {
        return this.getAllSpectrumMatches(waitingHandler, searchParameters, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LinkedList<SpectrumMatch> getAllSpectrumMatches(WaitingHandler waitingHandler, SearchParameters searchParameters, SequenceMatchingPreferences sequenceMatchingPreferences, boolean expandAaCombinations) throws IOException, IllegalArgumentException, SQLException, ClassNotFoundException, InterruptedException, JAXBException {
        this.direcTagParameters = (DirecTagParameters)searchParameters.getAlgorithmSpecificParameters().get(Advocate.direcTag.getIndex());
        this.dynamicModsResidues = new HashMap();
        String dynamicMods = this.tagsParameters.get("DynamicMods");
        if (!(dynamicMods = dynamicMods.trim()).isEmpty()) {
            String[] modElements = dynamicMods.split(" ");
            int index = 0;
            while (index + 2 < modElements.length) {
                this.dynamicModsResidues.put(Character.valueOf(modElements[index + 1].charAt(0)), Character.valueOf(modElements[index].charAt(0)));
                index += 3;
            }
        }
        int tagMapKeyLength = 3;
        if (sequenceMatchingPreferences != null && sequenceMatchingPreferences.getPeptideMapperType() == PeptideMapperType.tree) {
            SequenceFactory sequenceFactory = SequenceFactory.getInstance();
            tagMapKeyLength = ((ProteinTree)sequenceFactory.getDefaultPeptideMapper()).getInitialTagSize();
        }
        String spectrumFileName = Util.getFileName(this.getInputFile());
        if (waitingHandler != null && this.spectrumFactory.fileLoaded(spectrumFileName)) {
            waitingHandler.setMaxSecondaryProgressCounter(this.spectrumFactory.getNSpectra(spectrumFileName));
            waitingHandler.setSecondaryProgressCounter(0);
        }
        LinkedList<SpectrumMatch> result = new LinkedList<SpectrumMatch>();
        int sCpt = 0;
        Integer sIdColumnIndex = this.spectrumLineContent.get("ID");
        Integer chargeColumnIndex = this.spectrumLineContent.get("Charge");
        BufferedReader reader = new BufferedReader(new FileReader(this.tagFile));
        try {
            String line;
            Integer lastId = null;
            Integer lastCharge = null;
            int rank = 0;
            SpectrumMatch currentMatch = null;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("S")) {
                    Integer sId = ++sCpt;
                    rank = 0;
                    if (sIdColumnIndex != null) {
                        line = line.substring(1).trim();
                        String[] components = line.split("\t");
                        String id = components[sIdColumnIndex];
                        sId = new Integer(id.substring(id.indexOf("=") + 1));
                        String chargeString = components[chargeColumnIndex];
                        lastCharge = new Integer(chargeString);
                    }
                    if (!sId.equals(lastId)) {
                        if (currentMatch != null && currentMatch.hasAssumption()) {
                            result.add(currentMatch);
                        }
                        int utilitiesId = sId + 1;
                        String spectrumTitle = utilitiesId + "";
                        if (this.spectrumFactory.fileLoaded(spectrumFileName)) {
                            spectrumTitle = this.spectrumFactory.getSpectrumTitle(spectrumFileName, utilitiesId);
                        }
                        currentMatch = new SpectrumMatch(Spectrum.getSpectrumKey(spectrumFileName, spectrumTitle));
                        currentMatch.setSpectrumNumber(utilitiesId);
                        lastId = sId;
                    }
                    if (waitingHandler == null || !this.spectrumFactory.fileLoaded(spectrumFileName)) continue;
                    waitingHandler.increaseSecondaryProgressCounter();
                    continue;
                }
                if (!line.startsWith("T")) continue;
                TagAssumption tagAssumption = this.getAssumptionFromLine(line, ++rank);
                tagAssumption.setIdentificationCharge(new Charge(1, lastCharge));
                currentMatch.addHit(Advocate.direcTag.getIndex(), tagAssumption, true);
            }
            if (currentMatch != null && currentMatch.hasAssumption()) {
                result.add(currentMatch);
            }
        }
        finally {
            reader.close();
        }
        return result;
    }

    private TagAssumption getAssumptionFromLine(String line, int rank) {
        Integer nGapIndex;
        line = line.substring(1).trim();
        String[] components = line.split("\t");
        Integer cGapIndex = this.tagLineContent.get("cTerminusMass");
        if (cGapIndex == null) {
            throw new IllegalArgumentException("Column cTerminusMass not found.");
        }
        Double cGap = new Double(components[cGapIndex]);
        if (cGap > 0.0 && cGap < 0.0) {
            throw new IllegalArgumentException("Incompatible c-term gap " + cGap);
        }
        if (cGap > 0.0) {
            cGap = cGap + 0.0;
        }
        if ((nGapIndex = this.tagLineContent.get("nTerminusMass")) == null) {
            throw new IllegalArgumentException("Column nTerminusMass not found.");
        }
        Double nGap = new Double(components[nGapIndex]);
        Integer tagIndex = this.tagLineContent.get("Tag");
        if (tagIndex == null) {
            throw new IllegalArgumentException("Column Tag not found.");
        }
        String tagSequence = components[tagIndex];
        StringBuilder residues = new StringBuilder(tagSequence.length());
        HashMap<Integer, ModificationMatch> modificationMatches = new HashMap<Integer, ModificationMatch>();
        for (int i = 0; i < tagSequence.length(); ++i) {
            char charAtI = tagSequence.charAt(i);
            try {
                AminoAcid aa = AminoAcid.getAminoAcid(charAtI);
                residues.append(aa.singleLetterCode);
                continue;
            }
            catch (IllegalArgumentException e) {
                try {
                    String modIndexString = charAtI + "";
                    int modIndex = new Integer(modIndexString);
                    String utilitiesPtm = this.direcTagParameters.getUtilitiesPtmName(modIndex);
                    modificationMatches.put(i + 1, new ModificationMatch(utilitiesPtm, true, i + 1));
                    residues.append(this.dynamicModsResidues.get(Character.valueOf(modIndexString.charAt(0))));
                    continue;
                }
                catch (Exception e1) {
                    throw new IllegalArgumentException("No amino acid or modification could be mapped to tag component \"" + charAtI + "\" in tag \"" + tagSequence + "\".");
                }
            }
        }
        AminoAcidSequence tagAaSequence = new AminoAcidSequence(residues.toString());
        Iterator charAtI = modificationMatches.keySet().iterator();
        while (charAtI.hasNext()) {
            int i = (Integer)charAtI.next();
            tagAaSequence.addModificationMatch(i, (ModificationMatch)modificationMatches.get(i));
        }
        Tag tag = new Tag((double)nGap, tagAaSequence, (double)cGap);
        Integer chargeIndex = this.tagLineContent.get("TagChargeState");
        if (chargeIndex == null) {
            throw new IllegalArgumentException("Column TagChargeState not found.");
        }
        int charge = new Integer(components[chargeIndex]);
        Integer eValueIndex = this.tagLineContent.get("Total");
        if (eValueIndex == null) {
            throw new IllegalArgumentException("Column Total not found.");
        }
        double eValue = new Double(components[eValueIndex]);
        return new TagAssumption(Advocate.direcTag.getIndex(), rank, tag, new Charge(1, charge), eValue);
    }

    public String getTagsGenerator() {
        return this.tagsGenerator;
    }

    public String getTagsGeneratorVersion() {
        return this.tagsGeneratorVersion;
    }

    public String getCopyRight() {
        return this.copyRight;
    }

    public String getLicense() {
        return this.license;
    }

    public String getTimeStart() {
        return this.timeStart;
    }

    public String getTimeEnd() {
        return this.timeEnd;
    }

    public Double getTaggingTimeSeconds() {
        return this.taggingTimeSeconds;
    }

    public Integer getnProcessingNode() {
        return this.nProcessingNode;
    }

    public File getInputFile() {
        return new File(this.inputFile);
    }

    @Override
    public String getExtension() {
        return ".tags";
    }

    @Override
    public void close() throws IOException {
        this.bufferedRandomAccessFile.close();
    }

    @Override
    public HashMap<String, ArrayList<String>> getSoftwareVersions() {
        HashMap<String, ArrayList<String>> result = new HashMap<String, ArrayList<String>>();
        ArrayList<String> versions = new ArrayList<String>();
        versions.add(this.tagsGeneratorVersion);
        result.put(this.tagsGenerator, versions);
        return result;
    }

    @Override
    public boolean hasDeNovoTags() {
        return true;
    }
}

