/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.io.identifications.idfilereaders;

import com.compomics.util.Util;
import com.compomics.util.experiment.biology.AminoAcidSequence;
import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.identification.identification_parameters.SearchParameters;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.identification.spectrum_assumptions.PeptideAssumption;
import com.compomics.util.experiment.io.identifications.IdfileReader;
import com.compomics.util.experiment.massspectrometry.Charge;
import com.compomics.util.experiment.massspectrometry.Spectrum;
import com.compomics.util.experiment.massspectrometry.SpectrumFactory;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.preferences.SequenceMatchingPreferences;
import com.compomics.util.waiting.WaitingHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import javax.xml.bind.JAXBException;
import uk.ac.ebi.pride.tools.braf.BufferedRandomAccessFile;

public class TideIdfileReader
extends ExperimentObject
implements IdfileReader {
    private String softwareName = "Tide";
    private String softwareVersion = null;
    private File tideTsvFile;
    private SpectrumFactory spectrumFactory = SpectrumFactory.getInstance();

    public TideIdfileReader() {
    }

    public TideIdfileReader(File tideTsvFile) throws FileNotFoundException, IOException {
        this(tideTsvFile, null);
    }

    public TideIdfileReader(File tideTsvFile, WaitingHandler waitingHandler) throws FileNotFoundException, IOException {
        this.tideTsvFile = tideTsvFile;
    }

    @Override
    public String getExtension() {
        return ".tide-search.target.txt";
    }

    @Override
    public LinkedList<SpectrumMatch> getAllSpectrumMatches(WaitingHandler waitingHandler, SearchParameters searchParameters) throws IOException, IllegalArgumentException, SQLException, ClassNotFoundException, InterruptedException, JAXBException {
        return this.getAllSpectrumMatches(waitingHandler, searchParameters, null, true);
    }

    @Override
    public LinkedList<SpectrumMatch> getAllSpectrumMatches(WaitingHandler waitingHandler, SearchParameters searchParameters, SequenceMatchingPreferences sequenceMatchingPreferences, boolean expandAaCombinations) throws IOException, IllegalArgumentException, SQLException, ClassNotFoundException, InterruptedException, JAXBException {
        String line;
        LinkedList<SpectrumMatch> result = new LinkedList<SpectrumMatch>();
        BufferedRandomAccessFile bufferedRandomAccessFile = new BufferedRandomAccessFile(this.tideTsvFile, "r", 102400);
        if (waitingHandler != null) {
            waitingHandler.resetSecondaryProgressCounter();
            waitingHandler.setMaxSecondaryProgressCounter(100);
        }
        long progressUnit = bufferedRandomAccessFile.length() / 100L;
        String headerString = bufferedRandomAccessFile.readLine();
        String[] headers = headerString.split("\t");
        int scanNumberIndex = -1;
        int chargeIndex = -1;
        int precursorMzIndex = -1;
        int spectrumNeutralLossIndex = -1;
        int peptideMassIndex = -1;
        int deltaCnIndex = -1;
        int spScoreIndex = -1;
        int spRankIndex = -1;
        int exactPValueIndex = -1;
        int xcorrScoreIndex = -1;
        int xcorrRank = -1;
        int bAndyIonsMatchedIndex = -1;
        int bAndyIonsTotal = -1;
        int distinctMatchesPerSpectrum = -1;
        int sequenceIndex = -1;
        int cleavageType = -1;
        int proteinId = -1;
        int flankingAa = -1;
        for (int i = 0; i < headers.length; ++i) {
            String header = headers[i];
            if (header.equalsIgnoreCase("scan")) {
                scanNumberIndex = i;
                continue;
            }
            if (header.equalsIgnoreCase("charge")) {
                chargeIndex = i;
                continue;
            }
            if (header.equalsIgnoreCase("spectrum precursor m/z")) {
                precursorMzIndex = i;
                continue;
            }
            if (header.equalsIgnoreCase("spectrum neutral mass")) {
                spectrumNeutralLossIndex = i;
                continue;
            }
            if (header.equalsIgnoreCase("peptide mass")) {
                peptideMassIndex = i;
                continue;
            }
            if (header.equalsIgnoreCase("delta_cn")) {
                deltaCnIndex = i;
                continue;
            }
            if (header.equalsIgnoreCase("sp score")) {
                spScoreIndex = i;
                continue;
            }
            if (header.equalsIgnoreCase("sp rank")) {
                spRankIndex = i;
                continue;
            }
            if (header.equalsIgnoreCase("exact p-value")) {
                exactPValueIndex = i;
                continue;
            }
            if (header.equalsIgnoreCase("xcorr score")) {
                xcorrScoreIndex = i;
                continue;
            }
            if (header.equalsIgnoreCase("xcorr rank")) {
                xcorrRank = i;
                continue;
            }
            if (header.equalsIgnoreCase("b/y ions matched")) {
                bAndyIonsMatchedIndex = i;
                continue;
            }
            if (header.equalsIgnoreCase("b/y ions total")) {
                bAndyIonsTotal = i;
                continue;
            }
            if (header.equalsIgnoreCase("distinct matches/spectrum")) {
                distinctMatchesPerSpectrum = i;
                continue;
            }
            if (header.equalsIgnoreCase("sequence")) {
                sequenceIndex = i;
                continue;
            }
            if (header.equalsIgnoreCase("cleavage type")) {
                cleavageType = i;
                continue;
            }
            if (header.equalsIgnoreCase("protein id")) {
                proteinId = i;
                continue;
            }
            if (!header.equalsIgnoreCase("flanking aa")) continue;
            flankingAa = i;
        }
        if (scanNumberIndex == -1 || chargeIndex == -1 || xcorrRank == -1 || sequenceIndex == -1) {
            throw new IllegalArgumentException("Mandatory columns are missing in the Tide tsv file. Please check the file!");
        }
        String currentSpectrumTitle = null;
        SpectrumMatch currentMatch = null;
        String spectrumFileName = Util.getFileName(this.tideTsvFile);
        spectrumFileName = spectrumFileName.substring(0, spectrumFileName.length() - ".tide-search.target.txt".length()) + ".mgf";
        while ((line = bufferedRandomAccessFile.readLine()) != null) {
            double rawScore;
            double tideEValue;
            String scoreAsText;
            String[] elements = line.split("\t");
            if (line.trim().isEmpty()) continue;
            int scanNumber = Integer.valueOf(elements[scanNumberIndex]);
            String modifiedPeptideSequence = elements[sequenceIndex].toUpperCase();
            int charge = Integer.valueOf(elements[chargeIndex]);
            int rank = exactPValueIndex != -1 ? Integer.valueOf(elements[xcorrRank]).intValue() : Integer.valueOf(elements[xcorrRank]).intValue();
            if (exactPValueIndex != -1) {
                scoreAsText = elements[exactPValueIndex];
                rawScore = tideEValue = Util.readDoubleAsString(scoreAsText);
            } else {
                scoreAsText = elements[xcorrScoreIndex];
                rawScore = Util.readDoubleAsString(scoreAsText);
                tideEValue = rawScore < 0.0 ? 100.0 : Math.pow(10.0, -rawScore);
            }
            String spectrumTitle = scanNumber + "";
            if (this.spectrumFactory.fileLoaded(spectrumFileName)) {
                spectrumTitle = this.spectrumFactory.getSpectrumTitle(spectrumFileName, scanNumber);
            }
            if (currentMatch == null || currentSpectrumTitle != null && !currentSpectrumTitle.equalsIgnoreCase(spectrumTitle)) {
                if (currentMatch != null) {
                    result.add(currentMatch);
                }
                currentMatch = new SpectrumMatch(Spectrum.getSpectrumKey(spectrumFileName, spectrumTitle));
                currentMatch.setSpectrumNumber(scanNumber);
                currentSpectrumTitle = spectrumTitle;
            }
            ArrayList<ModificationMatch> utilitiesModifications = new ArrayList<ModificationMatch>();
            String unmodifiedPeptideSequence = "";
            if (modifiedPeptideSequence.contains("[")) {
                for (int i = 0; i < modifiedPeptideSequence.length(); ++i) {
                    if (modifiedPeptideSequence.charAt(i) != '[') {
                        unmodifiedPeptideSequence = unmodifiedPeptideSequence + modifiedPeptideSequence.charAt(i);
                        continue;
                    }
                    char modifiedResidue = modifiedPeptideSequence.charAt(i - 1);
                    double ptmMass = Double.parseDouble(modifiedPeptideSequence.substring(i + 1, modifiedPeptideSequence.indexOf("]", i + 1)));
                    utilitiesModifications.add(new ModificationMatch(ptmMass + "@" + modifiedResidue, true, i));
                    i = modifiedPeptideSequence.indexOf("]", i + 1);
                }
            } else {
                unmodifiedPeptideSequence = modifiedPeptideSequence;
            }
            Peptide peptide = new Peptide(unmodifiedPeptideSequence, utilitiesModifications, true);
            Charge peptideCharge = new Charge(1, charge);
            PeptideAssumption peptideAssumption = new PeptideAssumption(peptide, rank, Advocate.tide.getIndex(), peptideCharge, tideEValue, Util.getFileName(this.tideTsvFile));
            peptideAssumption.setRawScore(rawScore);
            if (expandAaCombinations && AminoAcidSequence.hasCombination(unmodifiedPeptideSequence)) {
                ArrayList<ModificationMatch> previousModificationMatches = peptide.getModificationMatches();
                ArrayList<ModificationMatch> newModificationMatches = null;
                if (previousModificationMatches != null) {
                    newModificationMatches = new ArrayList<ModificationMatch>(previousModificationMatches.size());
                }
                for (StringBuilder expandedSequence : AminoAcidSequence.getCombinations(peptide.getSequence())) {
                    Peptide newPeptide = new Peptide(expandedSequence.toString(), newModificationMatches, true);
                    if (previousModificationMatches != null) {
                        for (ModificationMatch modificationMatch : previousModificationMatches) {
                            newPeptide.addModificationMatch(new ModificationMatch(modificationMatch.getTheoreticPtm(), modificationMatch.isVariable(), modificationMatch.getModificationSite()));
                        }
                    }
                    PeptideAssumption newAssumption = new PeptideAssumption(newPeptide, peptideAssumption.getRank(), peptideAssumption.getAdvocate(), peptideAssumption.getIdentificationCharge(), peptideAssumption.getScore(), peptideAssumption.getIdentificationFile());
                    newAssumption.setRawScore(rawScore);
                    currentMatch.addHit(Advocate.tide.getIndex(), newAssumption, false);
                }
            } else {
                currentMatch.addHit(Advocate.tide.getIndex(), peptideAssumption, false);
            }
            if (waitingHandler == null || progressUnit == 0L) continue;
            waitingHandler.setSecondaryProgressCounter((int)(bufferedRandomAccessFile.getFilePointer() / progressUnit));
            if (!waitingHandler.isRunCanceled()) continue;
            bufferedRandomAccessFile.close();
            break;
        }
        if (currentMatch != null) {
            result.add(currentMatch);
        }
        bufferedRandomAccessFile.close();
        return result;
    }

    @Override
    public void close() throws IOException {
        this.tideTsvFile = null;
    }

    @Override
    public HashMap<String, ArrayList<String>> getSoftwareVersions() {
        HashMap<String, ArrayList<String>> result = new HashMap<String, ArrayList<String>>();
        ArrayList<String> versions = new ArrayList<String>();
        versions.add(this.softwareVersion);
        result.put(this.softwareName, versions);
        return result;
    }

    @Override
    public boolean hasDeNovoTags() {
        return false;
    }
}

