/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.massspectrometry;

import com.compomics.util.experiment.biology.ions.ElementaryIon;
import com.compomics.util.experiment.personalization.ExperimentObject;
import java.util.Comparator;

public class Peak
extends ExperimentObject {
    static final long serialVersionUID = -7425947046833405676L;
    public double mz;
    public double rt;
    public double intensity;
    public static final Comparator<Peak> AscendingIntensityComparator = new Comparator<Peak>(){

        @Override
        public int compare(Peak o1, Peak o2) {
            return o1.getIntensity() < o2.getIntensity() ? -1 : (o1.getIntensity() == o2.getIntensity() ? 0 : 1);
        }
    };
    public static final Comparator<Peak> DescendingIntensityComparator = new Comparator<Peak>(){

        @Override
        public int compare(Peak o1, Peak o2) {
            return o1.getIntensity() > o2.getIntensity() ? -1 : (o1.getIntensity() == o2.getIntensity() ? 0 : 1);
        }
    };
    public static final Comparator<Peak> AscendingMzComparator = new Comparator<Peak>(){

        @Override
        public int compare(Peak o1, Peak o2) {
            return o1.getMz() < o2.getMz() ? -1 : (o1.getMz() == o2.getMz() ? 0 : 1);
        }
    };

    public Peak(double mz, double intensity) {
        this.mz = mz;
        this.intensity = intensity;
    }

    public Peak(double mz, double intensity, double rt) {
        this.mz = mz;
        this.intensity = intensity;
        this.rt = rt;
    }

    public boolean isSameAs(Peak aPeak) {
        return this.mz == aPeak.mz && this.intensity == aPeak.intensity;
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + (int)(Double.doubleToLongBits(this.mz) ^ Double.doubleToLongBits(this.mz) >>> 32);
        hash = 97 * hash + (int)(Double.doubleToLongBits(this.rt) ^ Double.doubleToLongBits(this.rt) >>> 32);
        hash = 97 * hash + (int)(Double.doubleToLongBits(this.intensity) ^ Double.doubleToLongBits(this.intensity) >>> 32);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Peak other = (Peak)obj;
        if (Double.doubleToLongBits(this.mz) != Double.doubleToLongBits(other.mz)) {
            return false;
        }
        if (Double.doubleToLongBits(this.rt) != Double.doubleToLongBits(other.rt)) {
            return false;
        }
        return Double.doubleToLongBits(this.intensity) == Double.doubleToLongBits(other.intensity);
    }

    public double getMz() {
        return this.mz;
    }

    public void setMz(double mz) {
        this.mz = mz;
    }

    public double getIntensity() {
        return this.intensity;
    }

    public void setIntensity(double intensity) {
        this.intensity = intensity;
    }

    public int compareTo(Peak p) {
        return Double.compare(this.getIntensity(), p.getIntensity());
    }

    public double getMass(int chargeValue) {
        return this.mz * (double)chargeValue - (double)chargeValue * ElementaryIon.proton.getTheoreticMass();
    }
}

