/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.massspectrometry;

import com.compomics.util.experiment.identification.matches.IonMatch;
import com.compomics.util.experiment.identification.spectrum_annotation.AnnotationSettings;
import com.compomics.util.experiment.massspectrometry.Peak;
import com.compomics.util.experiment.massspectrometry.SimpleNoiseDistribution;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.math.BasicMathFunctions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.Semaphore;
import org.apache.commons.math.MathException;

public abstract class Spectrum
extends ExperimentObject {
    static final long serialVersionUID = 7152424141470431489L;
    protected String spectrumTitle;
    protected String fileName;
    protected int level;
    protected HashMap<Double, Peak> peakList;
    protected HashMap<Double, ArrayList<Peak>> intensityPeakMap = null;
    protected String scanNumber;
    protected double scanStartTime;
    public static final String SPECTRUM_KEY_SPLITTER = "_cus_";
    private double[][] jFreePeakList = null;
    private double[] mzValuesAsArray = null;
    private double[] mzValuesOrderedAsArray = null;
    private String peakListAsString = null;
    private double[] intensityValuesAsArray = null;
    private double[] intensityValuesNormaizedAsArray = null;
    private double[][] mzAndIntensityAsArray = null;
    private Double totalIntensity;
    private Double maxIntensity;
    private Double maxMz;
    private Double minMz;
    private Semaphore mutex = new Semaphore(1);
    private Double intensityLimit = null;
    private double intensityLimitLevel = -1.0;
    private AnnotationSettings.IntensityThresholdType intensityThresholdType = null;
    private SimpleNoiseDistribution binnedCumulativeFunction = null;

    public static String getSpectrumKey(String spectrumFile, String spectrumTitle) {
        return spectrumFile + SPECTRUM_KEY_SPLITTER + spectrumTitle;
    }

    public static String getSpectrumFile(String spectrumKey) {
        return spectrumKey.substring(0, spectrumKey.indexOf(SPECTRUM_KEY_SPLITTER));
    }

    public static String getSpectrumTitle(String spectrumKey) {
        return spectrumKey.substring(spectrumKey.indexOf(SPECTRUM_KEY_SPLITTER) + SPECTRUM_KEY_SPLITTER.length());
    }

    public void setSpectrumTitle(String spectrumTitle) {
        this.spectrumTitle = spectrumTitle;
    }

    public String getSpectrumKey() {
        StringBuilder stringBuilder = new StringBuilder(this.fileName.length() + SPECTRUM_KEY_SPLITTER.length() + this.spectrumTitle.length());
        stringBuilder.append(this.fileName);
        stringBuilder.append(SPECTRUM_KEY_SPLITTER);
        stringBuilder.append(this.spectrumTitle);
        return stringBuilder.toString();
    }

    public String getSpectrumTitle() {
        return this.spectrumTitle;
    }

    public double[][] getJFreePeakList() throws InterruptedException {
        if (this.jFreePeakList == null) {
            this.mutex.acquire();
            if (this.jFreePeakList == null) {
                double[] mz = new double[this.peakList.size()];
                double[] intensity = new double[this.peakList.size()];
                int cpt = 0;
                for (Peak currentPeak : this.peakList.values()) {
                    mz[cpt] = currentPeak.mz;
                    intensity[cpt] = currentPeak.intensity;
                    ++cpt;
                }
                this.jFreePeakList = new double[6][mz.length];
                this.jFreePeakList[0] = mz;
                this.jFreePeakList[1] = mz;
                this.jFreePeakList[2] = mz;
                this.jFreePeakList[3] = intensity;
                this.jFreePeakList[4] = intensity;
                this.jFreePeakList[5] = intensity;
            }
            this.mutex.release();
        }
        return this.jFreePeakList;
    }

    public HashMap<Double, Peak> getPeakMap() {
        return this.peakList;
    }

    public synchronized void addPeak(Peak aPeak) {
        if (this.peakList == null) {
            this.peakList = new HashMap();
        }
        this.peakList.put(aPeak.mz, aPeak);
        this.resetSavedData();
    }

    public synchronized void setPeaks(ArrayList<Peak> peaks) {
        if (this.peakList != null) {
            this.peakList.clear();
        } else {
            this.peakList = new HashMap();
        }
        for (Peak p : peaks) {
            double mz = p.mz;
            this.peakList.put(mz, p);
        }
        this.resetSavedData();
    }

    public String getScanNumber() {
        return this.scanNumber;
    }

    public synchronized void setScanNumber(String scanNumber) {
        this.scanNumber = scanNumber;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public int getLevel() {
        return this.level;
    }

    public Collection<Peak> getPeakList() {
        return this.peakList.values();
    }

    public synchronized void setPeakList(HashMap<Double, Peak> peakList) {
        this.peakList = peakList;
        this.resetSavedData();
    }

    public String getPeakListAsString() throws InterruptedException {
        if (this.peakListAsString == null) {
            double[] mzValues = this.getOrderedMzValues();
            this.mutex.acquire();
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            for (double mzValue : mzValues) {
                if (sb.length() > 1) {
                    sb.append(",");
                }
                Peak currentPeak = this.peakList.get(mzValue);
                sb.append("[");
                sb.append(currentPeak.mz);
                sb.append(",");
                sb.append(currentPeak.intensity);
                sb.append("]");
            }
            sb.append("]");
            this.peakListAsString = sb.toString();
            this.mutex.release();
        }
        return this.peakListAsString;
    }

    public double getScanStartTime() {
        return this.scanStartTime;
    }

    public synchronized void setScanStartTime(double scanStartTime) {
        this.scanStartTime = scanStartTime;
    }

    public synchronized void removePeakList() {
        if (this.peakList != null) {
            this.peakList.clear();
        }
    }

    public double[] getMzValuesAsArray() throws InterruptedException {
        if (this.mzValuesAsArray == null) {
            this.mutex.acquire();
            if (this.mzValuesAsArray == null) {
                this.mzValuesAsArray = new double[this.peakList.size()];
                int counter = 0;
                for (double currentMz : this.peakList.keySet()) {
                    this.mzValuesAsArray[counter++] = currentMz;
                }
            }
            this.mutex.release();
        }
        return this.mzValuesAsArray;
    }

    public double[] getOrderedMzValues() throws InterruptedException {
        if (this.mzValuesOrderedAsArray == null) {
            this.getMzValuesAsArray();
            if (this.mzValuesOrderedAsArray == null) {
                this.mutex.acquire();
                this.mzValuesOrderedAsArray = (double[])this.mzValuesAsArray.clone();
                Arrays.sort(this.mzValuesOrderedAsArray);
                this.mutex.release();
            }
        }
        return this.mzValuesOrderedAsArray;
    }

    public synchronized void setIntensityValuesAsArray(double[] intensityValuesAsArray) {
        this.intensityValuesAsArray = intensityValuesAsArray;
        this.removePeakList();
    }

    public double[] getIntensityValuesAsArray() throws InterruptedException {
        if (this.intensityValuesAsArray == null || this.intensityValuesAsArray.length != this.peakList.size()) {
            this.mutex.acquire();
            if (this.intensityValuesAsArray == null || this.intensityValuesAsArray.length != this.peakList.size()) {
                this.intensityValuesAsArray = new double[this.peakList.size()];
                int counter = 0;
                for (Peak currentPeak : this.peakList.values()) {
                    this.intensityValuesAsArray[counter++] = currentPeak.intensity;
                }
            }
            this.mutex.release();
        }
        return this.intensityValuesAsArray;
    }

    public double[] getIntensityValuesNormalizedAsArray() throws InterruptedException {
        if (this.intensityValuesNormaizedAsArray == null) {
            this.mutex.acquire();
            if (this.intensityValuesNormaizedAsArray == null) {
                this.intensityValuesNormaizedAsArray = new double[this.peakList.size()];
                double highestIntensity = 0.0;
                int counter = 0;
                for (Peak currentPeak : this.peakList.values()) {
                    this.intensityValuesNormaizedAsArray[counter++] = currentPeak.intensity;
                    if (!(currentPeak.intensity > highestIntensity)) continue;
                    highestIntensity = currentPeak.intensity;
                }
                if (highestIntensity > 0.0) {
                    for (int i = 0; i < this.intensityValuesNormaizedAsArray.length; ++i) {
                        this.intensityValuesNormaizedAsArray[i] = this.intensityValuesNormaizedAsArray[i] / highestIntensity * 100.0;
                    }
                }
            }
            this.mutex.release();
        }
        return this.intensityValuesNormaizedAsArray;
    }

    public double[][] getMzAndIntensityAsArray() throws InterruptedException {
        if (this.mzAndIntensityAsArray == null) {
            double[] orderedMzValues = this.getOrderedMzValues();
            this.mutex.acquire();
            if (this.mzAndIntensityAsArray == null) {
                this.mzAndIntensityAsArray = new double[2][this.peakList.size()];
                int counter = 0;
                for (double mz : orderedMzValues) {
                    Peak currentPeak = this.peakList.get(mz);
                    this.mzAndIntensityAsArray[0][counter] = currentPeak.mz;
                    this.mzAndIntensityAsArray[1][counter] = currentPeak.intensity;
                    ++counter;
                }
            }
            this.mutex.release();
        }
        return this.mzAndIntensityAsArray;
    }

    public double getTotalIntensity() throws InterruptedException {
        if (this.totalIntensity == null) {
            this.mutex.acquire();
            if (this.totalIntensity == null) {
                this.totalIntensity = 0.0;
                for (Peak currentPeak : this.peakList.values()) {
                    this.totalIntensity = this.totalIntensity + currentPeak.intensity;
                }
            }
            this.mutex.release();
        }
        return this.totalIntensity;
    }

    public double getMaxIntensity() throws InterruptedException {
        if (this.maxIntensity == null) {
            this.mutex.acquire();
            if (this.maxIntensity == null) {
                this.maxIntensity = 0.0;
                for (Peak currentPeak : this.peakList.values()) {
                    if (!(currentPeak.intensity > this.maxIntensity)) continue;
                    this.maxIntensity = currentPeak.intensity;
                }
            }
            this.mutex.release();
        }
        return this.maxIntensity;
    }

    public double getMaxMz() throws InterruptedException {
        if (this.maxMz == null) {
            this.mutex.acquire();
            if (this.maxMz == null) {
                this.maxMz = this.peakList.keySet().isEmpty() ? Double.valueOf(0.0) : Collections.max(this.peakList.keySet());
            }
            this.mutex.release();
        }
        return this.maxMz;
    }

    public double getMinMz() throws InterruptedException {
        if (this.minMz == null) {
            this.mutex.acquire();
            if (this.minMz == null) {
                this.minMz = this.peakList.keySet().isEmpty() ? Double.valueOf(0.0) : Collections.min(this.peakList.keySet());
            }
            this.mutex.release();
        }
        return this.minMz;
    }

    public ArrayList<Double> getPeaksAboveIntensityThreshold(double threshold) {
        ArrayList<Double> peakIntensities = new ArrayList<Double>();
        for (Peak currentPeak : this.peakList.values()) {
            if (!(currentPeak.intensity > threshold)) continue;
            peakIntensities.add(currentPeak.intensity);
        }
        return peakIntensities;
    }

    public double getIntensityLimit(AnnotationSettings.IntensityThresholdType intensityThresholdType, double intensityFraction) throws InterruptedException, MathException {
        if (this.intensityLimit == null || intensityThresholdType != this.intensityThresholdType || this.intensityLimitLevel != intensityFraction) {
            this.intensityLimit = this.estimateIntneistyLimit(intensityThresholdType, intensityFraction);
            this.intensityLimitLevel = intensityFraction;
            this.intensityThresholdType = intensityThresholdType;
        }
        return this.intensityLimit;
    }

    private double estimateIntneistyLimit(AnnotationSettings.IntensityThresholdType intensityThresholdType, double intensityThreshold) throws InterruptedException, MathException {
        if (intensityThreshold == 0.0) {
            return 0.0;
        }
        if (intensityThreshold == 1.0) {
            return this.getMaxIntensity();
        }
        switch (intensityThresholdType) {
            case snp: {
                SimpleNoiseDistribution binnedCumulativeFunction = this.getIntensityLogDistribution();
                return binnedCumulativeFunction.getIntensityAtP(1.0 - intensityThreshold);
            }
            case percentile: {
                ArrayList<Double> intensities = new ArrayList<Double>(this.peakList.size());
                for (Peak peak : this.peakList.values()) {
                    double mz = peak.mz;
                    if (!(mz > 200.0)) continue;
                    intensities.add(peak.intensity);
                }
                if (intensities.isEmpty()) {
                    return 0.0;
                }
                return BasicMathFunctions.percentile(intensities, intensityThreshold);
            }
        }
        throw new UnsupportedOperationException("Threshold of type " + (Object)((Object)intensityThresholdType) + " not supported.");
    }

    public HashMap<Double, Peak> getRecalibratedPeakList(HashMap<Double, Double> mzCorrections) {
        HashMap<Double, Peak> result = new HashMap<Double, Peak>(this.peakList.size());
        ArrayList<Double> keys = new ArrayList<Double>(mzCorrections.keySet());
        Collections.sort(keys);
        for (Peak peak : this.peakList.values()) {
            double fragmentMz = peak.mz;
            double key1 = keys.get(0);
            double correction = 0.0;
            if (fragmentMz <= key1) {
                correction = mzCorrections.get(key1);
            } else {
                key1 = keys.get(keys.size() - 1);
                if (fragmentMz >= key1) {
                    correction = mzCorrections.get(key1);
                } else {
                    for (int i = 0; i < keys.size() - 1; ++i) {
                        key1 = keys.get(i);
                        if (key1 == fragmentMz) {
                            correction = mzCorrections.get(key1);
                            break;
                        }
                        double key2 = keys.get(i + 1);
                        if (!(key1 < fragmentMz) || !(fragmentMz < key2)) continue;
                        double y1 = mzCorrections.get(key1);
                        double y2 = mzCorrections.get(key2);
                        correction = y1 + (fragmentMz - key1) * (y2 - y1) / (key2 - key1);
                        break;
                    }
                }
            }
            result.put(peak.mz - correction, new Peak(peak.mz - correction, peak.intensity));
        }
        return result;
    }

    public HashMap<Double, Peak> getDesignaledPeakList(ArrayList<IonMatch> matches) {
        HashMap<Double, Peak> result = new HashMap<Double, Peak>(this.peakList);
        for (IonMatch ionMatch : matches) {
            result.remove(ionMatch.peak.mz);
        }
        return result;
    }

    public HashMap<Double, Peak> getSubSpectrum(double mzMin, double mzMax) throws InterruptedException {
        HashMap<Double, Peak> result = new HashMap<Double, Peak>();
        for (double mz : this.getOrderedMzValues()) {
            if (mz >= mzMin && mz < mzMax) {
                result.put(mz, this.peakList.get(mz));
                continue;
            }
            if (mz >= mzMax) break;
        }
        return result;
    }

    public HashMap<Double, ArrayList<Peak>> getIntensityMap() throws InterruptedException {
        if (this.intensityPeakMap == null) {
            this.mutex.acquire();
            if (this.intensityPeakMap == null) {
                this.intensityPeakMap = new HashMap(this.peakList.size());
                for (Peak peak : this.peakList.values()) {
                    double intensity = peak.intensity;
                    ArrayList<Peak> peaksAtIntensity = this.intensityPeakMap.get(intensity);
                    if (peaksAtIntensity == null) {
                        peaksAtIntensity = new ArrayList();
                        this.intensityPeakMap.put(intensity, peaksAtIntensity);
                    }
                    peaksAtIntensity.add(peak);
                }
            }
            this.mutex.release();
        }
        return this.intensityPeakMap;
    }

    public int getNPeaks() {
        if (this.peakList == null) {
            return 0;
        }
        return this.peakList.size();
    }

    public boolean isEmpty() {
        return this.getNPeaks() == 0;
    }

    private void resetSavedData() {
        this.jFreePeakList = null;
        this.peakListAsString = null;
        this.mzValuesAsArray = null;
        this.mzValuesOrderedAsArray = null;
        this.intensityValuesAsArray = null;
        this.intensityValuesNormaizedAsArray = null;
        this.binnedCumulativeFunction = null;
        this.mzAndIntensityAsArray = null;
        this.totalIntensity = null;
        this.maxIntensity = null;
        this.maxMz = null;
        this.minMz = null;
        this.intensityPeakMap = null;
        this.intensityLimit = null;
        this.intensityThresholdType = null;
    }

    public SimpleNoiseDistribution getIntensityLogDistribution() throws InterruptedException, MathException {
        if (this.binnedCumulativeFunction == null) {
            this.mutex.acquire();
            if (this.binnedCumulativeFunction == null) {
                this.binnedCumulativeFunction = new SimpleNoiseDistribution(this.peakList);
            }
            this.mutex.release();
        }
        return this.binnedCumulativeFunction;
    }
}

