/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.filehandling;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.AbstractListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;

public class FileSelectionDialog
extends JDialog {
    private HashMap<String, File> fileMap = new HashMap();
    private boolean canceled = true;
    private JButton cancelButton;
    private JList fileList;
    private JScrollPane fileListScrollPane;
    private JLabel helpLabel;
    private JButton okButton;

    public FileSelectionDialog(JFrame parent, ArrayList<File> files, String text) {
        super((Frame)parent, true);
        this.initComponents();
        this.setUpGui(files, text);
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    public FileSelectionDialog(JDialog parent, ArrayList<File> files, String text) {
        super((Dialog)parent, true);
        this.initComponents();
        this.setUpGui(files, text);
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    private void setUpGui(ArrayList<File> files, String text) {
        String[] fileNames = new String[files.size()];
        for (int i = 0; i < files.size(); ++i) {
            fileNames[i] = files.get(i).getName();
            this.fileMap.put(files.get(i).getName(), files.get(i));
        }
        this.fileList.setListData(fileNames);
        this.fileList.setSelectedIndex(0);
        this.helpLabel.setText(text);
    }

    private void initComponents() {
        this.helpLabel = new JLabel();
        this.fileListScrollPane = new JScrollPane();
        this.fileList = new JList();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("SearchGUI Parameters");
        this.helpLabel.setFont(this.helpLabel.getFont().deriveFont(this.helpLabel.getFont().getStyle() | 2));
        this.helpLabel.setText("Please select the desired file.");
        this.fileList.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.fileList.setSelectionMode(0);
        this.fileList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                FileSelectionDialog.this.fileListMouseClicked(evt);
            }
        });
        this.fileListScrollPane.setViewportView(this.fileList);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileSelectionDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileSelectionDialog.this.okButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.helpLabel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addComponent(this.fileListScrollPane, -1, 482, Short.MAX_VALUE)).addContainerGap()));
        layout.linkSize(0, this.cancelButton, this.okButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.fileListScrollPane).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton).addComponent(this.helpLabel)).addContainerGap()));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.canceled = false;
        this.dispose();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.canceled = true;
        this.dispose();
    }

    private void fileListMouseClicked(MouseEvent evt) {
        if (evt.getButton() == 1 && evt.getClickCount() == 2 && this.fileList.getSelectedValue() != null) {
            this.okButtonActionPerformed(null);
        }
    }

    public File getSelectedFile() {
        String selectedName = (String)this.fileList.getSelectedValue();
        return this.fileMap.get(selectedName);
    }

    public boolean isCanceled() {
        return this.canceled;
    }
}

