/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.parameters.identification_parameters;

import com.compomics.util.experiment.identification.filtering.PeptideAssumptionFilter;
import com.compomics.util.gui.error_handlers.HelpDialog;
import com.compomics.util.gui.renderers.AlignedListCellRenderer;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class MatchesImportFiltersDialog
extends JDialog {
    private boolean canceled = false;
    private boolean editable;
    private JPanel backgroundPanel;
    private JButton cancelButton;
    private JPanel filterPanel;
    private JButton helpJButton;
    private JLabel isotopesLbl;
    private JLabel isotopesRangeLabel;
    private JTextField maxIsotopesTxt;
    private JTextField maxMissedCleavagesTxt;
    private JTextField minIsotopesTxt;
    private JTextField minMissedCleavagesTxt;
    private JLabel missedCleavagesLabel;
    private JLabel missedCleavagesRangeLabel;
    private JTextField nAAmaxTxt;
    private JTextField nAAminTxt;
    private JButton okButton;
    private JLabel peptideLengthLabel;
    private JLabel peptideLengthRangeLabel;
    private JTextField precDevTxt;
    private JLabel precursorAccuracyLabel;
    private JCheckBox ptmsCheck;
    private JComboBox unitCmb;

    public MatchesImportFiltersDialog(Frame parentFrame, PeptideAssumptionFilter idFilter, boolean editable) {
        super(parentFrame, true);
        this.editable = editable;
        this.setUpGui();
        this.populateGUI(idFilter);
        this.setLocationRelativeTo(parentFrame);
        this.setVisible(true);
    }

    public MatchesImportFiltersDialog(Dialog owner, Frame parentFrame, PeptideAssumptionFilter idFilter, boolean editable) {
        super(owner, true);
        this.editable = editable;
        this.setUpGui();
        this.populateGUI(idFilter);
        this.setLocationRelativeTo(owner);
        this.setVisible(true);
    }

    private void setUpGui() {
        this.initComponents();
        this.unitCmb.setRenderer(new AlignedListCellRenderer(0));
        this.nAAminTxt.setEditable(this.editable);
        this.nAAminTxt.setEnabled(this.editable);
        this.nAAmaxTxt.setEditable(this.editable);
        this.nAAmaxTxt.setEnabled(this.editable);
        this.precDevTxt.setEditable(this.editable);
        this.precDevTxt.setEnabled(this.editable);
        this.unitCmb.setEnabled(this.editable);
        this.unitCmb.setEnabled(this.editable);
        this.ptmsCheck.setEnabled(this.editable);
        this.minMissedCleavagesTxt.setEditable(this.editable);
        this.minMissedCleavagesTxt.setEnabled(this.editable);
        this.maxMissedCleavagesTxt.setEditable(this.editable);
        this.maxMissedCleavagesTxt.setEnabled(this.editable);
        this.minIsotopesTxt.setEditable(this.editable);
        this.minIsotopesTxt.setEnabled(this.editable);
        this.maxIsotopesTxt.setEditable(this.editable);
        this.maxIsotopesTxt.setEnabled(this.editable);
    }

    private void populateGUI(PeptideAssumptionFilter idFilter) {
        double doubleValue;
        int intValue = idFilter.getMinPepLength();
        if (intValue > 0) {
            this.nAAminTxt.setText(idFilter.getMinPepLength() + "");
        }
        if ((intValue = idFilter.getMaxPepLength()) > 0) {
            this.nAAmaxTxt.setText(idFilter.getMaxPepLength() + "");
        }
        if ((doubleValue = idFilter.getMaxMzDeviation()) > 0.0) {
            this.precDevTxt.setText(idFilter.getMaxMzDeviation() + "");
        }
        this.ptmsCheck.setSelected(idFilter.removeUnknownPTMs());
        if (idFilter.isIsPpm()) {
            this.unitCmb.setSelectedIndex(0);
        } else {
            this.unitCmb.setSelectedIndex(1);
        }
        if (idFilter.getMinMissedCleavages() != null) {
            this.minMissedCleavagesTxt.setText(idFilter.getMinMissedCleavages() + "");
        }
        if (idFilter.getMaxMissedCleavages() != null) {
            this.maxMissedCleavagesTxt.setText(idFilter.getMaxMissedCleavages() + "");
        }
        if (idFilter.getMinIsotopes() != null) {
            this.minIsotopesTxt.setText(idFilter.getMinIsotopes() + "");
        }
        if (idFilter.getMaxIsotopes() != null) {
            this.maxIsotopesTxt.setText(idFilter.getMaxIsotopes() + "");
        }
    }

    private boolean validateInput() {
        String input;
        try {
            input = this.nAAminTxt.getText();
            if (!input.equals("")) {
                new Integer(input);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Please verify the input for the minimal peptide length.", "Input Error", 0);
            return false;
        }
        try {
            input = this.nAAmaxTxt.getText();
            if (!input.equals("")) {
                new Integer(input);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Please verify the input for the maximal peptide length.", "Input Error", 0);
            return false;
        }
        try {
            input = this.precDevTxt.getText();
            if (!input.equals("")) {
                new Double(input);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Please verify the input for the precursor maximal deviation.", "Input Error", 0);
            return false;
        }
        Integer minCleavages = null;
        try {
            String input2 = this.minMissedCleavagesTxt.getText();
            if (!input2.equals("")) {
                minCleavages = new Integer(input2);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Please verify the input for the minimum number of missed cleavages.", "Input Error", 0);
            return false;
        }
        Integer maxCleavages = null;
        try {
            String input3 = this.maxMissedCleavagesTxt.getText();
            if (!input3.equals("")) {
                maxCleavages = new Integer(input3);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Please verify the input for the maximum number of missed cleavages.", "Input Error", 0);
            return false;
        }
        if (minCleavages != null && maxCleavages != null && maxCleavages <= minCleavages) {
            JOptionPane.showMessageDialog(null, "The maximum number of missed cleavages must be higher than the minimum.", "Input Error", 0);
            return false;
        }
        Integer minIsotopes = null;
        try {
            String input4 = this.minIsotopesTxt.getText();
            if (!input4.equals("")) {
                minIsotopes = new Integer(input4);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Please verify the input for the minimum number of isotopes.", "Input Error", 0);
            return false;
        }
        Integer maxIsotopes = null;
        try {
            String input5 = this.maxIsotopesTxt.getText();
            if (!input5.equals("")) {
                maxIsotopes = new Integer(input5);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Please verify the input for the maximum number of isotopes.", "Input Error", 0);
            return false;
        }
        if (minIsotopes != null && maxIsotopes != null && maxIsotopes <= minIsotopes) {
            JOptionPane.showMessageDialog(null, "The maximum number of isotopes must be higher than the minimum.", "Input Error", 0);
            return false;
        }
        return true;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public PeptideAssumptionFilter getFilter() {
        int nAAmin = -1;
        String input = this.nAAminTxt.getText();
        if (!input.equals("")) {
            nAAmin = new Integer(input);
        }
        int nAAmax = -1;
        input = this.nAAmaxTxt.getText();
        if (!input.equals("")) {
            nAAmax = new Integer(input);
        }
        double precDev = -1.0;
        input = this.precDevTxt.getText();
        if (!input.equals("")) {
            precDev = new Double(input);
        }
        boolean ppm = this.unitCmb.getSelectedIndex() == 0;
        boolean removePTM = this.ptmsCheck.isSelected();
        Integer minMissedCleavages = null;
        input = this.minMissedCleavagesTxt.getText();
        if (!input.equals("")) {
            minMissedCleavages = new Integer(input);
        }
        Integer maxMissedCleavages = null;
        input = this.maxMissedCleavagesTxt.getText();
        if (!input.equals("")) {
            maxMissedCleavages = new Integer(input);
        }
        Integer minIsotopes = null;
        input = this.minIsotopesTxt.getText();
        if (!input.equals("")) {
            minIsotopes = new Integer(input);
        }
        Integer maxIsotopes = null;
        input = this.maxIsotopesTxt.getText();
        if (!input.equals("")) {
            maxIsotopes = new Integer(input);
        }
        PeptideAssumptionFilter idFilter = new PeptideAssumptionFilter(nAAmin, nAAmax, precDev, ppm, removePTM, minMissedCleavages, maxMissedCleavages, minIsotopes, maxIsotopes);
        return idFilter;
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.filterPanel = new JPanel();
        this.nAAmaxTxt = new JTextField();
        this.peptideLengthRangeLabel = new JLabel();
        this.nAAminTxt = new JTextField();
        this.peptideLengthLabel = new JLabel();
        this.unitCmb = new JComboBox();
        this.precDevTxt = new JTextField();
        this.precursorAccuracyLabel = new JLabel();
        this.ptmsCheck = new JCheckBox();
        this.missedCleavagesLabel = new JLabel();
        this.minMissedCleavagesTxt = new JTextField();
        this.missedCleavagesRangeLabel = new JLabel();
        this.maxMissedCleavagesTxt = new JTextField();
        this.isotopesLbl = new JLabel();
        this.minIsotopesTxt = new JTextField();
        this.isotopesRangeLabel = new JLabel();
        this.maxIsotopesTxt = new JTextField();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.helpJButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Import Filters");
        this.setBackground(new Color(230, 230, 230));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                MatchesImportFiltersDialog.this.formWindowClosing(evt);
            }
        });
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.filterPanel.setBorder(BorderFactory.createTitledBorder("Filters"));
        this.filterPanel.setOpaque(false);
        this.nAAmaxTxt.setHorizontalAlignment(0);
        this.peptideLengthRangeLabel.setHorizontalAlignment(0);
        this.peptideLengthRangeLabel.setText("-");
        this.nAAminTxt.setHorizontalAlignment(0);
        this.peptideLengthLabel.setText("Peptide Length");
        this.unitCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"ppm", "Da"}));
        this.precDevTxt.setHorizontalAlignment(0);
        this.precursorAccuracyLabel.setText("Precursor m/z Deviation");
        this.ptmsCheck.setText("Exclude Unknown PTMs");
        this.ptmsCheck.setHorizontalAlignment(2);
        this.ptmsCheck.setHorizontalTextPosition(10);
        this.ptmsCheck.setIconTextGap(10);
        this.ptmsCheck.setMargin(new Insets(2, 0, 2, 2));
        this.missedCleavagesLabel.setText("Missed Cleavages");
        this.minMissedCleavagesTxt.setHorizontalAlignment(0);
        this.missedCleavagesRangeLabel.setHorizontalAlignment(0);
        this.missedCleavagesRangeLabel.setText("-");
        this.maxMissedCleavagesTxt.setHorizontalAlignment(0);
        this.isotopesLbl.setText("Isotopes");
        this.minIsotopesTxt.setHorizontalAlignment(0);
        this.isotopesRangeLabel.setHorizontalAlignment(0);
        this.isotopesRangeLabel.setText("-");
        this.maxIsotopesTxt.setHorizontalAlignment(0);
        GroupLayout filterPanelLayout = new GroupLayout(this.filterPanel);
        this.filterPanel.setLayout(filterPanelLayout);
        filterPanelLayout.setHorizontalGroup(filterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(filterPanelLayout.createSequentialGroup().addContainerGap().addGroup(filterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(filterPanelLayout.createSequentialGroup().addGroup(filterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.peptideLengthLabel).addComponent(this.precursorAccuracyLabel).addComponent(this.missedCleavagesLabel).addComponent(this.isotopesLbl)).addGap(27, 27, 27).addGroup(filterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(filterPanelLayout.createSequentialGroup().addComponent(this.minIsotopesTxt).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.isotopesRangeLabel, -2, 10, -2)).addGroup(filterPanelLayout.createSequentialGroup().addGroup(filterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.precDevTxt, -1, 83, Short.MAX_VALUE).addComponent(this.nAAminTxt)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.peptideLengthRangeLabel, -2, 10, -2)).addGroup(filterPanelLayout.createSequentialGroup().addComponent(this.minMissedCleavagesTxt).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.missedCleavagesRangeLabel, -2, 10, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(filterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.maxIsotopesTxt).addComponent(this.maxMissedCleavagesTxt).addComponent(this.nAAmaxTxt).addComponent(this.unitCmb, 0, 82, Short.MAX_VALUE))).addGroup(filterPanelLayout.createSequentialGroup().addComponent(this.ptmsCheck, -2, 279, -2).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        filterPanelLayout.setVerticalGroup(filterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(filterPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(filterPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nAAmaxTxt, -2, -1, -2).addComponent(this.nAAminTxt, -2, -1, -2).addComponent(this.peptideLengthLabel).addComponent(this.peptideLengthRangeLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(filterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.unitCmb, -2, -1, -2).addGroup(filterPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.precDevTxt, -2, -1, -2).addComponent(this.precursorAccuracyLabel))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(filterPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.maxMissedCleavagesTxt, -2, -1, -2).addComponent(this.minMissedCleavagesTxt, -2, -1, -2).addComponent(this.missedCleavagesLabel).addComponent(this.missedCleavagesRangeLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(filterPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.maxIsotopesTxt, -2, -1, -2).addComponent(this.minIsotopesTxt, -2, -1, -2).addComponent(this.isotopesLbl).addComponent(this.isotopesRangeLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.ptmsCheck)));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MatchesImportFiltersDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MatchesImportFiltersDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.helpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help.GIF")));
        this.helpJButton.setToolTipText("Help");
        this.helpJButton.setBorder(null);
        this.helpJButton.setBorderPainted(false);
        this.helpJButton.setContentAreaFilled(false);
        this.helpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                MatchesImportFiltersDialog.this.helpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                MatchesImportFiltersDialog.this.helpJButtonMouseExited(evt);
            }
        });
        this.helpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MatchesImportFiltersDialog.this.helpJButtonActionPerformed(evt);
            }
        });
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addGap(20, 20, 20).addComponent(this.helpJButton, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.filterPanel, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        backgroundPanelLayout.linkSize(0, this.cancelButton, this.okButton);
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.filterPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.helpJButton, -2, 23, -2).addComponent(this.okButton).addComponent(this.cancelButton)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -2, -1, -2));
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.canceled = true;
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.editable) {
            if (this.validateInput()) {
                this.dispose();
            }
        } else {
            this.dispose();
        }
    }

    private void helpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void helpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void helpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog(this, this.getClass().getResource("/helpFiles/FilterSettings.html"), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), "Import Filters - Help", 500, 10);
        this.setCursor(new Cursor(0));
    }

    private void formWindowClosing(WindowEvent evt) {
        this.canceled = true;
    }
}

