/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.parameters.identification_parameters.algorithm_settings;

import com.compomics.util.examples.BareBonesBrowserLaunch;
import com.compomics.util.experiment.identification.identification_parameters.IdentificationAlgorithmParameter;
import com.compomics.util.experiment.identification.identification_parameters.tool_specific.MyriMatchParameters;
import com.compomics.util.gui.GuiUtilities;
import com.compomics.util.gui.JOptionEditorPane;
import com.compomics.util.gui.parameters.identification_parameters.AlgorithmSettingsDialog;
import com.compomics.util.gui.renderers.AlignedListCellRenderer;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;

public class MyriMatchSettingsDialog
extends JDialog
implements AlgorithmSettingsDialog {
    private boolean cancelled = false;
    private boolean editable;
    private JPanel advancedSearchSettingsPanel;
    private JPanel advancedSettingsPanel;
    private JLabel advancedSettingsWarningLabel;
    private JPanel backgroundPanel;
    private JLabel classSizeMultiplierLabel;
    private JTextField classSizeMultiplierTxt;
    private JButton closeButton;
    private JComboBox computeXCorrCmb;
    private JLabel computeXCorrlLabel;
    private JComboBox fragmentationMethodCmb;
    private JLabel fragmentationMethodLabel;
    private JLabel maxPeakCountLabel;
    private JTextField maxPeakCountTxt;
    private JTextField maxPepLengthTxt;
    private JTextField maxPrecursorMassTxt;
    private JLabel maxPtmsLabel;
    private JTextField maxPtmsTxt;
    private JTextField minPepLengthTxt;
    private JTextField minPrecursorMassTxt;
    private JLabel numIntensityClassesLabel;
    private JTextField numIntensityClassesTxt;
    private JLabel numbBatchesLabel;
    private JTextField numbBatchesTxt;
    private JLabel numberMatchesLabel;
    private JTextField numberMatchesTxt;
    private JLabel numberTerminiLabel;
    private JButton okButton;
    private JButton openDialogHelpJButton;
    private JComboBox outputFormatCmb;
    private JLabel outputFormatLabel;
    private JLabel peptideLengthDividerLabel;
    private JLabel peptideLengthLabel;
    private JLabel precursorMassDividerLabel;
    private JLabel precursorMassLabel;
    private JScrollPane scrollPane;
    private JComboBox terminiCmb;
    private JLabel ticCutoffPercentageLabel;
    private JTextField ticCutoffPercentageTxt;
    private JComboBox useSmartPlusThreeModelCmb;
    private JLabel useSmartPlusThreeModelLabel;

    public MyriMatchSettingsDialog(Frame parent, MyriMatchParameters myriMatchParameters, boolean editable) {
        super(parent, true);
        this.editable = editable;
        this.initComponents();
        this.setUpGUI();
        this.populateGUI(myriMatchParameters);
        this.validateInput(false);
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    public MyriMatchSettingsDialog(Dialog owner, Frame parent, MyriMatchParameters myriMatchParameters, boolean editable) {
        super(owner, true);
        this.editable = editable;
        this.initComponents();
        this.setUpGUI();
        this.populateGUI(myriMatchParameters);
        this.validateInput(false);
        this.setLocationRelativeTo(owner);
        this.setVisible(true);
    }

    private void setUpGUI() {
        this.useSmartPlusThreeModelCmb.setRenderer(new AlignedListCellRenderer(0));
        this.computeXCorrCmb.setRenderer(new AlignedListCellRenderer(0));
        this.terminiCmb.setRenderer(new AlignedListCellRenderer(0));
        this.fragmentationMethodCmb.setRenderer(new AlignedListCellRenderer(0));
        this.outputFormatCmb.setRenderer(new AlignedListCellRenderer(0));
    }

    private void populateGUI(MyriMatchParameters myriMatchParameters) {
        if (myriMatchParameters.getMinPeptideLength() != null) {
            this.minPepLengthTxt.setText(myriMatchParameters.getMinPeptideLength() + "");
        }
        if (myriMatchParameters.getMaxPeptideLength() != null) {
            this.maxPepLengthTxt.setText(myriMatchParameters.getMaxPeptideLength() + "");
        }
        if (myriMatchParameters.getMinPrecursorMass() != null) {
            this.minPrecursorMassTxt.setText(myriMatchParameters.getMinPrecursorMass() + "");
        }
        if (myriMatchParameters.getMaxPrecursorMass() != null) {
            this.maxPrecursorMassTxt.setText(myriMatchParameters.getMaxPrecursorMass() + "");
        }
        if (myriMatchParameters.getNumberOfSpectrumMatches() != null) {
            this.numberMatchesTxt.setText(myriMatchParameters.getNumberOfSpectrumMatches() + "");
        }
        if (myriMatchParameters.getMaxDynamicMods() != null) {
            this.maxPtmsTxt.setText(myriMatchParameters.getMaxDynamicMods() + "");
        }
        this.fragmentationMethodCmb.setSelectedItem(myriMatchParameters.getFragmentationRule());
        if (myriMatchParameters.getMinTerminiCleavages() != null) {
            this.terminiCmb.setSelectedIndex(myriMatchParameters.getMinTerminiCleavages());
        }
        if (myriMatchParameters.getUseSmartPlusThreeModel()) {
            this.useSmartPlusThreeModelCmb.setSelectedIndex(0);
        } else {
            this.useSmartPlusThreeModelCmb.setSelectedIndex(1);
        }
        if (myriMatchParameters.getComputeXCorr()) {
            this.computeXCorrCmb.setSelectedIndex(0);
        } else {
            this.computeXCorrCmb.setSelectedIndex(1);
        }
        if (myriMatchParameters.getTicCutoffPercentage() != null) {
            this.ticCutoffPercentageTxt.setText(myriMatchParameters.getTicCutoffPercentage() + "");
        }
        if (myriMatchParameters.getNumIntensityClasses() != null) {
            this.numIntensityClassesTxt.setText(myriMatchParameters.getNumIntensityClasses() + "");
        }
        if (myriMatchParameters.getClassSizeMultiplier() != null) {
            this.classSizeMultiplierTxt.setText(myriMatchParameters.getClassSizeMultiplier() + "");
        }
        if (myriMatchParameters.getNumberOfBatches() != null) {
            this.numbBatchesTxt.setText(myriMatchParameters.getNumberOfBatches() + "");
        }
        if (myriMatchParameters.getMaxPeakCount() != null) {
            this.maxPeakCountTxt.setText(myriMatchParameters.getMaxPeakCount() + "");
        }
        if (myriMatchParameters.getOutputFormat().equalsIgnoreCase("mzIdentML")) {
            this.outputFormatCmb.setSelectedIndex(0);
        } else {
            this.outputFormatCmb.setSelectedIndex(1);
        }
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public IdentificationAlgorithmParameter getParameters() {
        return this.getInput();
    }

    public MyriMatchParameters getInput() {
        MyriMatchParameters result = new MyriMatchParameters();
        String input = this.minPepLengthTxt.getText().trim();
        if (!input.equals("")) {
            result.setMinPeptideLength(new Integer(input));
        }
        if (!(input = this.maxPepLengthTxt.getText().trim()).equals("")) {
            result.setMaxPeptideLength(new Integer(input));
        }
        if (!(input = this.minPrecursorMassTxt.getText().trim()).equals("")) {
            result.setMinPrecursorMass(new Double(input));
        }
        if (!(input = this.maxPrecursorMassTxt.getText().trim()).equals("")) {
            result.setMaxPrecursorMass(new Double(input));
        }
        if (!(input = this.numberMatchesTxt.getText().trim()).equals("")) {
            result.setNumberOfSpectrumMatches(new Integer(input));
        }
        if (!(input = this.maxPtmsTxt.getText().trim()).equals("")) {
            result.setMaxDynamicMods(new Integer(input));
        }
        result.setFragmentationRule((String)this.fragmentationMethodCmb.getSelectedItem());
        result.setMinTerminiCleavages(this.terminiCmb.getSelectedIndex());
        result.setUseSmartPlusThreeModel(this.useSmartPlusThreeModelCmb.getSelectedIndex() == 0);
        result.setComputeXCorr(this.computeXCorrCmb.getSelectedIndex() == 0);
        input = this.ticCutoffPercentageTxt.getText().trim();
        if (!input.equals("")) {
            result.setTicCutoffPercentage(new Double(input));
        }
        if (!(input = this.numIntensityClassesTxt.getText().trim()).equals("")) {
            result.setNumIntensityClasses(new Integer(input));
        }
        if (!(input = this.classSizeMultiplierTxt.getText().trim()).equals("")) {
            result.setClassSizeMultiplier(new Integer(input));
        }
        if (!(input = this.numbBatchesTxt.getText().trim()).equals("")) {
            result.setNumberOfBatches(new Integer(input));
        }
        if (!(input = this.maxPeakCountTxt.getText().trim()).equals("")) {
            result.setMaxPeakCount(new Integer(input));
        }
        result.setOutputFormat((String)this.outputFormatCmb.getSelectedItem());
        return result;
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.advancedSearchSettingsPanel = new JPanel();
        this.scrollPane = new JScrollPane();
        this.advancedSettingsPanel = new JPanel();
        this.useSmartPlusThreeModelCmb = new JComboBox();
        this.useSmartPlusThreeModelLabel = new JLabel();
        this.minPepLengthTxt = new JTextField();
        this.peptideLengthDividerLabel = new JLabel();
        this.maxPepLengthTxt = new JTextField();
        this.peptideLengthLabel = new JLabel();
        this.numberMatchesLabel = new JLabel();
        this.numberMatchesTxt = new JTextField();
        this.computeXCorrlLabel = new JLabel();
        this.computeXCorrCmb = new JComboBox();
        this.numberTerminiLabel = new JLabel();
        this.maxPtmsLabel = new JLabel();
        this.maxPtmsTxt = new JTextField();
        this.terminiCmb = new JComboBox();
        this.precursorMassLabel = new JLabel();
        this.minPrecursorMassTxt = new JTextField();
        this.precursorMassDividerLabel = new JLabel();
        this.maxPrecursorMassTxt = new JTextField();
        this.ticCutoffPercentageLabel = new JLabel();
        this.ticCutoffPercentageTxt = new JTextField();
        this.numIntensityClassesLabel = new JLabel();
        this.numIntensityClassesTxt = new JTextField();
        this.classSizeMultiplierLabel = new JLabel();
        this.classSizeMultiplierTxt = new JTextField();
        this.numbBatchesLabel = new JLabel();
        this.numbBatchesTxt = new JTextField();
        this.fragmentationMethodLabel = new JLabel();
        this.fragmentationMethodCmb = new JComboBox();
        this.maxPeakCountLabel = new JLabel();
        this.maxPeakCountTxt = new JTextField();
        this.outputFormatLabel = new JLabel();
        this.outputFormatCmb = new JComboBox();
        this.okButton = new JButton();
        this.closeButton = new JButton();
        this.openDialogHelpJButton = new JButton();
        this.advancedSettingsWarningLabel = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("MyriMatch Advanced Settings");
        this.setMinimumSize(new Dimension(400, 400));
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.advancedSearchSettingsPanel.setBorder(BorderFactory.createTitledBorder("Search Settings"));
        this.advancedSearchSettingsPanel.setOpaque(false);
        this.scrollPane.setBorder(null);
        this.advancedSettingsPanel.setBackground(new Color(230, 230, 230));
        this.useSmartPlusThreeModelCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.useSmartPlusThreeModelLabel.setText("Use Smart Plus Thee Model");
        this.minPepLengthTxt.setHorizontalAlignment(0);
        this.minPepLengthTxt.setText("6");
        this.minPepLengthTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MyriMatchSettingsDialog.this.minPepLengthTxtKeyReleased(evt);
            }
        });
        this.peptideLengthDividerLabel.setHorizontalAlignment(0);
        this.peptideLengthDividerLabel.setText("-");
        this.maxPepLengthTxt.setHorizontalAlignment(0);
        this.maxPepLengthTxt.setText("30");
        this.maxPepLengthTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MyriMatchSettingsDialog.this.maxPepLengthTxtKeyReleased(evt);
            }
        });
        this.peptideLengthLabel.setText("Peptide Length (min - max)");
        this.numberMatchesLabel.setText("Number of Spectrum Matches");
        this.numberMatchesTxt.setHorizontalAlignment(0);
        this.numberMatchesTxt.setText("1");
        this.numberMatchesTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MyriMatchSettingsDialog.this.numberMatchesTxtKeyReleased(evt);
            }
        });
        this.computeXCorrlLabel.setText("Compute XCorr");
        this.computeXCorrCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.computeXCorrCmb.setSelectedIndex(1);
        this.numberTerminiLabel.setText("Enzymatic Terminals");
        this.maxPtmsLabel.setText("Max Variable PTMs per Peptide");
        this.maxPtmsTxt.setHorizontalAlignment(0);
        this.maxPtmsTxt.setText("2");
        this.maxPtmsTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MyriMatchSettingsDialog.this.maxPtmsTxtKeyReleased(evt);
            }
        });
        this.terminiCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"None Required", "At Least One", "Both"}));
        this.terminiCmb.setSelectedIndex(2);
        this.precursorMassLabel.setText("Precursor Mass (min - max)");
        this.minPrecursorMassTxt.setHorizontalAlignment(0);
        this.minPrecursorMassTxt.setText("0");
        this.minPrecursorMassTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MyriMatchSettingsDialog.this.minPrecursorMassTxtKeyReleased(evt);
            }
        });
        this.precursorMassDividerLabel.setHorizontalAlignment(0);
        this.precursorMassDividerLabel.setText("-");
        this.maxPrecursorMassTxt.setHorizontalAlignment(0);
        this.maxPrecursorMassTxt.setText("10000");
        this.maxPrecursorMassTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MyriMatchSettingsDialog.this.maxPrecursorMassTxtKeyReleased(evt);
            }
        });
        this.ticCutoffPercentageLabel.setText("TIC Cutoff Percentage (0.0-1.0)");
        this.ticCutoffPercentageTxt.setHorizontalAlignment(0);
        this.ticCutoffPercentageTxt.setText("0.98");
        this.ticCutoffPercentageTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MyriMatchSettingsDialog.this.ticCutoffPercentageTxtKeyReleased(evt);
            }
        });
        this.numIntensityClassesLabel.setText("Number of Intensity Classes");
        this.numIntensityClassesTxt.setHorizontalAlignment(0);
        this.numIntensityClassesTxt.setText("3");
        this.numIntensityClassesTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MyriMatchSettingsDialog.this.numIntensityClassesTxtKeyReleased(evt);
            }
        });
        this.classSizeMultiplierLabel.setText("Class Size Multiplier");
        this.classSizeMultiplierTxt.setHorizontalAlignment(0);
        this.classSizeMultiplierTxt.setText("2");
        this.classSizeMultiplierTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MyriMatchSettingsDialog.this.classSizeMultiplierTxtKeyReleased(evt);
            }
        });
        this.numbBatchesLabel.setText("Number of Batches");
        this.numbBatchesTxt.setHorizontalAlignment(0);
        this.numbBatchesTxt.setText("50");
        this.numbBatchesTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MyriMatchSettingsDialog.this.numbBatchesTxtKeyReleased(evt);
            }
        });
        this.fragmentationMethodLabel.setText("Fragmentation Method");
        this.fragmentationMethodCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"CID", "HCD", "ETD"}));
        this.maxPeakCountLabel.setText("Max Peak Count");
        this.maxPeakCountTxt.setHorizontalAlignment(0);
        this.maxPeakCountTxt.setText("100");
        this.maxPeakCountTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MyriMatchSettingsDialog.this.maxPeakCountTxtKeyReleased(evt);
            }
        });
        this.outputFormatLabel.setText("Output Format");
        this.outputFormatCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"mzIdentML", "pepXML"}));
        this.outputFormatCmb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyriMatchSettingsDialog.this.outputFormatCmbActionPerformed(evt);
            }
        });
        GroupLayout advancedSettingsPanelLayout = new GroupLayout(this.advancedSettingsPanel);
        this.advancedSettingsPanel.setLayout(advancedSettingsPanelLayout);
        advancedSettingsPanelLayout.setHorizontalGroup(advancedSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(advancedSettingsPanelLayout.createSequentialGroup().addComponent(this.useSmartPlusThreeModelLabel, -2, 200, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.useSmartPlusThreeModelCmb, 0, -1, Short.MAX_VALUE)).addGroup(advancedSettingsPanelLayout.createSequentialGroup().addComponent(this.computeXCorrlLabel, -2, 200, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.computeXCorrCmb, 0, -1, Short.MAX_VALUE)).addGroup(advancedSettingsPanelLayout.createSequentialGroup().addComponent(this.ticCutoffPercentageLabel, -2, 200, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ticCutoffPercentageTxt)).addGroup(advancedSettingsPanelLayout.createSequentialGroup().addComponent(this.numIntensityClassesLabel, -2, 200, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.numIntensityClassesTxt)).addGroup(advancedSettingsPanelLayout.createSequentialGroup().addComponent(this.classSizeMultiplierLabel, -2, 200, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.classSizeMultiplierTxt)).addGroup(advancedSettingsPanelLayout.createSequentialGroup().addComponent(this.numbBatchesLabel, -2, 200, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.numbBatchesTxt)).addGroup(advancedSettingsPanelLayout.createSequentialGroup().addComponent(this.numberMatchesLabel, -2, 200, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.numberMatchesTxt)).addGroup(advancedSettingsPanelLayout.createSequentialGroup().addComponent(this.maxPtmsLabel, -2, 200, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.maxPtmsTxt)).addGroup(advancedSettingsPanelLayout.createSequentialGroup().addComponent(this.numberTerminiLabel, -2, 200, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.terminiCmb, 0, -1, Short.MAX_VALUE)).addGroup(advancedSettingsPanelLayout.createSequentialGroup().addComponent(this.peptideLengthLabel, -2, 200, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.minPepLengthTxt, -1, 77, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.peptideLengthDividerLabel, -2, 27, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.maxPepLengthTxt, -1, 77, Short.MAX_VALUE)).addGroup(advancedSettingsPanelLayout.createSequentialGroup().addComponent(this.precursorMassLabel, -2, 200, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.minPrecursorMassTxt, -1, 77, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.precursorMassDividerLabel, -2, 27, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.maxPrecursorMassTxt, -1, 77, Short.MAX_VALUE)).addGroup(advancedSettingsPanelLayout.createSequentialGroup().addComponent(this.fragmentationMethodLabel, -2, 200, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fragmentationMethodCmb, 0, -1, Short.MAX_VALUE)).addGroup(advancedSettingsPanelLayout.createSequentialGroup().addComponent(this.maxPeakCountLabel, -2, 200, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.maxPeakCountTxt)).addGroup(advancedSettingsPanelLayout.createSequentialGroup().addComponent(this.outputFormatLabel, -2, 200, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.outputFormatCmb, 0, -1, Short.MAX_VALUE)));
        advancedSettingsPanelLayout.setVerticalGroup(advancedSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(advancedSettingsPanelLayout.createSequentialGroup().addGroup(advancedSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.minPepLengthTxt, -2, -1, -2).addComponent(this.maxPepLengthTxt, -2, -1, -2).addComponent(this.peptideLengthDividerLabel).addComponent(this.peptideLengthLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.minPrecursorMassTxt, -2, -1, -2).addComponent(this.maxPrecursorMassTxt, -2, -1, -2).addComponent(this.precursorMassDividerLabel).addComponent(this.precursorMassLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.numberMatchesLabel).addComponent(this.numberMatchesTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.maxPtmsLabel).addComponent(this.maxPtmsTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fragmentationMethodCmb, -2, -1, -2).addComponent(this.fragmentationMethodLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.numberTerminiLabel).addComponent(this.terminiCmb, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.useSmartPlusThreeModelLabel).addComponent(this.useSmartPlusThreeModelCmb, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.computeXCorrlLabel).addComponent(this.computeXCorrCmb, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.ticCutoffPercentageLabel).addComponent(this.ticCutoffPercentageTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.numIntensityClassesLabel).addComponent(this.numIntensityClassesTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.classSizeMultiplierLabel).addComponent(this.classSizeMultiplierTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.numbBatchesLabel).addComponent(this.numbBatchesTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.maxPeakCountLabel).addComponent(this.maxPeakCountTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.outputFormatLabel).addComponent(this.outputFormatCmb, -2, -1, -2)).addContainerGap()));
        this.scrollPane.setViewportView(this.advancedSettingsPanel);
        GroupLayout advancedSearchSettingsPanelLayout = new GroupLayout(this.advancedSearchSettingsPanel);
        this.advancedSearchSettingsPanel.setLayout(advancedSearchSettingsPanelLayout);
        advancedSearchSettingsPanelLayout.setHorizontalGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(advancedSearchSettingsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.scrollPane).addContainerGap()));
        advancedSearchSettingsPanelLayout.setVerticalGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(advancedSearchSettingsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.scrollPane).addContainerGap()));
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyriMatchSettingsDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyriMatchSettingsDialog.this.closeButtonActionPerformed(evt);
            }
        });
        this.openDialogHelpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help.GIF")));
        this.openDialogHelpJButton.setToolTipText("Help");
        this.openDialogHelpJButton.setBorder(null);
        this.openDialogHelpJButton.setBorderPainted(false);
        this.openDialogHelpJButton.setContentAreaFilled(false);
        this.openDialogHelpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                MyriMatchSettingsDialog.this.openDialogHelpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                MyriMatchSettingsDialog.this.openDialogHelpJButtonMouseExited(evt);
            }
        });
        this.openDialogHelpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyriMatchSettingsDialog.this.openDialogHelpJButtonActionPerformed(evt);
            }
        });
        this.advancedSettingsWarningLabel.setText("Click to open the MyriMatch help page.");
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.advancedSearchSettingsPanel, -1, -1, Short.MAX_VALUE).addGroup(backgroundPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.openDialogHelpJButton).addGap(18, 18, 18).addComponent(this.advancedSettingsWarningLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.okButton, -2, 59, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeButton))).addContainerGap()));
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.advancedSearchSettingsPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.openDialogHelpJButton).addComponent(this.advancedSettingsWarningLabel).addComponent(this.okButton).addComponent(this.closeButton)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.cancelled = true;
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.validateInput(true)) {
            this.dispose();
        }
    }

    private void openDialogHelpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void openDialogHelpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void openDialogHelpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("http://fenchurch.mc.vanderbilt.edu/bumbershoot/myrimatch/");
        this.setCursor(new Cursor(0));
    }

    private void minPepLengthTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void maxPepLengthTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void numberMatchesTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void maxPtmsTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void minPrecursorMassTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void maxPrecursorMassTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void ticCutoffPercentageTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void numIntensityClassesTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void classSizeMultiplierTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void numbBatchesTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void maxPeakCountTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void outputFormatCmbActionPerformed(ActionEvent evt) {
        if (this.outputFormatCmb.getSelectedIndex() != 0 && this.isVisible()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(MyriMatchSettingsDialog.this, JOptionEditorPane.getJOptionEditorPane("Note that the MyriMatch pepXML format is not compatible with <a href=\"http://compomics.github.io/projects/peptide-shaker.html\">PeptideShaker</a>."), "Format Warning", 2);
                }
            });
        }
    }

    public boolean validateInput(boolean showMessage) {
        boolean valid = true;
        valid = GuiUtilities.validateIntegerInput(this, this.peptideLengthLabel, this.minPepLengthTxt, "minimum peptide length", "Peptide Length Error", true, showMessage, valid);
        valid = GuiUtilities.validateIntegerInput(this, this.peptideLengthLabel, this.maxPepLengthTxt, "maximum peptide length", "Peptide Length Error", true, showMessage, valid);
        valid = GuiUtilities.validateDoubleInput(this, this.precursorMassLabel, this.minPrecursorMassTxt, "minimum precursor mass", "Precursor Mass Error", true, showMessage, valid);
        valid = GuiUtilities.validateDoubleInput(this, this.precursorMassLabel, this.maxPrecursorMassTxt, "maximum precursor mass", "Precursor Mass Error", true, showMessage, valid);
        valid = GuiUtilities.validateIntegerInput(this, this.numberMatchesLabel, this.numberMatchesTxt, "number of spectrum matches", "Number Spectrum Matches Error", true, showMessage, valid);
        valid = GuiUtilities.validateIntegerInput(this, this.maxPtmsLabel, this.maxPtmsTxt, "max number of PTMs per peptide", "Peptide PTM Error", true, showMessage, valid);
        valid = GuiUtilities.validateDoubleInput(this, this.ticCutoffPercentageLabel, this.ticCutoffPercentageTxt, "TIC cutoff precentage", "TIC Cutoff Percentage Error", true, showMessage, valid);
        valid = GuiUtilities.validateIntegerInput(this, this.numIntensityClassesLabel, this.numIntensityClassesTxt, "number of intensity classes", "Intensity Classes Error", true, showMessage, valid);
        valid = GuiUtilities.validateIntegerInput(this, this.classSizeMultiplierLabel, this.classSizeMultiplierTxt, "class size multiplier", "Class Size Error", true, showMessage, valid);
        valid = GuiUtilities.validateIntegerInput(this, this.numbBatchesLabel, this.numbBatchesTxt, "number of batches", "Number of Batches Error", true, showMessage, valid);
        valid = GuiUtilities.validateIntegerInput(this, this.maxPeakCountLabel, this.maxPeakCountTxt, "maximum peak count", "Max Peak Count Error", true, showMessage, valid);
        try {
            double temp = Double.parseDouble(this.ticCutoffPercentageTxt.getText().trim());
            if (temp < 0.0 || temp > 1.0) {
                if (showMessage && valid) {
                    JOptionPane.showMessageDialog(this, "The TIC cutoff percentage has to be between 0.0 and 1.0.", "TIC Cutoff Percentage Error", 2);
                }
                valid = false;
                this.ticCutoffPercentageLabel.setForeground(Color.RED);
                this.ticCutoffPercentageLabel.setToolTipText("Please select a valid TIC cutoff percentage [0.0-1.0]");
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.okButton.setEnabled(valid);
        return valid;
    }
}

