/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.tablemodels;

import com.compomics.util.gui.TableMouseWheelListener;
import com.compomics.util.gui.TableScrollBarListener;
import com.compomics.util.gui.waiting.waitinghandlers.ProgressDialogX;
import com.compomics.util.gui.waiting.waitinghandlers.WaitingHandlerDummy;
import com.compomics.util.waiting.WaitingHandler;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;

public abstract class SelfUpdatingTableModel
extends DefaultTableModel {
    private int rowStartLoading = -1;
    private int rowEndLoading = -1;
    private static int batchSize = 100;
    private boolean selfUpdating = true;
    private boolean updateScheduled = false;
    private LoadingRunnable lastLoadingRunnable = null;
    private ArrayList<Integer> viewIndexes = null;
    private int lastColumnSorted = -1;
    private boolean sortAscending = false;
    private boolean unsorted = true;
    private ProgressDialogX progressDialog;
    public boolean isScrolling = false;

    protected abstract int loadDataForRows(ArrayList<Integer> var1, WaitingHandler var2);

    protected abstract void loadDataForColumn(int var1, WaitingHandler var2);

    protected abstract void catchException(Exception var1);

    protected void dataMissingAtRow(int row) throws InterruptedException {
        int anticipatedStart = (int)((double)row + 0.9 * (double)batchSize);
        if (this.lastLoadingRunnable == null || this.lastLoadingRunnable.isFinished() || row < this.rowStartLoading || row >= anticipatedStart) {
            this.rowStartLoading = row;
            this.rowEndLoading = Math.min(row + batchSize, this.getRowCount() - 1);
            if (this.lastLoadingRunnable != null) {
                this.lastLoadingRunnable.cancel();
            }
            this.lastLoadingRunnable = new LoadingRunnable();
            new Thread((Runnable)this.lastLoadingRunnable, "identificationFeatures").start();
        }
        this.updateContent();
    }

    private synchronized void updateContent() throws InterruptedException {
        if (this.selfUpdating && !this.updateScheduled) {
            this.updateScheduled = true;
            this.wait(100L);
            new Thread(new Runnable(){

                @Override
                public synchronized void run() {
                    try {
                        if (SelfUpdatingTableModel.this.selfUpdating) {
                            SelfUpdatingTableModel.this.fireTableDataChanged();
                        }
                    }
                    catch (Exception e) {
                        SelfUpdatingTableModel.this.catchException(e);
                    }
                    SelfUpdatingTableModel.this.updateScheduled = false;
                }
            }, "tableUpdate").start();
        }
    }

    public boolean isSelfUpdating() {
        return this.selfUpdating;
    }

    public void setSelfUpdating(boolean selfUpdating) {
        this.selfUpdating = selfUpdating;
    }

    public boolean needsUpdate(int column, String waitingContent) {
        for (int row = this.getRowCount() - 1; row >= 0; --row) {
            Object cellContent = this.getValueAt(row, column);
            if (!(cellContent instanceof String) || !cellContent.equals(waitingContent)) continue;
            return true;
        }
        return false;
    }

    public void initiateSorter() {
        int nRows = this.getRowCount();
        this.viewIndexes = new ArrayList(nRows);
        for (int row = 0; row < nRows; ++row) {
            this.viewIndexes.add(row);
        }
    }

    public int getViewIndex(int row) {
        if (this.viewIndexes == null) {
            return row;
        }
        int nRows = this.getRowCount();
        if (nRows != this.viewIndexes.size()) {
            this.initiateSorter();
        }
        if (row < 0 || row >= nRows) {
            throw new IllegalArgumentException("Row " + row + " must be between 0 and " + --nRows);
        }
        return this.viewIndexes.get(row);
    }

    public int getRowNumber(int viewIndex) {
        if (this.viewIndexes == null) {
            return viewIndex;
        }
        int nRows = this.getRowCount();
        if (nRows != this.viewIndexes.size()) {
            this.initiateSorter();
        }
        if (viewIndex < 0 || viewIndex >= nRows) {
            throw new IllegalArgumentException("View index " + viewIndex + " must be between 0 and " + --nRows + ".");
        }
        return this.viewIndexes.indexOf(viewIndex);
    }

    public void resetSorting(ProgressDialogX aProgressDialog) {
        if (!this.unsorted) {
            this.sortColumn(this.lastColumnSorted, aProgressDialog);
            if (!this.sortAscending) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Collections.reverse(SelfUpdatingTableModel.this.viewIndexes);
                        SelfUpdatingTableModel.this.fireTableDataChanged();
                    }
                });
            }
        }
    }

    public void sort(int column, ProgressDialogX aProgressDialog) {
        if (column == this.lastColumnSorted) {
            if (this.viewIndexes == null || this.viewIndexes.size() != this.getRowCount()) {
                this.initiateSorter();
            }
            this.sortAscending = !this.sortAscending;
            Collections.reverse(this.viewIndexes);
            this.fireTableDataChanged();
        } else {
            this.sortAscending = true;
            this.sortColumn(column, aProgressDialog);
        }
    }

    private void sortColumn(int column, ProgressDialogX aProgressDialog) {
        final int finalColumn = column;
        this.progressDialog = aProgressDialog;
        this.progressDialog.resetSecondaryProgressCounter();
        this.progressDialog.setTitle("Sorting. Please Wait...");
        this.progressDialog.setPrimaryProgressCounterIndeterminate(false);
        this.progressDialog.setMaxPrimaryProgressCounter(this.getRowCount());
        this.progressDialog.setValue(0);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    if (SelfUpdatingTableModel.this.progressDialog != null) {
                        SelfUpdatingTableModel.this.progressDialog.setVisible(true);
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }, "ProgressDialog").start();
        new Thread("SortThread"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            @Override
            public void run() {
                try {
                    SelfUpdatingTableModel.this.setSelfUpdating(false);
                    SelfUpdatingTableModel.this.progressDialog.setDisplayProgress(false);
                    SelfUpdatingTableModel.this.loadDataForColumn(finalColumn, SelfUpdatingTableModel.this.progressDialog);
                    SelfUpdatingTableModel.this.progressDialog.setDisplayProgress(true);
                    SelfUpdatingTableModel.this.initiateSorter();
                    SelfUpdatingTableModel.this.lastColumnSorted = 0;
                    HashMap valueToRowMap = new HashMap();
                    boolean comparable = false;
                    boolean string = false;
                    for (int row = 0; row < SelfUpdatingTableModel.this.getRowCount() && SelfUpdatingTableModel.this.progressDialog != null && !SelfUpdatingTableModel.this.progressDialog.isRunCanceled(); ++row) {
                        void var7_9;
                        Object key;
                        Object tableValue = SelfUpdatingTableModel.this.getValueAt(row, finalColumn);
                        if (tableValue instanceof Comparable) {
                            key = (Comparable)tableValue;
                            comparable = true;
                        } else {
                            key = tableValue.toString();
                            string = true;
                        }
                        ArrayList arrayList = (ArrayList)valueToRowMap.get(key);
                        if (arrayList == null) {
                            ArrayList arrayList2 = new ArrayList();
                            valueToRowMap.put(key, arrayList2);
                        }
                        var7_9.add(row);
                        if (SelfUpdatingTableModel.this.progressDialog == null) continue;
                        SelfUpdatingTableModel.this.progressDialog.increasePrimaryProgressCounter();
                    }
                    if (SelfUpdatingTableModel.this.progressDialog != null && SelfUpdatingTableModel.this.progressDialog.isRunCanceled()) {
                        SelfUpdatingTableModel.this.progressDialog.setRunFinished();
                        return;
                    }
                    ArrayList<Object> keys = new ArrayList(valueToRowMap.keySet());
                    if (string && comparable) {
                        ArrayList<String> stringValues = new ArrayList<String>();
                        for (Comparable comparable2 : keys) {
                            stringValues.add(comparable2.toString());
                        }
                        keys = stringValues;
                    }
                    if (SelfUpdatingTableModel.this.progressDialog == null || !SelfUpdatingTableModel.this.progressDialog.isRunCanceled()) {
                        SelfUpdatingTableModel.this.viewIndexes = new ArrayList();
                        Collections.sort(keys);
                        for (Object key : keys) {
                            SelfUpdatingTableModel.this.viewIndexes.addAll((Collection)valueToRowMap.get(key));
                        }
                        SelfUpdatingTableModel.this.lastColumnSorted = finalColumn;
                    }
                }
                catch (Exception ex) {
                    SelfUpdatingTableModel.this.catchException(ex);
                }
                finally {
                    SelfUpdatingTableModel.this.setSelfUpdating(true);
                }
                if (SelfUpdatingTableModel.this.progressDialog != null) {
                    SelfUpdatingTableModel.this.progressDialog.setRunFinished();
                }
                SelfUpdatingTableModel.this.fireTableDataChanged();
            }
        }.start();
    }

    public static void addSortListener(JTable jTable, ProgressDialogX progressDialog) {
        final JTableHeader proteinTableHeader = jTable.getTableHeader();
        final JTable finalTable = jTable;
        final ProgressDialogX progressDialogX = progressDialog;
        proteinTableHeader.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getButton() == 1) {
                    int column = proteinTableHeader.getColumnModel().getColumnIndexAtX(evt.getX());
                    SelfUpdatingTableModel model = (SelfUpdatingTableModel)finalTable.getModel();
                    model.sort(column, progressDialogX);
                    model.unsorted = false;
                }
            }
        });
        final TableCellRenderer r = finalTable.getTableHeader().getDefaultRenderer();
        TableCellRenderer wrapper = new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component comp = r.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (comp instanceof JLabel) {
                    JLabel label = (JLabel)comp;
                    label.setIcon(this.getSortIcon(table, column));
                    label.setHorizontalTextPosition(2);
                    finalTable.getTableHeader().revalidate();
                    finalTable.getTableHeader().repaint();
                }
                return comp;
            }

            private Icon getSortIcon(JTable table, int column) {
                if (table.getModel() instanceof SelfUpdatingTableModel && ((SelfUpdatingTableModel)table.getModel()).lastColumnSorted == column && !((SelfUpdatingTableModel)table.getModel()).unsorted) {
                    if (!((SelfUpdatingTableModel)table.getModel()).sortAscending) {
                        return UIManager.getIcon("Table.descendingSortIcon");
                    }
                    return UIManager.getIcon("Table.ascendingSortIcon");
                }
                return null;
            }
        };
        finalTable.getTableHeader().setDefaultRenderer(wrapper);
    }

    public boolean isScrolling() {
        return this.isScrolling;
    }

    public void setIsScrolling(boolean isScrolling) {
        this.isScrolling = isScrolling;
        if (isScrolling && this.lastLoadingRunnable != null) {
            this.lastLoadingRunnable.cancel();
        }
    }

    public static void addScrollListeners(JTable table, JScrollPane scrollPane, JScrollBar scrollBar) {
        TableScrollBarListener scrollBarListener = new TableScrollBarListener(table);
        scrollBar.addAdjustmentListener(scrollBarListener);
        TableMouseWheelListener mouseWheelListener = new TableMouseWheelListener(table);
        scrollPane.addMouseWheelListener(mouseWheelListener);
    }

    private class LoadingRunnable
    implements Runnable {
        private WaitingHandlerDummy waitingHandler = new WaitingHandlerDummy();

        private LoadingRunnable() {
        }

        @Override
        public synchronized void run() {
            try {
                ArrayList<Integer> viewIndexes = new ArrayList<Integer>(batchSize);
                for (int row = SelfUpdatingTableModel.this.rowStartLoading; row <= SelfUpdatingTableModel.this.rowEndLoading; ++row) {
                    viewIndexes.add(SelfUpdatingTableModel.this.getViewIndex(row));
                }
                if (!viewIndexes.isEmpty() && !this.waitingHandler.isRunCanceled()) {
                    SelfUpdatingTableModel.this.rowEndLoading = SelfUpdatingTableModel.this.getRowNumber(SelfUpdatingTableModel.this.loadDataForRows(viewIndexes, this.waitingHandler));
                }
            }
            catch (Exception e) {
                SelfUpdatingTableModel.this.catchException(e);
            }
            this.waitingHandler.setRunFinished();
        }

        public void cancel() {
            this.waitingHandler.setRunCanceled();
        }

        public boolean isFinished() {
            return this.waitingHandler.isRunFinished();
        }
    }
}

