/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.math.statistics.linear_regression.regressions;

import com.compomics.util.math.BasicMathFunctions;
import com.compomics.util.math.statistics.linear_regression.RegressionStatistics;
import java.util.ArrayList;

public class SimpleLinearRegression {
    public static RegressionStatistics getLinearRegression(ArrayList<Double> x, ArrayList<Double> y) {
        if (x == null) {
            throw new IllegalArgumentException("null given as x for linear regression.");
        }
        if (y == null) {
            throw new IllegalArgumentException("null given as y for linear regression.");
        }
        if (x.size() != y.size()) {
            throw new IllegalArgumentException("Attempting to perform linear regression of lists of different sizes.");
        }
        int n = x.size();
        if (n <= 1) {
            throw new IllegalArgumentException("Attempting to perform linear regression of a vectore of size " + n + ".");
        }
        Double sumXY = 0.0;
        Double sumX = 0.0;
        Double sumX2 = 0.0;
        Double sumY = 0.0;
        Double x0 = x.get(0);
        boolean newX = false;
        for (int i = 0; i < n; ++i) {
            Double xi = x.get(i);
            if (!newX && !xi.equals(x0)) {
                newX = true;
            }
            Double yi = y.get(i);
            sumXY = sumXY + xi * yi;
            sumX = sumX + xi;
            sumX2 = sumX2 + xi * xi;
            sumY = sumY + yi;
        }
        if (!newX) {
            throw new IllegalArgumentException("Attempting to perform the linear regression of a vertical line or a point.");
        }
        Double xMean = sumX / (double)n;
        Double yMean = sumY / (double)n;
        Double a = (sumXY - xMean * sumY) / (sumX2 - sumX * sumX / (double)n);
        Double b = yMean - a * xMean;
        Double ssTot = 0.0;
        Double ssRes = 0.0;
        ArrayList<Double> deltasSquare = new ArrayList<Double>(x.size());
        for (int i = 0; i < x.size(); ++i) {
            Double xi = x.get(i);
            Double yi = y.get(i);
            Double fi = a * xi + b;
            Double diffY = yi - yMean;
            ssTot = ssTot + diffY * diffY;
            Double diffF = yi - fi;
            ssRes = ssRes + diffF * diffF;
            Double deltaY = yi - b;
            Double ai = deltaY / xi;
            Double deltaA = ai - a;
            Double deltaSquare = xi * xi + deltaY * deltaY;
            deltaSquare = deltaSquare * (deltaA * deltaA);
            deltaSquare = deltaSquare / (1.0 + ai * ai);
            deltaSquare = deltaSquare / (1.0 + a * a);
            deltasSquare.add(deltaSquare);
        }
        Double rSquared = 1.0;
        if (ssTot > 0.0) {
            rSquared = 1.0 - ssRes / ssTot;
        }
        Double meanDelta = BasicMathFunctions.mean(deltasSquare);
        Double medianDelta = BasicMathFunctions.median(deltasSquare);
        return new RegressionStatistics(a, b, rSquared, meanDelta, medianDelta);
    }
}

