/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.preferences;

import com.compomics.util.experiment.biology.mutations.MutationMatrix;
import com.compomics.util.experiment.identification.protein_inference.PeptideMapperType;
import java.io.Serializable;

public class SequenceMatchingPreferences
implements Serializable {
    static final long serialVersionUID = 228961121369106450L;
    private MatchingType sequenceMatchingType;
    private Double limitX = null;
    private MutationMatrix mutationMatrix = null;
    private Integer maxMutationsPerPeptide = null;
    private PeptideMapperType peptideMapperType = PeptideMapperType.fm_index;
    public static final SequenceMatchingPreferences defaultStringMatching = SequenceMatchingPreferences.getStringMatching();

    public static SequenceMatchingPreferences getStringMatching() {
        SequenceMatchingPreferences sequenceMatchingPreferences = new SequenceMatchingPreferences();
        sequenceMatchingPreferences.setSequenceMatchingType(MatchingType.string);
        return sequenceMatchingPreferences;
    }

    public static SequenceMatchingPreferences getDefaultSequenceMatching() {
        SequenceMatchingPreferences sequenceMatchingPreferences = new SequenceMatchingPreferences();
        sequenceMatchingPreferences.setSequenceMatchingType(MatchingType.indistiguishableAminoAcids);
        sequenceMatchingPreferences.setLimitX(0.25);
        return sequenceMatchingPreferences;
    }

    public MatchingType getSequenceMatchingType() {
        return this.sequenceMatchingType;
    }

    public void setSequenceMatchingType(MatchingType sequenceMatchingType) {
        this.sequenceMatchingType = sequenceMatchingType;
    }

    public Double getLimitX() {
        return this.limitX;
    }

    public boolean hasLimitX() {
        return this.limitX != null && this.limitX >= 0.0;
    }

    public void setLimitX(Double limitX) {
        this.limitX = limitX;
    }

    public PeptideMapperType getPeptideMapperType() {
        if (this.peptideMapperType == null) {
            this.peptideMapperType = PeptideMapperType.tree;
        }
        return this.peptideMapperType;
    }

    public void setPeptideMapperType(PeptideMapperType peptideMapperEnum) {
        this.peptideMapperType = peptideMapperEnum;
    }

    public boolean isSameAs(SequenceMatchingPreferences sequenceMatchingPreferences) {
        double diff;
        if (this.peptideMapperType != sequenceMatchingPreferences.getPeptideMapperType()) {
            return false;
        }
        if (this.sequenceMatchingType != sequenceMatchingPreferences.getSequenceMatchingType()) {
            return false;
        }
        if (this.hasLimitX() && sequenceMatchingPreferences.hasLimitX() && (diff = Math.abs(this.limitX - sequenceMatchingPreferences.getLimitX())) > 1.0E-13) {
            return false;
        }
        if (this.hasLimitX() && !sequenceMatchingPreferences.hasLimitX()) {
            return false;
        }
        return this.hasLimitX() || !sequenceMatchingPreferences.hasLimitX();
    }

    public String getShortDescription() {
        String newLine = System.getProperty("line.separator");
        StringBuilder output = new StringBuilder();
        output.append("Index: ").append((Object)this.peptideMapperType).append(".").append(newLine);
        output.append("Method: ").append((Object)this.sequenceMatchingType).append(".").append(newLine);
        output.append("Max share of x's: ").append(this.limitX).append(".").append(newLine);
        return output.toString();
    }

    public static enum MatchingType {
        string(0, "Character Sequence"),
        aminoAcid(1, "Amino Acids"),
        indistiguishableAminoAcids(2, "Indistinguishable Amino Acids");

        public final int index;
        public final String description;

        private MatchingType(int index, String description) {
            this.index = index;
            this.description = description;
        }

        public String toString() {
            return this.description;
        }

        public static String getCommandLineOptions() {
            StringBuilder optionsStringBuilder = new StringBuilder();
            for (MatchingType matchingType : MatchingType.values()) {
                if (optionsStringBuilder.length() != 0) {
                    optionsStringBuilder.append(", ");
                }
                optionsStringBuilder.append(matchingType.index).append(": ").append(matchingType.description);
            }
            return optionsStringBuilder.toString();
        }

        public static MatchingType getMatchingType(int index) {
            for (MatchingType matchingType : MatchingType.values()) {
                if (matchingType.index != index) continue;
                return matchingType;
            }
            throw new IllegalArgumentException("No matching type found for index " + index + ".");
        }
    }
}

