/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.algo;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import fr.profi.ms.algo.IsotopePatternEstimator$;
import fr.profi.ms.model.TheoreticalIsotopePattern;
import fr.profi.mzdb.algo.IIsotopicPatternScorer;
import fr.profi.mzdb.model.SpectrumData;
import java.io.Serializable;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class DotProductPatternScorer$
implements IIsotopicPatternScorer {
    public static DotProductPatternScorer$ MODULE$;
    private final int fr$profi$mzdb$algo$IIsotopicPatternScorer$$MAX_CHARGE;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new DotProductPatternScorer$();
    }

    @Override
    public Tuple2<Object, TheoreticalIsotopePattern>[] calcIsotopicPatternHypotheses(SpectrumData spectrum, double mz, double ppmTol) {
        return IIsotopicPatternScorer.calcIsotopicPatternHypotheses$(this, spectrum, mz, ppmTol);
    }

    @Override
    public Tuple2<Object, TheoreticalIsotopePattern>[] calcIsotopicPatternHypothesesFromCharge(SpectrumData spectrum, double mz, int charge, double ppmTol) {
        return IIsotopicPatternScorer.calcIsotopicPatternHypothesesFromCharge$(this, spectrum, mz, charge, ppmTol);
    }

    @Override
    public int fr$profi$mzdb$algo$IIsotopicPatternScorer$$MAX_CHARGE() {
        return this.fr$profi$mzdb$algo$IIsotopicPatternScorer$$MAX_CHARGE;
    }

    @Override
    public final void fr$profi$mzdb$algo$IIsotopicPatternScorer$_setter_$fr$profi$mzdb$algo$IIsotopicPatternScorer$$MAX_CHARGE_$eq(int x$1) {
        this.fr$profi$mzdb$algo$IIsotopicPatternScorer$$MAX_CHARGE = x$1;
    }

    private Logger logger$lzycompute() {
        DotProductPatternScorer$ dotProductPatternScorer$ = this;
        synchronized (dotProductPatternScorer$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public Tuple2<Object, TheoreticalIsotopePattern> getIPHypothesis(SpectrumData spectrum, double initialMz, int isotopicShift, int charge, double ppmTol) {
        double score = 0.0;
        double mz = initialMz - (double)isotopicShift * 1.0027 / (double)charge;
        TheoreticalIsotopePattern pattern = IsotopePatternEstimator$.MODULE$.getTheoreticalPattern(mz, charge);
        double scale = (double)spectrum.getIntensityList()[spectrum.getNearestPeakIndex(initialMz)] / (double)BoxesRunTime.unboxToFloat((Object)pattern.mzAbundancePairs()[isotopicShift]._2());
        DoubleRef ipMoz = DoubleRef.create((double)mz);
        double[] observed = new double[pattern.mzAbundancePairs().length];
        double[] expected = new double[pattern.mzAbundancePairs().length];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), pattern.mzAbundancePairs().length).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)rank -> {
            ipMoz$2.elem = rank == 0 ? ipMoz$2.elem : ipMoz$2.elem + 1.0027 / (double)charge;
            int nearestPeakIdx = spectrum.getNearestPeakIndex(ipMoz$2.elem);
            observed$1[rank] = 1000000.0 * Math.abs(spectrum.getMzList()[nearestPeakIdx] - ipMoz$2.elem) / ipMoz$2.elem < ppmTol ? (double)spectrum.getIntensityList()[nearestPeakIdx] : (double)(-BoxesRunTime.unboxToFloat((Object)pattern.mzAbundancePairs()[rank]._2())) * scale;
            expected$1[rank] = BoxesRunTime.unboxToFloat((Object)pattern.mzAbundancePairs()[rank]._2());
        });
        score = this.dotProduct(observed, expected);
        score = 1.0 - score;
        return new Tuple2((Object)BoxesRunTime.boxToDouble((double)score), (Object)pattern);
    }

    public double dotProduct(double[] observed, double[] expected) {
        double sumObserved = 0.0;
        double sumExpected = 0.0;
        double product = 0.0;
        ObjectRef weights = ObjectRef.create((Object)((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(expected)).take(6)));
        weights.elem = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])weights.elem)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$3 -> x$3 / BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])weights$1.elem)).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        for (int k = 0; k < observed.length; ++k) {
            double weight = k < new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])weights.elem)).size() ? ((double[])weights.elem)[k] : 0.0;
            product += weight * observed[k] * expected[k];
            sumExpected += weight * expected[k] * expected[k];
            sumObserved += weight * observed[k] * observed[k];
        }
        return sumExpected == 0.0 || sumObserved == 0.0 ? 0.0 : product / (Math.sqrt(sumExpected) * Math.sqrt(sumObserved));
    }

    @Override
    public Tuple2<Object, TheoreticalIsotopePattern> selectBestPatternHypothese(Tuple2<Object, TheoreticalIsotopePattern>[] putativePatterns, double deltaScore) {
        double refScore = ((Tuple2)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])putativePatterns)).head())._1$mcD$sp();
        Tuple2[] patterns = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])putativePatterns)).filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)DotProductPatternScorer$.$anonfun$selectBestPatternHypothese$1(refScore, deltaScore, p)));
        return (Tuple2)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])patterns)).maxBy((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToInteger((int)DotProductPatternScorer$.$anonfun$selectBestPatternHypothese$2(p)), (Ordering)Ordering.Int$.MODULE$);
    }

    @Override
    public double selectBestPatternHypothese$default$2() {
        return 0.1;
    }

    public static final /* synthetic */ boolean $anonfun$selectBestPatternHypothese$1(double refScore$1, double deltaScore$1, Tuple2 p) {
        return package$.MODULE$.abs(p._1$mcD$sp() - refScore$1) < deltaScore$1;
    }

    public static final /* synthetic */ int $anonfun$selectBestPatternHypothese$2(Tuple2 p) {
        return ((TheoreticalIsotopePattern)p._2()).charge();
    }

    private DotProductPatternScorer$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        IIsotopicPatternScorer.$init$(this);
    }
}

