/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.algo;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import fr.profi.ms.algo.IsotopePatternEstimator$;
import fr.profi.ms.model.TheoreticalIsotopePattern;
import fr.profi.mzdb.algo.IIsotopicPatternScorer;
import fr.profi.mzdb.model.SpectrumData;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class LegacyIsotopicPatternScorer$
implements IIsotopicPatternScorer {
    public static LegacyIsotopicPatternScorer$ MODULE$;
    private final int fr$profi$mzdb$algo$IIsotopicPatternScorer$$MAX_CHARGE;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new LegacyIsotopicPatternScorer$();
    }

    @Override
    public Tuple2<Object, TheoreticalIsotopePattern>[] calcIsotopicPatternHypotheses(SpectrumData spectrum, double mz, double ppmTol) {
        return IIsotopicPatternScorer.calcIsotopicPatternHypotheses$(this, spectrum, mz, ppmTol);
    }

    @Override
    public Tuple2<Object, TheoreticalIsotopePattern>[] calcIsotopicPatternHypothesesFromCharge(SpectrumData spectrum, double mz, int charge, double ppmTol) {
        return IIsotopicPatternScorer.calcIsotopicPatternHypothesesFromCharge$(this, spectrum, mz, charge, ppmTol);
    }

    @Override
    public int fr$profi$mzdb$algo$IIsotopicPatternScorer$$MAX_CHARGE() {
        return this.fr$profi$mzdb$algo$IIsotopicPatternScorer$$MAX_CHARGE;
    }

    @Override
    public final void fr$profi$mzdb$algo$IIsotopicPatternScorer$_setter_$fr$profi$mzdb$algo$IIsotopicPatternScorer$$MAX_CHARGE_$eq(int x$1) {
        this.fr$profi$mzdb$algo$IIsotopicPatternScorer$$MAX_CHARGE = x$1;
    }

    private Logger logger$lzycompute() {
        LegacyIsotopicPatternScorer$ legacyIsotopicPatternScorer$ = this;
        synchronized (legacyIsotopicPatternScorer$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public Tuple2<Object, TheoreticalIsotopePattern> getIPHypothesis(SpectrumData spectrum, double initialMz, int isotopicShift, int charge, double ppmTol) {
        DoubleRef score = DoubleRef.create((double)0.0);
        double alternativeMoz = initialMz - (double)isotopicShift * 1.0027 / (double)charge;
        TheoreticalIsotopePattern pattern = IsotopePatternEstimator$.MODULE$.getTheoreticalPattern(alternativeMoz, charge);
        float isotopeAbundance = spectrum.getIntensityList()[spectrum.getNearestPeakIndex(alternativeMoz)];
        float normAbundance = BoxesRunTime.unboxToFloat((Object)pattern.mzAbundancePairs()[0]._2());
        DoubleRef ipMoz = DoubleRef.create((double)alternativeMoz);
        boolean rank2 = false;
        IntRef matches = IntRef.create((int)0);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), pattern.mzAbundancePairs().length).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & java.io.Serializable & Serializable)rank -> {
            float f;
            double rankPenality;
            ipMoz$1.elem = rank == 0 ? ipMoz$1.elem : ipMoz$1.elem + 1.0027 / (double)charge;
            float ipAbundance = BoxesRunTime.unboxToFloat((Object)pattern.mzAbundancePairs()[rank]._2()) * isotopeAbundance / normAbundance;
            int nearestPeakIdx = spectrum.getNearestPeakIndex(ipMoz$1.elem);
            double d = rankPenality = rank == isotopicShift ? 100.0 : Math.max(0.01, Math.pow(10.0, -(2 * rank - 4)));
            if (1000000.0 * Math.abs(spectrum.getMzList()[nearestPeakIdx] - ipMoz$1.elem) / ipMoz$1.elem < ppmTol) {
                ipMoz$1.elem = spectrum.getMzList()[nearestPeakIdx];
                ++matches$1.elem;
                f = spectrum.getIntensityList()[nearestPeakIdx];
            } else {
                f = ipAbundance / 1000.0f;
            }
            float abundance = f;
            double d2 = (double)((ipAbundance - abundance) / package$.MODULE$.min(abundance, ipAbundance)) * rankPenality;
            score$1.elem += d2 * d2;
        });
        score.elem = Math.log10(score.elem) - (double)matches.elem;
        return new Tuple2((Object)BoxesRunTime.boxToDouble((double)score.elem), (Object)pattern);
    }

    @Override
    public Tuple2<Object, TheoreticalIsotopePattern> selectBestPatternHypothese(Tuple2<Object, TheoreticalIsotopePattern>[] putativePatterns, double deltaScore) {
        return (Tuple2)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])putativePatterns)).head();
    }

    @Override
    public double selectBestPatternHypothese$default$2() {
        return 0.1;
    }

    private LegacyIsotopicPatternScorer$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        IIsotopicPatternScorer.$init$(this);
    }
}

