/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.algo.feature.extraction;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import fr.profi.api.progress.IProgressPlanSequence;
import fr.profi.api.progress.IProgressStepIdentity;
import fr.profi.api.progress.ProgressComputer;
import fr.profi.api.progress.ProgressPlan;
import fr.profi.api.progress.ProgressStep;
import fr.profi.mzdb.algo.feature.extraction.UnsupervisedPeakelDetector$;
import fr.profi.mzdb.algo.feature.extraction.UnsupervisedPeakelDetector$DETECTION_STEP1$;
import fr.profi.mzdb.algo.signal.detection.IPeakelFinder;
import fr.profi.mzdb.model.PeakList;
import fr.profi.mzdb.model.PeakListCollection;
import fr.profi.mzdb.model.PeakListTree;
import fr.profi.mzdb.model.PeakListTriplet;
import fr.profi.mzdb.model.Peakel;
import fr.profi.mzdb.model.PeakelCoordinates;
import fr.profi.mzdb.model.Spectrum;
import fr.profi.mzdb.model.SpectrumData;
import fr.profi.mzdb.model.SpectrumHeader;
import fr.profi.mzdb.util.ms.MsUtils;
import java.io.Serializable;
import java.util.BitSet;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.LongMap;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.control.Breaks$;

@ScalaSignature(bytes="\u0006\u0001\t}w!B,Y\u0011\u0003)g!B4Y\u0011\u0003A\u0007\"B8\u0002\t\u0003\u0001haB9\u0002!\u0003\r\nA]\u0004\u0006w\u0006A)\t \u0004\u0006}\u0006A)i \u0005\u0007_\u0016!\t!a\u0005\t\u0013\u0005UQA1A\u0005\u0002\u0005]\u0001\u0002CA\u0015\u000b\u0001\u0006I!!\u0007\t\u0013\u0005-R!!A\u0005B\u0005]\u0001\"CA\u0017\u000b\u0005\u0005I\u0011AA\u0018\u0011%\t9$BA\u0001\n\u0003\tI\u0004C\u0005\u0002F\u0015\t\t\u0011\"\u0011\u0002H!I\u0011QK\u0003\u0002\u0002\u0013\u0005\u0011q\u000b\u0005\n\u0003C*\u0011\u0011!C!\u0003GB\u0011\"!\u001a\u0006\u0003\u0003%\t%a\u001a\t\u0013\u0005%T!!A\u0005\n\u0005-\u0004bBA:\u0003\u0011\u0005\u0011Q\u000f\u0004\n\u0003\u007f\n\u0001\u0013aI\u0001\u0003\u0003;q!a!\u0002\u0011\u000b\u000b)IB\u0004\u0002\b\u0006A))!#\t\r=$B\u0011AAF\u0011%\t)\u0002\u0006b\u0001\n\u0003\t9\u0002\u0003\u0005\u0002*Q\u0001\u000b\u0011BA\r\u0011%\tY\u0003FA\u0001\n\u0003\n9\u0002C\u0005\u0002.Q\t\t\u0011\"\u0001\u00020!I\u0011q\u0007\u000b\u0002\u0002\u0013\u0005\u0011Q\u0012\u0005\n\u0003\u000b\"\u0012\u0011!C!\u0003\u000fB\u0011\"!\u0016\u0015\u0003\u0003%\t!!%\t\u0013\u0005\u0005D#!A\u0005B\u0005\r\u0004\"CA3)\u0005\u0005I\u0011IA4\u0011%\tI\u0007FA\u0001\n\u0013\tYgB\u0004\u0002\u0016\u0006A))a&\u0007\u000f\u0005e\u0015\u0001#\"\u0002\u001c\"1q.\tC\u0001\u0003;C\u0011\"!\u0006\"\u0005\u0004%\t!a\u0006\t\u0011\u0005%\u0012\u0005)A\u0005\u00033A\u0011\"a\u000b\"\u0003\u0003%\t%a\u0006\t\u0013\u00055\u0012%!A\u0005\u0002\u0005=\u0002\"CA\u001cC\u0005\u0005I\u0011AAP\u0011%\t)%IA\u0001\n\u0003\n9\u0005C\u0005\u0002V\u0005\n\t\u0011\"\u0001\u0002$\"I\u0011\u0011M\u0011\u0002\u0002\u0013\u0005\u00131\r\u0005\n\u0003K\n\u0013\u0011!C!\u0003OB\u0011\"!\u001b\"\u0003\u0003%I!a\u001b\b\u000f\u0005\u001d\u0016\u0001#\"\u0002*\u001a9\u00111V\u0001\t\u0006\u00065\u0006BB8/\t\u0003\ty\u000bC\u0005\u0002\u00169\u0012\r\u0011\"\u0001\u0002\u0018!A\u0011\u0011\u0006\u0018!\u0002\u0013\tI\u0002C\u0005\u0002,9\n\t\u0011\"\u0011\u0002\u0018!I\u0011Q\u0006\u0018\u0002\u0002\u0013\u0005\u0011q\u0006\u0005\n\u0003oq\u0013\u0011!C\u0001\u0003cC\u0011\"!\u0012/\u0003\u0003%\t%a\u0012\t\u0013\u0005Uc&!A\u0005\u0002\u0005U\u0006\"CA1]\u0005\u0005I\u0011IA2\u0011%\t)GLA\u0001\n\u0003\n9\u0007C\u0005\u0002j9\n\t\u0011\"\u0003\u0002l!9\u0011\u0011X\u0001\u0005\u0002\u0005m\u0006\"CAa\u0003E\u0005I\u0011AAb\u0011%\tI.AI\u0001\n\u0003\tY\u000eC\u0005\u0002f\u0006\t\n\u0011\"\u0001\u0002\\\"I\u0011q]\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u001e\u0004\u0006Ob\u0003\u0011Q \u0005\u000b\u0005'y$Q1A\u0005\u0002\tU\u0001B\u0003B\u0018\u007f\t\u0005\t\u0015!\u0003\u0003\u0018!Q!\u0011G \u0003\u0006\u0004%\tAa\r\t\u0015\t]rH!A!\u0002\u0013\u0011)\u0004\u0003\u0006\u0003:}\u0012)\u0019!C\u0001\u0005wA!B!\u0010@\u0005\u0003\u0005\u000b\u0011BAp\u0011)\u0011yd\u0010BC\u0002\u0013\u0005\u0011q\u0006\u0005\u000b\u0005\u0003z$\u0011!Q\u0001\n\u0005E\u0002B\u0003B\"\u007f\t\u0015\r\u0011\"\u0001\u0003<!Q!QI \u0003\u0002\u0003\u0006I!a8\t\u0015\t\u001dsH!b\u0001\n\u0003\u0011Y\u0004\u0003\u0006\u0003J}\u0012\t\u0011)A\u0005\u0003?D!Ba\u0013@\u0005\u000b\u0007I\u0011\u0001B'\u0011)\u0011ye\u0010B\u0001B\u0003%\u0011Q\u001e\u0005\u0007_~\"\tA!\u0015\t\u0013\t\rtH1A\u0005\u0002\u0005=\u0002\u0002\u0003B3\u007f\u0001\u0006I!!\r\t\u0013\t\u001dtH1A\u0005\u0002\tm\u0002\u0002\u0003B5\u007f\u0001\u0006I!a8\t\u0013\t-tH1A\u0005\n\tm\u0002\u0002\u0003B7\u007f\u0001\u0006I!a8\t\u000f\t=t\b\"\u0001\u0003r!9!1T \u0005\u0012\tu\u0015AG+ogV\u0004XM\u001d<jg\u0016$\u0007+Z1lK2$U\r^3di>\u0014(BA-[\u0003))\u0007\u0010\u001e:bGRLwN\u001c\u0006\u00037r\u000bqAZ3biV\u0014XM\u0003\u0002^=\u0006!\u0011\r\\4p\u0015\ty\u0006-\u0001\u0003nu\u0012\u0014'BA1c\u0003\u0015\u0001(o\u001c4j\u0015\u0005\u0019\u0017A\u00014s\u0007\u0001\u0001\"AZ\u0001\u000e\u0003a\u0013!$\u00168tkB,'O^5tK\u0012\u0004V-Y6fY\u0012+G/Z2u_J\u001c\"!A5\u0011\u0005)lW\"A6\u000b\u00031\fQa]2bY\u0006L!A\\6\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tQMA\u0012V]N,\b/\u001a:wSN,G\rU3bW\u0016dG)\u001a;fGRLwN\\*fcV,gnY3\u0014\u0007\rI7\u000f\u0005\u0002us6\tQO\u0003\u0002wo\u0006A\u0001O]8he\u0016\u001c8O\u0003\u0002yA\u0006\u0019\u0011\r]5\n\u0005i,(!F%Qe><'/Z:t!2\fgnU3rk\u0016t7-Z\u0001\u0010\t\u0016#Vi\u0011+J\u001f:{6\u000bV#QcA\u0011Q0B\u0007\u0002\u0003\tyA)\u0012+F\u0007RKuJT0T)\u0016\u0003\u0016g\u0005\u0005\u0006S\u0006\u0005\u0011qAA\u0007!\r!\u00181A\u0005\u0004\u0003\u000b)(!F%Qe><'/Z:t'R,\u0007/\u00133f]RLG/\u001f\t\u0004U\u0006%\u0011bAA\u0006W\n9\u0001K]8ek\u000e$\bc\u00016\u0002\u0010%\u0019\u0011\u0011C6\u0003\u0019M+'/[1mSj\f'\r\\3\u0015\u0003q\fqb\u001d;fa\u0012+7o\u0019:jaRLwN\\\u000b\u0003\u00033\u0001B!a\u0007\u0002&5\u0011\u0011Q\u0004\u0006\u0005\u0003?\t\t#\u0001\u0003mC:<'BAA\u0012\u0003\u0011Q\u0017M^1\n\t\u0005\u001d\u0012Q\u0004\u0002\u0007'R\u0014\u0018N\\4\u0002!M$X\r\u001d#fg\u000e\u0014\u0018\u000e\u001d;j_:\u0004\u0013!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u00022A\u0019!.a\r\n\u0007\u0005U2NA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002<\u0005\u0005\u0003c\u00016\u0002>%\u0019\u0011qH6\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002D-\t\t\u00111\u0001\u00022\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!\u0013\u0011\r\u0005-\u0013\u0011KA\u001e\u001b\t\tiEC\u0002\u0002P-\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\u0019&!\u0014\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u00033\ny\u0006E\u0002k\u00037J1!!\u0018l\u0005\u001d\u0011un\u001c7fC:D\u0011\"a\u0011\u000e\u0003\u0003\u0005\r!a\u000f\u0002\u0011!\f7\u000f[\"pI\u0016$\"!!\r\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!\u0007\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003[\u0002B!a\u0007\u0002p%!\u0011\u0011OA\u000f\u0005\u0019y%M[3di\u0006Ab.Z<EKR,7\r^5p]B\u0013xn\u001a:fgN\u0004F.\u00198\u0015\u0005\u0005]\u0004#\u0002;\u0002z\u0005u\u0014bAA>k\na\u0001K]8he\u0016\u001c8\u000f\u00157b]B\u0011Qp\u0001\u0002%+:\u001cX\u000f]3sm&\u001cX\r\u001a)fC.,G.\u0012=ue\u0006\u001cG/[8o'\u0016\fX/\u001a8dKN\u0019!#[:\u0002!\u0015CFKU!D)&{ejX*U\u000bB\u000b\u0004CA?\u0015\u0005A)\u0005\f\u0016*B\u0007RKuJT0T)\u0016\u0003\u0016g\u0005\u0005\u0015S\u0006\u0005\u0011qAA\u0007)\t\t)\t\u0006\u0003\u0002<\u0005=\u0005\"CA\"5\u0005\u0005\t\u0019AA\u0019)\u0011\tI&a%\t\u0013\u0005\rC$!AA\u0002\u0005m\u0012\u0001E#Y)J\u000b5\tV%P\u001d~\u001bF+\u0012)3!\ti\u0018E\u0001\tF1R\u0013\u0016i\u0011+J\u001f:{6\u000bV#QeMA\u0011%[A\u0001\u0003\u000f\ti\u0001\u0006\u0002\u0002\u0018R!\u00111HAQ\u0011%\t\u0019eJA\u0001\u0002\u0004\t\t\u0004\u0006\u0003\u0002Z\u0005\u0015\u0006\"CA\"S\u0005\u0005\t\u0019AA\u001e\u0003A)\u0005\f\u0016*B\u0007RKuJT0T)\u0016\u00036\u0007\u0005\u0002~]\t\u0001R\t\u0017+S\u0003\u000e#\u0016j\u0014(`'R+\u0005kM\n\t]%\f\t!a\u0002\u0002\u000eQ\u0011\u0011\u0011\u0016\u000b\u0005\u0003w\t\u0019\fC\u0005\u0002DQ\n\t\u00111\u0001\u00022Q!\u0011\u0011LA\\\u0011%\t\u0019ENA\u0001\u0002\u0004\tY$A\roK^,\u0005\u0010\u001e:bGRLwN\u001c)s_\u001e\u0014Xm]:QY\u0006tGCAA_!\u0015!\u0018\u0011PA`!\ti(#A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003\u000bTC!!\r\u0002H.\u0012\u0011\u0011\u001a\t\u0005\u0003\u0017\f).\u0004\u0002\u0002N*!\u0011qZAi\u0003%)hn\u00195fG.,GMC\u0002\u0002T.\f!\"\u00198o_R\fG/[8o\u0013\u0011\t9.!4\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%N\u000b\u0003\u0003;TC!a8\u0002HB\u0019!.!9\n\u0007\u0005\r8NA\u0003GY>\fG/A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEN\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001c\u0016\u0005\u0005-(\u0006BAw\u0003\u000f\u0004B!a<\u0002z6\u0011\u0011\u0011\u001f\u0006\u0005\u0003g\f)0A\u0005eKR,7\r^5p]*\u0019\u0011q\u001f/\u0002\rMLwM\\1m\u0013\u0011\tY0!=\u0003\u001b%\u0003V-Y6fY\u001aKg\u000eZ3s'\u0011y\u0014.a@\u0011\t\t\u0005!qB\u0007\u0003\u0005\u0007QAA!\u0002\u0003\b\u0005a1oY1mC2|wmZ5oO*!!\u0011\u0002B\u0006\u0003!!\u0018\u0010]3tC\u001a,'B\u0001B\u0007\u0003\r\u0019w.\\\u0005\u0005\u0005#\u0011\u0019AA\u0006MCjLHj\\4hS:<\u0017AE:qK\u000e$(/^7IK\u0006$WM\u001d\"z\u0013\u0012,\"Aa\u0006\u0011\r\te!q\u0004B\u0012\u001b\t\u0011YB\u0003\u0003\u0003\u001e\u00055\u0013aB7vi\u0006\u0014G.Z\u0005\u0005\u0005C\u0011YBA\u0004M_:<W*\u00199\u0011\t\t\u0015\"1F\u0007\u0003\u0005OQ1A!\u000b_\u0003\u0015iw\u000eZ3m\u0013\u0011\u0011iCa\n\u0003\u001dM\u0003Xm\u0019;sk6DU-\u00193fe\u0006\u00192\u000f]3diJ,X\u000eS3bI\u0016\u0014()_%eA\u0005qaN\u001a\"z'B,7\r\u001e:v[&#WC\u0001B\u001b!\u0019\u0011IBa\b\u0002`\u0006yaN\u001a\"z'B,7\r\u001e:v[&#\u0007%\u0001\u0005nuR{G\u000e\u0015)N+\t\ty.A\u0005nuR{G\u000e\u0015)NA\u0005\u0011R.\u0019=D_:\u001cXmY;uSZ,w)\u00199t\u0003Mi\u0017\r_\"p]N,7-\u001e;jm\u0016<\u0015\r]:!\u00035i\u0017\r\u001f+j[\u0016<\u0016N\u001c3po\u0006qQ.\u0019=US6,w+\u001b8e_^\u0004\u0013aE5oi\u0016t7/\u001b;z!\u0016\u00148-\u001a8uS2,\u0017\u0001F5oi\u0016t7/\u001b;z!\u0016\u00148-\u001a8uS2,\u0007%\u0001\u0007qK\u0006\\W\r\u001c$j]\u0012,'/\u0006\u0002\u0002n\u0006i\u0001/Z1lK24\u0015N\u001c3fe\u0002\"\u0002Ca\u0015\u0003V\t]#\u0011\fB.\u0005;\u0012yF!\u0019\u0011\u0005\u0019|\u0004b\u0002B\n\u001d\u0002\u0007!q\u0003\u0005\b\u0005cq\u0005\u0019\u0001B\u001b\u0011\u001d\u0011ID\u0014a\u0001\u0003?D\u0011Ba\u0010O!\u0003\u0005\r!!\r\t\u0013\t\rc\n%AA\u0002\u0005}\u0007\"\u0003B$\u001dB\u0005\t\u0019AAp\u0011%\u0011YE\u0014I\u0001\u0002\u0004\ti/A\u0007nS:\u0004V-Y6t\u0007>,h\u000e^\u0001\u000f[&t\u0007+Z1lg\u000e{WO\u001c;!\u0003Ii\u0017N\u001c)fC.,G.Q7qY&$X\u000fZ3\u0002'5Lg\u000eU3bW\u0016d\u0017)\u001c9mSR,H-\u001a\u0011\u0002\u001f5\f\u0007\u0010S1mM\u0012+(/\u0019;j_:\f\u0001#\\1y\u0011\u0006dg\rR;sCRLwN\u001c\u0011\u0002\u001b\u0011,G/Z2u!\u0016\f7.\u001a7t)!\u0011\u0019Ha \u0003\n\nM\u0005#\u00026\u0003v\te\u0014b\u0001B<W\n)\u0011I\u001d:bsB!!Q\u0005B>\u0013\u0011\u0011iHa\n\u0003\rA+\u0017m[3m\u0011\u001d\u0011\t)\u0016a\u0001\u0005\u0007\u000bq\u0001]6m)J,W\r\u0005\u0003\u0003&\t\u0015\u0015\u0002\u0002BD\u0005O\u0011A\u0002U3bW2K7\u000f\u001e+sK\u0016DqAa#V\u0001\u0004\u0011i)\u0001\u0007dkJ\u00146\u000fU6m\u0007>dG\u000e\u0005\u0003\u0003&\t=\u0015\u0002\u0002BI\u0005O\u0011!\u0003U3bW2K7\u000f^\"pY2,7\r^5p]\"9!QS+A\u0002\t]\u0015aF5oi\u0016t7/\u001b;z\t\u0016\u001c8\rU3bW\u000e{wN\u001d3t!\u0015Q'Q\u000fBM!\u0015Q'QOA\u0019\u00035)\u0007\u0010\u001e:bGR\u0004V-Y6fYRq!q\u0014BS\u0005O\u0013\u0019Ma2\u0003R\nU\u0007#\u00026\u0003\"\ne\u0014b\u0001BRW\n1q\n\u001d;j_:DqA!!W\u0001\u0004\u0011\u0019\tC\u0004\u0003*Z\u0003\rAa+\u0002\u0017U\u001cX\r\u001a)fC.l\u0015\r\u001d\t\t\u00053\u0011iK!-\u00038&!!q\u0016B\u000e\u0005\u001dA\u0015m\u001d5NCB\u0004BA!\n\u00034&!!Q\u0017B\u0014\u0005!\u0001V-Y6MSN$\b\u0003\u0002B]\u0005\u007fk!Aa/\u000b\t\tu\u0016\u0011E\u0001\u0005kRLG.\u0003\u0003\u0003B\nm&A\u0002\"jiN+G\u000fC\u0004\u0003FZ\u0003\r!!\r\u0002\u0017M\u0004Xm\u0019;sk6LE\r\u001f\u0005\b\u0005\u00134\u0006\u0019\u0001Bf\u00031\t\u0007/\u001a=Ta\u0016\u001cGO];n!\u0011\u0011)C!4\n\t\t='q\u0005\u0002\t'B,7\r\u001e:v[\"9!1\u001b,A\u0002\u0005E\u0012aC1qKb\u0004V-Y6JIbDqAa6W\u0001\u0004\u0011I.A\ftQ\u0006\u0014X\r\u001a)fC.,GnQ8pe\u0012Lg.\u0019;fgB!!Q\u0005Bn\u0013\u0011\u0011iNa\n\u0003#A+\u0017m[3m\u0007>|'\u000fZ5oCR,7\u000f")
public class UnsupervisedPeakelDetector
implements LazyLogging {
    private final LongMap<SpectrumHeader> spectrumHeaderById;
    private final LongMap<Object> nfBySpectrumId;
    private final float mzTolPPM;
    private final int maxConsecutiveGaps;
    private final float maxTimeWindow;
    private final float intensityPercentile;
    private final IPeakelFinder peakelFinder;
    private final int minPeaksCount;
    private final float minPeakelAmplitude;
    private final float maxHalfDuration;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static IPeakelFinder $lessinit$greater$default$7() {
        return UnsupervisedPeakelDetector$.MODULE$.$lessinit$greater$default$7();
    }

    public static float $lessinit$greater$default$6() {
        return UnsupervisedPeakelDetector$.MODULE$.$lessinit$greater$default$6();
    }

    public static float $lessinit$greater$default$5() {
        return UnsupervisedPeakelDetector$.MODULE$.$lessinit$greater$default$5();
    }

    public static int $lessinit$greater$default$4() {
        return UnsupervisedPeakelDetector$.MODULE$.$lessinit$greater$default$4();
    }

    public static ProgressPlan<UnsupervisedPeakelExtractionSequence> newExtractionProgressPlan() {
        return UnsupervisedPeakelDetector$.MODULE$.newExtractionProgressPlan();
    }

    public static ProgressPlan<UnsupervisedPeakelDetectionSequence> newDetectionProgressPlan() {
        return UnsupervisedPeakelDetector$.MODULE$.newDetectionProgressPlan();
    }

    private Logger logger$lzycompute() {
        UnsupervisedPeakelDetector unsupervisedPeakelDetector = this;
        synchronized (unsupervisedPeakelDetector) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public LongMap<SpectrumHeader> spectrumHeaderById() {
        return this.spectrumHeaderById;
    }

    public LongMap<Object> nfBySpectrumId() {
        return this.nfBySpectrumId;
    }

    public float mzTolPPM() {
        return this.mzTolPPM;
    }

    public int maxConsecutiveGaps() {
        return this.maxConsecutiveGaps;
    }

    public float maxTimeWindow() {
        return this.maxTimeWindow;
    }

    public float intensityPercentile() {
        return this.intensityPercentile;
    }

    public IPeakelFinder peakelFinder() {
        return this.peakelFinder;
    }

    public int minPeaksCount() {
        return this.minPeaksCount;
    }

    public float minPeakelAmplitude() {
        return this.minPeakelAmplitude;
    }

    private float maxHalfDuration() {
        return this.maxHalfDuration;
    }

    public Peakel[] detectPeakels(PeakListTree pklTree, PeakListCollection curRsPklColl, int[][] intensityDescPeakCoords) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        int nbPeaks = intensityDescPeakCoords.length;
        if (nbPeaks < 10) {
            return (Peakel[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(Peakel.class));
        }
        HashMap usedPeakMap = new HashMap();
        usedPeakMap.sizeHint(curRsPklColl.peakListsCount());
        pklTree.pklTripletBySpectrumId().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)UnsupervisedPeakelDetector.$anonfun$detectPeakels$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            UnsupervisedPeakelDetector.$anonfun$detectPeakels$2(usedPeakMap, x$1);
            return BoxedUnit.UNIT;
        });
        PeakList[] curRsPeakLists = curRsPklColl.peakLists();
        int curRsPeaklistsCount = curRsPeakLists.length;
        ProgressComputer progressComputer = new ProgressComputer(UnsupervisedPeakelDetector$.MODULE$.newDetectionProgressPlan(), ClassTag$.MODULE$.apply(UnsupervisedPeakelDetectionSequence.class));
        ProgressStep curStep = progressComputer.resetStepStartingTime((IProgressStepIdentity)UnsupervisedPeakelDetector$DETECTION_STEP1$.MODULE$);
        curStep.setMaxCount(nbPeaks);
        int[] lowestPeakCoords = intensityDescPeakCoords[Math.min(nbPeaks - 1, (int)((float)nbPeaks * this.intensityPercentile()))];
        int lowestPeakListIdx = lowestPeakCoords[0];
        int lowestPeakIdx = lowestPeakCoords[1];
        float intensityThreshold = curRsPklColl.getPeakAt(lowestPeakListIdx, lowestPeakIdx).getIntensity();
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("detecting peakels using {} min peaks count", new Object[]{BoxesRunTime.boxToInteger((int)this.minPeaksCount())});
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("detecting peakels using intensity threshold = {}", new Object[]{BoxesRunTime.boxToFloat((float)intensityThreshold)});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        ArrayBuffer peakelBuffer = new ArrayBuffer(20000);
        PeakelCoordinates sharedPeakelCoordinates = new PeakelCoordinates(curRsPeaklistsCount);
        Breaks$.MODULE$.breakable((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            IntRef peakNum = IntRef.create((int)0);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])intensityDescPeakCoords)).foreach((Function1 & Serializable & scala.Serializable)peakCoords -> {
                BoxedUnit boxedUnit;
                ++peakNum$1.elem;
                Object object = peakNum$1.elem % 1000 == 0 ? BoxesRunTime.boxToInteger((int)curStep.incrementAndGetCount(curStep.incrementAndGetCount$default$1())) : BoxedUnit.UNIT;
                int peakListIdx = peakCoords[0];
                int peakIdx = peakCoords[1];
                PeakList peakList = curRsPeakLists[peakListIdx];
                if (peakListIdx == lowestPeakListIdx && peakIdx == lowestPeakIdx) {
                    throw Breaks$.MODULE$.break();
                }
                if (!((BitSet)usedPeakMap.apply((Object)peakList)).get(peakIdx)) {
                    Spectrum spectrumSlice = peakList.getSpectrum();
                    sharedPeakelCoordinates$1.peakLists()[peakListIdx] = peakList;
                    sharedPeakelCoordinates.minIdx_$eq(peakListIdx);
                    sharedPeakelCoordinates.maxIdx_$eq(peakListIdx);
                    Option<Peakel> peakelOpt = this.extractPeakel(pklTree, (HashMap<PeakList, BitSet>)usedPeakMap, peakListIdx, spectrumSlice, peakIdx, sharedPeakelCoordinates);
                    if (peakelOpt.isDefined()) {
                        Peakel peakel = (Peakel)peakelOpt.get();
                        int apexIdx = peakel.apexIndex();
                        boxedUnit = peakelBuffer.$plus$eq(peakelOpt.get());
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return boxedUnit;
            });
        });
        curStep.setAsCompleted();
        return (Peakel[])peakelBuffer.toArray(ClassTag$.MODULE$.apply(Peakel.class));
    }

    public Option<Peakel> extractPeakel(PeakListTree pklTree, HashMap<PeakList, BitSet> usedPeakMap, int spectrumIdx, Spectrum apexSpectrum, int apexPeakIdx, PeakelCoordinates sharedPeakelCoordinates) {
        float intensityAmplitude;
        int i;
        LongMap<PeakListTriplet> pklTripletBySpectrumId = pklTree.pklTripletBySpectrumId();
        PeakList[] sharedPeakLists = sharedPeakelCoordinates.peakLists();
        int[] sharedPeakIndices = sharedPeakelCoordinates.peakIndices();
        PeakListTree.SpectrumHeaderMap pklTreeShMap = pklTree.spectrumHeaderMap();
        SpectrumHeader[] pklTreeSpecHeaders = pklTreeShMap.getSpectrumHeaders();
        int shCount = pklTreeSpecHeaders.length;
        SpectrumHeader apexSpectrumHeader = apexSpectrum.getHeader();
        SpectrumData apexSpectrumData = apexSpectrum.getData();
        double apexMz = apexSpectrumData.getMzList()[apexPeakIdx];
        float apexIntensity = apexSpectrumData.getIntensityList()[apexPeakIdx];
        float apexTime = apexSpectrumHeader.getTime();
        int apexShPklTreeIdx = pklTreeShMap.getSpectrumHeaderIndex(apexSpectrumHeader.getId());
        double mzTolDa = MsUtils.ppmToDa((double)apexMz, (double)this.mzTolPPM());
        IntRef peakelPeaksCount = IntRef.create((int)0);
        BooleanRef isRightDirection = BooleanRef.create((boolean)true);
        for (int numOfAnalyzedDirections = 0; numOfAnalyzedDirections < 2; ++numOfAnalyzedDirections) {
            BooleanRef timeOverRange = BooleanRef.create((boolean)false);
            IntRef consecutiveGapCount = IntRef.create((int)0);
            IntRef shIdxShift = IntRef.create((int)0);
            Breaks$.MODULE$.breakable((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                while (consecutiveGapCount$1.elem <= this.maxConsecutiveGaps() && !timeOverRange$1.elem) {
                    int curShIdx;
                    if (!isRightDirection$1.elem) {
                        --shIdxShift$1.elem;
                    }
                    if ((curShIdx = apexShPklTreeIdx + shIdxShift$1.elem) < 0 || curShIdx >= shCount) {
                        timeOverRange$1.elem = true;
                        throw Breaks$.MODULE$.break();
                    }
                    SpectrumHeader curSpectrumH = pklTreeSpecHeaders[curShIdx];
                    long curSpectrumId = curSpectrumH.getId();
                    float curTime = curSpectrumH.getTime();
                    if (this.maxHalfDuration() > 0.0f && Math.abs(curTime - apexTime) > this.maxHalfDuration()) {
                        timeOverRange$1.elem = true;
                        throw Breaks$.MODULE$.break();
                    }
                    PeakListTriplet pklTriplet = (PeakListTriplet)pklTripletBySpectrumId.getOrNull(curSpectrumId);
                    Predef$.MODULE$.require(pklTriplet != null, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("no pklTriplet for spectrum #").append(curSpectrumId).toString());
                    int nearestPeakIdx = pklTriplet.addNearestPeakToPeakelCoordinates(apexMz, mzTolDa, sharedPeakelCoordinates, curShIdx, pklTriplet.addNearestPeakToPeakelCoordinates$default$5());
                    if (nearestPeakIdx != -1 && !((BitSet)usedPeakMap.apply((Object)sharedPeakLists[curShIdx])).get(nearestPeakIdx)) {
                        consecutiveGapCount$1.elem = 0;
                        ++peakelPeaksCount$1.elem;
                    } else {
                        ++consecutiveGapCount$1.elem;
                        sharedPeakelCoordinates.removePeak(curShIdx);
                    }
                    if (isRightDirection$1.elem) {
                        ++shIdxShift$1.elem;
                        sharedPeakelCoordinates.maxIdx_$eq(curShIdx);
                        continue;
                    }
                    sharedPeakelCoordinates.minIdx_$eq(curShIdx);
                }
            });
            isRightDirection.elem = false;
        }
        if (peakelPeaksCount.elem < this.minPeaksCount()) {
            return None$.MODULE$;
        }
        BoxedUnit peakelAndPeaksOpt = BoxedUnit.UNIT;
        Tuple2<Object, Object>[] rtIntPairs = sharedPeakelCoordinates.getElutionTimeIntensityPairs();
        Predef$.MODULE$.require(rtIntPairs.length == peakelPeaksCount.elem, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(64).append("invalid number of RT/intensity pairs for mz=").append(apexMz).append(": got ").append(rtIntPairs.length).append(" but expected ").append(peakelPeaksCount$1.elem).toString());
        Tuple2<Object, Object>[] peakelsIndices = this.peakelFinder().findPeakelsIndices(rtIntPairs);
        ObjectRef matchingPeakelIdxOpt = ObjectRef.create((Object)Option$.MODULE$.empty());
        LongMap detectedPeaksIndices = new LongMap(rtIntPairs.length);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])peakelsIndices)).foreach((Function1 & Serializable & scala.Serializable)peakelIdx -> {
            UnsupervisedPeakelDetector.$anonfun$extractPeakel$4(apexTime, rtIntPairs, matchingPeakelIdxOpt, detectedPeaksIndices, peakelIdx);
            return BoxedUnit.UNIT;
        });
        LongMap<Object> peakListIdxByDefPeakIdx = sharedPeakelCoordinates.getDefinedPeakListIndexMapping();
        int rtIntPairsLength = rtIntPairs.length;
        for (i = 0; i < rtIntPairsLength; ++i) {
            if (detectedPeaksIndices.contains((long)i)) continue;
            int peakListIdx = BoxesRunTime.unboxToInt((Object)peakListIdxByDefPeakIdx.apply((long)i));
            PeakList peakList = sharedPeakLists[peakListIdx];
            int peakIdx = sharedPeakIndices[peakListIdx];
            ((BitSet)usedPeakMap.apply((Object)peakList)).set(peakIdx, true);
        }
        if (((Option)matchingPeakelIdxOpt.elem).isEmpty()) {
            return None$.MODULE$;
        }
        Tuple2 matchingPeakelIdx = (Tuple2)((Option)matchingPeakelIdxOpt.elem).get();
        sharedPeakelCoordinates.minIdx_$eq(BoxesRunTime.unboxToInt((Object)peakListIdxByDefPeakIdx.apply((long)matchingPeakelIdx._1$mcI$sp())));
        sharedPeakelCoordinates.maxIdx_$eq(BoxesRunTime.unboxToInt((Object)peakListIdxByDefPeakIdx.apply((long)matchingPeakelIdx._2$mcI$sp())));
        Peakel peakel = sharedPeakelCoordinates.toPeakel(sharedPeakelCoordinates.toPeakel$default$1());
        float minIntensity = BoxesRunTime.unboxToFloat((Object)new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(peakel.intensityValues())).min((Ordering)Ordering.Float$.MODULE$));
        float maxIntensity = peakel.getApexIntensity();
        float f = intensityAmplitude = minIntensity == 0.0f ? 2.0f : maxIntensity / minIntensity;
        if (intensityAmplitude < this.minPeakelAmplitude()) {
            return None$.MODULE$;
        }
        for (i = sharedPeakelCoordinates.minIdx(); i <= sharedPeakelCoordinates.maxIdx(); ++i) {
            PeakList peakList = sharedPeakLists[i];
            if (peakList == null) continue;
            int peakIdx = sharedPeakIndices[i];
            ((BitSet)usedPeakMap.apply((Object)peakList)).set(peakIdx, true);
        }
        return new Some((Object)peakel);
    }

    public static final /* synthetic */ boolean $anonfun$detectPeakels$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$detectPeakels$2(HashMap usedPeakMap$1, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        PeakListTriplet pklTriplet = (PeakListTriplet)tuple2._2();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pklTriplet.peakLists())).foreach((Function1 & Serializable & scala.Serializable)peaklist -> {
            usedPeakMap$1.update((Object)peaklist, (Object)new BitSet(peaklist.peaksCount()));
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$extractPeakel$4(float apexTime$1, Tuple2[] rtIntPairs$1, ObjectRef matchingPeakelIdxOpt$1, LongMap detectedPeaksIndices$1, Tuple2 peakelIdx) {
        if (apexTime$1 >= BoxesRunTime.unboxToFloat((Object)rtIntPairs$1[peakelIdx._1$mcI$sp()]._1()) && apexTime$1 <= BoxesRunTime.unboxToFloat((Object)rtIntPairs$1[peakelIdx._2$mcI$sp()]._1())) {
            matchingPeakelIdxOpt$1.elem = new Some((Object)peakelIdx);
        }
        for (int idx = peakelIdx._1$mcI$sp(); idx <= peakelIdx._2$mcI$sp(); ++idx) {
            detectedPeaksIndices$1.put((long)idx, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        }
    }

    public UnsupervisedPeakelDetector(LongMap<SpectrumHeader> spectrumHeaderById, LongMap<Object> nfBySpectrumId, float mzTolPPM, int maxConsecutiveGaps, float maxTimeWindow, float intensityPercentile, IPeakelFinder peakelFinder) {
        this.spectrumHeaderById = spectrumHeaderById;
        this.nfBySpectrumId = nfBySpectrumId;
        this.mzTolPPM = mzTolPPM;
        this.maxConsecutiveGaps = maxConsecutiveGaps;
        this.maxTimeWindow = maxTimeWindow;
        this.intensityPercentile = intensityPercentile;
        this.peakelFinder = peakelFinder;
        LazyLogging.$init$((LazyLogging)this);
        this.minPeaksCount = peakelFinder.minPeaksCount();
        this.minPeakelAmplitude = 1.5f;
        this.maxHalfDuration = maxTimeWindow / (float)2;
    }

    public static interface UnsupervisedPeakelDetectionSequence
    extends IProgressPlanSequence {
    }

    public static interface UnsupervisedPeakelExtractionSequence
    extends IProgressPlanSequence {
    }
}

