/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.algo.feature.scoring;

import fr.profi.ms.algo.IsotopePatternInterpolator$;
import fr.profi.ms.model.TheoreticalIsotopePattern;
import fr.profi.mzdb.algo.signal.detection.BasicPeakelFinder;
import fr.profi.mzdb.algo.signal.detection.BasicPeakelFinder$;
import fr.profi.mzdb.algo.signal.detection.waveletImpl.WaveletDetectorDuMethod;
import fr.profi.mzdb.model.Feature;
import fr.profi.mzdb.model.ILcContext;
import fr.profi.mzdb.model.Peak;
import fr.profi.mzdb.model.Peakel;
import fr.profi.mzdb.util.math.VectorSimilarity$;
import java.io.Serializable;
import org.apache.commons.math3.stat.descriptive.moment.StandardDeviation;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.LongMap;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.FloatRef;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction1;

public final class FeatureScorer$ {
    public static FeatureScorer$ MODULE$;
    private final BasicPeakelFinder basicPeakelFinder;

    static {
        new FeatureScorer$();
    }

    public BasicPeakelFinder basicPeakelFinder() {
        return this.basicPeakelFinder;
    }

    public float calcMeanPeakelCorrelation(Seq<Peakel> peakels) {
        int peakelsCount = peakels.length();
        if (peakelsCount < 2) {
            return 0.0f;
        }
        DoubleRef peakelCorrSum = DoubleRef.create((double)0.0);
        peakels.sliding(2).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            FeatureScorer$.$anonfun$calcMeanPeakelCorrelation$1(peakelCorrSum, x0$1);
            return BoxedUnit.UNIT;
        });
        return (float)(peakelCorrSum.elem / (double)(peakelsCount - 1));
    }

    public double calcPeakelCorrelation(Peakel firstPeakel, Peakel secondPeakel) {
        Map firstPeakelIntensityByTime = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])firstPeakel.getElutionTimeIntensityPairs())).toMap(Predef$.MODULE$.$conforms());
        Map secondPeakelIntensityByTime = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])secondPeakel.getElutionTimeIntensityPairs())).toMap(Predef$.MODULE$.$conforms());
        ArrayBuffer firstPeakelIntensities = new ArrayBuffer();
        ArrayBuffer secondPeakelIntensities = new ArrayBuffer();
        new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(firstPeakel.elutionTimes())).foreach((Function1 & Serializable & scala.Serializable)elutionTime -> FeatureScorer$.$anonfun$calcPeakelCorrelation$1(secondPeakelIntensityByTime, firstPeakelIntensities, firstPeakelIntensityByTime, secondPeakelIntensities, BoxesRunTime.unboxToFloat((Object)elutionTime)));
        if (!firstPeakelIntensities.isEmpty()) {
            return VectorSimilarity$.MODULE$.pearsonCorrelation((double[])firstPeakelIntensities.toArray(ClassTag$.MODULE$.Double()), (double[])secondPeakelIntensities.toArray(ClassTag$.MODULE$.Double()));
        }
        return Double.NaN;
    }

    public float calcOverlappingFactor(Feature f, double mzTolInPpm) {
        if (f.overlapProperties() == null || f.overlapProperties().overlappingFeatures() == null) {
            return 0.0f;
        }
        double of = 0.0;
        double mz = f.getMz();
        double mzTolInDa = mz * mzTolInPpm / 1000000.0;
        ArrayBuffer overlappingMap = new ArrayBuffer();
        Peakel peakel = f.getFirstPeakel();
        long refSpectrumID = peakel.getApexSpectrumId();
        Tuple2 tuple2 = new Tuple2((Object)Option$.MODULE$.empty(), (Object)Option$.MODULE$.empty());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Option leftOverlappingPeaks = (Option)tuple2._1();
        Option rightOverlappingPeaks = (Option)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)leftOverlappingPeaks, (Object)rightOverlappingPeaks);
        Tuple2 tuple23 = tuple22;
        ObjectRef leftOverlappingPeaks2 = ObjectRef.create((Object)((Option)tuple23._1()));
        ObjectRef rightOverlappingPeaks2 = ObjectRef.create((Object)((Option)tuple23._2()));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])f.overlapProperties().overlappingFeatures())).foreach((Function1 & Serializable & scala.Serializable)ovlFeature -> {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ovlFeature.feature().indexedPeakels())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                FeatureScorer$.$anonfun$calcOverlappingFactor$2(mz, mzTolInDa, refSpectrumID, leftOverlappingPeaks2, rightOverlappingPeaks2, x0$1);
                return BoxedUnit.UNIT;
            });
            return overlappingMap.$plus$eq((Object)new Tuple3((Object)peakel, (Object)((Option)leftOverlappingPeaks$1.elem), (Object)((Option)rightOverlappingPeaks$1.elem)));
        });
        return this.calcMeanOverlappingFactor((Seq<Tuple3<Peakel, Option<Peakel>, Option<Peakel>>>)overlappingMap);
    }

    public float calcMeanOverlappingFactor(Seq<Tuple3<Peakel, Option<Peakel>, Option<Peakel>>> peakels) {
        if (peakels.isEmpty()) {
            return 0.0f;
        }
        FloatRef m = FloatRef.create((float)0.0f);
        peakels.foreach((Function1 & Serializable & scala.Serializable)p -> {
            FeatureScorer$.$anonfun$calcMeanOverlappingFactor$1(m, p);
            return BoxedUnit.UNIT;
        });
        return m.elem / (float)peakels.length();
    }

    /*
     * Enabled aggressive block sorting
     */
    public float calcOverlappingFactor(Peakel peakel, Option<Peakel> leftOverlappingPeakel, Option<Peakel> rightOverlappingPeakel, float baseline) {
        Object object;
        FloatRef of = FloatRef.create((float)0.0f);
        Function2 & Serializable & scala.Serializable calcLeftOverlappingFactor = (Function2 & Serializable & scala.Serializable)(p, lop) -> {
            FeatureScorer$.$anonfun$calcOverlappingFactor$3(of, p, lop);
            return BoxedUnit.UNIT;
        };
        Function2 & Serializable & scala.Serializable calcRightOverlappingFactor = (Function2 & Serializable & scala.Serializable)(p, rop) -> {
            FeatureScorer$.$anonfun$calcOverlappingFactor$4(of, p, rop);
            return BoxedUnit.UNIT;
        };
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)peakel.getApexMz()), (Object)BoxesRunTime.boxToFloat((float)peakel.getApexIntensity()));
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        double mz = tuple2._1$mcD$sp();
        float intens = BoxesRunTime.unboxToFloat((Object)tuple2._2());
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)mz), (Object)BoxesRunTime.boxToFloat((float)intens));
        Tuple2 tuple23 = tuple22;
        double mz2 = tuple23._1$mcD$sp();
        float intens2 = BoxesRunTime.unboxToFloat((Object)tuple23._2());
        float lastIntens = BoxesRunTime.unboxToFloat((Object)new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(peakel.intensityValues())).last());
        float firstIntens = BoxesRunTime.unboxToFloat((Object)new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(peakel.intensityValues())).head());
        Option<Peakel> option = leftOverlappingPeakel;
        None$ none$ = None$.MODULE$;
        if (!(option != null ? !option.equals((Object)none$) : none$ != null)) {
            Option<Peakel> option2 = rightOverlappingPeakel;
            None$ none$2 = None$.MODULE$;
            if (!(option2 != null ? !option2.equals((Object)none$2) : none$2 != null)) {
                object = BoxedUnit.UNIT;
                return of.elem;
            }
        }
        Option<Peakel> option3 = leftOverlappingPeakel;
        None$ none$3 = None$.MODULE$;
        if (option3 == null ? none$3 != null : !option3.equals((Object)none$3)) {
            Option<Peakel> option4 = rightOverlappingPeakel;
            None$ none$4 = None$.MODULE$;
            if (!(option4 != null ? !option4.equals((Object)none$4) : none$4 != null)) {
                object = calcLeftOverlappingFactor.apply((Object)peakel, leftOverlappingPeakel.get());
                return of.elem;
            }
        }
        Option<Peakel> option5 = leftOverlappingPeakel;
        None$ none$5 = None$.MODULE$;
        if (!(option5 != null ? !option5.equals((Object)none$5) : none$5 != null)) {
            Option<Peakel> option6 = rightOverlappingPeakel;
            None$ none$6 = None$.MODULE$;
            if (option6 == null ? none$6 != null : !option6.equals((Object)none$6)) {
                object = calcRightOverlappingFactor.apply((Object)peakel, rightOverlappingPeakel.get());
                return of.elem;
            }
        }
        calcLeftOverlappingFactor.apply((Object)peakel, leftOverlappingPeakel.get());
        object = calcRightOverlappingFactor.apply((Object)peakel, rightOverlappingPeakel.get());
        return of.elem;
    }

    public float calcOverlappingFactor$default$4() {
        return 0.0f;
    }

    public float calcRmsdIsotopicPattern(Feature f) {
        Tuple2 tuple2;
        if (f.getPeakelsCount() < 2) {
            return Float.NaN;
        }
        double mz = f.getMz();
        TheoreticalIsotopePattern theoPattern = IsotopePatternInterpolator$.MODULE$.getTheoreticalPattern(mz, f.getCharge());
        double[] theoAbundances = (double[])new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(theoPattern.abundances())).map((Function1)(JFunction1.mcDF.sp & Serializable & scala.Serializable)ab -> ab / (float)100, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        double[] obsAbundances = (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])f.indexedPeakels())).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToDouble((double)FeatureScorer$.$anonfun$calcRmsdIsotopicPattern$2(x$5)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        double maxIntens = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(obsAbundances)).max((Ordering)Ordering.Double$.MODULE$));
        double[] normAbundances = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(obsAbundances)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> x / maxIntens, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        Tuple2 tuple22 = tuple2 = theoAbundances.length < normAbundances.length ? new Tuple2((Object)theoAbundances, (Object)normAbundances) : new Tuple2((Object)normAbundances, (Object)theoAbundances);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double[] shortest = (double[])tuple2._1();
        double[] longest = (double[])tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)shortest, (Object)longest);
        Tuple2 tuple24 = tuple23;
        double[] shortest2 = (double[])tuple24._1();
        double[] longest2 = (double[])tuple24._2();
        return (float)VectorSimilarity$.MODULE$.rmsd(shortest2, (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(longest2)).take(shortest2.length));
    }

    public float calcSignalFluctuationByBasicPeakelFinder(Feature f, LongMap<ILcContext> lcContextBySpectrumId) {
        FloatRef shape = FloatRef.create((float)0.0f);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])f.indexedPeakels())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            FeatureScorer$.$anonfun$calcSignalFluctuationByBasicPeakelFinder$1(shape, lcContextBySpectrumId, x0$1);
            return BoxedUnit.UNIT;
        });
        return shape.elem / (float)f.getPeakelsCount();
    }

    public float calcSignalFluctuationByWaveletBasedPeakelFinder(Feature f, LongMap<ILcContext> lcContextBySpectrumId) {
        FloatRef shape = FloatRef.create((float)0.0f);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])f.indexedPeakels())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            FeatureScorer$.$anonfun$calcSignalFluctuationByWaveletBasedPeakelFinder$1(shape, lcContextBySpectrumId, x0$1);
            return BoxedUnit.UNIT;
        });
        return shape.elem / (float)f.getPeakelsCount();
    }

    public float calcStdDevPeakelsMzPrecision(Feature f) {
        ArrayBuffer peakelsMzPrecision = new ArrayBuffer();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])f.indexedPeakels())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Peakel peakel = (Peakel)tuple2._1();
            double stdDev = new StandardDeviation().evaluate(peakel.mzValues());
            ArrayBuffer arrayBuffer = peakelsMzPrecision.$plus$eq((Object)BoxesRunTime.boxToDouble((double)(stdDev * (double)peakel.getArea())));
            return arrayBuffer;
        });
        return !peakelsMzPrecision.isEmpty() ? (float)(BoxesRunTime.unboxToDouble((Object)peakelsMzPrecision.sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (f.getMz() * (double)BoxesRunTime.unboxToFloat((Object)new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps((float[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])f.indexedPeakels())).map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToFloat((float)FeatureScorer$.$anonfun$calcStdDevPeakelsMzPrecision$2(x$7)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float())))).sum((Numeric)Numeric.FloatIsFractional$.MODULE$)))) : Float.NaN;
    }

    public float calcPeakelsAmplitude(Feature f) {
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])f.indexedPeakels())).isEmpty()) {
            return Float.NaN;
        }
        FloatRef weightedAmplitudeSum = FloatRef.create((float)0.0f);
        FloatRef areaSum = FloatRef.create((float)0.0f);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])f.indexedPeakels())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)FeatureScorer$.$anonfun$calcPeakelsAmplitude$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$8 -> {
            FeatureScorer$.$anonfun$calcPeakelsAmplitude$2(weightedAmplitudeSum, areaSum, x$8);
            return BoxedUnit.UNIT;
        });
        return weightedAmplitudeSum.elem / areaSum.elem;
    }

    private float getDistanceBetweenTwoPoints(float x1, float y1, float x2, float y2) {
        return (float)package$.MODULE$.sqrt(package$.MODULE$.pow((double)(x2 - x1), 2.0) + package$.MODULE$.pow((double)(y2 - y1), 2.0));
    }

    private float getDistanceSum(Peakel peakel) {
        FloatRef sum = FloatRef.create((float)0.0f);
        new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(peakel.spectrumIds())).indices().sliding(2).withFilter((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)FeatureScorer$.$anonfun$getDistanceSum$1(x$9))).foreach((Function1 & Serializable & scala.Serializable)indexPair -> {
            FeatureScorer$.$anonfun$getDistanceSum$2(peakel, sum, indexPair);
            return BoxedUnit.UNIT;
        });
        return sum.elem;
    }

    public float calcDistanceOverArea(Feature f) {
        FloatRef m = FloatRef.create((float)0.0f);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])f.indexedPeakels())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            FeatureScorer$.$anonfun$calcDistanceOverArea$1(m, x0$1);
            return BoxedUnit.UNIT;
        });
        return m.elem / (float)package$.MODULE$.pow((double)BoxesRunTime.unboxToFloat((Object)new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps((float[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])f.indexedPeakels())).map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToFloat((float)FeatureScorer$.$anonfun$calcDistanceOverArea$2(x$11)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float())))).sum((Numeric)Numeric.FloatIsFractional$.MODULE$)), 2.0);
    }

    public float calcMeanPeakelsApexDeviation(Peakel[] peakels) {
        FloatRef m = FloatRef.create((float)0.0f);
        IntRef count = IntRef.create((int)0);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])peakels)).sliding(2).withFilter((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)FeatureScorer$.$anonfun$calcMeanPeakelsApexDeviation$1(x$12))).foreach((Function1 & Serializable & scala.Serializable)x -> {
            FeatureScorer$.$anonfun$calcMeanPeakelsApexDeviation$2(m, count, x);
            return BoxedUnit.UNIT;
        });
        return m.elem / (float)count.elem;
    }

    public static final /* synthetic */ void $anonfun$calcMeanPeakelCorrelation$1(DoubleRef peakelCorrSum$1, Seq x0$1) {
        Seq seq = x0$1;
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
            Peakel p1 = (Peakel)((SeqLike)some.get()).apply(0);
            Peakel p2 = (Peakel)((SeqLike)some.get()).apply(1);
            peakelCorrSum$1.elem += MODULE$.calcPeakelCorrelation(p1, p2);
        } else {
            throw new MatchError((Object)seq);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$calcPeakelCorrelation$1(Map secondPeakelIntensityByTime$1, ArrayBuffer firstPeakelIntensities$1, Map firstPeakelIntensityByTime$1, ArrayBuffer secondPeakelIntensities$1, float elutionTime) {
        BoxedUnit boxedUnit;
        Option secondPeakelIntensityOpt = secondPeakelIntensityByTime$1.get((Object)BoxesRunTime.boxToFloat((float)elutionTime));
        if (secondPeakelIntensityOpt.isDefined()) {
            firstPeakelIntensities$1.$plus$eq((Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToFloat((Object)firstPeakelIntensityByTime$1.apply((Object)BoxesRunTime.boxToFloat((float)elutionTime)))));
            boxedUnit = secondPeakelIntensities$1.$plus$eq((Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToFloat((Object)secondPeakelIntensityOpt.get())));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return boxedUnit;
    }

    public static final /* synthetic */ void $anonfun$calcOverlappingFactor$2(double mz$1, double mzTolInDa$1, long refSpectrumID$1, ObjectRef leftOverlappingPeaks$1, ObjectRef rightOverlappingPeaks$1, Tuple2 x0$1) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Peakel p = (Peakel)tuple2._1();
            if (p.getMz() - mz$1 < mzTolInDa$1) {
                if (p.getApexSpectrumId() < refSpectrumID$1) {
                    leftOverlappingPeaks$1.elem = new Some((Object)p);
                }
                if (p.getApexSpectrumId() > refSpectrumID$1) {
                    rightOverlappingPeaks$1.elem = new Some((Object)p);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ void $anonfun$calcMeanOverlappingFactor$1(FloatRef m$1, Tuple3 p) {
        m$1.elem += MODULE$.calcOverlappingFactor((Peakel)p._1(), (Option<Peakel>)((Option)p._2()), (Option<Peakel>)((Option)p._3()), MODULE$.calcOverlappingFactor$default$4());
    }

    public static final /* synthetic */ void $anonfun$calcOverlappingFactor$3(FloatRef of$1, Peakel p, Peakel lop) {
        Tuple2 tuple2 = new Tuple2(new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(p.intensityValues())).head(), new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(p.intensityValues())).last());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        float overlappingIntens = BoxesRunTime.unboxToFloat((Object)tuple2._1());
        float refIntens = BoxesRunTime.unboxToFloat((Object)tuple2._2());
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToFloat((float)overlappingIntens), (Object)BoxesRunTime.boxToFloat((float)refIntens));
        Tuple2 tuple23 = tuple22;
        float overlappingIntens2 = BoxesRunTime.unboxToFloat((Object)tuple23._1());
        float refIntens2 = BoxesRunTime.unboxToFloat((Object)tuple23._2());
        of$1.elem += overlappingIntens2 / refIntens2 * (lop.getApexIntensity() / p.getApexIntensity());
    }

    public static final /* synthetic */ void $anonfun$calcOverlappingFactor$4(FloatRef of$1, Peakel p, Peakel rop) {
        Tuple2 tuple2 = new Tuple2(new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(p.intensityValues())).last(), new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(p.intensityValues())).head());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        float overlappingIntens = BoxesRunTime.unboxToFloat((Object)tuple2._1());
        float refIntens = BoxesRunTime.unboxToFloat((Object)tuple2._2());
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToFloat((float)overlappingIntens), (Object)BoxesRunTime.boxToFloat((float)refIntens));
        Tuple2 tuple23 = tuple22;
        float overlappingIntens2 = BoxesRunTime.unboxToFloat((Object)tuple23._1());
        float refIntens2 = BoxesRunTime.unboxToFloat((Object)tuple23._2());
        of$1.elem += overlappingIntens2 / refIntens2 * (rop.getApexIntensity() / p.getApexIntensity());
    }

    public static final /* synthetic */ double $anonfun$calcRmsdIsotopicPattern$2(Tuple2 x$5) {
        return ((Peakel)x$5._1()).area();
    }

    public static final /* synthetic */ void $anonfun$calcSignalFluctuationByBasicPeakelFinder$1(FloatRef shape$1, LongMap lcContextBySpectrumId$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Peakel p = (Peakel)tuple2._1();
            shape$1.elem += (float)MODULE$.basicPeakelFinder().findPeakelsIndices((Seq<Peak>)Predef$.MODULE$.wrapRefArray((Object[])p.toPeaks((LongMap<? extends ILcContext>)lcContextBySpectrumId$1))).length;
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$calcSignalFluctuationByWaveletBasedPeakelFinder$1(FloatRef shape$2, LongMap lcContextBySpectrumId$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Peakel p = (Peakel)tuple2._1();
            shape$2.elem += (float)new WaveletDetectorDuMethod((Seq<Peak>)Predef$.MODULE$.wrapRefArray((Object[])p.toPeaks((LongMap<? extends ILcContext>)lcContextBySpectrumId$2))).findCwtPeakels().length;
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ float $anonfun$calcStdDevPeakelsMzPrecision$2(Tuple2 x$7) {
        return ((Peakel)x$7._1()).getArea();
    }

    public static final /* synthetic */ boolean $anonfun$calcPeakelsAmplitude$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$calcPeakelsAmplitude$2(FloatRef weightedAmplitudeSum$1, FloatRef areaSum$1, Tuple2 x$8) {
        Tuple2 tuple2 = x$8;
        if (tuple2 != null) {
            Peakel peakel = (Peakel)tuple2._1();
            float[] intensityValues = peakel.intensityValues();
            float area = peakel.getArea();
            weightedAmplitudeSum$1.elem += BoxesRunTime.unboxToFloat((Object)new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(intensityValues)).max((Ordering)Ordering.Float$.MODULE$)) / BoxesRunTime.unboxToFloat((Object)new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(intensityValues)).min((Ordering)Ordering.Float$.MODULE$)) * area;
            areaSum$1.elem += area;
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$getDistanceSum$1(IndexedSeq x$9) {
        return x$9.size() == 2;
    }

    public static final /* synthetic */ void $anonfun$getDistanceSum$2(Peakel peakel$2, FloatRef sum$1, IndexedSeq indexPair) {
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(BoxesRunTime.unboxToInt((Object)indexPair.apply(0)), BoxesRunTime.unboxToInt((Object)indexPair.apply(1)));
        if (sp2 == null) {
            throw new MatchError((Object)sp2);
        }
        int idx1 = sp2._1$mcI$sp();
        int idx2 = sp2._2$mcI$sp();
        Tuple2.mcII.sp sp3 = new Tuple2.mcII.sp(idx1, idx2);
        Tuple2.mcII.sp sp4 = sp3;
        int idx12 = sp4._1$mcI$sp();
        int idx22 = sp4._2$mcI$sp();
        float t1 = peakel$2.elutionTimes()[idx12];
        float t2 = peakel$2.elutionTimes()[idx22];
        float i1 = peakel$2.intensityValues()[idx12];
        float i2 = peakel$2.intensityValues()[idx22];
        sum$1.elem += MODULE$.getDistanceBetweenTwoPoints(t1, i1, t2, i2);
    }

    public static final /* synthetic */ void $anonfun$calcDistanceOverArea$1(FloatRef m$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Peakel p = (Peakel)tuple2._1();
            m$2.elem += MODULE$.getDistanceSum(p) * p.area();
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ float $anonfun$calcDistanceOverArea$2(Tuple2 x$11) {
        return ((Peakel)x$11._1()).intensitySum();
    }

    public static final /* synthetic */ boolean $anonfun$calcMeanPeakelsApexDeviation$1(Peakel[] x$12) {
        return x$12.length == 2;
    }

    public static final /* synthetic */ void $anonfun$calcMeanPeakelsApexDeviation$2(FloatRef m$3, IntRef count$1, Peakel[] x) {
        m$3.elem += (float)package$.MODULE$.abs(x[0].apexIndex() - x[1].apexIndex());
        ++count$1.elem;
    }

    private FeatureScorer$() {
        MODULE$ = this;
        this.basicPeakelFinder = new BasicPeakelFinder(BasicPeakelFinder$.MODULE$.$lessinit$greater$default$1(), BasicPeakelFinder$.MODULE$.$lessinit$greater$default$2());
    }
}

